/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.binutils.utils.DefaultBinutilsFactory;
import org.eclipse.linuxtools.binutils.utils.ISTBinutilsFactory;
import org.eclipse.linuxtools.binutils.utils.STNM;
import org.eclipse.linuxtools.binutils.utils.STNMSymbolsHandler;
import org.eclipse.linuxtools.internal.Activator;

public class STBinutilsFactoryManager {
    private static final Map<String, ISTBinutilsFactory> map = new HashMap<String, ISTBinutilsFactory>();
    private static DefaultBinutilsFactory defaultFactory;

    private STBinutilsFactoryManager() {
    }

    private static ISTBinutilsFactory getBinutilsFactoryImpl(String cpu) {
        try {
            IExtension[] exts;
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.linuxtools.binutils.crossCompilerBinutils");
            IExtension[] iExtensionArray = exts = ep.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elems;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elems = extension.getConfigurationElements();
                int n3 = elems.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISTBinutilsFactory factory;
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    String s = configurationElement.getAttribute("CPU");
                    if (cpu.equals(s) && (factory = (ISTBinutilsFactory)configurationElement.createExecutableExtension("binutilsFactory")).testAvailability()) {
                        return factory;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        if (defaultFactory == null) {
            defaultFactory = new DefaultBinutilsFactory();
        }
        return defaultFactory;
    }

    public static ISTBinutilsFactory getBinutilsFactory(String cpu) {
        ISTBinutilsFactory factory = map.get(cpu);
        if (factory == null) {
            factory = STBinutilsFactoryManager.getBinutilsFactoryImpl(cpu);
            map.put(cpu, factory);
        }
        return factory;
    }

    public static Addr2line getAddr2line(String cpuType, String programPath, IProject project) throws IOException {
        ISTBinutilsFactory factory = STBinutilsFactoryManager.getBinutilsFactory(cpuType);
        return factory.getAddr2line(programPath, project);
    }

    public static CPPFilt getCPPFilt(String cpuType, IProject project) throws IOException {
        ISTBinutilsFactory factory = STBinutilsFactoryManager.getBinutilsFactory(cpuType);
        return factory.getCPPFilt(project);
    }

    public static STNM getNM(String cpuType, String programPath, STNMSymbolsHandler handler, IProject project) throws IOException {
        ISTBinutilsFactory factory = STBinutilsFactoryManager.getBinutilsFactory(cpuType);
        return factory.getNM(programPath, handler, project);
    }
}

