/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class CAbstractMainTab
extends CLaunchConfigurationTab {
    private static final String LAUNCHING_PREFERENCE_PAGE_ID = "org.eclipse.debug.ui.LaunchingPreferencePage";
    protected static final String EMPTY_STRING = "";
    protected String filterPlatform = "";
    protected static final String AUTO_CONFIG = "AUTO";
    protected Combo fBuildConfigCombo;
    protected Button fBuildConfigAuto;
    protected boolean fBuildConfigAutoChanged;
    protected Button fDisableBuildButton;
    protected Button fEnableBuildButton;
    protected Button fWorkspaceSettingsButton;
    protected Link fWorkpsaceSettingsLink;
    protected final Map<IPath, Boolean> fBinaryExeCache = new HashMap<IPath, Boolean>();
    protected Label fProjLabel;
    protected Text fProjText;
    protected Button fProjButton;
    protected Label fProgLabel;
    protected Text fProgText;
    protected Button fSearchButton;
    protected Label fCoreLabel;
    protected Text fCoreText;
    protected Button fCoreButton;
    protected String fPreviouslyCheckedProgram;
    protected boolean fPreviouslyCheckedProgramIsValid;
    protected String fPreviouslyCheckedProgramErrorMsg;

    protected abstract void handleSearchButtonSelected();

    protected void createProjectGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(LaunchMessages.CMainTab_ProjectColon);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CAbstractMainTab.this.fPreviouslyCheckedProgram = null;
                CAbstractMainTab.this.updateBuildConfigCombo(CAbstractMainTab.EMPTY_STRING);
                CAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, LaunchMessages.Launch_common_Browse_1, null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CAbstractMainTab.this.handleProjectButtonSelected();
                CAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected ICProject getCProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return CoreModel.getDefault().getCModel().getCProject(projectName);
    }

    protected void handleProjectButtonSelected() {
        IBinary[] bins;
        String currentProjectName = this.fProjText.getText();
        ICProject project = this.chooseCProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
        if (currentProjectName.length() == 0 && (bins = this.getBinaryFiles(project)) != null && bins.length == 1) {
            this.fProgText.setText(bins[0].getResource().getProjectRelativePath().toOSString());
        }
    }

    protected ICProject[] getCProjects() throws CModelException {
        ICProject[] cproject = CoreModel.getDefault().getCModel().getCProjects();
        ArrayList<ICProject> list = new ArrayList<ICProject>(cproject.length);
        int i = 0;
        while (i < cproject.length) {
            ICDescriptor cdesciptor = null;
            try {
                cdesciptor = CCorePlugin.getDefault().getCProjectDescription((IProject)cproject[i].getResource(), false);
                if (cdesciptor != null) {
                    String projectPlatform = cdesciptor.getPlatform();
                    if (this.filterPlatform.equals("*") || projectPlatform.equals("*") || this.filterPlatform.equalsIgnoreCase(projectPlatform)) {
                        list.add(cproject[i]);
                    }
                } else {
                    list.add(cproject[i]);
                }
            }
            catch (CoreException coreException) {
                list.add(cproject[i]);
            }
            ++i;
        }
        return list.toArray(new ICProject[list.size()]);
    }

    protected ICProject chooseCProject() {
        try {
            Object[] projects = this.getCProjects();
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(LaunchMessages.CMainTab_Project_Selection);
            dialog.setMessage(LaunchMessages.CMainTab_Choose_project_to_constrain_search_for_program);
            dialog.setElements(projects);
            ICProject cProject = this.getCProject();
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                return (ICProject)dialog.getFirstResult();
            }
        }
        catch (CModelException e) {
            LaunchUIPlugin.errorDialog("Launch UI internal error", e);
        }
        return null;
    }

    protected void updateBuildConfigCombo(String selectedConfigID) {
        if (this.fBuildConfigCombo != null) {
            ICProjectDescription projDes;
            this.fBuildConfigCombo.removeAll();
            int offset = 0;
            this.fBuildConfigCombo.add(LaunchMessages.CMainTab_Use_Active);
            this.fBuildConfigCombo.setData(String.valueOf(offset), (Object)EMPTY_STRING);
            this.fBuildConfigCombo.select(offset);
            ++offset;
            if (this.isAutoConfigSupported()) {
                this.fBuildConfigCombo.add(LaunchMessages.CMainTab_Use_Automatic);
                this.fBuildConfigCombo.setData(String.valueOf(offset), (Object)AUTO_CONFIG);
                if (AUTO_CONFIG.equals(selectedConfigID)) {
                    this.fBuildConfigCombo.select(offset);
                }
            }
            ++offset;
            ICProject cproject = this.getCProject();
            if (cproject != null && (projDes = CDTPropertyManager.getProjectDescription((IProject)cproject.getProject())) != null) {
                ICConfigurationDescription[] configurations = projDes.getConfigurations();
                int i = 0;
                while (i < configurations.length) {
                    String configName = configurations[i].getName();
                    String id = configurations[i].getId();
                    this.fBuildConfigCombo.add(configName);
                    int comboIndex = i + offset;
                    this.fBuildConfigCombo.setData(String.valueOf(comboIndex), (Object)id);
                    if (id.equals(selectedConfigID)) {
                        this.fBuildConfigCombo.select(comboIndex);
                    }
                    ++i;
                }
            }
        }
    }

    protected void createBuildConfigCombo(Composite parent, int colspan) {
        Composite comboComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comboComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colspan;
        comboComp.setLayoutData((Object)gd);
        Label dlabel = new Label(comboComp, 0);
        dlabel.setText(LaunchMessages.CMainTab_Build_Config);
        this.fBuildConfigCombo = new Combo(comboComp, 12);
        this.fBuildConfigCombo.setLayoutData((Object)new GridData(768));
        this.fBuildConfigCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CAbstractMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fBuildConfigAuto = new Button(comboComp, 32);
        GridData gd1 = new GridData(640);
        gd1.heightHint = 0;
        gd1.horizontalSpan = 2;
        this.fBuildConfigAuto.setLayoutData((Object)gd1);
        this.fBuildConfigAuto.setVisible(false);
        this.fBuildConfigAuto.setText(LaunchMessages.CMainTab_Build_Config_Auto);
    }

    protected void createBuildOptionGroup(final Composite parent, int colSpan) {
        Group buildGroup = new Group(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = colSpan;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        gridLayout.makeColumnsEqualWidth = true;
        buildGroup.setLayoutData((Object)gridData);
        buildGroup.setLayout((Layout)gridLayout);
        buildGroup.setText(LaunchMessages.CMainTab_Build_options);
        this.createBuildConfigCombo((Composite)buildGroup, 2);
        this.fEnableBuildButton = new Button((Composite)buildGroup, 16);
        this.fEnableBuildButton.setText(LaunchMessages.CMainTab_Enable_build_button_label);
        this.fEnableBuildButton.setToolTipText(LaunchMessages.CMainTab_Enable_build_button_tooltip);
        this.fEnableBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fDisableBuildButton = new Button((Composite)buildGroup, 16);
        this.fDisableBuildButton.setText(LaunchMessages.CMainTab_Disable_build_button_label);
        this.fDisableBuildButton.setToolTipText(LaunchMessages.CMainTab_Disable_build_button_tooltip);
        this.fDisableBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fWorkspaceSettingsButton = new Button((Composite)buildGroup, 16);
        this.fWorkspaceSettingsButton.setText(LaunchMessages.CMainTab_Workspace_settings_button_label);
        this.fWorkspaceSettingsButton.setToolTipText(LaunchMessages.CMainTab_Workspace_settings_button_tooltip);
        this.fWorkspaceSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fWorkpsaceSettingsLink = new Link((Composite)buildGroup, 0);
        this.fWorkpsaceSettingsLink.setText(LaunchMessages.CMainTab_Workspace_settings_link_label);
        this.fWorkpsaceSettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)CAbstractMainTab.LAUNCHING_PREFERENCE_PAGE_ID, null, null).open();
            }
        });
    }

    protected void updateBuildOptionFromConfig(ILaunchConfiguration config) {
        boolean configAuto = false;
        int buildBeforeLaunchValue = 2;
        try {
            buildBeforeLaunchValue = config.getAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", buildBeforeLaunchValue);
            configAuto = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", false);
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e);
        }
        if (configAuto) {
            this.updateBuildConfigCombo(AUTO_CONFIG);
        }
        this.updateComboTooltip();
        if (this.fDisableBuildButton != null) {
            this.fDisableBuildButton.setSelection(buildBeforeLaunchValue == 0);
        }
        if (this.fEnableBuildButton != null) {
            this.fEnableBuildButton.setSelection(buildBeforeLaunchValue == 1);
        }
        if (this.fWorkspaceSettingsButton != null) {
            this.fWorkspaceSettingsButton.setSelection(buildBeforeLaunchValue == 2);
        }
    }

    protected String handleBrowseButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.fProgText.getText());
        return fileDialog.open();
    }

    protected void createCoreFileGroup(Composite parent, int colSpan) {
        Composite coreComp = new Composite(parent, 0);
        GridLayout coreLayout = new GridLayout();
        coreLayout.numColumns = 3;
        coreLayout.marginHeight = 0;
        coreLayout.marginWidth = 0;
        coreComp.setLayout((Layout)coreLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        coreComp.setLayoutData((Object)gd);
        this.fCoreLabel = new Label(coreComp, 0);
        this.fCoreLabel.setText(LaunchMessages.CMainTab_CoreFile_path);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fCoreLabel.setLayoutData((Object)gd);
        this.fCoreText = new Text(coreComp, 2052);
        gd = new GridData(768);
        this.fCoreText.setLayoutData((Object)gd);
        this.fCoreText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseForCoreButton = this.createPushButton(coreComp, LaunchMessages.Launch_common_Browse_3, null);
        browseForCoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String text = CAbstractMainTab.this.handleBrowseButtonSelected();
                if (text != null) {
                    CAbstractMainTab.this.fCoreText.setText(text);
                }
                CAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    @Deprecated
    protected boolean isBinary(IProject project, IPath exePath) throws CoreException {
        try {
            Boolean binValue = this.fBinaryExeCache.get(exePath);
            if (binValue == null) {
                IBinaryParser.IBinaryObject exe = LaunchUtils.getBinary(project, exePath);
                binValue = exe != null;
                this.fBinaryExeCache.put(exePath, binValue);
            }
            return binValue;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    protected IBinary[] getBinaryFiles(final ICProject cproject) {
        if (cproject == null || !cproject.exists()) {
            return null;
        }
        Display display = this.getShell() == null ? LaunchUIPlugin.getShell().getDisplay() : this.getShell().getDisplay();
        final IBinary[][] ret = new IBinary[1][];
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = cproject.getBinaryContainer().getBinaries();
                }
                catch (CModelException e) {
                    LaunchUIPlugin.errorDialog("Launch UI internal error", e);
                }
            }
        });
        return ret[0];
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.fBuildConfigCombo != null) {
            String configId = (String)this.fBuildConfigCombo.getData(Integer.toString(this.fBuildConfigCombo.getSelectionIndex()));
            boolean auto = false;
            if (configId.equals(AUTO_CONFIG)) {
                auto = true;
                configId = this.getAutoConfigId();
            }
            config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", configId);
            config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", auto);
        }
        if (this.fDisableBuildButton != null) {
            int buildBeforeLaunchValue = 2;
            if (this.fDisableBuildButton.getSelection()) {
                buildBeforeLaunchValue = 0;
            } else if (this.fEnableBuildButton.getSelection()) {
                buildBeforeLaunchValue = 1;
            }
            config.setAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", buildBeforeLaunchValue);
        }
    }

    protected String getAutoConfigId() {
        ICConfigurationDescription autoConfig;
        String data = null;
        ICProject cproject = this.getCProject();
        if (cproject != null && (autoConfig = LaunchUtils.getBuildConfigByProgramPath(cproject.getProject(), this.fProgText.getText())) != null) {
            data = autoConfig.getId();
        }
        if (data == null) {
            data = EMPTY_STRING;
        }
        return data;
    }

    protected boolean isAutoConfigSupported() {
        return this.fBuildConfigAuto != null;
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        String configName = EMPTY_STRING;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
            configName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", EMPTY_STRING);
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log(ce);
        }
        if (!this.fProjText.getText().equals(projectName)) {
            this.fProjText.setText(projectName);
        }
        this.updateBuildConfigCombo(configName);
    }

    protected void updateProgramFromConfig(ILaunchConfiguration config) {
        if (this.fProgText != null) {
            String programName = EMPTY_STRING;
            try {
                programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STRING);
            }
            catch (CoreException ce) {
                LaunchUIPlugin.log(ce);
            }
            this.fProgText.setText(programName);
        }
    }

    protected void updateLaunchConfigurationDialog() {
        this.updateComboTooltip();
        super.updateLaunchConfigurationDialog();
    }

    protected void updateComboTooltip() {
        if (this.fBuildConfigCombo != null) {
            String configId = (String)this.fBuildConfigCombo.getData(Integer.toString(this.fBuildConfigCombo.getSelectionIndex()));
            String tooltip = EMPTY_STRING;
            if (configId != null) {
                if (configId.equals(AUTO_CONFIG)) {
                    tooltip = LaunchMessages.CMainTab_Build_Config_Auto_tooltip;
                } else if (configId.equals(EMPTY_STRING)) {
                    tooltip = LaunchMessages.CMainTab_Build_Config_Active_tooltip;
                }
            }
            this.fBuildConfigCombo.setToolTipText(tooltip);
        }
    }
}

