/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.core.AdapterUtil;
import org.eclipse.cdt.internal.ui.util.AbstractResourceActionHandler;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.GeneratedMakefileBuilder;
import org.eclipse.cdt.managedbuilder.internal.ui.commands.Messages;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;

public class BuildFilesHandler
extends AbstractResourceActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IFile> selectedFiles = this.getSelectedFiles(event);
        if (selectedFiles.isEmpty()) {
            return null;
        }
        BuildFilesJob buildFilesJob = new BuildFilesJob(selectedFiles);
        Collection<IProject> projects = this.getProjectsToBuild(selectedFiles);
        BuildUtilities.saveEditors(projects);
        buildFilesJob.schedule();
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        this.setBaseEnabled(this.shouldBeEnabled());
    }

    private boolean shouldBeEnabled() {
        IPreferencesService preferences = Platform.getPreferencesService();
        if (preferences.getBoolean("org.eclipse.core.resources", "description.autobuilding", false, null)) {
            return false;
        }
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            IFile file = (IFile)AdapterUtil.adapt(elements.next(), IFile.class);
            if (file == null) {
                return false;
            }
            if (!ManagedBuildManager.manages((IResource)file.getProject())) {
                return false;
            }
            IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)file.getProject());
            if (buildInfo == null || !buildInfo.isValid() || buildInfo.getDefaultConfiguration() == null || !buildInfo.getDefaultConfiguration().isManagedBuildOn()) {
                return false;
            }
            IManagedBuilderMakefileGenerator buildfileGenerator = ManagedBuildManager.getBuildfileGenerator((IConfiguration)buildInfo.getDefaultConfiguration());
            if (buildfileGenerator == null) {
                return false;
            }
            buildfileGenerator.initialize(file.getProject(), buildInfo, (IProgressMonitor)new NullProgressMonitor());
            if (buildInfo.buildsFileType(file.getFileExtension()) && !buildfileGenerator.isGeneratedResource((IResource)file)) continue;
            return false;
        }
        return true;
    }

    private List<IFile> getSelectedFiles(ExecutionEvent event) throws ExecutionException {
        Collection selectedResources = BuildFilesHandler.getSelectedResources((ExecutionEvent)event);
        ArrayList<IFile> files = new ArrayList<IFile>(selectedResources.size());
        for (IResource resource : selectedResources) {
            if (!(resource instanceof IFile)) continue;
            files.add((IFile)resource);
        }
        return files;
    }

    private Collection<IProject> getProjectsToBuild(List<IFile> selectedFiles) {
        HashSet<IProject> projectsToBuild = new HashSet<IProject>();
        for (IFile file : selectedFiles) {
            IProject project = file.getProject();
            if (projectsToBuild.contains(project) || !this.hasBuilder(project)) continue;
            projectsToBuild.add(project);
        }
        return projectsToBuild;
    }

    private boolean hasBuilder(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private static class BuildFilesJob
    extends Job {
        private final List<IFile> files;

        BuildFilesJob(List<IFile> filesToBuild) {
            super(Messages.BuildFilesHandler_buildingSelectedFiles);
            this.files = filesToBuild;
        }

        protected IStatus run(IProgressMonitor monitor) {
            GeneratedMakefileBuilder builder = new GeneratedMakefileBuilder();
            return builder.invokeInternalBuilder(this.files, monitor);
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

