/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize.dto;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;

public class GitSynchronizeDataSet
implements Iterable<GitSynchronizeData> {
    private boolean containsFolderLevelSynchronizationRequest = false;
    private final Set<GitSynchronizeData> gsdSet;
    private final Map<String, GitSynchronizeData> projectMapping;
    private final boolean forceFetch;

    public GitSynchronizeDataSet() {
        this(false);
    }

    public GitSynchronizeDataSet(boolean forceFetch) {
        this.forceFetch = forceFetch;
        this.gsdSet = new HashSet<GitSynchronizeData>();
        this.projectMapping = new HashMap<String, GitSynchronizeData>();
    }

    public GitSynchronizeDataSet(GitSynchronizeData data) {
        this();
        this.add(data);
    }

    public void add(GitSynchronizeData data) {
        this.gsdSet.add(data);
        if (data.getIncludedResources() != null && data.getIncludedResources().size() > 0) {
            this.containsFolderLevelSynchronizationRequest = true;
        }
        for (IProject proj : data.getProjects()) {
            this.projectMapping.put(proj.getName(), data);
        }
    }

    public boolean contains(IProject project) {
        return this.projectMapping.containsKey(project.getName());
    }

    public boolean containsFolderLevelSynchronizationRequest() {
        return this.containsFolderLevelSynchronizationRequest;
    }

    public int size() {
        return this.gsdSet.size();
    }

    public GitSynchronizeData getData(String projectName) {
        return this.projectMapping.get(projectName);
    }

    public GitSynchronizeData getData(IProject project) {
        return this.projectMapping.get(project.getName());
    }

    @Override
    public Iterator<GitSynchronizeData> iterator() {
        return this.gsdSet.iterator();
    }

    public IProject[] getAllProjects() {
        HashSet<IProject> resource = new HashSet<IProject>();
        for (GitSynchronizeData data : this.gsdSet) {
            resource.addAll(data.getProjects());
        }
        return resource.toArray(new IProject[resource.size()]);
    }

    public boolean shouldBeIncluded(IResource res) {
        IProject project = res.getProject();
        if (project == null) {
            return false;
        }
        GitSynchronizeData syncData = this.getData(project);
        if (syncData == null) {
            return false;
        }
        Set<IResource> includedResources = syncData.getIncludedResources();
        if (includedResources == null) {
            return true;
        }
        IPath path = res.getLocation();
        if (path != null) {
            for (IResource resource : includedResources) {
                IPath inclResourceLocation = resource.getLocation();
                if (inclResourceLocation == null || !inclResourceLocation.isPrefixOf(path)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean forceFetch() {
        return this.forceFetch;
    }

    public void dispose() {
        if (this.projectMapping != null) {
            this.projectMapping.clear();
        }
        if (this.gsdSet != null) {
            for (GitSynchronizeData gsd : this.gsdSet) {
                gsd.dispose();
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (GitSynchronizeData data : this.gsdSet) {
            builder.append(data.getRepository().getWorkTree());
            builder.append(" ");
        }
        return builder.toString();
    }
}

