/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.commands;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.IPersistableRegisterGroup;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.RegisterGroupDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractRegisterGroupCommandHandler
extends AbstractHandler {
    public void addRegisterGroup(IStructuredSelection selection) {
        ICDebugTarget t = this.getDebugTarget(selection);
        if (t != null) {
            try {
                IRegisterDescriptor[] registers = t.getRegisterDescriptors();
                RegisterGroupDialog dialog = new RegisterGroupDialog(Display.getCurrent().getActiveShell(), registers);
                if (dialog.open() == 0) {
                    t.addRegisterGroup(dialog.getName(), dialog.getDescriptors());
                }
            }
            catch (DebugException debugException) {}
        }
    }

    public boolean canAddRegisterGroup(IStructuredSelection selection) {
        ICDebugTarget target = this.getDebugTarget(selection);
        return target != null ? target.isSuspended() : false;
    }

    public void editRegisterGroup(IStructuredSelection selection) {
        IPersistableRegisterGroup group = this.getRegisterGroup(selection);
        if (group == null) {
            return;
        }
        try {
            IDebugTarget target;
            IRegisterDescriptor[] all = ((CDebugTarget)group.getDebugTarget()).getRegisterDescriptors();
            RegisterGroupDialog dialog = new RegisterGroupDialog(Display.getCurrent().getActiveShell(), group.getName(), all, group.getRegisterDescriptors());
            if (dialog.open() == 0 && (target = group.getDebugTarget()) instanceof ICDebugTarget) {
                ((ICDebugTarget)target).modifyRegisterGroup(group, dialog.getDescriptors());
            }
        }
        catch (DebugException e) {
            CDebugUIPlugin.errorDialog(ActionMessages.getString("EditRegisterGroupActionDelegate.0"), e.getStatus());
        }
    }

    public boolean canEditRegisterGroup(IStructuredSelection selection) {
        IPersistableRegisterGroup group = this.getRegisterGroup(selection);
        return group != null;
    }

    public void removeRegisterGroups(IStructuredSelection selection) {
        IDebugTarget target;
        IRegisterGroup[] groups = this.getRegisterGroups(selection);
        if (groups.length > 0 && (target = groups[0].getDebugTarget()) instanceof ICDebugTarget) {
            ((ICDebugTarget)target).removeRegisterGroups(groups);
        }
    }

    public boolean canRemoveRegisterGroups(IStructuredSelection selection) {
        IRegisterGroup[] groups = this.getRegisterGroups(selection);
        return groups.length > 0;
    }

    public void restoreDefaultGroups(IStructuredSelection selection) {
        this.getDebugTarget(selection).restoreDefaultRegisterGroups();
    }

    public boolean canRestoreDefaultGroups(IStructuredSelection selection) {
        ICDebugTarget target = this.getDebugTarget(selection);
        return target != null ? target.isSuspended() : false;
    }

    private ICDebugTarget getDebugTarget(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IDebugElement) {
            return (ICDebugTarget)((IDebugElement)element).getDebugTarget().getAdapter(ICDebugTarget.class);
        }
        return null;
    }

    private IPersistableRegisterGroup getRegisterGroup(IStructuredSelection ss) {
        Object s;
        IPersistableRegisterGroup selectedGroup = null;
        if (!ss.isEmpty() && (s = ss.getFirstElement()) instanceof IPersistableRegisterGroup) {
            selectedGroup = (IPersistableRegisterGroup)s;
        }
        return selectedGroup;
    }

    private IRegisterGroup[] getRegisterGroups(IStructuredSelection ss) {
        ArrayList<IRegisterGroup> list = new ArrayList<IRegisterGroup>();
        for (Object selection : ss) {
            if (!(selection instanceof IRegisterGroup)) continue;
            list.add((IRegisterGroup)selection);
        }
        return list.toArray(new IRegisterGroup[list.size()]);
    }
}

