/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.ui.IMemento;

public class IncludeMap {
    private static final String TAG_MAPPING = "mapping";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";
    private final boolean unconditionalSubstitution;
    private final LinkedHashMap<IncludeInfo, List<IncludeInfo>> map;

    public IncludeMap(boolean unconditionalSubstitution) {
        this.unconditionalSubstitution = unconditionalSubstitution;
        this.map = new LinkedHashMap();
    }

    public IncludeMap(boolean unconditionalSubstitution, String[] keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("More keys than values");
        }
        this.unconditionalSubstitution = unconditionalSubstitution;
        this.map = new LinkedHashMap(keysAndValues.length / 2);
        int i = 0;
        while (i < keysAndValues.length) {
            String key = keysAndValues[i++];
            this.addMapping(key, keysAndValues[i++]);
        }
    }

    public IncludeMap(IncludeMap other) {
        this.unconditionalSubstitution = other.unconditionalSubstitution;
        this.map = new LinkedHashMap(other.map.size());
        this.addAllMappings(other);
    }

    protected void addMapping(IncludeInfo from, IncludeInfo to) {
        if (from.equals(to)) {
            return;
        }
        List<IncludeInfo> list = this.map.get(from);
        if (list == null) {
            list = new ArrayList<IncludeInfo>(2);
            this.map.put(from, list);
        }
        list.add(to);
    }

    public void addMapping(String from, String to) {
        this.addMapping(new IncludeInfo(from), new IncludeInfo(to));
    }

    public List<IncludeInfo> getMapping(IncludeInfo from) {
        List<IncludeInfo> list = this.map.get(from);
        if (list == null) {
            if (!from.isSystem()) {
                list = this.map.get(new IncludeInfo(from.getName(), true));
            }
            if (list == null) {
                return Collections.emptyList();
            }
        }
        return list;
    }

    public List<IncludeInfo> removeMapping(String from) {
        return this.removeMapping(new IncludeInfo(from));
    }

    public List<IncludeInfo> removeMapping(IncludeInfo from) {
        return (List)this.map.remove(from);
    }

    public List<IncludeInfo> getMapping(String from) {
        return this.getMapping(new IncludeInfo(from));
    }

    public IncludeInfo getPreferredMapping(IncludeInfo from) {
        List<IncludeInfo> list = this.getMapping(from);
        return list == null ? null : list.get(0);
    }

    public boolean isUnconditionalSubstitution() {
        return this.unconditionalSubstitution;
    }

    public void saveToMemento(IMemento memento) {
        ArrayList<IncludeInfo> keys = new ArrayList<IncludeInfo>(this.map.keySet());
        Collections.sort(keys);
        for (IncludeInfo key : keys) {
            for (IncludeInfo value : this.map.get(key)) {
                IMemento mapping = memento.createChild(TAG_MAPPING);
                mapping.putString(TAG_KEY, key.toString());
                mapping.putString(TAG_VALUE, value.toString());
            }
        }
    }

    public static IncludeMap fromMemento(boolean unconditionalSubstitution, IMemento memento) {
        IncludeMap includeMap = new IncludeMap(unconditionalSubstitution);
        HashSet<String> keys = unconditionalSubstitution ? new HashSet<String>() : Collections.emptySet();
        IMemento[] iMementoArray = memento.getChildren(TAG_MAPPING);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento mapping = iMementoArray[n2];
            String key = mapping.getString(TAG_KEY);
            if (!unconditionalSubstitution || keys.add(key)) {
                includeMap.addMapping(key, mapping.getString(TAG_VALUE));
            }
            ++n2;
        }
        return includeMap;
    }

    public void addAllMappings(IncludeMap other) {
        if (other.unconditionalSubstitution != this.unconditionalSubstitution) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<IncludeInfo, List<IncludeInfo>> entry : other.map.entrySet()) {
            IncludeInfo source = entry.getKey();
            List<IncludeInfo> otherTargets = entry.getValue();
            List<IncludeInfo> targets = this.map.get(source);
            if (targets == null) {
                targets = new ArrayList<IncludeInfo>(otherTargets);
                this.map.put(source, targets);
                continue;
            }
            targets.addAll(otherTargets);
        }
    }

    public void transitivelyClose() {
        List<IncludeInfo> targets;
        IncludeInfo source;
        block0: for (Map.Entry<IncludeInfo, List<IncludeInfo>> entry : this.map.entrySet()) {
            IncludeInfo target;
            source = entry.getKey();
            targets = entry.getValue();
            ArrayDeque<IncludeInfo> queue = new ArrayDeque<IncludeInfo>(targets);
            targets.clear();
            HashSet<IncludeInfo> processed = new HashSet<IncludeInfo>();
            if (!this.unconditionalSubstitution) {
                processed.add(source);
            }
            HashSet<IncludeInfo> seenTargets = new HashSet<IncludeInfo>();
            while ((target = queue.pollFirst()) != null) {
                if (processed.contains(target)) continue;
                List<IncludeInfo> newTargets = this.map.get(target);
                if (newTargets != null) {
                    queue.addFirst(target);
                    boolean added = false;
                    if (seenTargets.add(target)) {
                        int i = newTargets.size();
                        while (--i >= 0) {
                            IncludeInfo newTarget = newTargets.get(i);
                            if (processed.contains(newTarget)) continue;
                            if (this.unconditionalSubstitution && newTarget.equals(source)) continue block0;
                            queue.addFirst(newTarget);
                            added = true;
                        }
                    }
                    if (added) continue;
                    target = queue.pollFirst();
                    targets.add(target);
                    if (this.unconditionalSubstitution) continue block0;
                    processed.add(target);
                    seenTargets.clear();
                    continue;
                }
                targets.add(target);
                if (this.unconditionalSubstitution) continue block0;
                processed.add(target);
                seenTargets.clear();
            }
        }
        if (this.unconditionalSubstitution) {
            Iterator<Map.Entry<IncludeInfo, List<IncludeInfo>>> iter = this.map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<IncludeInfo, List<IncludeInfo>> entry = iter.next();
                source = entry.getKey();
                targets = entry.getValue();
                if (!targets.isEmpty() && (targets.size() != 1 || !source.equals(targets.get(0)))) continue;
                iter.remove();
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("upconditionalSubstitution = ").append(this.unconditionalSubstitution);
        ArrayList<IncludeInfo> sources = new ArrayList<IncludeInfo>(this.map.keySet());
        Collections.sort(sources);
        for (IncludeInfo source : sources) {
            buf.append('\n');
            buf.append(source);
            buf.append(" -> ");
            List<IncludeInfo> targets = this.map.get(source);
            int i = 0;
            while (i < targets.size()) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(targets.get(i));
                ++i;
            }
        }
        return buf.toString();
    }

    public Map<IncludeInfo, List<IncludeInfo>> getMap() {
        return Collections.unmodifiableMap(this.map);
    }
}

