/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.sourcelookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;

@ThreadSafe
public class DsfSourceLookupParticipant
implements ISourceLookupParticipant {
    protected static final Object[] EMPTY = new Object[0];
    private DsfExecutor fExecutor;
    private String fSessionId;
    private DsfServicesTracker fServicesTracker;
    private ISourceLookupDirector fDirector;
    private Map<String, List<Object>> fLookupCache = Collections.synchronizedMap(new HashMap());

    public DsfSourceLookupParticipant(DsfSession session) {
        this.fSessionId = session.getId();
        this.fExecutor = session.getExecutor();
        this.fServicesTracker = new DsfServicesTracker(DsfPlugin.getBundleContext(), this.fSessionId);
    }

    public void init(ISourceLookupDirector director) {
        this.fDirector = director;
    }

    public void dispose() {
        this.fServicesTracker.dispose();
        this.fDirector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] findSourceElements(Object object) throws CoreException {
        CoreException single = null;
        MultiStatus multiStatus = null;
        List<Object> results = null;
        String name = this.getSourceName(object);
        if (name != null) {
            results = this.fLookupCache.get(name);
            if (results != null) {
                return results.toArray();
            }
            results = new ArrayList<Object>();
            ISourceContainer[] containers = this.getSourceContainers();
            if (containers.length == 0) {
                containers = new ISourceContainer[]{new AbsolutePathSourceContainer()};
            }
            int i = 0;
            while (i < containers.length) {
                block17: {
                    try {
                        Object[] objects;
                        ISourceContainer container = containers[i];
                        if (container == null || (objects = container.findSourceElements(name)).length <= 0) break block17;
                        if (this.isFindDuplicates()) {
                            results.addAll(Arrays.asList(objects));
                            break block17;
                        }
                        results.add(objects[0]);
                        break;
                    }
                    catch (CoreException e) {
                        if (single == null) {
                            single = e;
                        }
                        if (multiStatus == null) {
                            multiStatus = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 120, new IStatus[]{single.getStatus()}, "Source Lookup error", null);
                            multiStatus.add(e.getStatus());
                        }
                        multiStatus.add(e.getStatus());
                    }
                }
                ++i;
            }
            if (!results.isEmpty()) {
                Map<String, List<Object>> map = this.fLookupCache;
                synchronized (map) {
                    if (!this.fLookupCache.containsKey(name)) {
                        this.fLookupCache.put(name, results);
                    }
                }
            }
        }
        if (results == null || results.isEmpty()) {
            if (multiStatus != null) {
                throw new CoreException(multiStatus);
            }
            if (single != null) {
                throw single;
            }
            return EMPTY;
        }
        return results.toArray();
    }

    protected boolean isFindDuplicates() {
        ISourceLookupDirector director = this.fDirector;
        if (director != null) {
            return director.isFindDuplicates();
        }
        return false;
    }

    protected ISourceContainer[] getSourceContainers() {
        ISourceLookupDirector director = this.fDirector;
        if (director != null) {
            return director.getSourceContainers();
        }
        return new ISourceContainer[0];
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.fLookupCache.clear();
    }

    public String getSourceName(Object object) throws CoreException {
        block7: {
            if (!(object instanceof IDMContext) || !((IDMContext)object).getSessionId().equals(this.fSessionId)) {
                return null;
            }
            final IDMContext dmc = (IDMContext)object;
            Query<String> query = new Query<String>(){

                @Override
                protected void execute(DataRequestMonitor<String> rm) {
                    DsfSourceLookupParticipant.this.getSourceNameOnDispatchThread(dmc, rm);
                }
            };
            this.fExecutor.execute(query);
            try {
                String result = (String)query.get();
                if (result != null && result.length() == 0) {
                    result = null;
                }
                return result;
            }
            catch (InterruptedException interruptedException) {
                assert (false) : "Interrupted exception in DSF executor";
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)"Unexptected exception");
            }
        }
        return null;
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    private void getSourceNameOnDispatchThread(IDMContext dmc, final DataRequestMonitor<String> rm) {
        if (!(dmc instanceof IStack.IFrameDMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10002, "No source for this object", null));
            rm.done();
            return;
        }
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)dmc;
        IStack stackService = this.fServicesTracker.getService(IStack.class);
        if (stackService == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10002, "Stack data not available", null));
            rm.done();
            return;
        }
        stackService.getFrameData(frameDmc, new DataRequestMonitor<IStack.IFrameDMData>((Executor)this.fExecutor, rm){

            @Override
            public void handleSuccess() {
                rm.setData(((IStack.IFrameDMData)this.getData()).getFile());
                rm.done();
            }
        });
    }
}

