/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.action;

import java.io.File;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.gcov.action.Messages;
import org.eclipse.linuxtools.internal.gcov.dialog.OpenGCDialog;
import org.eclipse.linuxtools.internal.gcov.view.CovView;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.GcovAnnotationModelTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PlatformUI;

public class OpenGCAction
implements IEditorLauncher {
    public void autoOpen(final IPath file, String binaryPath, final boolean isCompleteCoverageResultWanted) {
        final GCFilePair pair = new GCFilePair(file);
        if (this.isFileValid(pair.gcda) && this.isFileValid(pair.gcno)) {
            final String safeBinaryPath = STSymbolManager.sharedInstance.getBinaryObject(binaryPath) == null ? this.getDefaultBinary(file) : binaryPath;
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    OpenGCAction.this.displayCoverage(file, safeBinaryPath, pair.gcda, isCompleteCoverageResultWanted);
                }
            });
        }
    }

    public void open(IPath file) {
        GCFilePair pair = new GCFilePair(file);
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (!this.isFileValid(pair.gcda)) {
            String msg = NLS.bind((String)Messages.OpenGCAction_file_dne_run, (Object)pair.gcda);
            MessageDialog.openError((Shell)shell, (String)Messages.OpenGCAction_gcov_error, (String)msg);
            return;
        }
        if (!this.isFileValid(pair.gcno)) {
            String msg = NLS.bind((String)Messages.OpenGCAction_file_dne_compile, (Object)pair.gcno);
            MessageDialog.openError((Shell)shell, (String)Messages.OpenGCAction_gcov_error, (String)msg);
            return;
        }
        OpenGCDialog d = new OpenGCDialog(shell, this.getDefaultBinary(file), file);
        if (d.open() != 0) {
            return;
        }
        this.displayCoverage(file, d.getBinaryFile(), pair.gcda, d.isCompleteCoverageResultWanted());
    }

    private void displayCoverage(IPath file, String binaryPath, File gcda, boolean isCompleteCoverageResultWanted) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file).getProject();
        GcovAnnotationModelTracker.getInstance().addProject(project, (IPath)new Path(binaryPath));
        GcovAnnotationModelTracker.getInstance().annotateAllCEditors();
        if (isCompleteCoverageResultWanted) {
            CovView.displayCovResults(binaryPath, gcda.getAbsolutePath());
        } else {
            CovView.displayCovDetailedResult(binaryPath, gcda.getAbsolutePath());
        }
    }

    private String getDefaultBinary(IPath file) {
        ICProject cproject;
        IProject project;
        IFile c = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
        if (c != null && (project = c.getProject()) != null && project.exists() && (cproject = CoreModel.getDefault().create(project)) != null) {
            try {
                IBinary[] b = cproject.getBinaryContainer().getBinaries();
                if (b != null && b.length > 0 && b[0] != null) {
                    IResource r = b[0].getResource();
                    return r.getLocation().toOSString();
                }
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
        return "";
    }

    private boolean isFileValid(File file) {
        return file != null && file.isFile() && file.exists();
    }

    private class GCFilePair {
        final File gcda;
        final File gcno;

        private GCFilePair(IPath file) {
            String extension = file.getFileExtension();
            if ("gcno".equals(extension)) {
                this.gcda = file.removeFileExtension().addFileExtension("gcda").toFile();
                this.gcno = file.toFile();
            } else if ("gcda".equals(extension)) {
                this.gcda = file.toFile();
                this.gcno = file.removeFileExtension().addFileExtension("gcno").toFile();
            } else {
                this.gcda = null;
                this.gcno = null;
            }
        }
    }
}

