/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    long modelHandle;
    long checkRenderer;
    int columnCount;
    int sortDirection;
    long ignoreCell;
    TreeItem[] items;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    TreeItem currentItem;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    boolean modelChanged;
    boolean expandAll;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean ignoreAccessibility;
    static final int ID_COLUMN = 0;
    static final int CHECKED_COLUMN = 1;
    static final int GRAYED_COLUMN = 2;
    static final int FOREGROUND_COLUMN = 3;
    static final int BACKGROUND_COLUMN = 4;
    static final int FONT_COLUMN = 5;
    static final int FIRST_COLUMN = 6;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        if (!this.ownerDraw) {
            switch (eventType) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TreeItem _getItem(long iter) {
        int id = this.getId(iter, true);
        if (this.items[id] != null) {
            return this.items[id];
        }
        long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
        int depth = OS.gtk_tree_path_get_depth(path);
        int[] indices = new int[depth];
        OS.memmove(indices, OS.gtk_tree_path_get_indices(path), (long)(4 * depth));
        long parentIter = 0L;
        if (depth > 1) {
            OS.gtk_tree_path_up(path);
            parentIter = OS.g_malloc(OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_get_iter(this.modelHandle, parentIter, path);
        }
        this.items[id] = new TreeItem(this, parentIter, 0, indices[indices.length - 1], false);
        OS.gtk_tree_path_free(path);
        if (parentIter != 0L) {
            OS.g_free(parentIter);
        }
        return this.items[id];
    }

    TreeItem _getItem(long parentIter, int index) {
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parentIter, index);
        int id = this.getId(iter, true);
        OS.g_free(iter);
        if (this.items[id] != null) {
            return this.items[id];
        }
        this.items[id] = new TreeItem(this, parentIter, 0, index, false);
        return this.items[id];
    }

    int getId(long iter, boolean queryModel) {
        if (queryModel) {
            int[] value = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
            if (value[0] != -1) {
                return value[0];
            }
        }
        int id = 0;
        while (id < this.items.length && this.items[id] != null) {
            ++id;
        }
        if (id == this.items.length) {
            TreeItem[] newItems = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        OS.gtk_tree_store_set(this.modelHandle, iter, 0, id, -1);
        return id;
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Tree.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    long cellDataProc(long tree_column, long cell, long tree_model, long iter, long data) {
        if (cell == this.ignoreCell) {
            return 0L;
        }
        TreeItem item = this._getItem(iter);
        if (item != null) {
            OS.g_object_set_qdata(cell, Display.SWT_OBJECT_INDEX2, item.handle);
        }
        boolean isPixbuf = OS.GTK_IS_CELL_RENDERER_PIXBUF(cell);
        boolean isText = OS.GTK_IS_CELL_RENDERER_TEXT(cell);
        if (isText && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(cell, -1, -1);
        }
        if (!isPixbuf && !isText) {
            return 0L;
        }
        int modelIndex = -1;
        boolean customDraw = false;
        if (this.columnCount == 0) {
            modelIndex = 6;
            customDraw = this.firstCustomDraw;
        } else {
            TreeColumn column = (TreeColumn)this.display.getWidget(tree_column);
            if (column != null) {
                modelIndex = column.modelIndex;
                customDraw = column.customDraw;
            }
        }
        if (modelIndex == -1) {
            return 0L;
        }
        boolean setData = false;
        if ((this.style & 0x10000000) != 0 && !item.cached) {
            setData = this.checkData(item);
        }
        long[] ptr = new long[1];
        if (setData) {
            if (isPixbuf) {
                ptr[0] = 0L;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 0, ptr, -1);
                OS.g_object_set(cell, OS.GTK3 ? OS.gicon : OS.pixbuf, ptr[0], 0L);
                if (ptr[0] != 0L) {
                    OS.g_object_unref(ptr[0]);
                }
            } else {
                ptr[0] = 0L;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 1, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.text, ptr[0], 0L);
                    OS.g_free(ptr[0]);
                }
            }
        }
        if (customDraw) {
            if (!this.ownerDraw) {
                ptr[0] = 0L;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 3, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.cell_background_gdk, ptr[0], 0L);
                    OS.gdk_color_free(ptr[0]);
                }
            }
            if (!isPixbuf) {
                ptr[0] = 0L;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 2, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.foreground_gdk, ptr[0], 0L);
                    OS.gdk_color_free(ptr[0]);
                }
                ptr[0] = 0L;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 4, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.font_desc, ptr[0], 0L);
                    OS.pango_font_description_free(ptr[0]);
                }
            }
        }
        if (setData) {
            this.ignoreCell = cell;
            this.setScrollWidth(tree_column, item);
            this.ignoreCell = 0L;
        }
        return 0L;
    }

    boolean checkData(TreeItem item) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            TreeItem parentItem = item.getParentItem();
            Event event = new Event();
            event.item = item;
            event.index = parentItem == null ? this.indexOf(item) : parentItem.indexOf(item);
            int mask = 17;
            int signal_id = OS.g_signal_lookup(OS.row_changed, OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, mask, signal_id, 0, 0L, 0L, this.handle);
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, mask, signal_id, 0, 0L, 0L, this.handle);
            if (item.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(long column, long iter, boolean recurse) {
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
        int width = 0;
        int[] w = new int[1];
        long path = 0L;
        if (OS.gtk_tree_view_get_expander_column(this.handle) == column) {
            GdkRectangle rect = new GdkRectangle();
            OS.gtk_widget_realize(this.handle);
            path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            OS.gtk_tree_view_get_cell_area(this.handle, path, column, rect);
            width += rect.x;
            OS.gtk_widget_style_get(this.handle, OS.expander_size, w, 0L);
            width += w[0] + 4;
        }
        OS.gtk_widget_style_get(this.handle, OS.focus_line_width, w, 0L);
        width += 2 * w[0];
        long list = OS.gtk_cell_layout_get_cells(column);
        if (list == 0L) {
            return 0;
        }
        long temp = list;
        while (temp != 0L) {
            long renderer = OS.g_list_data(temp);
            if (renderer != 0L) {
                this.gtk_cell_renderer_get_preferred_size(renderer, this.handle, w, null);
                width += w[0];
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        if (recurse) {
            boolean expanded;
            if (path == 0L) {
                path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            }
            if (expanded = OS.gtk_tree_view_row_expanded(this.handle, path)) {
                long childIter = OS.g_malloc(OS.GtkTreeIter_sizeof());
                boolean valid = OS.gtk_tree_model_iter_children(this.modelHandle, childIter, iter);
                while (valid) {
                    width = Math.max(width, this.calculateWidth(column, childIter, true));
                    valid = OS.gtk_tree_model_iter_next(this.modelHandle, childIter);
                }
                OS.g_free(childIter);
            }
        }
        if (path != 0L) {
            OS.gtk_tree_path_free(path);
        }
        if (OS.gtk_tree_view_get_grid_lines(this.handle) > 0) {
            OS.gtk_widget_style_get(this.handle, OS.grid_line_width, w, 0L);
            width += 2 * w[0];
        }
        return width;
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        this.clear(0L, index, all);
    }

    void clear(long parentIter, int index, boolean all) {
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parentIter, index);
        int[] value = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
        if (value[0] != -1) {
            TreeItem item = this.items[value[0]];
            item.clear();
        }
        if (all) {
            this.clearAll(all, iter);
        }
        OS.g_free(iter);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.clearAll(all, 0L);
    }

    void clearAll(boolean all, long parentIter) {
        int length = OS.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (length == 0) {
            return;
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        boolean valid = OS.gtk_tree_model_iter_children(this.modelHandle, iter, parentIter);
        int[] value = new int[1];
        while (valid) {
            OS.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
            if (value[0] != -1) {
                TreeItem item = this.items[value[0]];
                item.clear();
            }
            if (all) {
                this.clearAll(all, iter);
            }
            valid = OS.gtk_tree_model_iter_next(this.modelHandle, iter);
        }
        OS.g_free(iter);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        OS.gtk_widget_realize(this.handle);
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if (size.x == 0 && wHint == -1) {
            size.x = 64;
        }
        if (OS.GTK3 && size.y == 0 && hHint == -1) {
            size.y = this.getItemCount() * this.getItemHeight();
        }
        if (size.y == 0 && hHint == -1) {
            size.y = 64;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    void copyModel(long oldModel, int oldStart, long newModel, int newStart, long[] types, long oldParent, long newParent, int modelLength) {
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_iter_children(oldModel, iter, oldParent)) {
            long[] oldItems = new long[OS.gtk_tree_model_iter_n_children(oldModel, oldParent)];
            int oldIndex = 0;
            long[] ptr = new long[1];
            int[] ptr1 = new int[1];
            do {
                long newItem;
                if ((newItem = OS.g_malloc(OS.GtkTreeIter_sizeof())) == 0L) {
                    this.error(2);
                }
                OS.gtk_tree_store_append(newModel, newItem, newParent);
                OS.gtk_tree_model_get(oldModel, iter, 0, ptr1, -1);
                int index = ptr1[0];
                TreeItem item = null;
                if (index != -1) {
                    item = this.items[index];
                    if (item != null) {
                        long oldItem = item.handle;
                        oldItems[oldIndex++] = oldItem;
                        int j = 0;
                        while (j < 3) {
                            OS.gtk_tree_model_get(oldModel, oldItem, j, ptr1, -1);
                            OS.gtk_tree_store_set(newModel, newItem, j, ptr1[0], -1);
                            ++j;
                        }
                        j = 3;
                        while (j < 6) {
                            OS.gtk_tree_model_get(oldModel, oldItem, j, ptr, -1);
                            OS.gtk_tree_store_set(newModel, newItem, j, ptr[0], -1);
                            if (ptr[0] != 0L) {
                                if (types[j] == OS.G_TYPE_STRING()) {
                                    OS.g_free(ptr[0]);
                                } else if (types[j] == OS.GDK_TYPE_COLOR()) {
                                    OS.gdk_color_free(ptr[0]);
                                } else if (types[j] == OS.GDK_TYPE_PIXBUF()) {
                                    OS.g_object_unref(ptr[0]);
                                } else if (types[j] == OS.PANGO_TYPE_FONT_DESCRIPTION()) {
                                    OS.pango_font_description_free(ptr[0]);
                                }
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < modelLength - 6) {
                            int newIndex = newStart + j;
                            OS.gtk_tree_model_get(oldModel, oldItem, oldStart + j, ptr, -1);
                            OS.gtk_tree_store_set(newModel, newItem, newIndex, ptr[0], -1);
                            if (ptr[0] != 0L) {
                                if (types[newIndex] == OS.G_TYPE_STRING()) {
                                    OS.g_free(ptr[0]);
                                } else if (types[newIndex] == OS.GDK_TYPE_COLOR()) {
                                    OS.gdk_color_free(ptr[0]);
                                } else if (types[newIndex] == OS.GDK_TYPE_PIXBUF()) {
                                    OS.g_object_unref(ptr[0]);
                                } else if (types[newIndex] == OS.PANGO_TYPE_FONT_DESCRIPTION()) {
                                    OS.pango_font_description_free(ptr[0]);
                                }
                            }
                            ++j;
                        }
                    }
                } else {
                    OS.gtk_tree_store_set(newModel, newItem, 0, -1, -1);
                }
                this.copyModel(oldModel, oldStart, newModel, newStart, types, iter, newItem, modelLength);
                if (item != null) {
                    item.handle = newItem;
                    continue;
                }
                OS.g_free(newItem);
            } while (OS.gtk_tree_model_iter_next(oldModel, iter));
            int i = 0;
            while (i < oldItems.length) {
                long oldItem = oldItems[i];
                if (oldItem != 0L) {
                    OS.gtk_tree_store_remove(oldModel, oldItem);
                    OS.g_free(oldItem);
                }
                ++i;
            }
        }
        OS.g_free(iter);
    }

    void createColumn(TreeColumn column, int index) {
        long columnHandle;
        int modelIndex = 6;
        if (this.columnCount != 0) {
            int modelLength = OS.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] usedColumns = new boolean[modelLength];
            int i = 0;
            while (i < this.columnCount) {
                int columnIndex = this.columns[i].modelIndex;
                int j = 0;
                while (j < 5) {
                    usedColumns[columnIndex + j] = true;
                    ++j;
                }
                ++i;
            }
            while (modelIndex < modelLength) {
                if (!usedColumns[modelIndex]) break;
                ++modelIndex;
            }
            if (modelIndex == modelLength) {
                long oldModel = this.modelHandle;
                long[] types = this.getColumnTypes(this.columnCount + 4);
                long newModel = OS.gtk_tree_store_newv(types.length, types);
                if (newModel == 0L) {
                    this.error(2);
                }
                this.copyModel(oldModel, 6, newModel, 6, types, 0L, 0L, modelLength);
                OS.gtk_tree_view_set_model(this.handle, newModel);
                this.setModel(newModel);
            }
        }
        if ((columnHandle = OS.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        if (index == 0 && this.columnCount > 0) {
            TreeColumn checkColumn = this.columns[0];
            this.createRenderers(checkColumn.handle, checkColumn.modelIndex, false, checkColumn.style);
        }
        this.createRenderers(columnHandle, modelIndex, index == 0, column == null ? 0 : column.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing(columnHandle, 0);
        } else {
            OS.gtk_tree_view_column_set_sizing(columnHandle, 2);
        }
        OS.gtk_tree_view_column_set_resizable(columnHandle, true);
        OS.gtk_tree_view_column_set_clickable(columnHandle, true);
        OS.gtk_tree_view_column_set_min_width(columnHandle, 0);
        OS.gtk_tree_view_insert_column(this.handle, columnHandle, index);
        if (this.columnCount != 0) {
            OS.gtk_tree_view_column_set_visible(columnHandle, false);
        }
        if (column != null) {
            column.handle = columnHandle;
            column.modelIndex = modelIndex;
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] types = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_tree_store_newv(types.length, types);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        long selectionHandle = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(selectionHandle, mode);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0L);
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        }
    }

    int applyThemeBackground() {
        return -1;
    }

    void createItem(TreeColumn column, int index) {
        long imageHandle;
        long labelHandle;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (index == 0) {
            column.style &= 0xFEFDBFFF;
            column.style |= 0x4000;
        }
        if (this.columnCount == 0) {
            column.handle = OS.gtk_tree_view_get_column(this.handle, 0);
            OS.gtk_tree_view_column_set_sizing(column.handle, 2);
            OS.gtk_tree_view_column_set_visible(column.handle, false);
            column.modelIndex = 6;
            this.createRenderers(column.handle, column.modelIndex, true, column.style);
            column.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(column, index);
        }
        long boxHandle = this.gtk_box_new(0, false, 3);
        if (boxHandle == 0L) {
            this.error(2);
        }
        if ((labelHandle = OS.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((imageHandle = OS.gtk_image_new()) == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(boxHandle, imageHandle);
        OS.gtk_container_add(boxHandle, labelHandle);
        OS.gtk_widget_show(boxHandle);
        OS.gtk_widget_show(labelHandle);
        column.labelHandle = labelHandle;
        column.imageHandle = imageHandle;
        OS.gtk_tree_view_column_set_widget(column.handle, boxHandle);
        if (OS.GTK3) {
            column.buttonHandle = OS.gtk_tree_view_column_get_button(column.handle);
        } else {
            long widget = OS.gtk_widget_get_parent(boxHandle);
            while (widget != this.handle) {
                if (OS.GTK_IS_BUTTON(widget)) {
                    column.buttonHandle = widget;
                    break;
                }
                widget = OS.gtk_widget_get_parent(widget);
            }
        }
        if (this.columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        if ((this.state & 0x4000) != 0) {
            column.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            int i = 0;
            while (i < this.items.length) {
                Font[] cellFont;
                TreeItem item = this.items[i];
                if (item != null && (cellFont = item.cellFont) != null) {
                    Font[] temp = new Font[this.columnCount];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                    item.cellFont = temp;
                }
                ++i;
            }
        }
    }

    void createItem(TreeItem item, long parentIter, int index) {
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (index == -1) {
            index = count;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        item.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (item.handle == 0L) {
            this.error(2);
        }
        if (index == count) {
            OS.gtk_tree_store_append(this.modelHandle, item.handle, parentIter);
        } else {
            OS.gtk_tree_store_insert(this.modelHandle, item.handle, parentIter, index);
        }
        int id = this.getId(item.handle, false);
        this.items[id] = item;
        this.modelChanged = true;
    }

    void createRenderers(long columnHandle, int modelIndex, boolean check, int columnStyle) {
        long textRenderer;
        long pixbufRenderer;
        OS.gtk_tree_view_column_clear(columnHandle);
        if ((this.style & 0x20) != 0 && check) {
            OS.gtk_tree_view_column_pack_start(columnHandle, this.checkRenderer, false);
            OS.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.active, 1);
            OS.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.inconsistent, 2);
            if (!this.ownerDraw) {
                OS.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.cell_background_gdk, 4);
            }
            if (this.ownerDraw) {
                OS.gtk_tree_view_column_set_cell_data_func(columnHandle, this.checkRenderer, this.display.cellDataProc, this.handle, 0L);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            }
        }
        long l = pixbufRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0L) : OS.gtk_cell_renderer_pixbuf_new();
        if (pixbufRenderer == 0L) {
            this.error(2);
        } else if (!this.ownerDraw && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(pixbufRenderer, 16, 16);
        }
        long l2 = textRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0L) : OS.gtk_cell_renderer_text_new();
        if (textRenderer == 0L) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(pixbufRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            OS.g_object_set_qdata(textRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
        }
        if ((this.style & 0x20) != 0 && check) {
            OS.g_object_set(pixbufRenderer, OS.mode, 1, 0L);
        }
        if ((columnStyle & 0x20000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 1.0f, 0L);
            OS.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            OS.gtk_tree_view_column_pack_end(columnHandle, pixbufRenderer, false);
            OS.gtk_tree_view_column_set_alignment(columnHandle, 1.0f);
        } else if ((columnStyle & 0x1000000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 0.5f, 0L);
            OS.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            OS.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            OS.gtk_tree_view_column_set_alignment(columnHandle, 0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            OS.gtk_tree_view_column_pack_start(columnHandle, textRenderer, true);
            OS.gtk_tree_view_column_set_alignment(columnHandle, 0.0f);
        }
        OS.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.GTK3 ? OS.gicon : OS.pixbuf, modelIndex + 0);
        if (!this.ownerDraw) {
            OS.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.cell_background_gdk, 4);
            OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.cell_background_gdk, 4);
        }
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.text, modelIndex + 1);
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.foreground_gdk, 3);
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.font_desc, 5);
        boolean customDraw = this.firstCustomDraw;
        if (this.columnCount != 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if ((this.style & 0x10000000) != 0 || customDraw || this.ownerDraw) {
            OS.gtk_tree_view_column_set_cell_data_func(columnHandle, textRenderer, this.display.cellDataProc, this.handle, 0L);
            OS.gtk_tree_view_column_set_cell_data_func(columnHandle, pixbufRenderer, this.display.cellDataProc, this.handle, 0L);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.columnCount = 0;
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_iter(selection, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TreeColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        if (index == this.columnCount) {
            return;
        }
        long columnHandle = column.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = column.customDraw;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        OS.gtk_tree_view_remove_column(this.handle, columnHandle);
        if (this.columnCount == 0) {
            long oldModel = this.modelHandle;
            long[] types = this.getColumnTypes(1);
            long newModel = OS.gtk_tree_store_newv(types.length, types);
            if (newModel == 0L) {
                this.error(2);
            }
            this.copyModel(oldModel, column.modelIndex, newModel, 6, types, 0L, 0L, 11);
            OS.gtk_tree_view_set_model(this.handle, newModel);
            this.setModel(newModel);
            this.createColumn(null, 0);
        } else {
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    long iter = item.handle;
                    int modelIndex = column.modelIndex;
                    OS.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 0, 0L, -1);
                    OS.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 1, 0L, -1);
                    OS.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 2, 0L, -1);
                    OS.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 3, 0L, -1);
                    OS.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 4, 0L, -1);
                    Font[] cellFont = item.cellFont;
                    if (cellFont != null) {
                        if (this.columnCount == 0) {
                            item.cellFont = null;
                        } else {
                            Font[] temp = new Font[this.columnCount];
                            System.arraycopy(cellFont, 0, temp, 0, index);
                            System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - index);
                            item.cellFont = temp;
                        }
                    }
                }
                ++i;
            }
            if (index == 0) {
                TreeColumn firstColumn = this.columns[0];
                firstColumn.style &= 0xFEFDBFFF;
                firstColumn.style |= 0x4000;
                this.createRenderers(firstColumn.handle, firstColumn.modelIndex, true, firstColumn.style);
            }
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    void destroyItem(TreeItem item) {
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_store_remove(this.modelHandle, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        this.modelChanged = true;
    }

    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean dragDetect;
        boolean selected = false;
        if (filter) {
            long[] path = new long[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, null, null, null)) {
                if (path[0] != 0L) {
                    long selection = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                        selected = true;
                    }
                    OS.gtk_tree_path_free(path[0]);
                }
            } else {
                return false;
            }
        }
        if ((dragDetect = super.dragDetect(x, y, filter, false, consume)) && selected && consume != null) {
            consume[0] = true;
        }
        return dragDetect;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    boolean fixAccessibility() {
        return true;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        int i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this.columns[i];
            if (column.toolTipText != null) {
                column.setToolTipText(oldShell, null);
                column.setToolTipText(newShell, column.toolTipText);
            }
            ++i;
        }
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        OS.gtk_widget_realize(this.handle);
        long fixedWindow = this.gtk_widget_get_window(this.fixedHandle);
        long binWindow = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] binX = new int[1];
        int[] binY = new int[1];
        OS.gdk_window_get_origin(binWindow, binX, binY);
        int[] fixedX = new int[1];
        int[] fixedY = new int[1];
        OS.gdk_window_get_origin(fixedWindow, fixedX, fixedY);
        long clientHandle = this.clientHandle();
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(clientHandle, allocation);
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        Rectangle rect = new Rectangle(fixedX[0] - binX[0], fixedY[0] - binY[0], width, height);
        if (this.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            rect.y += this.getHeaderHeight();
        }
        return rect;
    }

    int getClientWidth() {
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gtk_widget_realize(this.handle);
        this.gdk_window_get_size(OS.gtk_tree_view_get_bin_window(this.handle), w, h);
        return w[0];
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        long list = OS.gtk_tree_view_get_columns(this.handle);
        if (list == 0L) {
            return new int[0];
        }
        int i = 0;
        int count = OS.g_list_length(list);
        int[] order = new int[count];
        long temp = list;
        while (temp != 0L) {
            long column = OS.g_list_data(temp);
            if (column != 0L) {
                int j = 0;
                while (j < this.columnCount) {
                    if (this.columns[j].handle == column) {
                        order[i++] = j;
                        break;
                    }
                    ++j;
                }
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        return order;
    }

    long[] getColumnTypes(int columnCount) {
        long[] types = new long[6 + columnCount * 5];
        types[0] = OS.G_TYPE_INT();
        types[1] = OS.G_TYPE_BOOLEAN();
        types[2] = OS.G_TYPE_BOOLEAN();
        types[3] = OS.GDK_TYPE_COLOR();
        types[4] = OS.GDK_TYPE_COLOR();
        types[5] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        int i = 6;
        while (i < types.length) {
            types[i + 0] = OS.GDK_TYPE_PIXBUF();
            types[i + 1] = OS.G_TYPE_STRING();
            types[i + 2] = OS.GDK_TYPE_COLOR();
            types[i + 3] = OS.GDK_TYPE_COLOR();
            types[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            i += 5;
        }
        return types;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    TreeItem getFocusItem() {
        long[] path = new long[1];
        OS.gtk_tree_view_get_cursor(this.handle, path, null);
        if (path[0] == 0L) {
            return null;
        }
        TreeItem item = null;
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, iter, path[0])) {
            int[] index = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
            if (index[0] != -1) {
                item = this.items[index[0]];
            }
        }
        OS.g_free(iter);
        OS.gtk_tree_path_free(path[0]);
        return item;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition requisition = new GtkRequisition();
            int height = 0;
            int i = 0;
            while (i < this.columnCount) {
                long buttonHandle = this.columns[i].buttonHandle;
                if (buttonHandle != 0L) {
                    this.gtk_widget_get_preferred_size(buttonHandle, requisition);
                    height = Math.max(height, requisition.height);
                }
                ++i;
            }
            return height;
        }
        OS.gtk_widget_realize(this.handle);
        long fixedWindow = this.gtk_widget_get_window(this.fixedHandle);
        long binWindow = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] binY = new int[1];
        OS.gdk_window_get_origin(binWindow, null, binY);
        int[] fixedY = new int[1];
        OS.gdk_window_get_origin(fixedWindow, null, fixedY);
        return binY[0] - fixedY[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        return this._getItem(0L, index);
    }

    public TreeItem getItem(Point point) {
        long[] columnHandle;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        long[] path = new long[1];
        OS.gtk_widget_realize(this.handle);
        int x = point.x;
        int y = point.y;
        if (this.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            y -= this.getHeaderHeight();
        }
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - x;
        }
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, columnHandle = new long[1], null, null)) {
            return null;
        }
        if (path[0] == 0L) {
            return null;
        }
        TreeItem item = null;
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, iter, path[0])) {
            boolean overExpander = false;
            if (OS.gtk_tree_view_get_expander_column(this.handle) == columnHandle[0]) {
                GdkRectangle rect = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(this.handle, path[0], columnHandle[0], rect);
                if ((this.style & 0x8000000) != 0) {
                    overExpander = x > rect.x + rect.width;
                } else {
                    boolean bl = overExpander = x < rect.x;
                }
            }
            if (!overExpander) {
                item = this._getItem(iter);
            }
        }
        OS.g_free(iter);
        OS.gtk_tree_path_free(path[0]);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        int itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (itemCount == 0) {
            long column = OS.gtk_tree_view_get_column(this.handle, 0);
            int[] w = new int[1];
            int[] h = new int[1];
            this.ignoreSize = true;
            OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            int height = h[0];
            if (OS.GTK3) {
                long textRenderer = this.getTextRenderer(column);
                OS.gtk_cell_renderer_get_preferred_height_for_width(textRenderer, this.handle, 0, h, null);
                height += h[0];
            }
            this.ignoreSize = false;
            return height;
        }
        int height = 0;
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, iter);
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            long column = OS.gtk_tree_view_get_column(this.handle, i);
            OS.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            height = Math.max(height, h[0]);
            ++i;
        }
        OS.g_free(iter);
        return height;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(0L);
    }

    TreeItem[] getItems(long parent) {
        int length = OS.gtk_tree_model_iter_n_children(this.modelHandle, parent);
        TreeItem[] result = new TreeItem[length];
        if (length == 0) {
            return result;
        }
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < length) {
                result[i] = this._getItem(parent, i);
                ++i;
            }
        } else {
            int i = 0;
            int[] index = new int[1];
            long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
            boolean valid = OS.gtk_tree_model_iter_children(this.modelHandle, iter, parent);
            while (valid) {
                OS.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
                result[i++] = this.items[index[0]];
                valid = OS.gtk_tree_model_iter_next(this.modelHandle, iter);
            }
            OS.g_free(iter);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        if (OS.GTK3) {
            return OS.gtk_tree_view_get_grid_lines(this.handle) > 0;
        }
        return OS.gtk_tree_view_get_rules_hint(this.handle);
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    long getPixbufRenderer(long column) {
        long list = OS.gtk_cell_layout_get_cells(column);
        if (list == 0L) {
            return 0L;
        }
        long originalList = list;
        long pixbufRenderer = 0L;
        while (list != 0L) {
            long renderer = OS.g_list_data(list);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF(renderer)) {
                pixbufRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return pixbufRenderer;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        long list = OS.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0L) {
            long originalList = list;
            int count = OS.g_list_length(list);
            TreeItem[] treeSelection = new TreeItem[count];
            int length = 0;
            int i = 0;
            while (i < count) {
                long data = OS.g_list_data(list);
                long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (OS.gtk_tree_model_get_iter(this.modelHandle, iter, data)) {
                    treeSelection[length] = this._getItem(iter);
                    ++length;
                }
                list = OS.g_list_next(list);
                OS.g_free(iter);
                OS.gtk_tree_path_free(data);
                ++i;
            }
            OS.g_list_free(originalList);
            if (length < count) {
                TreeItem[] temp = new TreeItem[length];
                System.arraycopy(treeSelection, 0, temp, 0, length);
                treeSelection = temp;
            }
            return treeSelection;
        }
        return new TreeItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        return OS.gtk_tree_selection_count_selected_rows(selection);
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    long getTextRenderer(long column) {
        long list = OS.gtk_cell_layout_get_cells(column);
        if (list == 0L) {
            return 0L;
        }
        long originalList = list;
        long textRenderer = 0L;
        while (list != 0L) {
            long renderer = OS.g_list_data(list);
            if (OS.GTK_IS_CELL_RENDERER_TEXT(renderer)) {
                textRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return textRenderer;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        long[] path = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, path, null, null, null)) {
            return null;
        }
        if (path[0] == 0L) {
            return null;
        }
        TreeItem item = null;
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, iter, path[0])) {
            item = this._getItem(iter);
        }
        OS.g_free(iter);
        OS.gtk_tree_path_free(path[0]);
        return item;
    }

    long gtk_button_press_event(long widget, long event) {
        long selection;
        long[] path;
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        int button = gdkEvent.button;
        if (button == 3 && gdkEvent.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new long[1], null, null, null) && path[0] != 0L) {
            selection = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                result = 1L;
            }
            OS.gtk_tree_path_free(path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new long[1], null, null, null) && path[0] != 0L) {
            selection = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_view_set_cursor(this.handle, path[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_path_free(path[0]);
        }
        if (gdkEvent.type == 5) {
            this.sendTreeDefaultSelection();
        }
        return result;
    }

    long gtk_key_press_event(long widget, long event) {
        GdkEventKey keyEvent = new GdkEventKey();
        OS.memmove(keyEvent, event, (long)GdkEventKey.sizeof);
        int key = keyEvent.keyval;
        this.keyPressDefaultSelectionHandler(event, key);
        return super.gtk_key_press_event(widget, event);
    }

    void keyPressDefaultSelectionHandler(long event, int key) {
        int keymask = this.gdk_event_get_state(event);
        switch (key) {
            case 65293: {
                if ((keymask & 0x1C00000D) != 0) break;
                this.sendTreeDefaultSelection();
                break;
            }
            case 32: {
                if ((keymask & 0x1C00000C) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
    }

    void sendTreeDefaultSelection() {
        TreeItem treeItem = this.getFocusItem();
        if (treeItem == null) {
            return;
        }
        Event event = new Event();
        event.item = treeItem;
        this.sendSelectionEvent(14, event, false);
    }

    long gtk_button_release_event(long widget, long event) {
        long window = OS.GDK_EVENT_WINDOW(event);
        if (window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_button_release_event(widget, event);
    }

    long gtk_changed(long widget) {
        TreeItem item = this.getFocusItem();
        if (item != null) {
            Event event = new Event();
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    long gtk_event_after(long widget, long gdkEvent) {
        switch (OS.GDK_EVENT_TYPE(gdkEvent)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L) != 0) break;
                this.gtk_expose_event(widget, gdkEvent);
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    long gtk_expand_collapse_cursor_row(long widget, long logical, long expand, long open_all) {
        if (expand != 0L && open_all != 0L) {
            this.expandAll = true;
        }
        return 0L;
    }

    void drawInheritedBackground(long eventPtr, long cairo) {
        Control control;
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            long window = OS.gtk_tree_view_get_bin_window(this.handle);
            long rgn = 0L;
            if (eventPtr != 0L) {
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, eventPtr, (long)GdkEventExpose.sizeof);
                if (window != gdkEvent.window) {
                    return;
                }
                rgn = gdkEvent.region;
            }
            int[] width = new int[1];
            int[] height = new int[1];
            this.gdk_window_get_size(window, width, height);
            long parent = 0L;
            int itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, parent);
            GdkRectangle rect = new GdkRectangle();
            boolean expanded = true;
            while (itemCount != 0 && expanded && height[0] > rect.y + rect.height) {
                long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parent, itemCount - 1);
                itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, iter);
                long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                OS.gtk_tree_view_get_cell_area(this.handle, path, 0L, rect);
                expanded = OS.gtk_tree_view_row_expanded(this.handle, path);
                OS.gtk_tree_path_free(path);
                if (parent != 0L) {
                    OS.g_free(parent);
                }
                parent = iter;
            }
            if (parent != 0L) {
                OS.g_free(parent);
            }
            if (height[0] > rect.y + rect.height) {
                this.drawBackground(control, window, cairo, rgn, 0, rect.y + rect.height, width[0], height[0] - (rect.y + rect.height));
            }
        }
    }

    long gtk_draw(long widget, long cairo) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawInheritedBackground(0L, cairo);
        return super.gtk_draw(widget, cairo);
    }

    long gtk_expose_event(long widget, long eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawInheritedBackground(eventPtr, 0L);
        return super.gtk_expose_event(widget, eventPtr);
    }

    long gtk_motion_notify_event(long widget, long event) {
        long window = OS.GDK_EVENT_WINDOW(event);
        if (window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_motion_notify_event(widget, event);
    }

    long gtk_row_deleted(long model, long path) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(model, OS.row_deleted);
        }
        return 0L;
    }

    long gtk_row_has_child_toggled(long model, long path, long iter) {
        int[] index = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
        if (index[0] >= this.items.length) {
            return 0L;
        }
        TreeItem item = this.items[index[0]];
        if (item == null) {
            return 0L;
        }
        int childCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, item.handle);
        if (childCount != 0 && item.isExpanded) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            OS.gtk_tree_view_expand_row(this.handle, path, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
        }
        return 0L;
    }

    long gtk_row_inserted(long model, long path, long iter) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(model, OS.row_inserted);
        }
        return 0L;
    }

    long gtk_start_interactive_search(long widget) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(widget, OS.start_interactive_search);
            return 1L;
        }
        return 0L;
    }

    long gtk_test_collapse_row(long tree, long iter, long path) {
        int[] index = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
        TreeItem item = this.items[index[0]];
        Event event = new Event();
        event.item = item;
        boolean oldModelChanged = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(18, event);
        boolean changed = this.modelChanged || !OS.gtk_tree_view_row_expanded(this.handle, path);
        this.modelChanged = oldModelChanged;
        if (this.isDisposed() || item.isDisposed()) {
            return 1L;
        }
        item.isExpanded = false;
        if (changed) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 50L);
            OS.gtk_tree_view_collapse_row(this.handle, path);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 50L);
            return 1L;
        }
        return 0L;
    }

    long gtk_test_expand_row(long tree, long iter, long path) {
        int[] index = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
        TreeItem item = this.items[index[0]];
        Event event = new Event();
        event.item = item;
        boolean oldModelChanged = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(17, event);
        boolean changed = this.modelChanged || OS.gtk_tree_view_row_expanded(this.handle, path);
        this.modelChanged = oldModelChanged;
        if (this.isDisposed() || item.isDisposed()) {
            return 1L;
        }
        item.isExpanded = true;
        if (changed || this.expandAll) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            OS.gtk_tree_view_expand_row(this.handle, path, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            return 1L;
        }
        return 0L;
    }

    long gtk_toggled(long renderer, long pathStr) {
        long path = OS.gtk_tree_path_new_from_string(pathStr);
        if (path == 0L) {
            return 0L;
        }
        TreeItem item = null;
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, iter, path)) {
            item = this._getItem(iter);
        }
        OS.g_free(iter);
        OS.gtk_tree_path_free(path);
        if (item != null) {
            item.setChecked(!item.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    void gtk_widget_size_request(long widget, GtkRequisition requisition) {
        long columns;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(widget, requisition);
            return;
        }
        long list = columns = OS.gtk_tree_view_get_columns(this.handle);
        boolean fixVisible = columns != 0L;
        while (list != 0L) {
            long column = OS.g_list_data(list);
            if (OS.gtk_tree_view_column_get_visible(column)) {
                fixVisible = false;
                break;
            }
            list = OS.g_list_next(list);
        }
        long columnHandle = 0L;
        if (fixVisible) {
            columnHandle = OS.g_list_data(columns);
            OS.gtk_tree_view_column_set_visible(columnHandle, true);
        }
        super.gtk_widget_size_request(widget, requisition);
        if (fixVisible) {
            OS.gtk_tree_view_column_set_visible(columnHandle, false);
        }
        if (columns != 0L) {
            OS.g_list_free(columns);
        }
    }

    void hideFirstColumn() {
        long firstColumn = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(firstColumn, false);
    }

    void hookEvents() {
        super.hookEvents();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(selection, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
        OS.g_signal_connect_closure(this.handle, OS.test_expand_row, this.display.getClosure(51), false);
        OS.g_signal_connect_closure(this.handle, OS.test_collapse_row, this.display.getClosure(50), false);
        OS.g_signal_connect_closure(this.handle, OS.expand_collapse_cursor_row, this.display.getClosure(17), false);
        OS.g_signal_connect_closure(this.modelHandle, OS.row_has_child_toggled, this.display.getClosure(84), false);
        if (this.checkRenderer != 0L) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.getClosure(69), false);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TreeItem item) {
        long indices;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int index = -1;
        long path = OS.gtk_tree_model_get_path(this.modelHandle, item.handle);
        int depth = OS.gtk_tree_path_get_depth(path);
        if (depth == 1 && (indices = OS.gtk_tree_path_get_indices(path)) != 0L) {
            int[] temp = new int[1];
            OS.memmove(temp, indices, 4L);
            index = temp[0];
        }
        OS.gtk_tree_path_free(path);
        return index;
    }

    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.columnCount) {
            long labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.columnCount) {
            long labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    long paintWindow() {
        OS.gtk_widget_realize(this.handle);
        if (this.fixedHandle != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            OS.gtk_widget_realize(this.fixedHandle);
            return OS.gtk_widget_get_window(this.fixedHandle);
        }
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            long l = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0L) : OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(OS.gtk_tree_view_get_column(this.handle, 0), 6, true, 0);
        } else {
            int i = 0;
            while (i < this.columnCount) {
                TreeColumn column = this.columns[i];
                this.createRenderers(column.handle, column.modelIndex, i == 0, column.style);
                ++i;
            }
        }
    }

    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0L) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    void releaseItem(TreeItem item, boolean release) {
        int[] index = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, item.handle, 0, index, -1);
        if (index[0] == -1) {
            return;
        }
        if (release) {
            item.release(false);
        }
        this.items[index[0]] = null;
    }

    void releaseItems(long parentIter) {
        int[] index = new int[1];
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        boolean valid = OS.gtk_tree_model_iter_children(this.modelHandle, iter, parentIter);
        while (valid) {
            this.releaseItems(iter);
            if (!this.isDisposed()) {
                TreeItem item;
                OS.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
                if (index[0] != -1 && (item = this.items[index[0]]) != null) {
                    this.releaseItem(item, true);
                }
            }
            valid = OS.gtk_tree_model_iter_next(this.modelHandle, iter);
        }
        OS.g_free(iter);
    }

    void releaseChildren(boolean destroy) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TreeColumn column = this.columns[i];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++i;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
        if (this.checkRenderer != 0L) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    void remove(long parentIter, int start, int end) {
        if (start > end) {
            return;
        }
        int itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (start < 0 || start > end || end >= itemCount) {
            this.error(6);
        }
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        int i = start;
        while (i <= end) {
            TreeItem item;
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parentIter, start);
            int[] value = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
            TreeItem treeItem = item = value[0] != -1 ? this.items[value[0]] : null;
            if (item != null && !item.isDisposed()) {
                item.dispose();
            } else {
                OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
                OS.gtk_tree_store_remove(this.modelHandle, iter);
                OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            }
            ++i;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(iter);
    }

    public void removeAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.items = new TreeItem[4];
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        OS.gtk_tree_view_set_model(this.handle, 0L);
        OS.gtk_tree_store_clear(this.modelHandle);
        OS.gtk_tree_view_set_model(this.handle, this.modelHandle);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    void sendMeasureEvent(long cell, long width, long height) {
        if (!this.ignoreSize && OS.GTK_IS_CELL_RENDERER_TEXT(cell) && this.hooks(41)) {
            long iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
            TreeItem item = null;
            if (iter != 0L) {
                item = this._getItem(iter);
            }
            if (item != null) {
                int columnIndex = 0;
                if (this.columnCount > 0) {
                    long columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
                    int i = 0;
                    while (i < this.columnCount) {
                        if (this.columns[i].handle == columnHandle) {
                            columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
                int[] contentWidth = new int[1];
                int[] contentHeight = new int[1];
                if (width != 0L) {
                    OS.memmove(contentWidth, width, 4L);
                }
                if (height != 0L) {
                    OS.memmove(contentHeight, height, 4L);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_get_preferred_height_for_width(cell, this.handle, contentWidth[0], contentHeight, null);
                }
                Image image = item.getImage(columnIndex);
                int imageWidth = 0;
                if (image != null) {
                    Rectangle bounds = image.getBounds();
                    imageWidth = bounds.width;
                }
                contentWidth[0] = contentWidth[0] + imageWidth;
                GC gc = new GC(this);
                gc.setFont(item.getFont(columnIndex));
                Event event = new Event();
                event.item = item;
                event.index = columnIndex;
                event.gc = gc;
                event.width = contentWidth[0];
                event.height = contentHeight[0];
                long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                long selection = OS.gtk_tree_view_get_selection(this.handle);
                if (OS.gtk_tree_selection_path_is_selected(selection, path)) {
                    event.detail = 2;
                }
                OS.gtk_tree_path_free(path);
                this.sendEvent(41, event);
                gc.dispose();
                contentWidth[0] = event.width - imageWidth;
                if (contentHeight[0] < event.height) {
                    contentHeight[0] = event.height;
                }
                if (width != 0L) {
                    OS.memmove(width, contentWidth, 4L);
                }
                if (height != 0L) {
                    OS.memmove(height, contentHeight, 4L);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_set_fixed_size(cell, contentWidth[0], contentHeight[0]);
                }
            }
        }
    }

    long rendererGetPreferredWidthProc(long cell, long handle, long minimun_size, long natural_size) {
        long g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        OS.call(klass.get_preferred_width, cell, handle, minimun_size, natural_size);
        this.sendMeasureEvent(cell, minimun_size, 0L);
        return 0L;
    }

    long rendererGetSizeProc(long cell, long widget, long cell_area, long x_offset, long y_offset, long width, long height) {
        long g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        OS.call_get_size(klass.get_size, cell, this.handle, cell_area, x_offset, y_offset, width, height);
        this.sendMeasureEvent(cell, width, height);
        return 0L;
    }

    long rendererRenderProc(long cell, long cr, long widget, long background_area, long cell_area, long flags) {
        this.rendererRender(cell, cr, 0L, widget, background_area, cell_area, 0L, flags);
        return 0L;
    }

    long rendererRenderProc(long cell, long window, long widget, long background_area, long cell_area, long expose_area, long flags) {
        this.rendererRender(cell, 0L, window, widget, background_area, cell_area, expose_area, flags);
        return 0L;
    }

    void rendererRender(long cell, long cr, long window, long widget, long background_area, long cell_area, long expose_area, long flags) {
        Event event;
        GC gc;
        GdkRectangle rect;
        TreeItem item = null;
        long iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
        if (iter != 0L) {
            item = this._getItem(iter);
        }
        long columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
        int columnIndex = 0;
        if (this.columnCount > 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    columnIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (item != null && (OS.GTK_IS_CELL_RENDERER_TOGGLE(cell) || (OS.GTK_IS_CELL_RENDERER_PIXBUF(cell) || OS.GTK_VERSION > OS.VERSION(3, 13, 0)) && (columnIndex != 0 || (this.style & 0x20) == 0))) {
            long textRenderer;
            Control control;
            this.drawFlags = (int)flags;
            this.drawState = 16;
            long[] ptr = new long[1];
            OS.gtk_tree_model_get(this.modelHandle, item.handle, 4, ptr, -1);
            if (ptr[0] == 0L) {
                int modelIndex = this.columnCount == 0 ? 6 : this.columns[columnIndex].modelIndex;
                OS.gtk_tree_model_get(this.modelHandle, item.handle, modelIndex + 3, ptr, -1);
            }
            if (ptr[0] != 0L) {
                this.drawState |= 8;
                OS.gdk_color_free(ptr[0]);
            }
            if ((flags & 1L) != 0L) {
                this.drawState |= 2;
            }
            if (!(OS.GTK3 && (flags & 1L) != 0L || (flags & 0x10L) == 0L)) {
                this.drawState |= 4;
            }
            rect = new GdkRectangle();
            long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            OS.gtk_tree_view_get_background_area(this.handle, path, columnHandle, rect);
            OS.gtk_tree_path_free(path);
            if (cr != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                GdkRectangle r2 = new GdkRectangle();
                OS.gdk_cairo_get_clip_rectangle(cr, r2);
                rect.x = r2.x;
                rect.width = r2.width;
            }
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
                if (cr != 0L) {
                    Cairo.cairo_save(cr);
                    if (!OS.GTK3) {
                        Cairo.cairo_reset_clip(cr);
                    }
                }
                this.drawBackground(control, window, cr, 0L, rect.x, rect.y, rect.width, rect.height);
                if (cr != 0L) {
                    Cairo.cairo_restore(cr);
                }
            }
            if ((textRenderer = this.getTextRenderer(columnHandle)) != 0L) {
                this.gtk_cell_renderer_get_preferred_size(textRenderer, this.handle, null, null);
            }
            if (this.hooks(40)) {
                boolean wasSelected;
                boolean bl = wasSelected = (this.drawState & 2) != 0;
                if (wasSelected) {
                    Control control2 = this.findBackgroundControl();
                    if (control2 == null) {
                        control2 = this;
                    }
                    if (!OS.GTK3) {
                        if (cr != 0L) {
                            Cairo.cairo_save(cr);
                            Cairo.cairo_reset_clip(cr);
                        }
                        this.drawBackground(control2, window, cr, 0L, rect.x, rect.y, rect.width, rect.height);
                        if (cr != 0L) {
                            Cairo.cairo_restore(cr);
                        }
                    }
                }
                gc = this.getGC(cr);
                if ((this.drawState & 2) != 0) {
                    gc.setBackground(this.display.getSystemColor(26));
                    gc.setForeground(this.display.getSystemColor(27));
                } else {
                    gc.setBackground(item.getBackground(columnIndex));
                    gc.setForeground(item.getForeground(columnIndex));
                }
                gc.setFont(item.getFont(columnIndex));
                if ((this.style & 0x8000000) != 0) {
                    rect.x = this.getClientWidth() - rect.width - rect.x;
                }
                if (OS.GTK_VERSION >= OS.VERSION(3, 9, 0) && cr != 0L) {
                    GdkRectangle r = new GdkRectangle();
                    OS.gdk_cairo_get_clip_rectangle(cr, r);
                    gc.setClipping(rect.x, r.y, r.width, r.height);
                } else {
                    gc.setClipping(rect.x, rect.y, rect.width, rect.height);
                }
                event = new Event();
                event.item = item;
                event.index = columnIndex;
                event.gc = gc;
                event.x = rect.x;
                event.y = rect.y;
                event.width = rect.width;
                event.height = rect.height;
                event.detail = this.drawState;
                this.sendEvent(40, event);
                this.drawForeground = null;
                this.drawState = event.doit ? event.detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    if (!OS.GTK3) {
                        long style = OS.gtk_widget_get_style(widget);
                        byte[] detail = Converter.wcsToMbcs(null, "cell_odd", true);
                        OS.gtk_paint_flat_box(style, window, 3, 0, rect, widget, detail, rect.x, rect.y, rect.width, rect.height);
                    }
                } else if (wasSelected) {
                    this.drawForeground = gc.getForeground().handle;
                }
                gc.dispose();
            }
        }
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gc2 = this.getGC(cr);
            gc2.setBackground(item.getBackground(columnIndex));
            rect = new GdkRectangle();
            OS.memmove(rect, background_area, (long)GdkRectangle.sizeof);
            gc2.fillRectangle(rect.x, rect.y, rect.width, rect.height);
            gc2.dispose();
        }
        if ((this.drawState & 0x10) != 0 || OS.GTK_IS_CELL_RENDERER_TOGGLE(cell)) {
            long g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
            GtkCellRendererClass klass = new GtkCellRendererClass();
            OS.memmove(klass, g_class);
            if (this.drawForeground != null && OS.GTK_IS_CELL_RENDERER_TEXT(cell)) {
                OS.g_object_set(cell, OS.foreground_gdk, this.drawForeground, 0L);
            }
            if (OS.GTK3) {
                OS.call(klass.render, cell, cr, widget, background_area, cell_area, this.drawFlags);
            } else {
                OS.call(klass.render, cell, window, widget, background_area, cell_area, expose_area, this.drawFlags);
            }
        }
        if (item != null && OS.GTK_IS_CELL_RENDERER_TEXT(cell) && this.hooks(42)) {
            GdkRectangle rect2 = new GdkRectangle();
            long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            OS.gtk_tree_view_get_cell_area(this.handle, path, columnHandle, rect2);
            OS.gtk_tree_path_free(path);
            if (cr != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                GdkRectangle r2 = new GdkRectangle();
                OS.gdk_cairo_get_clip_rectangle(cr, r2);
                rect2.x = r2.x;
                rect2.width = r2.width;
            }
            this.ignoreSize = true;
            int[] contentX = new int[1];
            int[] contentWidth = new int[1];
            this.gtk_cell_renderer_get_preferred_size(cell, this.handle, contentWidth, null);
            OS.gtk_tree_view_column_cell_get_position(columnHandle, cell, contentX, null);
            this.ignoreSize = false;
            Image image = item.getImage(columnIndex);
            int imageWidth = 0;
            if (image != null) {
                Rectangle bounds = image.getBounds();
                imageWidth = bounds.width;
            }
            if (cr != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                rect2.x -= imageWidth;
                rect2.width += imageWidth;
            }
            contentX[0] = contentX[0] - imageWidth;
            contentWidth[0] = contentWidth[0] + imageWidth;
            gc = this.getGC(cr);
            if ((this.drawState & 2) != 0) {
                Color foreground;
                Color background;
                if (OS.gtk_widget_has_focus(this.handle) || OS.GTK3) {
                    background = this.display.getSystemColor(26);
                    foreground = this.display.getSystemColor(27);
                } else {
                    background = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_INACTIVE);
                    foreground = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_TEXT_INACTIVE);
                }
                gc.setBackground(background);
                gc.setForeground(foreground);
            } else {
                gc.setBackground(item.getBackground(columnIndex));
                Color foreground = this.drawForeground != null ? Color.gtk_new(this.display, this.drawForeground) : item.getForeground(columnIndex);
                gc.setForeground(foreground);
            }
            gc.setFont(item.getFont(columnIndex));
            if ((this.style & 0x8000000) != 0) {
                rect2.x = this.getClientWidth() - rect2.width - rect2.x;
            }
            gc.setClipping(rect2.x, rect2.y, rect2.width, rect2.height);
            event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            event.x = rect2.x + contentX[0];
            event.y = rect2.y;
            event.width = contentWidth[0];
            event.height = rect2.height;
            event.detail = this.drawState;
            this.sendEvent(42, event);
            gc.dispose();
        }
    }

    private GC getGC(long cr) {
        GC gc;
        if (OS.GTK3) {
            GCData gcData = new GCData();
            gcData.cairo = cr;
            gc = GC.gtk_new(this, gcData);
        } else {
            gc = new GC(this);
        }
        return gc;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int end = Math.max(1, this.columnCount);
        int i = 0;
        while (i < end) {
            boolean customDraw;
            boolean bl = customDraw = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (customDraw) {
                long column = OS.gtk_tree_view_get_column(this.handle, i);
                long textRenderer = this.getTextRenderer(column);
                OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, 0L, 0L, 0L);
                if (this.columnCount != 0) {
                    this.columns[i].customDraw = false;
                }
            }
            ++i;
        }
        this.firstCustomDraw = false;
    }

    void reskinChildren(int flags) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    item.reskinChildren(flags);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columns.length) {
                TreeColumn column = this.columns[i];
                if (column != null) {
                    column.reskinChildren(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    boolean searchEnabled() {
        return (this.style & 0x10000000) == 0;
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item == null) {
            OS.gtk_tree_view_set_drag_dest_row(this.handle, 0L, 0);
            return;
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        Rectangle rect = item.getBounds();
        long[] path = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, rect.x, rect.y, path, null, null, null)) {
            return;
        }
        if (path[0] == 0L) {
            return;
        }
        int position = before ? 0 : 1;
        OS.gtk_tree_view_set_drag_dest_row(this.handle, path[0], position);
        OS.gtk_tree_path_free(path[0]);
    }

    void setItemCount(long parentIter, int count) {
        boolean isVirtual;
        int itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (count == itemCount) {
            return;
        }
        boolean bl = isVirtual = (this.style & 0x10000000) != 0;
        if (!isVirtual) {
            this.setRedraw(false);
        }
        this.remove(parentIter, count, itemCount - 1);
        if (isVirtual) {
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = true;
            }
            int i = itemCount;
            while (i < count) {
                long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (iter == 0L) {
                    this.error(2);
                }
                OS.gtk_tree_store_append(this.modelHandle, iter, parentIter);
                OS.gtk_tree_store_set(this.modelHandle, iter, 0, -1, -1);
                OS.g_free(iter);
                ++i;
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = false;
                OS.g_object_notify(this.handle, OS.model);
            }
        } else {
            int i = itemCount;
            while (i < count) {
                new TreeItem(this, parentIter, 0, i, true);
                ++i;
            }
        }
        if (!isVirtual) {
            this.setRedraw(true);
        }
        this.modelChanged = true;
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.setItemCount(0L, count);
    }

    public void select(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_select_iter(selection, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_select_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        if (!OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, color);
        } else {
            GdkColor defaultColor = this.getDisplay().COLOR_LIST_SELECTION;
            GdkRGBA selectedBackground = new GdkRGBA();
            selectedBackground.alpha = 1.0;
            selectedBackground.red = (float)(defaultColor.red & 0xFFFF) / 65535.0f;
            selectedBackground.green = (float)(defaultColor.green & 0xFFFF) / 65535.0f;
            selectedBackground.blue = (float)(defaultColor.blue & 0xFFFF) / 65535.0f;
            OS.gtk_widget_override_background_color(this.handle, 4, selectedBackground);
        }
    }

    void setBackgroundPixmap(Image image) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        OS.gtk_widget_realize(this.handle);
        return result;
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length > 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(6);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            ++i;
        }
        long baseColumn = 0L;
        int i2 = 0;
        while (i2 < order.length) {
            long column = this.columns[order[i2]].handle;
            OS.gtk_tree_view_move_column_after(this.handle, column, baseColumn);
            baseColumn = column;
            ++i2;
        }
    }

    void setFontDescription(long font) {
        super.setFontDescription(font);
        TreeColumn[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i] != null) {
                columns[i].setFontDescription(font);
            }
            ++i;
        }
    }

    void setForegroundColor(GdkColor color) {
        this.setForegroundColor(this.handle, color, false);
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible(this.handle, show);
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        if (!OS.GTK3) {
            OS.gtk_tree_view_set_rules_hint(this.handle, show);
        }
        OS.gtk_tree_view_set_grid_lines(this.handle, show ? 2 : 0);
    }

    void setModel(long newModel) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = newModel;
        this.display.addWidget(this.modelHandle, this);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    void setOrientation(boolean create) {
        int i;
        super.setOrientation(create);
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null) {
                    this.items[i].setOrientation(create);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columns.length) {
                if (this.columns[i] != null) {
                    this.columns[i].setOrientation(create);
                }
                ++i;
            }
        }
    }

    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    void setParentWindow(long widget) {
        long window = this.eventWindow();
        OS.gtk_widget_set_parent_window(widget, window);
    }

    void setScrollWidth(long column, TreeItem item) {
        int itemWidth;
        if (this.columnCount != 0 || this.currentItem == item) {
            return;
        }
        int width = OS.gtk_tree_view_column_get_fixed_width(column);
        if (width < (itemWidth = this.calculateWidth(column, item.handle, true))) {
            OS.gtk_tree_view_column_set_fixed_width(column, itemWidth);
        }
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{item});
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        boolean first = true;
        int i = 0;
        while (i < length) {
            TreeItem item = items[i];
            if (item != null) {
                if (item.isDisposed()) break;
                if (item.parent == this) {
                    long path = OS.gtk_tree_model_get_path(this.modelHandle, item.handle);
                    this.showItem(path, false);
                    if (first) {
                        OS.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
                    }
                    OS.gtk_tree_selection_select_iter(selection, item.handle);
                    OS.gtk_tree_path_free(path);
                    first = false;
                }
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = column;
        if (this.sortColumn != null && this.sortDirection != 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setTopItem(TreeItem item) {
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        long path = OS.gtk_tree_model_get_path(this.modelHandle, item.handle);
        this.showItem(path, false);
        OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, true, 0.0f, 0.0f);
        OS.gtk_tree_path_free(path);
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        OS.gtk_tree_view_scroll_to_cell(this.handle, 0L, column.handle, false, 0.0f, 0.0f);
    }

    boolean showFirstColumn() {
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            long column = OS.gtk_tree_view_get_column(this.handle, i);
            if (OS.gtk_tree_view_column_get_visible(column)) {
                return false;
            }
            ++i;
        }
        long firstColumn = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(firstColumn, true);
        return true;
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] items = this.getSelection();
        if (items.length != 0 && items[0] != null) {
            this.showItem(items[0]);
        }
    }

    void showItem(long path, boolean scroll) {
        int depth = OS.gtk_tree_path_get_depth(path);
        if (depth > 1) {
            int[] indices = new int[depth - 1];
            long indicesPtr = OS.gtk_tree_path_get_indices(path);
            OS.memmove(indices, indicesPtr, (long)(indices.length * 4));
            long tempPath = OS.gtk_tree_path_new();
            int i = 0;
            while (i < indices.length) {
                OS.gtk_tree_path_append_index(tempPath, indices[i]);
                OS.gtk_tree_view_expand_row(this.handle, tempPath, false);
                ++i;
            }
            OS.gtk_tree_path_free(tempPath);
        }
        if (scroll) {
            GdkRectangle cellRect = new GdkRectangle();
            OS.gtk_widget_realize(this.handle);
            OS.gtk_tree_view_get_cell_area(this.handle, path, 0L, cellRect);
            boolean isHidden = cellRect.y == 0 && cellRect.height == 0;
            int[] tx = new int[1];
            int[] ty = new int[1];
            OS.gtk_tree_view_convert_bin_window_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
            if (!isHidden) {
                GdkRectangle visibleRect = new GdkRectangle();
                OS.gtk_tree_view_get_visible_rect(this.handle, visibleRect);
                if (ty[0] < visibleRect.y || ty[0] + cellRect.height > visibleRect.y + visibleRect.height) {
                    isHidden = true;
                }
            }
            if (isHidden) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, depth != 1, 0.5f, 0.0f);
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        long path = OS.gtk_tree_model_get_path(this.modelHandle, item.handle);
        this.showItem(path, true);
        OS.gtk_tree_path_free(path);
    }

    void updateScrollBarValue(ScrollBar bar) {
        super.updateScrollBarValue(bar);
        long parentHandle = this.parentingHandle();
        long list = OS.gtk_container_get_children(parentHandle);
        if (list == 0L) {
            return;
        }
        long temp = list;
        while (temp != 0L) {
            long widget = OS.g_list_data(temp);
            if (widget != 0L) {
                OS.gtk_widget_queue_resize(widget);
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
    }

    long windowProc(long handle, long arg0, long user_data) {
        switch ((int)user_data) {
            case 19: {
                Control control;
                int itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
                if (itemCount != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null) break;
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, arg0, (long)GdkEventExpose.sizeof);
                long window = OS.gtk_tree_view_get_bin_window(handle);
                if (window != gdkEvent.window) break;
                this.drawBackground(control, window, gdkEvent.region, gdkEvent.area_x, gdkEvent.area_y, gdkEvent.area_width, gdkEvent.area_height);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }
}

