/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.CollectionUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;

public class CPPInheritance {
    public static FinalOverriderMap getFinalOverriderMap(ICPPClassType classType, IASTNode point) {
        Map<ICPPClassType, FinalOverriderMap> cache = null;
        if (point != null && point.getTranslationUnit() instanceof CPPASTTranslationUnit) {
            cache = ((CPPASTTranslationUnit)point.getTranslationUnit()).getFinalOverriderMapCache();
        }
        FinalOverriderMap result = null;
        if (cache != null) {
            result = (FinalOverriderMap)cache.get(classType);
        }
        if (result == null) {
            result = FinalOverriderAnalysis.computeFinalOverriderMap(classType, point);
        }
        if (cache != null) {
            cache.put(classType, result);
        }
        return result;
    }

    public static ICPPMethod getFinalOverrider(ICPPMethod method, ICPPClassType hierarchyRoot, IASTNode point) {
        FinalOverriderMap map = CPPInheritance.getFinalOverriderMap(hierarchyRoot, point);
        Map<Integer, List<ICPPMethod>> finalOverriders = map.getMap().get(method);
        if (finalOverriders != null && finalOverriders.size() == 1) {
            for (Integer subobjectNumber : finalOverriders.keySet()) {
                List<ICPPMethod> overridersForSubobject = finalOverriders.get(subobjectNumber);
                if (overridersForSubobject.size() != 1) continue;
                return overridersForSubobject.get(0);
            }
        }
        return null;
    }

    private static class FinalOverriderAnalysis {
        private Map<ICPPClassType, Integer> subobjectNumbers = new HashMap<ICPPClassType, Integer>();
        private Map<ICPPClassType, FinalOverriderMap> virtualBaseCache = new HashMap<ICPPClassType, FinalOverriderMap>();

        private FinalOverriderAnalysis() {
        }

        public static FinalOverriderMap computeFinalOverriderMap(ICPPClassType classType, IASTNode point) {
            return new FinalOverriderAnalysis().collectFinalOverriders(classType, false, new HashSet<ICPPClassType>(), 16, point);
        }

        private FinalOverriderMap collectFinalOverriders(ICPPClassType classType, boolean isVirtualBase, Set<ICPPClassType> inheritanceChain, int maxdepth, IASTNode point) {
            FinalOverriderMap result = new FinalOverriderMap();
            inheritanceChain.add(classType);
            int subobjectNumber = 0;
            if (!isVirtualBase) {
                Integer lastNumber = this.subobjectNumbers.get(classType);
                subobjectNumber = (lastNumber == null ? 0 : lastNumber) + 1;
                this.subobjectNumbers.put(classType, subobjectNumber);
            }
            ICPPBase[] iCPPBaseArray = ClassTypeHelper.getBases(classType, point);
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassType baseType;
                ICPPBase base = iCPPBaseArray[n2];
                IBinding baseClass = base.getBaseClass();
                if (baseClass instanceof ICPPClassType && !inheritanceChain.contains(baseType = (ICPPClassType)baseClass) && maxdepth > 0) {
                    FinalOverriderMap baseOverriderMap;
                    if (base.isVirtual()) {
                        baseOverriderMap = this.virtualBaseCache.get(baseType);
                        if (baseOverriderMap == null) {
                            baseOverriderMap = this.collectFinalOverriders(baseType, true, inheritanceChain, maxdepth - 1, point);
                            this.virtualBaseCache.put(baseType, baseOverriderMap);
                        }
                    } else {
                        baseOverriderMap = this.collectFinalOverriders(baseType, false, inheritanceChain, maxdepth - 1, point);
                    }
                    result.addOverriders(baseOverriderMap);
                }
                ++n2;
            }
            for (ICPPMethod method : ClassTypeHelper.getOwnMethods(classType, point)) {
                ICPPMethod[] overriddenMethods;
                if (method.getOwner() != classType) continue;
                result.add(method, subobjectNumber, method);
                ICPPMethod[] iCPPMethodArray = overriddenMethods = ClassTypeHelper.findOverridden(method, point);
                int n3 = overriddenMethods.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICPPMethod overriddenMethod = iCPPMethodArray[n4];
                    result.replaceForAllSubobjects(overriddenMethod, method);
                    ++n4;
                }
            }
            inheritanceChain.remove(classType);
            return result;
        }
    }

    public static class FinalOverriderMap {
        private Map<ICPPMethod, Map<Integer, List<ICPPMethod>>> fMap = new HashMap<ICPPMethod, Map<Integer, List<ICPPMethod>>>();

        public Map<ICPPMethod, Map<Integer, List<ICPPMethod>>> getMap() {
            return this.fMap;
        }

        void add(ICPPMethod method, int subobjectNumber, ICPPMethod overrider) {
            Map<Integer, List<ICPPMethod>> overriders = this.fMap.get(method);
            if (overriders == null) {
                overriders = new HashMap<Integer, List<ICPPMethod>>();
                this.fMap.put(method, overriders);
            }
            CollectionUtils.listMapGet(overriders, subobjectNumber).add(overrider);
        }

        void replaceForAllSubobjects(ICPPMethod method, ICPPMethod overrider) {
            Map<Integer, List<ICPPMethod>> overriders = this.fMap.get(method);
            if (overriders == null) {
                return;
            }
            for (Integer i : overriders.keySet()) {
                List<ICPPMethod> overridersForSubobject = CollectionUtils.listMapGet(overriders, i);
                overridersForSubobject.clear();
                overridersForSubobject.add(overrider);
            }
        }

        void addOverriders(FinalOverriderMap other) {
            for (ICPPMethod method : other.fMap.keySet()) {
                Map<Integer, List<ICPPMethod>> overriders = this.fMap.get(method);
                if (overriders == null) {
                    overriders = new HashMap<Integer, List<ICPPMethod>>();
                    this.fMap.put(method, overriders);
                }
                Map<Integer, List<ICPPMethod>> otherOverriders = other.fMap.get(method);
                for (Integer i : otherOverriders.keySet()) {
                    this.mergeOverriders(CollectionUtils.listMapGet(overriders, i), otherOverriders.get(i));
                }
            }
        }

        private void mergeOverriders(List<ICPPMethod> target, List<ICPPMethod> source) {
            ArrayList<ICPPMethod> toAdd = new ArrayList<ICPPMethod>();
            for (ICPPMethod candidate : source) {
                boolean superseded = false;
                for (ICPPMethod existing : target) {
                    if (existing == candidate || !ClassTypeHelper.isOverrider(existing, candidate)) continue;
                    superseded = true;
                }
                if (superseded) continue;
                toAdd.add(candidate);
            }
            target.addAll(toAdd);
        }
    }
}

