/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import javax.inject.Inject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.RenderedElementUtil;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolItemUpdater;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DirectContributionItem
extends ContributionItem {
    public static final String DISPOSABLE = "IDisposable";
    private static final String FORCE_TEXT = "FORCE_TEXT";
    private static final String ICON_URI = "iconURI";
    private static final String DISABLED_URI = "disabledURI";
    private static final String DCI_STATIC_CONTEXT = "DCI-staticContext";
    private static final Object missingExecute = new Object();
    private MItem model;
    private Widget widget;
    private Listener menuItemListener;
    private LocalResourceManager localResourceManager;
    private IEclipseContext infoContext;
    @Inject
    private IContributionFactory contribFactory;
    @Inject
    private EModelService modelService;
    private ISWTResourceUtilities resUtils = null;
    @Inject
    @Optional
    private Logger logger;
    private boolean logged = false;
    private ISafeRunnable updateRunner;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            DirectContributionItem.this.update(null);
        }
    };

    @Inject
    void setResourceUtils(IResourceUtilities<ImageDescriptor> utils) {
        this.resUtils = (ISWTResourceUtilities)utils;
    }

    private ISafeRunnable getUpdateRunner() {
        if (this.updateRunner == null) {
            this.updateRunner = new ISafeRunnable(){

                public void run() throws Exception {
                    boolean shouldEnable = DirectContributionItem.this.canExecuteItem(null);
                    if (shouldEnable != DirectContributionItem.this.model.isEnabled()) {
                        DirectContributionItem.this.model.setEnabled(shouldEnable);
                        DirectContributionItem.this.update();
                    }
                }

                public void handleException(Throwable exception) {
                    if (!DirectContributionItem.this.logged) {
                        DirectContributionItem.this.logged = true;
                        if (DirectContributionItem.this.logger != null) {
                            DirectContributionItem.this.logger.error(exception, "Internal error during tool item enablement updating, this is only logged once per tool item.");
                        }
                    }
                }
            };
        }
        return this.updateRunner;
    }

    public void setModel(MItem item) {
        this.model = item;
        this.setId(this.model.getElementId());
        this.updateVisible();
    }

    public void fill(Menu menu, int index) {
        if (this.model == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        int style = 8;
        if (this.model.getType() == ItemType.PUSH) {
            style = 8;
        } else if (this.model.getType() == ItemType.CHECK) {
            style = 32;
        } else if (this.model.getType() == ItemType.RADIO) {
            style = 16;
        }
        MenuItem item = null;
        item = index >= 0 ? new MenuItem(menu, style, index) : new MenuItem(menu, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        item.addListener(14, this.getItemListener());
        this.widget = item;
        this.model.setWidget((Object)this.widget);
        this.widget.setData("modelElement", (Object)this.model);
        this.update(null);
    }

    public void fill(ToolBar parent, int index) {
        if (this.model == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        boolean isDropdown = false;
        if (this.model instanceof MToolItem) {
            MMenu menu = ((MToolItem)this.model).getMenu();
            isDropdown = menu != null;
        }
        int style = 8;
        if (isDropdown) {
            style = 4;
        } else if (this.model.getType() == ItemType.CHECK) {
            style = 32;
        } else if (this.model.getType() == ItemType.RADIO) {
            style = 16;
        }
        ToolItem item = null;
        item = index >= 0 ? new ToolItem(parent, style, index) : new ToolItem(parent, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        item.addListener(14, this.getItemListener());
        this.widget = item;
        this.model.setWidget((Object)this.widget);
        this.widget.setData("modelElement", (Object)this.model);
        ToolItemUpdater updater = this.getUpdater();
        if (updater != null) {
            updater.registerItem(this);
        }
        this.update(null);
    }

    private void updateVisible() {
        this.setVisible(this.model.isVisible());
        IContributionManager parent = this.getParent();
        if (parent != null) {
            parent.markDirty();
        }
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        this.updateIcons();
        if (this.widget instanceof MenuItem) {
            this.updateMenuItem();
        } else if (this.widget instanceof ToolItem) {
            this.updateToolItem();
        }
    }

    private void updateMenuItem() {
        MenuItem item = (MenuItem)this.widget;
        String text = this.model.getLocalizedLabel();
        if (text != null) {
            item.setText(text);
        } else {
            item.setText("");
        }
        item.setSelection(this.model.isSelected());
        item.setEnabled(this.model.isEnabled());
    }

    private void updateToolItem() {
        ToolItem item = (ToolItem)this.widget;
        String text = this.model.getLocalizedLabel();
        Image icon = item.getImage();
        boolean mode = this.model.getTags().contains(FORCE_TEXT);
        if ((icon == null || mode) && text != null) {
            item.setText(text);
        } else {
            item.setText("");
        }
        String tooltip = this.model.getLocalizedTooltip();
        item.setToolTipText(tooltip);
        item.setSelection(this.model.isSelected());
        item.setEnabled(this.model.isEnabled());
    }

    private void updateIcons() {
        if (!(this.widget instanceof Item)) {
            return;
        }
        Item item = (Item)this.widget;
        String iconURI = this.model.getIconURI() != null ? this.model.getIconURI() : "";
        String disabledURI = this.getDisabledIconURI(this.model);
        if (!iconURI.equals(item.getData(ICON_URI)) || !disabledURI.equals(item.getData(DISABLED_URI))) {
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
            Image iconImage = this.getImage(iconURI, resourceManager);
            item.setImage(iconImage);
            item.setData(ICON_URI, (Object)iconURI);
            if (item instanceof ToolItem) {
                iconImage = this.getImage(disabledURI, resourceManager);
                ((ToolItem)item).setDisabledImage(iconImage);
                item.setData(DISABLED_URI, (Object)disabledURI);
            }
            this.disposeOldImages();
            this.localResourceManager = resourceManager;
        }
    }

    private Image getImage(String iconURI, LocalResourceManager resourceManager) {
        ImageDescriptor iconDescriptor;
        Image image = null;
        if (iconURI != null && iconURI.length() > 0 && (iconDescriptor = (ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI))) != null) {
            try {
                image = resourceManager.createImage(iconDescriptor);
            }
            catch (DeviceResourceException e) {
                iconDescriptor = ImageDescriptor.getMissingImageDescriptor();
                image = resourceManager.createImage(iconDescriptor);
                Activator.trace((String)"/trace/menus", (String)("failed to create image " + iconURI), (Throwable)e);
            }
        }
        return image;
    }

    private String getDisabledIconURI(MItem toolItem) {
        Object obj = toolItem.getTransientData().get("e4_disabled_icon_image_key");
        return obj instanceof String ? (String)obj : "";
    }

    private void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    private Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            DirectContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: 
                        case 14: {
                            if (event.widget == null) break;
                            DirectContributionItem.this.handleWidgetSelection(event);
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            ToolItemUpdater updater;
            if (this.infoContext != null) {
                this.infoContext.dispose();
                this.infoContext = null;
            }
            if ((updater = this.getUpdater()) != null) {
                updater.removeItem(this);
            }
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget.removeListener(14, this.getItemListener());
            this.widget = null;
            Object obj = this.model.getTransientData().get(DISPOSABLE);
            if (obj instanceof Runnable) {
                ((Runnable)obj).run();
            }
            this.model.setWidget(null);
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
            this.model.setWidget(null);
        }
    }

    private void handleWidgetSelection(Event event) {
        if (this.widget != null && !this.widget.isDisposed()) {
            if (this.dropdownEvent(event)) {
                return;
            }
            if (this.model.getType() == ItemType.CHECK || this.model.getType() == ItemType.RADIO) {
                boolean selection = false;
                if (this.widget instanceof MenuItem) {
                    selection = ((MenuItem)this.widget).getSelection();
                } else if (this.widget instanceof ToolItem) {
                    selection = ((ToolItem)this.widget).getSelection();
                }
                this.model.setSelected(selection);
            }
            if (this.canExecuteItem(event)) {
                this.executeItem(event);
            }
        }
    }

    private boolean dropdownEvent(Event event) {
        if (event.detail == 4 && this.model instanceof MToolItem) {
            ToolItem ti = (ToolItem)event.widget;
            MMenu mmenu = ((MToolItem)this.model).getMenu();
            if (mmenu == null) {
                return false;
            }
            Menu menu = this.getMenu(mmenu, ti);
            if (menu == null) {
                return true;
            }
            Rectangle itemBounds = ti.getBounds();
            Point displayAt = ti.getParent().toDisplay(itemBounds.x, itemBounds.y + itemBounds.height);
            menu.setLocation(displayAt);
            menu.setVisible(true);
            Display display = menu.getDisplay();
            while (menu.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return true;
        }
        return false;
    }

    protected Menu getMenu(final MMenu mmenu, ToolItem toolItem) {
        Object obj = mmenu.getWidget();
        if (obj instanceof Menu && !((Menu)obj).isDisposed()) {
            return (Menu)obj;
        }
        if (RenderedElementUtil.isRenderedMenu((MUIElement)mmenu)) {
            IMenuCreator creator;
            Menu menu;
            obj = RenderedElementUtil.getContributionManager((MUIElement)mmenu);
            if (obj instanceof IContextFunction) {
                IEclipseContext lclContext = this.getContext((MUIElement)mmenu);
                obj = ((IContextFunction)obj).compute(lclContext, null);
                RenderedElementUtil.setContributionManager((MUIElement)mmenu, (Object)obj);
            }
            if (obj instanceof IMenuCreator && (menu = (creator = (IMenuCreator)obj).getMenu((Control)toolItem.getParent().getShell())) != null) {
                toolItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (menu != null && !menu.isDisposed()) {
                            creator.dispose();
                            mmenu.setWidget(null);
                        }
                    }
                });
                menu.setData("modelElement", (Object)menu);
                return menu;
            }
        } else {
            IEclipseContext lclContext = this.getContext((MUIElement)this.model);
            IPresentationEngine engine = (IPresentationEngine)lclContext.get(IPresentationEngine.class);
            obj = engine.createGui((MUIElement)mmenu, (Object)toolItem.getParent(), lclContext);
            if (obj instanceof Menu) {
                return (Menu)obj;
            }
            if (this.logger != null) {
                this.logger.debug("Rendering returned " + obj);
            }
        }
        return null;
    }

    private IEclipseContext getStaticContext(Event event) {
        if (this.infoContext == null) {
            this.infoContext = EclipseContextFactory.create((String)DCI_STATIC_CONTEXT);
            ContributionsAnalyzer.populateModelInterfaces((Object)this.model, (IEclipseContext)this.infoContext, (Class[])this.model.getClass().getInterfaces());
        }
        if (event == null) {
            this.infoContext.remove(Event.class);
        } else {
            this.infoContext.set(Event.class, (Object)event);
        }
        return this.infoContext;
    }

    private void executeItem(Event trigger) {
        IEclipseContext lclContext = this.getContext((MUIElement)this.model);
        if (!this.checkContribution(lclContext)) {
            return;
        }
        MContribution contrib = (MContribution)this.model;
        IEclipseContext staticContext = this.getStaticContext(trigger);
        Object result = ContextInjectionFactory.invoke((Object)contrib.getObject(), Execute.class, (IEclipseContext)this.getExecutionContext(lclContext), (IEclipseContext)staticContext, (Object)missingExecute);
        if (result == missingExecute && this.logger != null) {
            this.logger.error("Contribution is missing @Execute: " + contrib.getContributionURI());
        }
    }

    private boolean canExecuteItem(Event trigger) {
        IEclipseContext lclContext = this.getContext((MUIElement)this.model);
        if (!this.checkContribution(lclContext)) {
            return false;
        }
        MContribution contrib = (MContribution)this.model;
        IEclipseContext staticContext = this.getStaticContext(trigger);
        Boolean result = (Boolean)ContextInjectionFactory.invoke((Object)contrib.getObject(), CanExecute.class, (IEclipseContext)this.getExecutionContext(lclContext), (IEclipseContext)staticContext, (Object)Boolean.TRUE);
        return result;
    }

    private IEclipseContext getExecutionContext(IEclipseContext context) {
        if (context == null) {
            return null;
        }
        return context.getActiveLeaf();
    }

    private boolean checkContribution(IEclipseContext lclContext) {
        if (!(this.model instanceof MContribution)) {
            return false;
        }
        MContribution contrib = (MContribution)this.model;
        if (contrib.getObject() == null) {
            contrib.setObject(this.contribFactory.create(contrib.getContributionURI(), lclContext));
        }
        return contrib.getObject() != null;
    }

    public void setParent(IContributionManager parent) {
        IMenuManager menuMgr;
        if (this.getParent() instanceof IMenuManager) {
            menuMgr = (IMenuManager)this.getParent();
            menuMgr.removeMenuListener(this.menuListener);
        }
        if (parent instanceof IMenuManager) {
            menuMgr = (IMenuManager)parent;
            menuMgr.addMenuListener(this.menuListener);
        }
        super.setParent(parent);
    }

    protected IEclipseContext getContextForParent(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    protected IEclipseContext getContext(MUIElement part) {
        if (part instanceof MContext) {
            return ((MContext)part).getContext();
        }
        return this.getContextForParent(part);
    }

    public Widget getWidget() {
        return this.widget;
    }

    public MItem getModel() {
        return this.model;
    }

    private ToolItemUpdater getUpdater() {
        Object obj;
        if (this.model != null && (obj = this.model.getRenderer()) instanceof ToolBarManagerRenderer) {
            return ((ToolBarManagerRenderer)((Object)obj)).getUpdater();
        }
        return null;
    }

    protected void updateItemEnablement() {
        if (!(this.model.getWidget() instanceof ToolItem)) {
            return;
        }
        ToolItem widget = (ToolItem)this.model.getWidget();
        if (widget == null || widget.isDisposed()) {
            return;
        }
        SafeRunner.run((ISafeRunnable)this.getUpdateRunner());
    }
}

