/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui.tabs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.launch.RMLaunchUtils;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.ui.tabs.LaunchConfigurationTab;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.ui.IRemoteUIFileService;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WorkingDirectoryBlock
extends LaunchConfigurationTab {
    protected Button useDefaultWorkingDirButton = null;
    protected Text workingDirText = null;
    protected Button workingDirBrowseButton = null;
    protected ILaunchConfiguration launchConfiguration;
    protected WidgetListener listener = new WidgetListener();

    public void createControl(Composite parent) {
        Composite workingDirComp = new Composite(parent, 0);
        workingDirComp.setLayout((Layout)this.createGridLayout(3, false, 0, 0));
        workingDirComp.setLayoutData((Object)this.spanGridData(768, 5));
        this.setControl((Control)workingDirComp);
        Label workingDirLabel = new Label(workingDirComp, 0);
        workingDirLabel.setText(Messages.WorkingDirectoryBlock_Working_directory);
        workingDirLabel.setLayoutData((Object)this.spanGridData(-1, 3));
        this.useDefaultWorkingDirButton = new Button(workingDirComp, 32);
        this.useDefaultWorkingDirButton.setText(Messages.WorkingDirectoryBlock_Use_default_working_directory);
        this.useDefaultWorkingDirButton.setLayoutData((Object)this.spanGridData(-1, 3));
        this.useDefaultWorkingDirButton.addSelectionListener((SelectionListener)this.listener);
        Label dirLabel = new Label(workingDirComp, 0);
        dirLabel.setText(Messages.WorkingDirectoryBlock_Directory);
        this.workingDirText = new Text(workingDirComp, 2052);
        this.workingDirText.setLayoutData((Object)new GridData(768));
        this.workingDirText.addModifyListener((ModifyListener)this.listener);
        this.workingDirBrowseButton = this.createPushButton(workingDirComp, Messages.WorkingDirectoryBlock_Browse, null);
        this.workingDirBrowseButton.addSelectionListener((SelectionListener)this.listener);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", null);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", null);
            this.workingDirText.setText("");
            if (wd == null) {
                this.useDefaultWorkingDirButton.setSelection(true);
            } else {
                Path path = new Path(wd);
                if (path.isAbsolute()) {
                    this.workingDirText.setText(wd);
                }
                this.useDefaultWorkingDirButton.setSelection(false);
            }
            this.handleUseDefaultWorkingDirButtonSelected();
        }
        catch (CoreException coreException) {
            this.setErrorMessage(Messages.WorkingDirectoryBlock_Cannot_read_configuration);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String wd = null;
        if (!this.isDefaultWorkingDirectory()) {
            wd = this.getFieldContent(this.workingDirText.getText());
        }
        configuration.setAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", wd);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        String workingDirPath;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isDefaultWorkingDirectory() && (workingDirPath = this.getFieldContent(this.workingDirText.getText())) == null) {
            this.setErrorMessage(Messages.WorkingDirectoryBlock_Directory_cannot_be_empty);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.WorkingDirectoryBlock_Working_Directory;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    protected boolean isDefaultWorkingDirectory() {
        return this.useDefaultWorkingDirButton.getSelection();
    }

    protected void setDefaultWorkingDir(ILaunchConfiguration configuration) {
        if (configuration == null) {
            this.workingDirText.setText(System.getProperty("user.dir"));
            return;
        }
    }

    protected void handleUseDefaultWorkingDirButtonSelected() {
        if (this.isDefaultWorkingDirectory()) {
            this.setDefaultWorkingDir(this.getLaunchConfiguration());
            this.workingDirText.setEnabled(false);
            this.workingDirBrowseButton.setEnabled(false);
        } else {
            this.workingDirText.setEnabled(true);
            this.workingDirBrowseButton.setEnabled(true);
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void handleWorkingDirBrowseButtonSelected() {
        IRemoteConnection conn = RMLaunchUtils.getRemoteConnection(this.getLaunchConfiguration());
        if (conn != null) {
            IRemoteUIFileService fileService = (IRemoteUIFileService)conn.getConnectionType().getService(IRemoteUIFileService.class);
            if (fileService != null) {
                fileService.setConnection(conn);
                fileService.showConnections(false);
                String path = fileService.browseDirectory(this.getShell(), Messages.WorkingDirectoryBlock_Select_Working_Directory, this.getFieldContent(this.workingDirText.getText()), 0);
                if (path != null) {
                    this.workingDirText.setText(path.toString());
                }
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.WorkingDirectoryBlock_Unable_to_open_connection, (String)Messages.WorkingDirectoryBlock_Please_select_remote_connection_first);
        }
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    @Override
    public void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == WorkingDirectoryBlock.this.useDefaultWorkingDirButton) {
                WorkingDirectoryBlock.this.handleUseDefaultWorkingDirButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.workingDirBrowseButton) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            } else {
                WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
            }
        }

        public void modifyText(ModifyEvent evt) {
            WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
        }
    }
}

