/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.renderers.swt.DirectContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;

public class ToolItemUpdater {
    private List<HandledContributionItem> itemsToCheck = new ArrayList<HandledContributionItem>();
    private final List<HandledContributionItem> orphanedToolItems = new ArrayList<HandledContributionItem>();
    private List<DirectContributionItem> directItemsToCheck = new ArrayList<DirectContributionItem>();
    private final List<DirectContributionItem> directOrphanedToolItems = new ArrayList<DirectContributionItem>();

    void registerItem(HandledContributionItem item) {
        if (!this.itemsToCheck.contains((Object)item)) {
            this.itemsToCheck.add(item);
        }
    }

    void removeItem(HandledContributionItem item) {
        this.itemsToCheck.remove((Object)item);
    }

    void registerItem(DirectContributionItem item) {
        if (!this.directItemsToCheck.contains((Object)item)) {
            this.directItemsToCheck.add(item);
        }
    }

    void removeItem(DirectContributionItem item) {
        this.directItemsToCheck.remove((Object)item);
    }

    public void updateContributionItems(Selector selector) {
        for (HandledContributionItem hci : this.itemsToCheck) {
            if (hci.getModel() != null && hci.getModel().getParent() != null && selector.select((MApplicationElement)hci.getModel())) {
                hci.updateItemEnablement();
                continue;
            }
            this.orphanedToolItems.add(hci);
        }
        if (!this.orphanedToolItems.isEmpty()) {
            this.itemsToCheck.removeAll(this.orphanedToolItems);
            this.orphanedToolItems.clear();
        }
        for (DirectContributionItem dci : this.directItemsToCheck) {
            if (dci.getModel() != null && dci.getModel().getParent() != null && selector.select((MApplicationElement)dci.getModel())) {
                dci.updateItemEnablement();
                continue;
            }
            this.directOrphanedToolItems.add(dci);
        }
        if (!this.directOrphanedToolItems.isEmpty()) {
            this.directItemsToCheck.removeAll(this.directOrphanedToolItems);
            this.directOrphanedToolItems.clear();
        }
    }
}

