/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStreamMonitor;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;
import org.eclipse.ptp.internal.rm.jaxb.control.core.messages.Messages;

public class CommandJobStreamMonitor
implements ICommandJobStreamMonitor {
    protected final StringBuffer fContents;
    protected final String fEncoding;
    protected ListenerList fListeners;
    protected Thread fThread;
    protected boolean fKilled = false;
    protected int bufferLimit;
    private final InputStream fStream;
    private long lastSleep;

    public CommandJobStreamMonitor() {
        this(null, null);
    }

    public CommandJobStreamMonitor(InputStream stream) {
        this(stream, null);
    }

    public CommandJobStreamMonitor(InputStream stream, String encoding) {
        this.fStream = stream;
        this.fEncoding = encoding;
        this.fContents = new StringBuffer();
        this.bufferLimit = -1;
        this.fListeners = new ListenerList();
    }

    public synchronized void addListener(IStreamListener listener) {
        this.fListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String text) {
        CommandJobStreamMonitor commandJobStreamMonitor = this;
        synchronized (commandJobStreamMonitor) {
            this.fContents.append(text);
        }
        this.fireStreamAppended(text);
    }

    @Override
    public synchronized void close() {
        this.fKilled = true;
        if (this.fThread != null) {
            Thread thread = this.fThread;
            this.fThread = null;
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.fContents.setLength(0);
            this.fListeners = new ListenerList();
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public synchronized String getContents() {
        return this.fContents.toString();
    }

    public synchronized void removeListener(IStreamListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void setBufferLimit(int bufferLimit) {
        this.bufferLimit = bufferLimit;
    }

    @Override
    public synchronized void startMonitoring() {
        if (this.fThread == null) {
            this.fThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    CommandJobStreamMonitor.this.read();
                }
            }, Messages.CommandJobStreamMonitor_label);
            this.fThread.setDaemon(true);
            this.fThread.setPriority(1);
            this.fThread.start();
        }
    }

    protected void fireStreamAppended(String text) {
        this.getNotifier().notifyAppend(text);
    }

    protected ContentNotifier getNotifier() {
        return new ContentNotifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read() {
        if (this.fStream == null) {
            JAXBControlCorePlugin.log(CoreExceptionUtils.getErrorStatus((String)Messages.CommandJobNullMonitorStreamError, null));
            return;
        }
        long currentTime = this.lastSleep = System.currentTimeMillis();
        byte[] bytes = new byte[8192];
        int read = 0;
        while (read >= 0) {
            block16: {
                try {
                    if (this.fKilled) break;
                    read = this.fStream.read(bytes);
                    if (read <= 0) break block16;
                    String text = this.fEncoding != null ? new String(bytes, 0, read, this.fEncoding) : new String(bytes, 0, read);
                    CommandJobStreamMonitor commandJobStreamMonitor = this;
                    synchronized (commandJobStreamMonitor) {
                        this.fContents.append(text);
                        int len = this.fContents.length();
                        if (this.bufferLimit != -1 && len > this.bufferLimit) {
                            this.fContents.delete(0, len - this.bufferLimit);
                        }
                    }
                    this.fireStreamAppended(text);
                }
                catch (EOFException eOFException) {
                    break;
                }
                catch (IOException ioe) {
                    if (!this.fKilled) {
                        JAXBControlCorePlugin.log(ioe);
                    }
                    return;
                }
                catch (NullPointerException e) {
                    if (!this.fKilled && this.fThread != null) {
                        JAXBControlCorePlugin.log(e);
                    }
                    return;
                }
            }
            if ((currentTime = System.currentTimeMillis()) - this.lastSleep <= 1000L) continue;
            this.lastSleep = currentTime;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.fStream.close();
        }
        catch (IOException e) {
            JAXBControlCorePlugin.log(e);
        }
    }

    class ContentNotifier
    implements ISafeRunnable {
        private IStreamListener fListener;
        private String fText;

        ContentNotifier() {
        }

        public void handleException(Throwable exception) {
            JAXBControlCorePlugin.log(exception);
        }

        public void notifyAppend(String text) {
            Object[] copiedListeners;
            if (text == null) {
                return;
            }
            this.fText = text;
            Object[] objectArray = copiedListeners = CommandJobStreamMonitor.this.fListeners.getListeners();
            int n = copiedListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object copiedListener = objectArray[n2];
                this.fListener = (IStreamListener)copiedListener;
                SafeRunner.run((ISafeRunnable)this);
                ++n2;
            }
            this.fListener = null;
            this.fText = null;
        }

        public void run() throws Exception {
            this.fListener.streamAppended(this.fText, (IStreamMonitor)CommandJobStreamMonitor.this);
        }
    }
}

