/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.toolopts.BuildTool;
import org.eclipse.ptp.internal.etfw.ToolStep;
import org.eclipse.ptp.internal.etfw.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderTool
extends ToolStep
implements IToolLaunchConfigurationConstants {
    private String progPath = null;
    private boolean runbuilt = false;
    private IConfiguration newBuildConfig = null;
    private String buildConf = null;
    private IConfiguration olddefbuildconf = null;
    private IManagedBuildInfo buildInfo = null;
    private Map<String, String> buildMods = null;
    private String newname = null;
    private String binary = null;
    private BuildTool tool = null;
    private IBuildLaunchUtils utilBlob = null;
    private boolean isManaged;
    public IConfiguration selectedconf = null;
    private static final String CComp = "CC";
    private static final String CxxComp = "CXX";
    private static final String FComp = "F90";
    private static final String UPCComp = "UPCC";
    private static final String EQ = ":=";

    private static int modifyCommand(ITool tool, String command, String args, boolean replace) {
        int didChange = 0;
        String toolCommand = tool.getToolCommand();
        if (replace) {
            String newcom = String.valueOf(command) + " " + args;
            if (!newcom.equals(toolCommand)) {
                tool.setToolCommand(String.valueOf(command) + " " + args);
                didChange = 1;
            }
        } else {
            String newcom;
            String oldcom = toolCommand.trim();
            int lastspc = oldcom.lastIndexOf(32);
            if (lastspc >= 0) {
                oldcom = toolCommand.substring(lastspc).trim();
            }
            if (!(newcom = String.valueOf(command) + " " + args + " " + oldcom).equals(toolCommand)) {
                tool.setToolCommand(newcom);
                didChange = 1;
            }
        }
        return didChange;
    }

    public BuilderTool(ILaunchConfiguration conf, BuildTool btool, IBuildLaunchUtils utilBlob) throws CoreException {
        super(conf, Messages.BuilderTool_InstrumentingBuilding, utilBlob);
        this.utilBlob = utilBlob;
        this.tool = btool;
        this.initBuild(conf);
    }

    public BuilderTool(ILaunchConfiguration conf, BuildTool btool, Map<String, String> buildMods, IBuildLaunchUtils utilBlob) throws CoreException {
        super(conf, Messages.BuilderTool_InstrumentingBuilding, utilBlob);
        this.buildMods = buildMods;
        this.utilBlob = utilBlob;
        this.tool = btool;
        this.initBuild(conf);
    }

    public void buildIndstrumented(IProgressMonitor monitor) throws Exception {
        if (this.tool != null) {
            if (!this.isManaged) {
                this.standardMakeBuild(monitor);
            } else if (this.runbuilt) {
                this.runbuilt = this.initMMBuildConf();
                if (this.runbuilt) {
                    this.runbuilt = this.managedMakeBuild(monitor);
                }
            }
        }
    }

    public boolean getBuildSuccessful() {
        return this.runbuilt;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public String getProgramPath() {
        return this.progPath;
    }

    private String getStandardMakeBuildOps(BuildTool tool, ILaunchConfiguration configuration, String allargs) throws CoreException {
        String ops = "";
        if (tool.getCcCompiler() != null) {
            ops = String.valueOf(ops) + this.getStandardMakeOp(CComp, this.getToolCommand(tool.getCcCompiler(), configuration), allargs, tool.replaceCompiler);
        }
        if (tool.getCxxCompiler() != null) {
            ops = String.valueOf(ops) + this.getStandardMakeOp(CxxComp, this.getToolCommand(tool.getCxxCompiler(), configuration), allargs, tool.replaceCompiler);
        }
        if (tool.getF90Compiler() != null) {
            ops = String.valueOf(ops) + this.getStandardMakeOp(FComp, this.getToolCommand(tool.getF90Compiler(), configuration), allargs, tool.replaceCompiler);
        }
        if (tool.getUPCCompiler() != null) {
            ops = String.valueOf(ops) + this.getStandardMakeOp(UPCComp, this.getToolCommand(tool.getUPCCompiler(), configuration), allargs, tool.replaceCompiler);
        }
        return ops;
    }

    private String getStandardMakeOp(String var, String command, String args, boolean replace) {
        String op = "";
        if (command != null) {
            op = String.valueOf(var) + EQ + command + " " + args;
            if (!replace) {
                op = String.valueOf(op) + " $(" + var + ")";
            }
            op = String.valueOf(op) + "\n";
        }
        return op;
    }

    private void initBuild(ILaunchConfiguration conf) throws CoreException {
        this.buildConf = this.configuration.getAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", null);
        if (this.tool == null) {
            return;
        }
        this.buildInfo = ManagedBuildManager.getBuildInfo((IResource)this.thisCProject.getResource());
        this.olddefbuildconf = this.buildInfo.getDefaultConfiguration();
        this.isManaged = this.olddefbuildconf.isManagedBuildOn();
        this.runbuilt = this.isManaged ? this.initMMBuild() : this.initSMBuild();
    }

    private boolean initMMBuild() throws CoreException {
        IConfiguration[] confs;
        IConfiguration[] buildconfigs;
        String bextension;
        if (this.buildInfo == null || !this.buildInfo.isValid()) {
            System.out.println(Messages.BuilderTool_NoInfo);
            return false;
        }
        IManagedProject managedBuildProj = this.buildInfo.getManagedProject();
        if (managedBuildProj == null) {
            System.out.println(Messages.BuilderTool_NoManagedProject);
            return false;
        }
        this.binary = this.buildInfo.getBuildArtifactName();
        if (this.binary.equals("${ProjName}")) {
            this.binary = this.thisProject.getName();
        }
        if ((bextension = this.buildInfo.getBuildArtifactExtension()).length() > 0) {
            this.binary = String.valueOf(this.binary) + "." + bextension;
        }
        IConfiguration[] iConfigurationArray = buildconfigs = this.buildInfo.getManagedProject().getConfigurations();
        int n = buildconfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration buildconfig = iConfigurationArray[n2];
            if (buildconfig.getName().equals(this.buildConf)) {
                this.selectedconf = buildconfig;
                break;
            }
            ++n2;
        }
        if (this.selectedconf == null) {
            System.out.println(Messages.BuilderTool_NoConfSelected);
            return false;
        }
        if (this.selectedconf.getName() == null) {
            System.out.println(Messages.BuilderTool_SelConfHasNoName);
            return false;
        }
        String basename = this.selectedconf.getName();
        this.newname = null;
        String addname = this.configuration.getAttribute("performance_tool_build_configuration_name_modifier." + this.tool.toolID, "PerformanceAnalysis");
        this.newname = String.valueOf(basename) + "_" + addname;
        if (addname.equals("PerformanceAnalysis")) {
            String nameMod = this.tool.toolName;
            if (nameMod == null) {
                nameMod = this.tool.toolID;
            }
            this.newname = String.valueOf(this.newname) + "_" + nameMod;
        }
        this.progPath = String.valueOf(this.newname) + File.separator + this.binary;
        if (!this.isSyncProject && this.configuration.getAttribute("perf_executable_path_tag_for_path_value", null) != null) {
            this.outputLocation = this.thisProject.getFile(this.newname).getLocationURI().getPath();
        }
        boolean confExists = false;
        IConfiguration[] iConfigurationArray2 = confs = managedBuildProj.getConfigurations();
        int n3 = confs.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfiguration conf = iConfigurationArray2[n4];
            if (conf.getName().equals(this.newname) || conf.getName().indexOf(this.newname) >= 0) {
                confExists = true;
                this.newBuildConfig = conf;
                break;
            }
            ++n4;
        }
        if (!confExists) {
            this.newBuildConfig = managedBuildProj.createConfigurationClone(this.selectedconf, String.valueOf(this.selectedconf.getId()) + "." + ManagedBuildManager.getRandomNumber());
        }
        if (this.newBuildConfig == null) {
            System.out.println(Messages.BuilderTool_NoConfig);
            return false;
        }
        return true;
    }

    public boolean initMMBuildConf() throws CoreException, FileNotFoundException {
        ITool[] tools;
        if (!this.newBuildConfig.getName().equals(this.newname)) {
            this.newBuildConfig.setName(this.newname);
        }
        IToolChain chain = this.newBuildConfig.getToolChain();
        ITool[] iToolArray = tools = chain.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool it = iToolArray[n2];
            IOption[] iOptionArray = it.getOptions();
            int n3 = iOptionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption op = iOptionArray[n4];
                if (op == null || op.getName() == null) {
                    // empty if block
                }
                ++n4;
            }
            ++n2;
        }
        String allargs = "";
        if (this.tool.getGlobalCompiler() != null && !this.tool.getGlobalCompiler().equals(this.tool.getCcCompiler())) {
            allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration);
        }
        int numChanges = 0;
        ITool[] iToolArray2 = tools;
        int n5 = tools.length;
        int n6 = 0;
        while (n6 < n5) {
            String toolid;
            ITool tool2 = iToolArray2[n6];
            if (this.buildMods != null) {
                for (String opName : this.buildMods.keySet()) {
                    IOption[] iOptionArray = tool2.getOptions();
                    int n7 = iOptionArray.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        IOption op = iOptionArray[n8];
                        if (op.getName().equals(opName)) {
                            try {
                                op.setValue(this.buildMods.get(opName));
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n8;
                    }
                }
            }
            if ((toolid = tool2.getId()).indexOf(".c.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tool2, this.getToolCommand(this.tool.getCcCompiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".cpp.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tool2, this.getToolCommand(this.tool.getCxxCompiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".fortran.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tool2, this.getToolCommand(this.tool.getF90Compiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".upc.") >= 0 || toolid.indexOf(".bupc.") >= 0 || toolid.indexOf(".xlupc.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tool2, this.getToolCommand(this.tool.getUPCCompiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            ++n6;
        }
        if (numChanges > 0) {
            ManagedBuildManager.saveBuildInfo((IProject)this.thisCProject.getProject(), (boolean)true);
        }
        return true;
    }

    private boolean initSMBuild() throws CoreException {
        IConfiguration[] buildconfigs;
        if (this.buildInfo == null || !this.buildInfo.isValid()) {
            System.out.println(Messages.BuilderTool_NoInfo);
            return false;
        }
        IConfiguration[] iConfigurationArray = buildconfigs = this.buildInfo.getManagedProject().getConfigurations();
        int n = buildconfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration buildconfig = iConfigurationArray[n2];
            if (buildconfig.getName().equals(this.buildConf)) {
                this.selectedconf = buildconfig;
                break;
            }
            ++n2;
        }
        this.newname = this.progPath = this.olddefbuildconf.getEditableBuilder().getBuildLocation().toOSString();
        if (this.configuration.getAttribute("perf_executable_path_tag_for_path_value", null) != null) {
            IFileStore newFile;
            this.outputLocation = this.newname == null ? "" : ((newFile = this.utilBlob.getFile(this.newname)).fetchInfo().exists() ? newFile.toURI().getPath() : "");
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean managedMakeBuild(IProgressMonitor monitor) {
        programPath = null;
        pathStore = null;
        if (this.isSyncProject) {
            pathStore = this.utilBlob.getFile(this.outputLocation);
            pathStore = pathStore.getChild(this.progPath);
        } else {
            programPath = this.thisProject.getFile(this.progPath);
            pathStore = this.utilBlob.getFile(programPath.getLocationURI().getPath());
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.newBuildConfig);
        try {
            this.thisProject.build(6, monitor);
            if (true) ** GOTO lbl26
        }
        catch (Exception v0) {
            return false;
        }
        do {
            if (monitor != null && monitor.isCanceled()) {
                this.restoreBuild();
                this.runbuilt = false;
                throw new OperationCanceledException();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException v1) {}
            if (this.isSyncProject) continue;
            programPath = this.thisProject.getFile(this.progPath);
lbl26:
            // 3 sources

        } while (this.waitForBuild(-1L, programPath, pathStore.fetchInfo()));
        this.restoreBuild();
        return true;
    }

    public void restoreBuild() {
        if (this.isManaged) {
            ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.olddefbuildconf);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.buildIndstrumented(monitor);
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, Messages.BuilderTool_BuildIncomplete, (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, Messages.BuilderTool_BuildSuccessful, null);
    }

    public void standardMakeBuild(IProgressMonitor monitor) throws CoreException {
        IFileStore projectFileStore = this.utilBlob.getFile(this.projectLocation);
        IFileStore compilerInclude = projectFileStore.getChild("eclipse.inc");
        try {
            BufferedOutputStream makeOut = new BufferedOutputStream(compilerInclude.openOutputStream(0, null));
            String allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration);
            String ops = this.getStandardMakeBuildOps(this.tool, this.configuration, allargs);
            makeOut.write(ops.getBytes());
            makeOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MakeTargetManager targetMan = new MakeTargetManager();
        targetMan.startup();
        IMakeTarget[] targs = targetMan.getTargets((IContainer)this.thisProject);
        IMakeTarget select = null;
        IMakeTarget[] iMakeTargetArray = targs;
        int n = targs.length;
        int n2 = 0;
        while (n2 < n) {
            IMakeTarget targ = iMakeTargetArray[n2];
            if (targ.getName().equals(Messages.BuilderTool_all)) {
                select = targ;
                break;
            }
            ++n2;
        }
        if (select == null) {
            IMakeBuilderInfo info;
            if (!(this.isSyncProject || (info = MakeCorePlugin.createBuildInfo((IProject)this.thisProject, (String)"org.eclipse.ptp.rdt.core.remoteMakeBuilder")) != null && info.isFullBuildEnabled())) {
                System.out.println(Messages.BuilderTool_NoMakeTargetAll);
                this.runbuilt = false;
                return;
            }
            this.thisProject.build(15, monitor);
            this.thisProject.build(6, monitor);
        } else {
            select.build(monitor);
        }
        targetMan.shutdown();
        try {
            BufferedOutputStream out = new BufferedOutputStream(compilerInclude.openOutputStream(0, null));
            byte[] buf = new byte[1024];
            ((OutputStream)out).write(buf, 0, 0);
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.runbuilt = true;
    }

    private boolean waitForBuild(long lastBuilt, IFile programPath, IFileInfo progInfo) {
        return programPath != null && !programPath.exists() && !progInfo.exists();
    }
}

