/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;

public class FileTreeIterator
extends WorkingTreeIterator {
    protected final File directory;
    protected final FS fs;

    public FileTreeIterator(Repository repo) {
        this(repo.getWorkTree(), repo.getFS(), repo.getConfig().get(WorkingTreeOptions.KEY));
        this.initRootIterator(repo);
    }

    public FileTreeIterator(File root, FS fs, WorkingTreeOptions options) {
        super(options);
        this.directory = root;
        this.fs = fs;
        this.init(this.entries());
    }

    protected FileTreeIterator(WorkingTreeIterator p, File root, FS fs) {
        super(p);
        this.directory = root;
        this.fs = fs;
        this.init(this.entries());
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        return new FileTreeIterator(this, ((FileEntry)this.current()).getFile(), this.fs);
    }

    private WorkingTreeIterator.Entry[] entries() {
        File[] all = this.directory.listFiles();
        if (all == null) {
            return EOF;
        }
        WorkingTreeIterator.Entry[] r = new WorkingTreeIterator.Entry[all.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new FileEntry(all[i], this.fs);
        }
        return r;
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getEntryFile() {
        return ((FileEntry)this.current()).getFile();
    }

    @Override
    protected byte[] idSubmodule(WorkingTreeIterator.Entry e) {
        if (this.repository == null) {
            return this.idSubmodule(this.getDirectory(), e);
        }
        return super.idSubmodule(e);
    }

    public static class FileEntry
    extends WorkingTreeIterator.Entry {
        private final FileMode mode;
        private FS.Attributes attributes;
        private FS fs;

        public FileEntry(File f, FS fs) {
            this.fs = fs;
            f = fs.normalize(f);
            this.attributes = fs.getAttributes(f);
            this.mode = this.attributes.isSymbolicLink() ? FileMode.SYMLINK : (this.attributes.isDirectory() ? (new File(f, ".git").exists() ? FileMode.GITLINK : FileMode.TREE) : (this.attributes.isExecutable() ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE));
        }

        @Override
        public FileMode getMode() {
            return this.mode;
        }

        @Override
        public String getName() {
            return this.attributes.getName();
        }

        @Override
        public long getLength() {
            return this.attributes.getLength();
        }

        @Override
        public long getLastModified() {
            return this.attributes.getLastModifiedTime();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.fs.isSymLink(this.getFile())) {
                return new ByteArrayInputStream(this.fs.readSymLink(this.getFile()).getBytes("UTF-8"));
            }
            return new FileInputStream(this.getFile());
        }

        public File getFile() {
            return this.attributes.getFile();
        }
    }
}

