/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.runnable.Command;
import org.eclipse.linuxtools.systemtap.structures.runnable.StreamGobbler;
import org.eclipse.linuxtools.systemtap.ui.consolelog.Messages;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.RemoteScriptOptions;
import org.eclipse.linuxtools.tools.launch.core.factory.LinuxtoolsProcessFactory;

public class ScpExec
extends Command {
    public static final int INPUT_STREAM = 1;
    private static final int WAIT_DELAY = 1000;
    private Channel channel;
    private RemoteScriptOptions remoteOptions;

    public ScpExec(String[] cmd, RemoteScriptOptions remoteOptions, String[] envVars) {
        super(cmd, envVars, null);
        this.remoteOptions = remoteOptions;
    }

    protected IStatus init() {
        try {
            this.channel = LinuxtoolsProcessFactory.execRemote((String[])this.cmd, (OutputStream)System.out, (OutputStream)System.err, (String)this.remoteOptions.userName, (String)this.remoteOptions.hostName, (String)this.remoteOptions.password, (int)this.remoteOptions.port, (String[])this.envVars);
            this.errorGobbler = new StreamGobbler(this.channel.getExtInputStream());
            this.inputGobbler = new StreamGobbler(this.channel.getInputStream());
            this.transferListeners();
            return Status.OK_STATUS;
        }
        catch (JSchException | IOException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.systemtap.ui.consolelog", Messages.ScpExec_FileTransferFailed, e);
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.errorGobbler.start();
            this.inputGobbler.start();
            ScpExec scpExec = this;
            synchronized (scpExec) {
                while (!this.channel.isClosed()) {
                    ((Object)((Object)this)).wait(1000L);
                }
                this.cleanUpAfterStop();
            }
        }
        catch (InterruptedException e) {
            this.stop();
        }
    }

    public synchronized void stop() {
        if (!this.stopped) {
            try {
                if (this.channel != null) {
                    this.channel.getSession().disconnect();
                }
                this.cleanUpAfterStop();
            }
            catch (JSchException e) {
                ExceptionErrorDialog.openError((String)Messages.ScpExec_Error, (String)e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

