/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.ui;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.linuxtools.internal.profiling.ui.ProfileUIPlugin;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ProfileUIUtils {
    public static void openEditorAndSelect(String path, int line) throws PartInitException, BadLocationException {
        IFileStore file;
        IWorkbenchPage activePage;
        IEditorPart editor;
        Path p = new Path(path);
        if (p.toFile().exists() && (editor = IDE.openEditorOnFileStore((IWorkbenchPage)(activePage = ProfileUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()), (IFileStore)(file = EFS.getLocalFileSystem().getStore((IPath)p)))) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            if (line > 0) {
                IDocumentProvider provider = textEditor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                int start = document.getLineOffset(line - 1);
                textEditor.selectAndReveal(start, 0);
            }
        }
    }

    public static void openEditorAndSelect(String path, int line, IProject project) throws PartInitException, BadLocationException, CoreException {
        IEditorPart editor;
        IWorkbenchPage activePage = ProfileUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IRemoteFileProxy proxy = null;
        proxy = RemoteProxyManager.getInstance().getFileProxy(project);
        IFileStore file = proxy.getResource(path);
        if (file.fetchInfo().exists() && (editor = IDE.openEditorOnFileStore((IWorkbenchPage)activePage, (IFileStore)file)) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            if (line > 0) {
                IDocumentProvider provider = textEditor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                int start = document.getLineOffset(line - 1);
                textEditor.selectAndReveal(start, 0);
            }
        }
    }

    public static void openEditorAndSelect(IFile file, int line) throws PartInitException, BadLocationException {
        IWorkbenchPage activePage;
        IEditorPart editor;
        if (file.exists() && (editor = IDE.openEditor((IWorkbenchPage)(activePage = ProfileUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()), (IFile)file)) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            if (line > 0) {
                IDocumentProvider provider = textEditor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                int start = document.getLineOffset(line - 1);
                textEditor.selectAndReveal(start, 0);
            }
        }
    }

    public static void openEditorAndSelect(ISourceLookupResult result, int line) throws PartInitException, BadLocationException {
        IWorkbenchPage activePage;
        IEditorPart editor;
        Object sourceElement;
        IEditorInput input = result.getEditorInput();
        String editorID = result.getEditorId();
        if ((input == null || editorID == null) && (sourceElement = result.getSourceElement()) != null) {
            if (sourceElement instanceof LocalFileStorage) {
                IPath filePath = ((LocalFileStorage)sourceElement).getFullPath();
                URI fileURI = URIUtil.toURI((IPath)filePath);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile[] files = root.findFilesForLocationURI(fileURI);
                if (files.length > 0) {
                    sourceElement = files[0];
                }
            }
            IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation((String)CDebugCorePlugin.getUniqueIdentifier());
            input = pres.getEditorInput(sourceElement);
            editorID = pres.getEditorId(input, sourceElement);
            pres.dispose();
        }
        if (input != null && editorID != null && (editor = IDE.openEditor((IWorkbenchPage)(activePage = ProfileUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()), (IEditorInput)input, (String)editorID)) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            if (line > 0) {
                IDocumentProvider provider = textEditor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                IRegion lineRegion = document.getLineInformation(line - 1);
                textEditor.selectAndReveal(lineRegion.getOffset(), lineRegion.getLength());
            }
        }
    }

    public static void openEditorAndSelect(String path, int offset, int length) throws PartInitException {
        IFileStore fileStore;
        IWorkbenchPage activePage;
        IEditorPart editor;
        Path p = new Path(path);
        if (p.toFile().exists() && (editor = IDE.openEditorOnFileStore((IWorkbenchPage)(activePage = ProfileUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()), (IFileStore)(fileStore = EFS.getLocalFileSystem().getStore((IPath)p)))) instanceof ITextEditor) {
            ITextEditor text = (ITextEditor)editor;
            text.selectAndReveal(offset, length);
        }
    }

    public static ICProject findCProjectWithAbsolutePath(final String absPath) throws CoreException {
        ICProject[] cProjects;
        final String workspaceLoc = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        final ArrayList ret = new ArrayList();
        ICElementVisitor vis = new ICElementVisitor(){

            public boolean visit(ICElement element) {
                if (element.getElementType() == 12 || element.getElementType() == 11) {
                    return true;
                }
                if (absPath.equals(String.valueOf(workspaceLoc) + element.getPath().toFile().getAbsolutePath())) {
                    ret.add(element.getCProject());
                }
                return false;
            }
        };
        ICProject[] iCProjectArray = cProjects = CCorePlugin.getDefault().getCoreModel().getCModel().getCProjects();
        int n = cProjects.length;
        int n2 = 0;
        while (n2 < n) {
            ICProject proj = iCProjectArray[n2];
            proj.accept(vis);
            ++n2;
        }
        return ret.isEmpty() ? null : (ICProject)ret.get(0);
    }

    public static Map<String, int[]> findFunctionsInProject(ICProject project, String functionName, int numArgs, String fileHint) {
        HashMap<String, int[]> files = new HashMap<String, int[]>();
        IIndexManager manager = CCorePlugin.getIndexManager();
        IIndex index = null;
        try {
            try {
                IIndexBinding[] bindings;
                index = manager.getIndex(project);
                index.acquireReadLock();
                IIndexBinding[] iIndexBindingArray = bindings = index.findBindings(functionName.toCharArray(), IndexFilter.ALL, null);
                int n = bindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexBinding bind = iIndexBindingArray[n2];
                    if (bind instanceof IFunction && (numArgs == -1 || ((IFunction)bind).getParameters().length == numArgs)) {
                        IIndexName[] names;
                        IFunction ifunction = (IFunction)bind;
                        IIndexName[] iIndexNameArray = names = index.findNames((IBinding)ifunction, 2);
                        int n3 = names.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IIndexName iname = iIndexNameArray[n4];
                            IIndexFile file = iname.getFile();
                            if (file != null) {
                                String loc = file.getLocation().getURI().getPath();
                                if (fileHint != null) {
                                    if (loc.equals(new File(fileHint).getCanonicalPath())) {
                                        files.put(loc, new int[]{iname.getNodeOffset(), iname.getNodeLength()});
                                    }
                                } else {
                                    files.put(loc, new int[]{iname.getNodeOffset(), iname.getNodeLength()});
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (IOException | InterruptedException | CoreException e) {
                e.printStackTrace();
                index.releaseReadLock();
            }
        }
        finally {
            index.releaseReadLock();
        }
        return files;
    }

    public static Map<String, int[]> findFunctionsInProject(ICProject project, String functionName, int numArgs, String fileHint, boolean needResult) {
        Map<String, int[]> map = ProfileUIUtils.findFunctionsInProject(project, functionName, numArgs, fileHint);
        if (needResult && map.isEmpty() && (map = ProfileUIUtils.findFunctionsInProject(project, functionName, -1, fileHint)).isEmpty()) {
            return ProfileUIUtils.findFunctionsInProject(project, functionName, -1, null);
        }
        return map;
    }
}

