/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SystemTapScriptLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    static final String SCRIPT_PATH_ATTR = "ScriptPath";
    static final String CURRENT_USER_ATTR = "executeAsCurrentUser";
    static final String USER_NAME_ATTR = "userName";
    static final String USER_PASS_ATTR = "userPassword";
    static final String LOCAL_HOST_ATTR = "executeOnLocalHost";
    static final String HOST_NAME_ATTR = "hostName";
    static final String PORT_ATTR = "port";
    static final String USE_DEFAULT_PORT_ATTR = "useDefaultPort";
    private Text scriptPathText;
    private Button currentUserCheckButton;
    private Text userNameText;
    private Label userNameLabel;
    private Text userPasswordText;
    private Label userPasswordLabel;
    private Button localHostCheckButton;
    private Group hostSettingsGroup;
    private Text hostNameText;
    private Label hostNameLabel;
    private Text portText;
    private Label portLabel;
    private Button portCheckButton;
    private FileDialog fileDialog;
    SelectionListener checkListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            this.update();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.update();
        }

        private void update() {
            SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    };

    IPath getScriptPath() {
        Path scriptPath = new Path(this.scriptPathText.getText());
        return scriptPath.toFile().exists() ? scriptPath : null;
    }

    public void createControl(Composite parent) {
        this.fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        this.fileDialog.setText(Messages.SystemTapScriptLaunchConfigurationTab_selectScript);
        this.fileDialog.setFilterPath(Platform.getLocation().toOSString());
        GridLayout layout = new GridLayout();
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        Group scriptSettingsGroup = new Group(top, 16);
        scriptSettingsGroup.setText(Messages.SystemTapScriptLaunchConfigurationTab_script);
        scriptSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout();
        layout.numColumns = 2;
        scriptSettingsGroup.setLayout((Layout)layout);
        this.scriptPathText = new Text((Composite)scriptSettingsGroup, 2052);
        this.scriptPathText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scriptPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button selectScriptButon = new Button((Composite)scriptSettingsGroup, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 110;
        selectScriptButon.setLayoutData((Object)gridData);
        selectScriptButon.setText(Messages.SystemTapScriptLaunchConfigurationTab_browse);
        selectScriptButon.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String path = SystemTapScriptLaunchConfigurationTab.this.fileDialog.open();
                if (path != null) {
                    SystemTapScriptLaunchConfigurationTab.this.scriptPathText.setText(path);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group userSettingsGroup = new Group(top, 16);
        layout = new GridLayout();
        userSettingsGroup.setLayout((Layout)layout);
        layout.numColumns = 2;
        userSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.currentUserCheckButton = new Button((Composite)userSettingsGroup, 32);
        this.currentUserCheckButton.setText(Messages.SystemTapScriptLaunchConfigurationTab_currentUser);
        this.currentUserCheckButton.setSelection(true);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.currentUserCheckButton.setLayoutData((Object)gridData);
        this.currentUserCheckButton.addSelectionListener(this.checkListener);
        this.userNameLabel = new Label((Composite)userSettingsGroup, 0);
        this.userNameLabel.setText(Messages.SystemTapScriptLaunchConfigurationTab_username);
        this.userNameText = new Text((Composite)userSettingsGroup, 2052);
        this.userNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.userPasswordLabel = new Label((Composite)userSettingsGroup, 0);
        this.userPasswordLabel.setText(Messages.SystemTapScriptLaunchConfigurationTab_password);
        this.userPasswordText = new Text((Composite)userSettingsGroup, 0x400804);
        this.userPasswordText.setLayoutData((Object)new GridData(4, 4, true, false));
        userSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        userSettingsGroup.setText(Messages.SystemTapScriptLaunchConfigurationTab_user);
        this.userNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.userPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.hostSettingsGroup = new Group(top, 16);
        this.hostSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hostSettingsGroup.setText(Messages.SystemTapScriptLaunchConfigurationTab_host);
        layout = new GridLayout();
        this.hostSettingsGroup.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.localHostCheckButton = new Button((Composite)this.hostSettingsGroup, 32);
        this.localHostCheckButton.setText(Messages.SystemTapScriptLaunchConfigurationTab_runLocally);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.hostNameLabel = new Label((Composite)this.hostSettingsGroup, 0);
        this.hostNameLabel.setText(Messages.SystemTapScriptLaunchConfigurationTab_hostname);
        this.hostNameText = new Text((Composite)this.hostSettingsGroup, 2052);
        this.hostNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.localHostCheckButton.setLayoutData((Object)gridData);
        this.localHostCheckButton.addSelectionListener(this.checkListener);
        this.hostNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.portCheckButton = new Button((Composite)this.hostSettingsGroup, 32);
        this.portCheckButton.setText(Messages.SystemTapScriptLaunchConfigurationTab_useDefaultPort);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.portCheckButton.setLayoutData((Object)gridData);
        this.portCheckButton.addSelectionListener(this.checkListener);
        this.portLabel = new Label((Composite)this.hostSettingsGroup, 0);
        this.portLabel.setText(Messages.SystemTapScriptLaunchConfigurationTab_port);
        this.portText = new Text((Composite)this.hostSettingsGroup, 2052);
        this.portText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.portText.setTextLimit(5);
        this.portText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 8) {
                    return;
                }
                int i = 0;
                int n = e.text.length();
                while (i < n) {
                    if (!Character.isDigit(e.text.charAt(i))) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void setUserGroupEnablement(boolean enable) {
        this.userNameText.setEnabled(enable);
        this.userNameLabel.setEnabled(enable);
        this.userPasswordText.setEnabled(enable);
        this.userPasswordLabel.setEnabled(enable);
        this.hostSettingsGroup.setEnabled(enable);
        this.localHostCheckButton.setEnabled(enable);
    }

    private void setHostGroupEnablement(boolean enable) {
        this.hostNameText.setEnabled(enable);
        this.hostNameLabel.setEnabled(enable);
        this.portCheckButton.setEnabled(enable);
        boolean portEnabled = enable && !this.portCheckButton.getSelection();
        this.portText.setEnabled(portEnabled);
        this.portLabel.setEnabled(portEnabled);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SCRIPT_PATH_ATTR, this.getSelectedScriptPath());
        configuration.setAttribute(CURRENT_USER_ATTR, true);
        configuration.setAttribute(USER_NAME_ATTR, "");
        configuration.setAttribute(USER_PASS_ATTR, "");
        configuration.setAttribute(LOCAL_HOST_ATTR, true);
        configuration.setAttribute(HOST_NAME_ATTR, "");
        configuration.setAttribute(PORT_ATTR, 22);
        configuration.setAttribute(USE_DEFAULT_PORT_ATTR, true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.scriptPathText.setText(configuration.getAttribute(SCRIPT_PATH_ATTR, ""));
            this.currentUserCheckButton.setSelection(configuration.getAttribute(CURRENT_USER_ATTR, true));
            this.userNameText.setText(configuration.getAttribute(USER_NAME_ATTR, ""));
            this.userPasswordText.setText(configuration.getAttribute(USER_PASS_ATTR, ""));
            this.localHostCheckButton.setSelection(configuration.getAttribute(LOCAL_HOST_ATTR, true));
            this.hostNameText.setText(configuration.getAttribute(HOST_NAME_ATTR, ""));
            this.portText.setText(Integer.toString(configuration.getAttribute(PORT_ATTR, 22)));
            this.portCheckButton.setSelection(configuration.getAttribute(USE_DEFAULT_PORT_ATTR, true));
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptLaunchConfigurationTab_errorInitializingTab, (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SCRIPT_PATH_ATTR, this.scriptPathText.getText());
        configuration.setAttribute(CURRENT_USER_ATTR, this.currentUserCheckButton.getSelection());
        configuration.setAttribute(USER_NAME_ATTR, this.userNameText.getText());
        configuration.setAttribute(USER_PASS_ATTR, this.userPasswordText.getText());
        configuration.setAttribute(LOCAL_HOST_ATTR, this.localHostCheckButton.getSelection());
        configuration.setAttribute(HOST_NAME_ATTR, this.hostNameText.getText());
        configuration.setAttribute(USE_DEFAULT_PORT_ATTR, this.portCheckButton.getSelection());
        String portString = this.portText.getText();
        configuration.setAttribute(PORT_ATTR, !portString.isEmpty() ? Integer.valueOf(portString) : 0);
        boolean enable = !this.currentUserCheckButton.getSelection();
        this.setUserGroupEnablement(enable);
        this.setHostGroupEnablement(enable &= !this.localHostCheckButton.getSelection());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        IPath scriptPath = this.getScriptPath();
        if (scriptPath == null) {
            this.setErrorMessage(MessageFormat.format(Messages.SystemTapScriptLaunchConfigurationTab_fileNotFound, this.scriptPathText.getText()));
            return false;
        }
        String extension = scriptPath.getFileExtension();
        if (extension == null || !extension.equals("stp")) {
            this.setErrorMessage(Messages.SystemTapScriptLaunchConfigurationTab_fileNotStp);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.SystemTapScriptLaunchConfigurationTab_general;
    }

    private String getSelectedScriptPath() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        String pathString = "";
        if (window != null) {
            Object selectedElement;
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof TreeSelection && (selectedElement = ((TreeSelection)selection).getFirstElement()) instanceof IFile) {
                IPath path = ((IFile)selectedElement).getLocation();
                pathString = path.toOSString();
            }
            if (selection instanceof TextSelection) {
                IEditorPart ed = window.getActivePage().getActiveEditor();
                pathString = ed.getEditorInput() instanceof PathEditorInput ? ((PathEditorInput)ed.getEditorInput()).getPath().toString() : ResourceUtil.getFile((IEditorInput)ed.getEditorInput()).getLocation().toString();
            }
        }
        if (pathString.endsWith(".stp")) {
            return pathString;
        }
        return "";
    }

    public Image getImage() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.systemtap.ui.ide", (String)"icons/main_tab.gif").createImage();
    }
}

