/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.valgrind.ui.Messages;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindViewPart;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ValgrindUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.ui";
    private static final String VIEW_EXT_ID = "valgrindToolViews";
    protected static final String EXT_ELEMENT = "view";
    protected static final String EXT_ATTR_ID = "definitionId";
    protected static final String EXT_ATTR_CLASS = "class";
    private HashMap<String, IConfigurationElement> toolMap;
    private static ValgrindUIPlugin plugin;
    private ValgrindViewPart view;
    private IWorkbenchPage activePage;
    private IProject project;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ValgrindUIPlugin getDefault() {
        return plugin;
    }

    public void createView(final String contentDescription, final String toolID) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ValgrindUIPlugin.this.activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    ValgrindUIPlugin.this.activePage.showView("org.eclipse.linuxtools.valgrind.ui.valgrindview", null, 3);
                    ValgrindUIPlugin.this.activePage.showView("org.eclipse.linuxtools.valgrind.ui.valgrindview");
                    ValgrindUIPlugin.this.view.createDynamicContent(contentDescription, toolID);
                    ValgrindUIPlugin.this.view.refreshView();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ValgrindUIPlugin.this.activePage.showView("org.eclipse.linuxtools.valgrind.ui.valgrindview");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void refreshView() {
        if (this.view != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ValgrindUIPlugin.this.view.refreshView();
                }
            });
        }
    }

    public void resetView() {
        if (this.view != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ValgrindUIPlugin.this.view.createDynamicContent(Messages.getString("ValgrindViewPart.No_Valgrind_output"), null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    protected void setView(ValgrindViewPart view) {
        this.view = view;
    }

    public ValgrindViewPart getView() {
        return this.view;
    }

    private void initializeToolMap() {
        IConfigurationElement[] configs;
        this.toolMap = new HashMap();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, VIEW_EXT_ID);
        IConfigurationElement[] iConfigurationElementArray = configs = extPoint.getConfigurationElements();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (config.getName().equals(EXT_ELEMENT) && (id = config.getAttribute(EXT_ATTR_ID)) != null && config.getAttribute(EXT_ATTR_CLASS) != null) {
                this.toolMap.put(id, config);
            }
            ++n2;
        }
    }

    private HashMap<String, IConfigurationElement> getToolMap() {
        if (this.toolMap == null) {
            this.initializeToolMap();
        }
        return this.toolMap;
    }

    public IValgrindToolView getToolView(String id) throws CoreException {
        Object obj;
        IValgrindToolView view = null;
        IConfigurationElement config = this.getToolMap().get(id);
        if (config != null && (obj = config.createExecutableExtension(EXT_ATTR_CLASS)) instanceof IValgrindToolView) {
            view = (IValgrindToolView)obj;
        }
        if (view == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, Messages.getString("ValgrindUIPlugin.Cannot_retrieve_view")));
        }
        return view;
    }

    public void setProfiledProject(IProject project) {
        this.project = project;
    }

    public IProject getProfiledProject() {
        return this.project;
    }
}

