/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class PushOperation {
    private static final int WORK_UNITS_PER_TRANSPORT = 10;
    private final Repository localDb;
    private final PushOperationSpecification specification;
    private final boolean dryRun;
    private final String remoteName;
    private final int timeout;
    private OutputStream out;
    private PushOperationResult operationResult;
    private CredentialsProvider credentialsProvider;

    public PushOperation(Repository localDb, PushOperationSpecification specification, boolean dryRun, int timeout) {
        this(localDb, null, specification, dryRun, timeout);
    }

    public PushOperation(Repository localDb, String remoteName, boolean dryRun, int timeout) {
        this(localDb, remoteName, null, dryRun, timeout);
    }

    private PushOperation(Repository localDb, String remoteName, PushOperationSpecification specification, boolean dryRun, int timeout) {
        this.localDb = localDb;
        this.specification = specification;
        this.dryRun = dryRun;
        this.remoteName = remoteName;
        this.timeout = timeout;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public PushOperationResult getOperationResult() {
        if (this.operationResult == null) {
            throw new IllegalStateException(CoreText.OperationNotYetExecuted);
        }
        return this.operationResult;
    }

    public PushOperationSpecification getSpecification() {
        return this.specification;
    }

    public void run(IProgressMonitor actMonitor) throws InvocationTargetException {
        if (this.operationResult != null) {
            throw new IllegalStateException(CoreText.OperationAlreadyExecuted);
        }
        if (this.specification != null) {
            for (URIish uri : this.specification.getURIs()) {
                for (RemoteRefUpdate update : this.specification.getRefUpdates(uri)) {
                    if (update.getStatus() == RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
                    throw new IllegalStateException(CoreText.RemoteRefUpdateCantBeReused);
                }
            }
        }
        int totalWork = this.specification != null ? this.specification.getURIsNumber() * 10 : 1;
        String taskName = this.dryRun ? CoreText.PushOperation_taskNameDryRun : CoreText.PushOperation_taskNameNormalRun;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor, (String)taskName, (int)totalWork);
        this.operationResult = new PushOperationResult();
        Git git = new Git(this.localDb);
        if (this.specification != null) {
            for (URIish uri : this.specification.getURIs()) {
                if (progress.isCanceled()) {
                    this.operationResult.addOperationResult(uri, CoreText.PushOperation_resultCancelled);
                    continue;
                }
                Collection<RemoteRefUpdate> refUpdates = this.specification.getRefUpdates(uri);
                EclipseGitProgressTransformer gitSubMonitor = new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(5));
                try {
                    Transport transport = Transport.open((Repository)this.localDb, (URIish)uri);
                    transport.setDryRun(this.dryRun);
                    transport.setTimeout(this.timeout);
                    if (this.credentialsProvider != null) {
                        transport.setCredentialsProvider(this.credentialsProvider);
                    }
                    PushResult result = transport.push((ProgressMonitor)gitSubMonitor, refUpdates, this.out);
                    this.operationResult.addOperationResult(result.getURI(), result);
                    this.specification.addURIRefUpdates(result.getURI(), result.getRemoteUpdates());
                }
                catch (JGitInternalException e) {
                    String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                    String userMessage = NLS.bind((String)CoreText.PushOperation_InternalExceptionOccurredMessage, (Object)errorMessage);
                    this.handleException(uri, (Exception)((Object)e), userMessage);
                }
                catch (Exception e) {
                    this.handleException(uri, e, e.getMessage());
                }
                progress.worked(5);
            }
        } else {
            EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(totalWork));
            try {
                Iterable results = ((PushCommand)((PushCommand)git.push().setRemote(this.remoteName).setDryRun(this.dryRun).setTimeout(this.timeout)).setProgressMonitor((ProgressMonitor)gitMonitor).setCredentialsProvider(this.credentialsProvider)).setOutputStream(this.out).call();
                for (PushResult result : results) {
                    this.operationResult.addOperationResult(result.getURI(), result);
                }
            }
            catch (JGitInternalException e) {
                String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                String userMessage = NLS.bind((String)CoreText.PushOperation_InternalExceptionOccurredMessage, (Object)errorMessage);
                URIish uri = this.getPushURIForErrorHandling();
                this.handleException(uri, (Exception)((Object)e), userMessage);
            }
            catch (Exception e) {
                URIish uri = this.getPushURIForErrorHandling();
                this.handleException(uri, e, e.getMessage());
            }
        }
    }

    private void handleException(URIish uri, Exception e, String userMessage) {
        String uriString;
        if (uri != null) {
            this.operationResult.addOperationResult(uri, userMessage);
            uriString = uri.toString();
        } else {
            uriString = "retrieving URI failed";
        }
        String userMessageForUri = NLS.bind((String)CoreText.PushOperation_ExceptionOccurredDuringPushOnUriMessage, (Object)uriString, (Object)userMessage);
        Activator.logError(userMessageForUri, e);
    }

    private URIish getPushURIForErrorHandling() {
        RemoteConfig rc = null;
        try {
            rc = new RemoteConfig((Config)this.localDb.getConfig(), this.remoteName);
            return rc.getPushURIs().isEmpty() ? (URIish)rc.getURIs().get(0) : (URIish)rc.getPushURIs().get(0);
        }
        catch (URISyntaxException e) {
            Activator.logError("Reading RemoteConfig failed", e);
            return null;
        }
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }
}

