/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.actions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.autotools.core.AutotoolsNewMakeGenerator;
import org.eclipse.cdt.internal.autotools.ui.actions.AbstractTargetAction;
import org.eclipse.cdt.internal.autotools.ui.actions.InvokeMessages;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.remote.core.RemoteCommandLauncher;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public abstract class InvokeAction
extends AbstractTargetAction {
    public final String SHELL_COMMAND = "sh";

    protected void showInformation(String title, String content) {
        MessageDialog.openInformation((Shell)new Shell(), (String)title, (String)content);
    }

    protected void showError(String title, String content) {
        MessageDialog.openError((Shell)new Shell(), (String)title, (String)content);
    }

    protected void showSuccess(String title) {
        MessageDialog.openInformation((Shell)new Shell(), (String)title, (String)InvokeMessages.getString("InvokeAction.success"));
    }

    protected String showInput(String title, String content, String defaultTxt) {
        InputDialog getOptionDialog = new InputDialog(new Shell(), title, content, defaultTxt, null);
        getOptionDialog.open();
        return getOptionDialog.getValue();
    }

    protected String[] separateTargets(String rawArgList) {
        StringTokenizer st = new StringTokenizer(rawArgList, " ");
        ArrayList<String> targetList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            StringBuffer tmpTarget;
            String currentWord = st.nextToken().trim();
            if (currentWord.startsWith("'")) {
                tmpTarget = new StringBuffer();
                while (!currentWord.endsWith("'")) {
                    tmpTarget.append(String.valueOf(currentWord) + " ");
                    if (!st.hasMoreTokens()) {
                        return null;
                    }
                    currentWord = st.nextToken().trim();
                }
                tmpTarget.append(currentWord);
                targetList.add(tmpTarget.toString());
                continue;
            }
            if (currentWord.startsWith("\"")) {
                tmpTarget = new StringBuffer();
                while (!currentWord.endsWith("\"")) {
                    tmpTarget.append(String.valueOf(currentWord) + " ");
                    if (!st.hasMoreTokens()) {
                        return null;
                    }
                    currentWord = st.nextToken().trim();
                }
                tmpTarget.append(currentWord);
                targetList.add(tmpTarget.toString());
                continue;
            }
            targetList.add(currentWord);
        }
        return targetList.toArray(new String[targetList.size()]);
    }

    protected String[] separateOptions(String rawArgList) {
        ArrayList<String> argList = new ArrayList<String>();
        rawArgList = rawArgList.trim();
        boolean finished = false;
        int lastIndex = rawArgList.indexOf("--");
        if (lastIndex != -1) {
            while (!finished) {
                int index = rawArgList.indexOf("--", lastIndex + 2);
                if (index != -1) {
                    String previous = rawArgList.substring(lastIndex, index).trim();
                    argList.add(previous);
                    rawArgList = rawArgList.substring(index);
                    continue;
                }
                argList.add(rawArgList);
                finished = true;
            }
        }
        return argList.toArray(new String[argList.size()]);
    }

    protected String[] simpleParseOptions(String rawArgList) {
        ArrayList<String> argList = new ArrayList<String>();
        int lastArgIndex = -1;
        int i = 0;
        while (i < rawArgList.length()) {
            char ch = rawArgList.charAt(i);
            while (Character.isWhitespace(ch)) {
                if (++i < rawArgList.length()) {
                    ch = rawArgList.charAt(i);
                    continue;
                }
                return argList.toArray(new String[argList.size()]);
            }
            lastArgIndex = i;
            boolean inString = false;
            while (i < rawArgList.length()) {
                ch = rawArgList.charAt(i);
                if (ch == '\\') {
                    ++i;
                } else if (ch == '\"') {
                    inString = !inString;
                } else if (Character.isWhitespace(ch) && !inString) {
                    argList.add(rawArgList.substring(lastArgIndex, i));
                    break;
                }
                ++i;
            }
            if (i >= rawArgList.length()) {
                argList.add(rawArgList.substring(lastArgIndex));
            }
            ++i;
        }
        return argList.toArray(new String[argList.size()]);
    }

    protected IPath getExecDir(IContainer container) {
        int type = container.getType();
        IPath execDir = null;
        execDir = type == 1 ? container.getLocation().removeLastSegments(1) : container.getLocation();
        return execDir;
    }

    protected IPath getCWD(IContainer container) {
        int type = container.getType();
        IPath cwd = null;
        cwd = type == 1 ? container.getFullPath().removeLastSegments(1) : container.getFullPath();
        return cwd;
    }

    protected Map<String, String> executeCommand(IPath command, String[] argumentList, String[] envList, IPath execDir) {
        try {
            ExecuteProgressDialog d = new ExecuteProgressDialog(command, argumentList, envList, execDir);
            new ProgressMonitorDialog(new Shell()).run(false, false, (IRunnableWithProgress)d);
            if (d.getStatus() == -1) {
                this.showError(InvokeMessages.getString("InvokeAction.execute.windowTitle.error"), String.valueOf(InvokeMessages.getString("InvokeAction.execute.message")) + command.toOSString());
            }
            return d.getOutputs();
        }
        catch (InvocationTargetException e) {
            this.showError(InvokeMessages.getString("InvokeAction.execute.windowTitle.error"), String.valueOf(InvokeMessages.getString("InvokeAction.execute.message")) + command.toOSString());
            AutotoolsUIPlugin.logException(e);
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    protected void executeConsoleCommand(final String actionName, final String command, final String[] argumentList, final IPath execDir) {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        Job backgroundJob = new Job(actionName, (ISchedulingRule)rule){
            private final /* synthetic */ ISchedulingRule val$rule;
            {
                this.val$rule = iSchedulingRule;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().run(monitor1 -> {
                        try {
                            String errMsg = null;
                            IProject project = InvokeAction.this.getSelectedContainer().getProject();
                            IConsole console = CCorePlugin.getDefault().getConsole("org.eclipse.cdt.autotools.ui.autotoolsConsole");
                            console.start(project);
                            CUIPlugin.getDefault().startGlobalConsole();
                            ConsoleOutputStream consoleOutStream = console.getOutputStream();
                            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                            IConfiguration cfg = info.getDefaultConfiguration();
                            StringBuffer buf = new StringBuffer();
                            String[] consoleHeader = new String[]{actionName, cfg.getName(), project.getName()};
                            buf.append(System.getProperty("line.separator", "\n"));
                            String invokeMsg = InvokeMessages.getFormattedString("InvokeAction.console.message", new String[]{actionName, execDir.toString()});
                            buf.append(invokeMsg);
                            buf.append(System.getProperty("line.separator", "\n"));
                            buf.append(System.getProperty("line.separator", "\n"));
                            consoleOutStream.write(buf.toString().getBytes());
                            consoleOutStream.flush();
                            ArrayList additionalEnvs = new ArrayList();
                            String strippedCommand = AutotoolsNewMakeGenerator.stripEnvVars((String)command, additionalEnvs);
                            RemoteCommandLauncher launcher = new RemoteCommandLauncher();
                            launcher.setProject(project);
                            IEnvironmentVariable[] variables = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(cfg, true);
                            String[] env = null;
                            ArrayList<String> envList = new ArrayList<String>();
                            if (variables != null) {
                                int i = 0;
                                while (i < variables.length) {
                                    envList.add(String.valueOf(variables[i].getName()) + "=" + variables[i].getValue());
                                    ++i;
                                }
                                if (additionalEnvs.size() > 0) {
                                    envList.addAll(additionalEnvs);
                                }
                                env = envList.toArray(new String[envList.size()]);
                            }
                            StringBuffer command1 = new StringBuffer(strippedCommand);
                            String[] stringArray2 = argumentList;
                            int n = argumentList.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String arg = stringArray2[n2];
                                command1.append(" " + arg);
                                ++n2;
                            }
                            String[] newArgumentList = new String[]{"-c", command1.toString()};
                            ConsoleOutputStream stdout = consoleOutStream;
                            ConsoleOutputStream stderr = consoleOutStream;
                            launcher.showCommand(true);
                            Process proc = launcher.execute((IPath)new Path("sh"), newArgumentList, env, execDir, (IProgressMonitor)new NullProgressMonitor());
                            if (proc != null) {
                                try {
                                    proc.getOutputStream().close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor1)) != 0) {
                                    errMsg = launcher.getErrorMessage();
                                }
                                monitor1.subTask(AutotoolsUIPlugin.getResourceString("MakeGenerator.refresh"));
                                try {
                                    project.refreshLocal(2, null);
                                }
                                catch (CoreException e2) {
                                    monitor1.subTask(AutotoolsUIPlugin.getResourceString("MakeGenerator.refresh.error"));
                                }
                            } else {
                                errMsg = launcher.getErrorMessage();
                            }
                            if (errMsg != null) {
                                AutotoolsUIPlugin.logErrorMessage(errMsg);
                            }
                        }
                        catch (IOException e3) {
                            AutotoolsUIPlugin.log(e3);
                        }
                    }, this.val$rule, 1, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        backgroundJob.setRule((ISchedulingRule)rule);
        backgroundJob.schedule();
    }

    private static class ExecuteProgressDialog
    implements IRunnableWithProgress {
        private final IPath command;
        private final String[] argumentList;
        private final String[] envList;
        private final IPath execDir;
        private int status;
        private Map<String, String> outputs = null;

        public ExecuteProgressDialog(IPath command, String[] argumentList, String[] envList, IPath execDir) {
            this.command = command;
            this.argumentList = argumentList;
            this.envList = envList;
            this.execDir = execDir;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            RemoteCommandLauncher cmdL = new RemoteCommandLauncher();
            this.outputs = new HashMap<String, String>();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                    try {
                        ByteArrayOutputStream stderr;
                        block20: {
                            block19: {
                                stderr = new ByteArrayOutputStream();
                                monitor.beginTask(InvokeMessages.getFormattedString("InvokeAction.progress.message", new String[]{this.command.toOSString()}), -1);
                                monitor.worked(1);
                                Process process = cmdL.execute(this.command, this.argumentList, this.envList, this.execDir, (IProgressMonitor)new NullProgressMonitor());
                                if (cmdL.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new NullProgressMonitor()) != 0) {
                                    this.status = -1;
                                    monitor.done();
                                }
                                try {
                                    this.status = 0;
                                    monitor.done();
                                    process.getOutputStream().close();
                                }
                                catch (IOException iOException) {}
                                this.outputs.put("stdout", stdout.toString());
                                break block20;
                                finally {
                                    if (stderr == null) break block19;
                                    stderr.close();
                                }
                            }
                            if (stdout != null) {
                                stdout.close();
                            }
                            return;
                        }
                        this.outputs.put("stderr", stderr.toString());
                        if (stdout == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stdout == null) throw throwable;
                        stdout.close();
                        throw throwable;
                    }
                    stdout.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                monitor.done();
                throw new InvocationTargetException(e);
            }
        }

        public Map<String, String> getOutputs() {
            return this.outputs;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

