/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.util.ArrayList;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.internal.autotools.ui.MakeUIImages;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IBadDirective;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ICommand;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IComment;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IDirective;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IEmptyLine;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IInclude;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IInferenceRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IMacroDefinition;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IMakefile;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IParent;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ITargetRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ITerminal;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IWorkingCopyManager;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.LexicalSortingAction;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MakefileEditor;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.NullMakefile;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.OpenIncludeAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class MakefileContentOutlinePage
extends ContentOutlinePage {
    protected MakefileEditor fEditor;
    protected Object fInput;
    protected OpenIncludeAction fOpenIncludeAction;

    public MakefileContentOutlinePage(MakefileEditor editor) {
        this.fEditor = editor;
        this.fOpenIncludeAction = new OpenIncludeAction((ISelectionProvider)this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new MakefileContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MakefileLabelProvider());
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
        MenuManager manager = new MenuManager("#MakefileOutlinerContext");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(m -> this.contextMenuAboutToShow(m));
        Control tree = viewer.getControl();
        Menu menu = manager.createContextMenu(tree);
        tree.setMenu(menu);
        viewer.addDoubleClickListener(event -> {
            if (this.fOpenIncludeAction != null) {
                this.fOpenIncludeAction.run();
            }
        });
        IPageSite site = this.getSite();
        site.registerContextMenu(String.valueOf(AutotoolsUIPlugin.getPluginId()) + ".outline", manager, (ISelectionProvider)viewer);
        site.setSelectionProvider((ISelectionProvider)viewer);
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        if (OpenIncludeAction.canActionBeAdded(this.getSelection())) {
            menu.add((IAction)this.fOpenIncludeAction);
        }
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public Object getInput() {
        return this.fInput;
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(() -> {
                if (!control.isDisposed()) {
                    control.setRedraw(false);
                    viewer.setInput(this.fInput);
                    viewer.expandAll();
                    control.setRedraw(true);
                }
            });
        }
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        LexicalSortingAction action = new LexicalSortingAction(this.getTreeViewer());
        toolBarManager.add((IAction)action);
    }

    private class MakefileContentProvider
    implements ITreeContentProvider {
        protected boolean showMacroDefinition = true;
        protected boolean showTargetRule = true;
        protected boolean showInferenceRule = true;
        protected boolean showIncludeChildren = false;
        protected IMakefile makefile;
        protected IMakefile nullMakefile = new NullMakefile();

        private MakefileContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element == MakefileContentOutlinePage.this.fInput) {
                return this.getElements(this.makefile);
            }
            if (element instanceof IDirective) {
                return this.getElements(element);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IMakefile) {
                return MakefileContentOutlinePage.this.fInput;
            }
            if (element instanceof IDirective) {
                return ((IDirective)element).getParent();
            }
            return MakefileContentOutlinePage.this.fInput;
        }

        public boolean hasChildren(Object element) {
            if (element == MakefileContentOutlinePage.this.fInput) {
                return true;
            }
            if (element instanceof IParent) {
                return !(element instanceof IInclude) || this.showIncludeChildren;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            IDirective[] directives = inputElement == MakefileContentOutlinePage.this.fInput ? this.makefile.getDirectives() : (inputElement instanceof IRule ? ((IRule)inputElement).getCommands() : (inputElement instanceof IParent ? (inputElement instanceof IInclude && !this.showIncludeChildren ? new IDirective[]{} : ((IParent)inputElement).getDirectives()) : new IDirective[]{}));
            ArrayList<IDirective> list = new ArrayList<IDirective>(directives.length);
            int i = 0;
            while (i < directives.length) {
                if (this.showMacroDefinition && directives[i] instanceof IMacroDefinition) {
                    list.add(directives[i]);
                } else if (this.showInferenceRule && directives[i] instanceof IInferenceRule) {
                    list.add(directives[i]);
                } else if (this.showTargetRule && directives[i] instanceof ITargetRule) {
                    list.add(directives[i]);
                } else {
                    boolean irrelevant;
                    boolean bl = irrelevant = directives[i] instanceof IComment || directives[i] instanceof IEmptyLine || directives[i] instanceof ITerminal;
                    if (!irrelevant) {
                        list.add(directives[i]);
                    }
                }
                ++i;
            }
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null) {
                this.makefile = this.nullMakefile;
            }
            if (newInput != null) {
                IWorkingCopyManager manager = AutomakeEditorFactory.getDefault().getWorkingCopyManager();
                this.makefile = manager.getWorkingCopy((IEditorInput)newInput);
                if (this.makefile == null) {
                    this.makefile = this.nullMakefile;
                }
            }
        }
    }

    private static class MakefileLabelProvider
    extends LabelProvider {
        private MakefileLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ITargetRule) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_TARGET_RULE);
            }
            if (element instanceof IInferenceRule) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_INFERENCE_RULE);
            }
            if (element instanceof IMacroDefinition) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_MACRO);
            }
            if (element instanceof ICommand) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_COMMAND);
            }
            if (element instanceof IInclude) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_INCLUDE);
            }
            if (element instanceof IBadDirective) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_ERROR);
            }
            if (element instanceof IParent) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_RELATION);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            String name = element instanceof IRule ? ((IRule)element).getTarget().toString().trim() : (element instanceof IMacroDefinition ? ((IMacroDefinition)element).getName().trim() : super.getText(element));
            if (name != null && (name = name.trim()).length() > 25) {
                name = String.valueOf(name.substring(0, 25)) + " ...";
            }
            return name;
        }
    }
}

