/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.internal.autotools.ui.preferences.AbstractEditorPreferencePage;
import org.eclipse.cdt.internal.autotools.ui.preferences.AutotoolsPreferencesMessages;
import org.eclipse.cdt.internal.autotools.ui.preferences.ColorEditor;
import org.eclipse.cdt.internal.autotools.ui.preferences.ColorManager;
import org.eclipse.cdt.internal.autotools.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.autotools.ui.preferences.TabFolderLayout;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class AutoconfEditorPreferencePage
extends AbstractEditorPreferencePage {
    private static String[] fACVersions = new String[]{"2.13", "2.59", "2.61", "2.68"};
    public static final String LATEST_AC_VERSION = fACVersions[fACVersions.length - 1];
    private static String[] fAMVersions = new String[]{"1.4-p6", "1.9.5", "1.9.6", "1.11.1"};
    public static final String LATEST_AM_VERSION = fAMVersions[fAMVersions.length - 1];
    private String[][] fSyntaxColorListModel;
    private TableViewer fHighlightingColorListViewer;
    private final List<HighlightingColorListItem> fHighlightingColorList = new ArrayList<HighlightingColorListItem>(5);
    ColorEditor fSyntaxForegroundColorEditor;
    Button fBoldCheckBox;
    Button fItalicCheckBox;
    protected Button fFoldingCheckbox;
    protected Combo fACVersionCombo;
    protected Combo fAMVersionCombo;

    @Override
    protected OverlayPreferenceStore createOverlayStore() {
        String[][] stringArrayArray = new String[8][];
        String[] stringArray = new String[3];
        stringArray[0] = AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.autoconf_editor_comment");
        stringArray[1] = "org.eclipse.cdt.autotools.ui.autoconf.editor.comment";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.autoconf_editor_acmacro");
        stringArray2[1] = "org.eclipse.cdt.autotools.ui.autoconf.editor.acmacro";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.autoconf_editor_ammacro");
        stringArray3[1] = "org.eclipse.cdt.autotools.ui.autoconf.editor.ammacro";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.autoconf_editor_code_seq");
        stringArray4[1] = "org.eclipse.cdt.autotools.ui.autoconf.editor.codeseq";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.autoconf_editor_keyword");
        stringArray5[1] = "org.eclipse.cdt.autotools.ui.autoconf.editor.keyword";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[3];
        stringArray6[0] = AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.autoconf_editor_var_ref");
        stringArray6[1] = "org.eclipse.cdt.autotools.ui.autoconf.editor.var_ref";
        stringArrayArray[5] = stringArray6;
        String[] stringArray7 = new String[3];
        stringArray7[0] = AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.autoconf_editor_var_set");
        stringArray7[1] = "org.eclipse.cdt.autotools.ui.autoconf.editor.var_set";
        stringArrayArray[6] = stringArray7;
        String[] stringArray8 = new String[3];
        stringArray8[0] = AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.autoconf_editor_default");
        stringArray8[1] = "org.eclipse.cdt.autotools.ui.autoconf.editor.default";
        stringArrayArray[7] = stringArray8;
        this.fSyntaxColorListModel = stringArrayArray;
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_enabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_conditional"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_macrodef"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_rule"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "autoconf_version"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "automake_version"));
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            String colorKey = this.fSyntaxColorListModel[i][1];
            this.addTextKeyToCover(overlayKeys, colorKey);
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    private void addTextKeyToCover(List<OverlayPreferenceStore.OverlayKey> overlayKeys, String mainKey) {
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, mainKey));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_italic"));
    }

    protected Control createContents(Composite parent) {
        AutotoolsUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), IMakeHelpContextIds.MAKE_EDITOR_PREFERENCE_PAGE);
        this.getOverlayStore().load();
        this.getOverlayStore().start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(AutotoolsPreferencesMessages.getString("AutomakeEditorPreferencePage.syntax"));
        item.setControl(this.createSyntaxPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.folding"));
        item.setControl((Control)this.createFoldingTabContent(folder));
        item = new TabItem(folder, 0);
        item.setText(AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.version"));
        item.setControl((Control)this.createVersionTabContent(folder));
        this.initialize();
        this.applyDialogFont((Composite)folder);
        return folder;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fHighlightingColorList.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + "_bold", String.valueOf(this.fSyntaxColorListModel[i][1]) + "_italic", null));
            ++i;
        }
        this.fHighlightingColorListViewer.setInput(this.fHighlightingColorList);
        this.fHighlightingColorListViewer.setSelection((ISelection)new StructuredSelection(this.fHighlightingColorListViewer.getElementAt(0)));
        i = 0;
        n = fACVersions.length;
        while (i < n) {
            this.fACVersionCombo.setItem(i, fACVersions[i]);
            ++i;
        }
        this.initializeFolding();
        this.initializeACVersion();
        this.initializeAMVersion();
    }

    void initializeFolding() {
        boolean enabled = this.getOverlayStore().getBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(enabled);
    }

    void initializeACVersion() {
        String version = this.getOverlayStore().getString("autoconf_version");
        String[] items = this.fACVersionCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(version)) break;
            ++i;
        }
        if (i >= items.length) {
            i = items.length - 1;
        }
        this.fACVersionCombo.select(i);
    }

    void initializeAMVersion() {
        String version = this.getOverlayStore().getString("automake_version");
        String[] items = this.fAMVersionCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(version)) break;
            ++i;
        }
        if (i >= items.length) {
            i = items.length - 1;
        }
        this.fAMVersionCombo.select(i);
    }

    void initializeDefaultFolding() {
        boolean enabled = this.getOverlayStore().getDefaultBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(enabled);
    }

    @Override
    protected void handleDefaults() {
        this.handleSyntaxColorListSelection();
        this.initializeDefaultFolding();
    }

    private Control createSyntaxPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Label label = new Label(colorComposite, 16384);
        label.setText(AutotoolsPreferencesMessages.getString("AutomakeEditorPreferencePage.Foreground"));
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer = new TableViewer(editorComposite, 68100);
        this.fHighlightingColorListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fHighlightingColorListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fHighlightingColorListViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fHighlightingColorListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText(AutotoolsPreferencesMessages.getString("AutomakeEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(AutotoolsPreferencesMessages.getString("AutomakeEditorPreferencePage.bold"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(AutotoolsPreferencesMessages.getString("AutomakeEditorPreferencePage.italic"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer.addSelectionChangedListener(event -> this.handleSyntaxColorListSelection());
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AutoconfEditorPreferencePage.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)AutoconfEditorPreferencePage.this.getOverlayStore(), (String)item.getColorKey(), (RGB)AutoconfEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AutoconfEditorPreferencePage.this.getHighlightingColorListItem();
                AutoconfEditorPreferencePage.this.getOverlayStore().setValue(item.getBoldKey(), AutoconfEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AutoconfEditorPreferencePage.this.getHighlightingColorListItem();
                AutoconfEditorPreferencePage.this.getOverlayStore().setValue(item.getItalicKey(), AutoconfEditorPreferencePage.this.fItalicCheckBox.getSelection());
            }
        });
        return colorComposite;
    }

    private Composite createFoldingTabContent(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        GridData gd = new GridData(80);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fFoldingCheckbox = new Button(composite, 32);
        this.fFoldingCheckbox.setText(AutotoolsPreferencesMessages.getString("AutomakeEditorPreferencePage.foldingenable"));
        gd = new GridData(34);
        this.fFoldingCheckbox.setLayoutData((Object)gd);
        this.fFoldingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = AutoconfEditorPreferencePage.this.fFoldingCheckbox.getSelection();
                AutoconfEditorPreferencePage.this.getOverlayStore().setValue("editor_folding_enabled", enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    private Composite createVersionTabContent(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        GridData gd = new GridData(80);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fACVersionCombo = new Combo(composite, 44);
        this.fACVersionCombo.setItems(fACVersions);
        this.fACVersionCombo.select(fACVersions.length - 1);
        gd = new GridData(34);
        this.fACVersionCombo.setLayoutData((Object)gd);
        this.fACVersionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = AutoconfEditorPreferencePage.this.fACVersionCombo.getSelectionIndex();
                AutoconfEditorPreferencePage.this.getOverlayStore().setValue("autoconf_version", AutoconfEditorPreferencePage.this.fACVersionCombo.getItem(index));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(composite, 16384);
        label.setText(AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.autoconfVersion"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAMVersionCombo = new Combo(composite, 44);
        this.fAMVersionCombo.setItems(fAMVersions);
        this.fAMVersionCombo.select(fAMVersions.length - 1);
        gd = new GridData(34);
        this.fAMVersionCombo.setLayoutData((Object)gd);
        this.fAMVersionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = AutoconfEditorPreferencePage.this.fAMVersionCombo.getSelectionIndex();
                AutoconfEditorPreferencePage.this.getOverlayStore().setValue("automake_version", AutoconfEditorPreferencePage.this.fAMVersionCombo.getItem(index));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label2 = new Label(composite, 16384);
        label2.setText(AutotoolsPreferencesMessages.getString("AutoconfEditorPreferencePage.automakeVersion"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label2.setLayoutData((Object)gd);
        return composite;
    }

    void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getItalicKey()));
    }

    HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fHighlightingColorListViewer.getSelection();
        return (HighlightingColorListItem)selection.getFirstElement();
    }

    public static void initDefaults(IPreferenceStore prefs) {
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.autotools.ui.autoconf.editor.comment", (RGB)ColorManager.AUTOCONF_COMMENT_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.autotools.ui.autoconf.editor.default", (RGB)ColorManager.AUTOCONF_DEFAULT_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.autotools.ui.autoconf.editor.keyword", (RGB)ColorManager.AUTOCONF_KEYWORD_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.autotools.ui.autoconf.editor.var_ref", (RGB)ColorManager.AUTOCONF_VAR_REF_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.autotools.ui.autoconf.editor.var_set", (RGB)ColorManager.AUTOCONF_VAR_SET_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.autotools.ui.autoconf.editor.acmacro", (RGB)ColorManager.AUTOCONF_ACMACRO_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.autotools.ui.autoconf.editor.ammacro", (RGB)ColorManager.AUTOCONF_AMMACRO_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.autotools.ui.autoconf.editor.codeseq", (RGB)ColorManager.AUTOCONF_CODESEQ_RGB);
        prefs.setDefault("org.eclipse.cdt.autotools.ui.autoconf.editor.codeseq_italic", true);
    }

    private static class ColorListContentProvider
    implements IStructuredContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            return ((HighlightingColorListItem)element).getDisplayName();
        }

        public Color getForeground(Object element) {
            return ((HighlightingColorListItem)element).getItemColor();
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private Color fItemColor;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, Color itemColor) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fItemColor = itemColor;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public Color getItemColor() {
            return this.fItemColor;
        }
    }
}

