/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfigurationManager;
import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.internal.autotools.ui.AbstractAutotoolsCPropertyTab;
import org.eclipse.cdt.internal.autotools.ui.properties.AbstractConfigurePropertyOptionsPage;
import org.eclipse.cdt.internal.autotools.ui.properties.AutotoolsCategoryPropertyOptionPage;
import org.eclipse.cdt.internal.autotools.ui.properties.AutotoolsConfigurePrefStore;
import org.eclipse.cdt.internal.autotools.ui.properties.AutotoolsConfigurePropertyPage;
import org.eclipse.cdt.internal.autotools.ui.properties.AutotoolsToolPropertyOptionPage;
import org.eclipse.cdt.internal.autotools.ui.properties.ToolListContentProvider;
import org.eclipse.cdt.internal.autotools.ui.properties.ToolListElement;
import org.eclipse.cdt.internal.autotools.ui.properties.ToolListLabelProvider;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.ui.newui.AbstractPage;
import org.eclipse.cdt.ui.newui.PageLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class AutotoolsConfigurePropertyTab
extends AbstractAutotoolsCPropertyTab
implements IPreferencePageContainer {
    private TreeViewer fTree;
    private SashForm sashForm;
    private Composite settingsPageContainer;
    private AutotoolsConfigurePrefStore settingsStore;
    private AbstractConfigurePropertyOptionsPage currentSettingsPage;
    private ScrolledComposite containerSC;
    private ToolListContentProvider listprovider;
    private ToolListElement selectedElement;
    private ICConfigurationDescription icfgd;
    private Map<String, List<AbstractConfigurePropertyOptionsPage>> configToPageListMap;

    private IProject getProject() {
        return this.page.getProject();
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    public IAConfiguration getAutotoolsCfg() {
        AutotoolsConfigurePropertyPage ap = (AutotoolsConfigurePropertyPage)this.page;
        return ap.getConfiguration(this.icfgd);
    }

    private void syncClones() {
        AutotoolsConfigurePropertyPage ap = (AutotoolsConfigurePropertyPage)this.page;
        ap.getAllConfigurationData();
    }

    public IPreferenceStore getPreferenceStore() {
        return this.settingsStore;
    }

    public void createControls(Composite parent) {
        AutotoolsConfigurationManager.getInstance().clearTmpConfigurations(this.getProject());
        this.syncClones();
        super.createControls(parent);
        Composite composite = this.usercomp;
        this.settingsStore = AutotoolsConfigurePrefStore.getInstance();
        this.configToPageListMap = new HashMap<String, List<AbstractConfigurePropertyOptionsPage>>();
        GridData gd = new GridData(1872);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.sashForm = new SashForm(this.usercomp, 0);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout(2, true);
        layout.marginHeight = 5;
        this.sashForm.setLayout((Layout)layout);
        this.createSelectionArea((Composite)this.sashForm);
        this.createEditArea((Composite)this.sashForm);
    }

    protected void createSelectionArea(Composite parent) {
        this.fTree = new TreeViewer(parent, 2820);
        this.fTree.addSelectionChangedListener(event -> this.handleOptionSelection());
        this.fTree.getControl().setLayoutData((Object)new GridData(1808));
        IAConfiguration tmp = AutotoolsConfigurationManager.getInstance().createDefaultConfiguration(this.getProject(), "");
        this.fTree.setLabelProvider((IBaseLabelProvider)new ToolListLabelProvider(tmp));
    }

    protected void createEditArea(Composite parent) {
        this.containerSC = new ScrolledComposite(parent, 2816);
        this.containerSC.setExpandHorizontal(true);
        this.containerSC.setExpandVertical(true);
        this.settingsPageContainer = new Composite((Composite)this.containerSC, 0);
        this.settingsPageContainer.setLayout((Layout)new PageLayout());
        this.containerSC.setContent((Control)this.settingsPageContainer);
        this.settingsPageContainer.layout();
    }

    protected void setValues() {
        IConfiguration icfg = AutotoolsConfigurePropertyTab.getCfg((ICConfigurationDescription)this.icfgd.getConfiguration());
        if (icfg instanceof IMultiConfiguration) {
            this.fTree.setInput(null);
            this.fTree.getControl().setEnabled(false);
            this.currentSettingsPage.setVisible(false);
            return;
        }
        IAConfiguration currCfg = this.getAutotoolsCfg();
        if (this.listprovider == null) {
            this.listprovider = new ToolListContentProvider();
            this.fTree.setContentProvider((IContentProvider)this.listprovider);
        }
        this.fTree.setInput((Object)currCfg);
        this.fTree.getControl().setEnabled(true);
        ToolListElement[] newElements = (ToolListElement[])this.listprovider.getElements(currCfg);
        this.fTree.expandAll();
        this.selectedElement = newElements[0];
        this.fTree.setSelection((ISelection)new StructuredSelection((Object)this.selectedElement), true);
    }

    private void handleOptionSelection() {
        ScrollBar sb;
        if (this.fTree == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fTree.getSelection();
        ToolListElement element = (ToolListElement)selection.getFirstElement();
        if (element != null) {
            this.displayPageForElement(element);
        }
        if ((sb = this.containerSC.getHorizontalBar()) != null && sb.isVisible()) {
            this.settingsPageContainer.pack(true);
            this.containerSC.setMinSize(this.settingsPageContainer.getSize());
            ((AbstractPage)this.page).resize();
        }
    }

    private void displayPageForElement(ToolListElement element) {
        this.selectedElement = element;
        this.settingsStore.setSelection(this.getAutotoolsCfg(), this.selectedElement);
        AbstractConfigurePropertyOptionsPage oldPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List<AbstractConfigurePropertyOptionsPage> pages = this.getPagesForConfig();
        ListIterator<AbstractConfigurePropertyOptionsPage> iter = pages.listIterator();
        while (iter.hasNext()) {
            AbstractConfigurePropertyOptionsPage page = iter.next();
            if (!page.getName().equals(element.getName())) continue;
            this.currentSettingsPage = page;
            break;
        }
        if (this.currentSettingsPage == null) {
            this.currentSettingsPage = element.getType() == 5 ? new AutotoolsToolPropertyOptionPage(element, this.getAutotoolsCfg()) : new AutotoolsCategoryPropertyOptionPage(element, this.getAutotoolsCfg());
            pages.add(this.currentSettingsPage);
            this.currentSettingsPage.setContainer(this);
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        Control[] children = this.settingsPageContainer.getChildren();
        Control currentControl = this.currentSettingsPage.getControl();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        this.currentSettingsPage.setVisible(true);
        this.currentSettingsPage.updateFields();
        if (oldPage != null && oldPage != this.currentSettingsPage) {
            oldPage.setVisible(false);
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    private List<AbstractConfigurePropertyOptionsPage> getPagesForConfig() {
        if (this.getCfg() == null) {
            return null;
        }
        List<AbstractConfigurePropertyOptionsPage> pages = this.configToPageListMap.get(this.getCfg().getName());
        if (pages == null) {
            pages = new ArrayList<AbstractConfigurePropertyOptionsPage>();
            this.configToPageListMap.put(this.getCfg().getName(), pages);
        }
        return pages;
    }

    public boolean isDirty() {
        List<AbstractConfigurePropertyOptionsPage> pages = this.getPagesForConfig();
        if (pages == null) {
            return false;
        }
        ListIterator<AbstractConfigurePropertyOptionsPage> iter = pages.listIterator();
        while (iter.hasNext()) {
            AbstractConfigurePropertyOptionsPage page = iter.next();
            if (page == null || !page.isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void performOK() {
        ICConfigurationDescription[] cfgs = this.page.getCfgsEditable();
        AutotoolsConfigurePropertyPage ap = (AutotoolsConfigurePropertyPage)this.page;
        HashMap<String, IAConfiguration> cfgList = new HashMap<String, IAConfiguration>();
        int i = 0;
        while (i < cfgs.length) {
            ICConfigurationDescription cd = cfgs[i];
            IAConfiguration acfg = ap.getConfiguration(cd);
            cfgList.put(cd.getId(), acfg);
            ++i;
        }
        IProject project = this.getProject();
        AutotoolsConfigurationManager.getInstance().replaceProjectConfigurations(project, cfgList, cfgs);
        AutotoolsConfigurationManager.getInstance().clearTmpConfigurations(project);
    }

    protected void performCancel() {
        AutotoolsConfigurationManager.getInstance().clearTmpConfigurations(this.getProject());
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        IProject project = this.getProject();
        ICConfigurationDescription[] cfgs = this.page.getCfgsEditable();
        AutotoolsConfigurationManager.getInstance().applyConfigs(project.getName(), cfgs);
    }

    protected void performDefaults() {
        IAConfiguration cfg = this.getAutotoolsCfg();
        cfg.setDefaultOptions();
        this.setValues();
    }

    protected void updateData(ICResourceDescription rd) {
        if (rd == null) {
            return;
        }
        this.icfgd = rd.getConfiguration();
        this.setValues();
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }
}

