/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.build.CToolChain;
import org.eclipse.cdt.core.build.IToolChainFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CToolChainManager {
    private static final String TOOLCHAINS = "toolchains";
    public static final CToolChainManager instance = new CToolChainManager();
    private Map<String, IConfigurationElement> toolChainFamilies = new HashMap<String, IConfigurationElement>();
    private Map<String, CToolChain> toolChains = new HashMap<String, CToolChain>();

    private CToolChainManager() {
        new Job("Load toolchains"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IExtensionRegistry registry = Platform.getExtensionRegistry();
                    IExtensionPoint point = registry.getExtensionPoint("org.eclipse.cdt.core.ToolChainFactory");
                    IExtension[] iExtensionArray = point.getExtensions();
                    int n = iExtensionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                        int n3 = iConfigurationElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            String family = element.getAttribute("family");
                            if (family != null) {
                                CToolChainManager.this.toolChainFamilies.put(family, element);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    Preferences toolChainsPref = CToolChainManager.this.getToolChainSettings();
                    String[] stringArray = toolChainsPref.childrenNames();
                    int n5 = stringArray.length;
                    n = 0;
                    while (n < n5) {
                        IConfigurationElement element;
                        String toolChainId = stringArray[n];
                        Preferences toolChainPref = toolChainsPref.node(toolChainId);
                        String family = toolChainPref.get("family", "");
                        if (!family.isEmpty() && (element = (IConfigurationElement)CToolChainManager.this.toolChainFamilies.get(family)) != null) {
                            IToolChainFactory factory = (IToolChainFactory)element.createExecutableExtension("class");
                            CToolChain toolChain = factory.createToolChain(toolChainId, toolChainPref);
                            CToolChainManager.this.toolChains.put(toolChain.getName(), toolChain);
                        }
                        ++n;
                    }
                    return Status.OK_STATUS;
                }
                catch (BackingStoreException e) {
                    return new Status(4, "org.eclipse.cdt.core", "loading toolchains", (Throwable)e);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        }.schedule();
    }

    private Preferences getToolChainSettings() {
        return ConfigurationScope.INSTANCE.getNode("org.eclipse.cdt.core").node(TOOLCHAINS);
    }

    Preferences getSettings(String id) {
        return this.getToolChainSettings().node(id);
    }

    public Collection<CToolChain> getToolChains() {
        return this.toolChains.values();
    }

    public void addToolChain(CToolChain toolChain) throws CoreException {
        String id = null;
        int i = 0;
        while (i < this.toolChains.size()) {
            String istr = String.valueOf(i);
            if (this.toolChains.containsKey(istr)) {
                id = istr;
                break;
            }
            ++i;
        }
        if (id == null) {
            id = String.valueOf(this.toolChains.size());
        }
        toolChain.setId(id);
        this.toolChains.put(id, toolChain);
        try {
            Preferences toolChainsPref = this.getToolChainSettings();
            toolChain.save(toolChainsPref.node(id));
            toolChainsPref.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "saving toolchain " + id, (Throwable)e));
        }
    }
}

