/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;

public class CPPASTCatchHandler
extends ASTAttributeOwner
implements ICPPASTCatchHandler,
IASTAmbiguityParent {
    private boolean fIsCatchAll;
    private IASTStatement fBody;
    private IASTDeclaration fDeclaration;
    private IScope fScope;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTCatchHandler() {
    }

    public CPPASTCatchHandler(IASTDeclaration declaration, IASTStatement body) {
        this.setCatchBody(body);
        this.setDeclaration(declaration);
    }

    @Override
    public CPPASTCatchHandler copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCatchHandler copy(IASTNode.CopyStyle style) {
        CPPASTCatchHandler copy = new CPPASTCatchHandler();
        copy.setDeclaration(this.fDeclaration == null ? null : this.fDeclaration.copy(style));
        copy.setCatchBody(this.fBody == null ? null : this.fBody.copy(style));
        copy.setIsCatchAll(this.fIsCatchAll);
        return this.copy(copy, style);
    }

    @Override
    public void setIsCatchAll(boolean isEllipsis) {
        this.assertNotFrozen();
        this.fIsCatchAll = isEllipsis;
    }

    @Override
    public boolean isCatchAll() {
        return this.fIsCatchAll;
    }

    @Override
    public void setCatchBody(IASTStatement compoundStatement) {
        this.assertNotFrozen();
        this.fBody = compoundStatement;
        if (compoundStatement != null) {
            compoundStatement.setParent(this);
            compoundStatement.setPropertyInParent(CATCH_BODY);
        }
    }

    @Override
    public IASTStatement getCatchBody() {
        return this.fBody;
    }

    @Override
    public void setDeclaration(IASTDeclaration decl) {
        this.assertNotFrozen();
        this.fDeclaration = decl;
        if (decl != null) {
            decl.setParent(this);
            decl.setPropertyInParent(DECLARATION);
        }
    }

    @Override
    public IASTDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getLocalVariablesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.fDeclaration != null && !this.fDeclaration.accept(action)) {
            return false;
        }
        if (this.fBody != null && !this.fBody.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTCatchHandler.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.fBody == child) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fBody = (IASTStatement)other;
        }
        if (this.fDeclaration == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.fDeclaration = (IASTDeclaration)other;
        }
    }

    @Override
    public IScope getScope() {
        if (this.fScope == null) {
            this.fScope = new CPPBlockScope(this);
        }
        return this.fScope;
    }
}

