/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannelState {
    private static final Logger LOG = Log.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = Long.getLong("org.eclipse.jetty.server.HttpChannelState.DEFAULT_TIMEOUT", 30000L);
    private final boolean DEBUG = LOG.isDebugEnabled();
    private final Locker _locker = new Locker();
    private final HttpChannel _channel;
    private List<AsyncListener> _asyncListeners;
    private State _state;
    private Async _async;
    private boolean _initial;
    private boolean _asyncReadPossible;
    private boolean _asyncReadUnready;
    private boolean _asyncWrite;
    private long _timeoutMs = DEFAULT_TIMEOUT;
    private AsyncContextEvent _event;

    protected HttpChannelState(HttpChannel channel) {
        this._channel = channel;
        this._state = State.IDLE;
        this._async = null;
        this._initial = true;
    }

    public State getState() {
        try (Locker.Lock lock = this._locker.lock();){
            State state = this._state;
            return state;
        }
    }

    public void addListener(AsyncListener listener) {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    public void setTimeout(long ms) {
        try (Locker.Lock lock = this._locker.lock();){
            this._timeoutMs = ms;
        }
    }

    public long getTimeout() {
        try (Locker.Lock lock = this._locker.lock();){
            long l = this._timeoutMs;
            return l;
        }
    }

    public AsyncContextEvent getAsyncContextEvent() {
        try (Locker.Lock lock = this._locker.lock();){
            AsyncContextEvent asyncContextEvent = this._event;
            return asyncContextEvent;
        }
    }

    public String toString() {
        try (Locker.Lock lock = this._locker.lock();){
            Object[] objectArray = new Object[7];
            objectArray[0] = this.getClass().getSimpleName();
            objectArray[1] = this.hashCode();
            objectArray[2] = this._state;
            objectArray[3] = this._async;
            objectArray[4] = this._initial;
            objectArray[5] = this._asyncReadPossible ? (this._asyncReadUnready ? "PU" : "P!U") : (this._asyncReadUnready ? "!PU" : "!P!U");
            objectArray[6] = this._asyncWrite;
            String string = String.format("%s@%x{s=%s a=%s i=%b r=%s w=%b}", objectArray);
            return string;
        }
    }

    private String getStatusStringLocked() {
        return String.format("s=%s i=%b a=%s", new Object[]{this._state, this._initial, this._async});
    }

    public String getStatusString() {
        try (Locker.Lock lock = this._locker.lock();){
            String string = this.getStatusStringLocked();
            return string;
        }
    }

    protected Action handling() {
        if (this.DEBUG) {
            LOG.debug("{} handling {}", new Object[]{this, this._state});
        }
        Throwable throwable = null;
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case IDLE: {
                    this._initial = true;
                    this._state = State.DISPATCHED;
                    Action action = Action.DISPATCH;
                    return action;
                }
                case COMPLETING: {
                    Action action = Action.COMPLETE;
                    return action;
                }
                case COMPLETED: {
                    Action action = Action.TERMINATED;
                    return action;
                }
                case ASYNC_WOKEN: {
                    if (this._asyncReadPossible) {
                        this._state = State.ASYNC_IO;
                        this._asyncReadUnready = false;
                        Action action = Action.READ_CALLBACK;
                        return action;
                    }
                    if (this._asyncWrite) {
                        this._state = State.ASYNC_IO;
                        this._asyncWrite = false;
                        Action action = Action.WRITE_CALLBACK;
                        return action;
                    }
                    if (this._async != null) {
                        Async async = this._async;
                        switch (async) {
                            case COMPLETE: {
                                this._state = State.COMPLETING;
                                Action action = Action.COMPLETE;
                                return action;
                            }
                            case DISPATCH: {
                                this._state = State.DISPATCHED;
                                this._async = null;
                                Action action = Action.ASYNC_DISPATCH;
                                return action;
                            }
                            case EXPIRING: {
                                break;
                            }
                            case EXPIRED: {
                                this._state = State.DISPATCHED;
                                this._async = null;
                                Action action = Action.ERROR_DISPATCH;
                                return action;
                            }
                            case STARTED: {
                                Action action = Action.WAIT;
                                return action;
                            }
                            case ERRORING: {
                                this._state = State.DISPATCHED;
                                Action action = Action.ASYNC_ERROR;
                                return action;
                            }
                            default: {
                                throw new IllegalStateException(this.getStatusStringLocked());
                            }
                        }
                    }
                    Action action = Action.WAIT;
                    return action;
                }
            }
            try {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void startAsync(final AsyncContextEvent event) {
        List<AsyncListener> lastAsyncListeners;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._state != State.DISPATCHED || this._async != null) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            this._async = Async.STARTED;
            this._event = event;
            lastAsyncListeners = this._asyncListeners;
            this._asyncListeners = null;
        }
        if (lastAsyncListeners != null) {
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    for (AsyncListener listener : lastAsyncListeners) {
                        try {
                            listener.onStartAsync((AsyncEvent)event);
                        }
                        catch (Exception e) {
                            LOG.warn((Throwable)e);
                        }
                    }
                }

                public String toString() {
                    return "startAsync";
                }
            };
            this.runInContext(event, callback);
        }
    }

    protected void error(Throwable th) {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._event != null) {
                this._event.addThrowable(th);
            }
            this._async = Async.ERRORING;
        }
    }

    protected Action unhandle() {
        Action action;
        AsyncContextEvent schedule_event = null;
        boolean read_interested = false;
        if (this.DEBUG) {
            LOG.debug("{} unhandle {}", new Object[]{this, this._state});
        }
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case COMPLETING: 
                case COMPLETED: {
                    Action action2 = Action.TERMINATED;
                    return action2;
                }
                case ASYNC_IO: 
                case DISPATCHED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            if (this._async != null) {
                this._initial = false;
                switch (this._async) {
                    case COMPLETE: {
                        this._state = State.COMPLETING;
                        this._async = null;
                        action = Action.COMPLETE;
                        break;
                    }
                    case DISPATCH: {
                        this._state = State.DISPATCHED;
                        this._async = null;
                        action = Action.ASYNC_DISPATCH;
                        break;
                    }
                    case EXPIRED: {
                        this._state = State.DISPATCHED;
                        this._async = null;
                        action = Action.ERROR_DISPATCH;
                        break;
                    }
                    case STARTED: {
                        if (this._asyncReadUnready && this._asyncReadPossible) {
                            this._state = State.ASYNC_IO;
                            this._asyncReadUnready = false;
                            action = Action.READ_CALLBACK;
                            break;
                        }
                        if (this._asyncWrite) {
                            this._asyncWrite = false;
                            this._state = State.ASYNC_IO;
                            action = Action.WRITE_CALLBACK;
                            break;
                        }
                        schedule_event = this._event;
                        read_interested = this._asyncReadUnready;
                        this._state = State.ASYNC_WAIT;
                        action = Action.WAIT;
                        break;
                    }
                    case EXPIRING: {
                        schedule_event = this._event;
                        this._state = State.ASYNC_WAIT;
                        action = Action.WAIT;
                        break;
                    }
                    case ERRORING: {
                        this._state = State.DISPATCHED;
                        action = Action.ASYNC_ERROR;
                        break;
                    }
                    case ERRORED: {
                        this._state = State.DISPATCHED;
                        action = Action.ERROR_DISPATCH;
                        this._async = null;
                        break;
                    }
                    default: {
                        this._state = State.COMPLETING;
                        action = Action.COMPLETE;
                        break;
                    }
                }
            } else {
                this._state = State.COMPLETING;
                action = Action.COMPLETE;
            }
        }
        if (schedule_event != null) {
            this.scheduleTimeout(schedule_event);
        }
        if (read_interested) {
            this._channel.asyncReadFillInterested();
        }
        return action;
    }

    /*
     * Unable to fully structure code
     */
    public void dispatch(ServletContext context, String path) {
        block23: {
            dispatch = false;
            event = null;
            lock = this._locker.lock();
            var6_6 = null;
            try {
                started = false;
                event = this._event;
                switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$Async[this._async.ordinal()]) {
                    case 5: {
                        started = true;
                        break;
                    }
                    case 3: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                }
                this._async = Async.DISPATCH;
                if (context != null) {
                    this._event.setDispatchContext(context);
                }
                if (path != null) {
                    this._event.setDispatchPath(path);
                }
                if (!started) break block23;
                switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                    case 4: 
                    case 5: 
                    case 7: {
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        this._state = State.ASYNC_WOKEN;
                        dispatch = true;
                        ** break;
lbl30:
                        // 1 sources

                        break;
                    }
                    default: {
                        HttpChannelState.LOG.warn("async dispatched when complete {}", new Object[]{this});
                        break;
                    }
                }
            }
            catch (Throwable var7_9) {
                var6_6 = var7_9;
                throw var7_9;
            }
            finally {
                if (lock != null) {
                    if (var6_6 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable var7_8) {
                            var6_6.addSuppressed(var7_8);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
        }
        this.cancelTimeout(event);
        if (dispatch) {
            this.scheduleDispatch();
        }
    }

    protected void onTimeout() {
        List<AsyncListener> listeners;
        AsyncContextEvent event;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._async != Async.STARTED) {
                return;
            }
            this._async = Async.EXPIRING;
            event = this._event;
            listeners = this._asyncListeners;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Async timeout {}", new Object[]{this});
        }
        if (listeners != null) {
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    for (AsyncListener listener : listeners) {
                        try {
                            listener.onTimeout((AsyncEvent)event);
                        }
                        catch (Exception e) {
                            LOG.debug((Throwable)e);
                            event.addThrowable(e);
                            HttpChannelState.this._channel.getRequest().setAttribute("javax.servlet.error.exception", event.getThrowable());
                            break;
                        }
                    }
                }

                public String toString() {
                    return "onTimeout";
                }
            };
            this.runInContext(event, callback);
        }
        boolean dispatch = false;
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._async) {
                case EXPIRING: {
                    if (event.getThrowable() == null) {
                        this._async = Async.EXPIRED;
                        this._event.addThrowable(new TimeoutException("Async API violation"));
                        break;
                    }
                    this._async = Async.ERRORING;
                    break;
                }
                case COMPLETE: 
                case DISPATCH: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this._state == State.ASYNC_WAIT) {
                this._state = State.ASYNC_WOKEN;
                dispatch = true;
            }
        }
        if (dispatch) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatch after async timeout {}", new Object[]{this});
            }
            this.scheduleDispatch();
        }
    }

    public void complete() {
        boolean handle = false;
        AsyncContextEvent event = null;
        try (Locker.Lock lock = this._locker.lock();){
            boolean started = false;
            event = this._event;
            switch (this._async) {
                case STARTED: {
                    started = true;
                    break;
                }
                case EXPIRING: 
                case ERRORED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._async = Async.COMPLETE;
            if (started && this._state == State.ASYNC_WAIT) {
                handle = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        this.cancelTimeout(event);
        if (handle) {
            this.runInContext(event, this._channel);
        }
    }

    public void errorComplete() {
        try (Locker.Lock lock = this._locker.lock();){
            this._async = Async.COMPLETE;
            this._event.setDispatchContext(null);
            this._event.setDispatchPath(null);
        }
        this.cancelTimeout();
    }

    protected void onError() {
        AsyncContextEvent event;
        List<AsyncListener> aListeners;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._state != State.DISPATCHED) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            aListeners = this._asyncListeners;
            event = this._event;
            this._async = Async.ERRORED;
        }
        if (event != null && aListeners != null) {
            event.getSuppliedRequest().setAttribute("javax.servlet.error.exception", (Object)event.getThrowable());
            event.getSuppliedRequest().setAttribute("javax.servlet.error.message", (Object)event.getThrowable().getMessage());
            for (AsyncListener listener : aListeners) {
                try {
                    listener.onError((AsyncEvent)event);
                }
                catch (Exception x) {
                    LOG.info("Exception while invoking listener " + listener, (Throwable)x);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onComplete() {
        lock = this._locker.lock();
        var4_2 = null;
        try {
            switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                case 2: {
                    aListeners = this._asyncListeners;
                    event = this._event;
                    this._state = State.COMPLETED;
                    this._async = null;
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
        }
        catch (Throwable var5_6) {
            var4_2 = var5_6;
            throw var5_6;
        }
        finally {
            if (lock != null) {
                if (var4_2 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable var5_5) {
                        var4_2.addSuppressed(var5_5);
                    }
                } else {
                    lock.close();
                }
            }
        }
        if (event != null) {
            if (aListeners != null) {
                callback = new Runnable(){

                    @Override
                    public void run() {
                        for (AsyncListener listener : aListeners) {
                            try {
                                listener.onComplete((AsyncEvent)event);
                            }
                            catch (Exception e) {
                                LOG.warn((Throwable)e);
                            }
                        }
                    }

                    public String toString() {
                        return "onComplete";
                    }
                };
                this.runInContext(event, callback);
            }
            event.completed();
        }
    }

    protected void recycle() {
        this.cancelTimeout();
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case ASYNC_IO: 
                case DISPATCHED: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                case UPGRADED: {
                    return;
                }
            }
            this._asyncListeners = null;
            this._state = State.IDLE;
            this._async = null;
            this._initial = true;
            this._asyncReadUnready = false;
            this._asyncReadPossible = false;
            this._asyncWrite = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    public void upgrade() {
        this.cancelTimeout();
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case IDLE: 
                case COMPLETED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._asyncListeners = null;
            this._state = State.UPGRADED;
            this._async = null;
            this._initial = true;
            this._asyncReadUnready = false;
            this._asyncReadPossible = false;
            this._asyncWrite = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    protected void scheduleTimeout(AsyncContextEvent event) {
        Scheduler scheduler = this._channel.getScheduler();
        if (scheduler != null && this._timeoutMs > 0L) {
            event.setTimeoutTask(scheduler.schedule((Runnable)event, this._timeoutMs, TimeUnit.MILLISECONDS));
        }
    }

    protected void cancelTimeout() {
        AsyncContextEvent event;
        try (Locker.Lock lock = this._locker.lock();){
            event = this._event;
        }
        this.cancelTimeout(event);
    }

    protected void cancelTimeout(AsyncContextEvent event) {
        if (event != null) {
            event.cancelTimeoutTask();
        }
    }

    public boolean isIdle() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public boolean isExpired() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._async == Async.EXPIRED;
            return bl;
        }
    }

    public boolean isInitial() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._initial;
            return bl;
        }
    }

    public boolean isSuspended() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.ASYNC_WAIT || this._state == State.DISPATCHED && this._async == Async.STARTED;
            return bl;
        }
    }

    boolean isCompleting() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.COMPLETING;
            return bl;
        }
    }

    boolean isCompleted() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.COMPLETED;
            return bl;
        }
    }

    public boolean isAsyncStarted() {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._state == State.DISPATCHED) {
                boolean bl = this._async != null;
                return bl;
            }
            boolean bl = this._async == Async.STARTED || this._async == Async.EXPIRING;
            return bl;
        }
    }

    public boolean isAsync() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = !this._initial || this._async != null;
            return bl;
        }
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public ContextHandler getContextHandler() {
        AsyncContextEvent event;
        try (Locker.Lock lock = this._locker.lock();){
            event = this._event;
        }
        return this.getContextHandler(event);
    }

    ContextHandler getContextHandler(AsyncContextEvent event) {
        ContextHandler.Context context;
        if (event != null && (context = (ContextHandler.Context)event.getServletContext()) != null) {
            return context.getContextHandler();
        }
        return null;
    }

    public ServletResponse getServletResponse() {
        AsyncContextEvent event;
        try (Locker.Lock lock = this._locker.lock();){
            event = this._event;
        }
        return this.getServletResponse(event);
    }

    public ServletResponse getServletResponse(AsyncContextEvent event) {
        if (event != null && event.getSuppliedResponse() != null) {
            return event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    void runInContext(AsyncContextEvent event, Runnable runnable) {
        ContextHandler contextHandler = this.getContextHandler(event);
        if (contextHandler == null) {
            runnable.run();
        } else {
            contextHandler.handle(this._channel.getRequest(), runnable);
        }
    }

    public Object getAttribute(String name) {
        return this._channel.getRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._channel.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._channel.getRequest().setAttribute(name, attribute);
    }

    public void onReadUnready() {
        boolean interested = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (!this._asyncReadUnready) {
                this._asyncReadUnready = true;
                this._asyncReadPossible = false;
                if (this._state == State.ASYNC_WAIT) {
                    interested = true;
                }
            }
        }
        if (interested) {
            this._channel.asyncReadFillInterested();
        }
    }

    public boolean onReadPossible() {
        boolean woken = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._asyncReadPossible = true;
            if (this._state == State.ASYNC_WAIT && this._asyncReadUnready) {
                woken = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        return woken;
    }

    public boolean onReadReady() {
        boolean woken = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._asyncReadUnready = true;
            this._asyncReadPossible = true;
            if (this._state == State.ASYNC_WAIT) {
                woken = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        return woken;
    }

    public boolean isReadPossible() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._asyncReadPossible;
            return bl;
        }
    }

    public boolean onWritePossible() {
        boolean handle = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._asyncWrite = true;
            if (this._state == State.ASYNC_WAIT) {
                this._state = State.ASYNC_WOKEN;
                handle = true;
            }
        }
        return handle;
    }

    public static enum Async {
        STARTED,
        DISPATCH,
        COMPLETE,
        EXPIRING,
        EXPIRED,
        ERRORING,
        ERRORED;

    }

    public static enum Action {
        DISPATCH,
        ASYNC_DISPATCH,
        ERROR_DISPATCH,
        ASYNC_ERROR,
        WRITE_CALLBACK,
        READ_CALLBACK,
        COMPLETE,
        TERMINATED,
        WAIT;

    }

    public static enum State {
        IDLE,
        DISPATCHED,
        ASYNC_WAIT,
        ASYNC_WOKEN,
        ASYNC_IO,
        COMPLETING,
        COMPLETED,
        UPGRADED;

    }
}

