/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openacc.internal.fortran.analysis;

import java.util.regex.Pattern;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTNameNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.SourceInfo;

public class OpenACCFortranASTVisitor
extends GenericASTVisitor {
    private static final String PREFIX = "ACC_";
    private static final Pattern END_DIRECTIVE = Pattern.compile("^end", 2);
    private static final boolean shouldIgnoreEndDirectives = false;
    private static final boolean traceOn = false;
    private final ScanReturn scanReturn;
    private final String fileName;

    public OpenACCFortranASTVisitor(String fileName, ScanReturn scanReturn) {
        this.scanReturn = scanReturn;
        this.fileName = fileName;
    }

    public void visitToken(Token node) {
        for (Token accDirective : node.getOpenACCComments()) {
            if (this.shouldIgnore(accDirective)) continue;
            this.addArtifact(accDirective, 3);
        }
    }

    private boolean shouldIgnore(Token accDirective) {
        return false;
    }

    private boolean isOpenACCEndDirective(Token ompDirective) {
        return END_DIRECTIVE.matcher(ompDirective.getText()).find();
    }

    public void visitASTCallStmtNode(ASTCallStmtNode node) {
        Token subroutineName = node.getSubroutineName();
        this.addArtifact(subroutineName, 1);
    }

    public void visitASTVarOrFnRefNode(ASTVarOrFnRefNode node) {
        ASTNameNode nameNode = node.getName();
        if (nameNode != null) {
            Token varName = nameNode.getName();
            this.addArtifact(varName, 2);
        }
    }

    private void addArtifact(Token subroutineName, int artifactType) {
        String callname = subroutineName.getText().toUpperCase();
        if (artifactType == 3 || callname.startsWith(PREFIX)) {
            int start = subroutineName.getFileOffset();
            int end = subroutineName.getFileOffset() + subroutineName.getLength();
            SourceInfo si = new SourceInfo(subroutineName.getLine(), start, end, artifactType);
            this.scanReturn.addArtifact(new Artifact(this.fileName, subroutineName.getLine(), 1, callname, si));
        }
    }
}

