/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.autotools.core.AutotoolsNewProjectNature;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.ui.wizards.CProjectPlatformPage;
import org.eclipse.cdt.internal.autotools.ui.wizards.NewAutotoolsProjectOptionPage;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.ui.wizards.NewCCProjectWizard;
import org.eclipse.cdt.ui.wizards.NewCProjectWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class AutotoolsNewCCProjectWizardV2
extends NewCCProjectWizard {
    protected static final String PREFIX = "WizardAutotoolsNewCCProjectV2";
    protected static final String OP_ERROR = "WizardAutotoolsNewCCProjectV2.op_error";
    protected static final String WZ_TITLE = "WizardAutotoolsNewCCProjectV2.title";
    protected static final String WZ_DESC = "WizardAutotoolsNewCCProjectV2.description";
    protected static final String WINDOW_TITLE = "WizardAutotoolsNewCCProjectV2.windowTitle";
    protected static final String CONF_TITLE = "WizardAutotoolsNewCCProjectV2.config.title";
    protected static final String CONF_DESC = "WizardAutotoolsNewCCProjectV2.config.desc";
    protected static final String OPTIONS_TITLE = "WizardAutotoolsNewCCProjectV2.options.title";
    protected static final String OPTIONS_DESC = "WizardAutotoolsNewCCProjectV2.options.desc";
    protected static final String MSG_ADD_NATURE = "WizardAutotoolsNewCCProjectV2.message.add_nature";
    protected static final String MSG_ADD_BUILDER = "WizardAutotoolsNewCCProjectV2.message.add_builder";
    protected static final String MSG_SAVE = "WizardAutotoolsNewCCProjectV2.message.save";
    protected CProjectPlatformPage projectConfigurationPage;
    protected NewAutotoolsProjectOptionPage optionPage;
    protected IProjectType projectType;

    public AutotoolsNewCCProjectWizardV2() {
        this(AutotoolsUIPlugin.getResourceString(WZ_TITLE), AutotoolsUIPlugin.getResourceString(WZ_DESC));
    }

    public AutotoolsNewCCProjectWizardV2(String title, String description) {
        super(title, description);
    }

    protected static String getWzDescriptionResource() {
        return AutotoolsUIPlugin.getResourceString(WZ_DESC);
    }

    protected static String getWzTitleResource() {
        return AutotoolsUIPlugin.getResourceString(WZ_TITLE);
    }

    protected static String getWindowTitleResource() {
        return AutotoolsUIPlugin.getResourceString(WINDOW_TITLE);
    }

    protected static String getPrefix() {
        return PREFIX;
    }

    public void addPages() {
        super.addPages();
        this.projectConfigurationPage = new CProjectPlatformPage(PREFIX);
        this.projectConfigurationPage.setTitle(AutotoolsUIPlugin.getResourceString(CONF_TITLE));
        this.projectConfigurationPage.setDescription(AutotoolsUIPlugin.getResourceString(CONF_DESC));
        this.addPage((IWizardPage)this.projectConfigurationPage);
        this.optionPage = new NewAutotoolsProjectOptionPage(PREFIX);
        this.optionPage.setTitle(AutotoolsUIPlugin.getResourceString(OPTIONS_TITLE));
        this.optionPage.setDescription(AutotoolsUIPlugin.getResourceString(OPTIONS_DESC));
        this.addPage((IWizardPage)this.optionPage);
        MBSCustomPageManager.init();
        MBSCustomPageManager.addStockPage((IWizardPage)this.fMainPage, (String)"org.eclipse.cdt.ui.wizard.basicPage");
        MBSCustomPageManager.addStockPage((IWizardPage)this.projectConfigurationPage, (String)"org.eclipse.cdt.managedbuilder.ui.wizard.platformPage");
        MBSCustomPageManager.addStockPage((IWizardPage)this.optionPage, (String)"org.eclipse.cdt.managedbuilder.ui.wizard.projectOptionsPage");
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        IWizardPage[] pages = this.getPages();
        if (pages != null) {
            int i = 0;
            while (i < pages.length) {
                IWizardPage page = pages[i];
                if (page instanceof NewCProjectWizardPage) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageContainer, "org.eclipse.cdt.ui.new_proj_wiz_m_name");
                } else if (page instanceof NewAutotoolsProjectOptionPage) {
                    NewAutotoolsProjectOptionPage optionPage = (NewAutotoolsProjectOptionPage)page;
                    optionPage.setupHelpContextIds();
                }
                ++i;
            }
        }
    }

    public void updateProjectTypeProperties() {
        this.optionPage.updateProjectTypeProperties();
    }

    protected void addNature(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 4);
        monitor.subTask(AutotoolsUIPlugin.getResourceString(MSG_ADD_NATURE));
        ManagedCProjectNature.addManagedNature((IProject)this.newProject, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        monitor.subTask(AutotoolsUIPlugin.getResourceString(MSG_ADD_BUILDER));
        ManagedCProjectNature.addManagedBuilder((IProject)this.newProject, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        monitor.subTask(AutotoolsUIPlugin.getResourceString(MSG_ADD_NATURE));
        AutotoolsNewProjectNature.addAutotoolsNature((IProject)this.newProject, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        monitor.subTask(AutotoolsUIPlugin.getResourceString(MSG_ADD_BUILDER));
        AutotoolsNewProjectNature.addAutotoolsBuilder((IProject)this.newProject, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        monitor.done();
    }

    public IProjectType getProjectType() {
        return this.projectConfigurationPage.getProjectType();
    }

    protected void doRun(IProgressMonitor monitor) throws CoreException {
        IStatus initResult;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        super.doRun((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)5));
        try {
            this.addNature((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)2));
        }
        catch (CoreException e) {
            AutotoolsUIPlugin.log(e);
        }
        this.newProject.setPersistentProperty(AutotoolsPropertyConstants.SCANNER_USE_MAKE_W, "true");
        CCorePlugin.getDefault().mapCProjectOwner(this.newProject, this.getProjectID(), true);
        IManagedProject newManagedProject = null;
        ManagedBuildInfo info = null;
        try {
            info = ManagedBuildManager.createBuildInfo((IResource)this.newProject);
            IProjectType parent = this.getProjectType();
            newManagedProject = ManagedBuildManager.createManagedProject((IResource)this.newProject, (IProjectType)parent);
            if (newManagedProject != null) {
                IConfiguration[] selectedConfigs = this.getSelectedConfigurations();
                int i = 0;
                while (i < selectedConfigs.length) {
                    IConfiguration config = selectedConfigs[i];
                    int id = ManagedBuildManager.getRandomNumber();
                    IConfiguration newConfig = newManagedProject.createConfiguration(config, String.valueOf(config.getId()) + "." + id);
                    newConfig.setArtifactName(newManagedProject.getDefaultArtifactName());
                    ++i;
                }
                IConfiguration defaultCfg = null;
                IConfiguration[] newConfigs = newManagedProject.getConfigurations();
                int i2 = 0;
                while (i2 < newConfigs.length) {
                    if (newConfigs[i2].isSupported()) {
                        defaultCfg = newConfigs[i2];
                        break;
                    }
                    ++i2;
                }
                if (defaultCfg == null && newConfigs.length > 0) {
                    defaultCfg = newConfigs[0];
                }
                if (defaultCfg != null) {
                    ManagedBuildManager.setDefaultConfiguration((IProject)this.newProject, defaultCfg);
                    ManagedBuildManager.setSelectedConfiguration((IProject)this.newProject, (IConfiguration)defaultCfg);
                }
                ManagedBuildManager.setNewProjectVersion((IProject)this.newProject);
                ICDescriptor desc = null;
                try {
                    desc = CCorePlugin.getDefault().getCProjectDescription(this.newProject, true);
                    desc.create("org.eclipse.cdt.core.ScannerInfoProvider", "org.eclipse.cdt.managedbuilder.core.ManagedBuildManager");
                }
                catch (CoreException e) {
                    AutotoolsUIPlugin.log(e);
                }
            }
        }
        catch (BuildException e) {
            AutotoolsUIPlugin.log(e);
        }
        if (this.newProject != null) {
            this.optionPage.performApply((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)2));
        }
        monitor.subTask(AutotoolsUIPlugin.getResourceString(MSG_SAVE));
        if (info != null) {
            info.setValid(true);
            ManagedBuildManager.saveBuildInfo((IProject)this.newProject, (boolean)true);
        }
        if ((initResult = ManagedBuildManager.initBuildInfoContainer((IResource)this.newProject)).getCode() != 0) {
            AutotoolsUIPlugin.log(initResult);
        }
        monitor.done();
    }

    protected void doRunPrologue(IProgressMonitor monitor) {
    }

    protected void doRunEpilogue(IProgressMonitor monitor) {
        IRunnableWithProgress[] operations;
        if (this.newProject == null) {
            return;
        }
        IStatus initResult = ManagedBuildManager.initBuildInfoContainer((IResource)this.newProject);
        if (initResult.getCode() != 0) {
            AutotoolsUIPlugin.log(initResult);
        }
        if ((operations = MBSCustomPageManager.getOperations()) != null) {
            int k = 0;
            while (k < operations.length) {
                try {
                    operations[k].run(monitor);
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
                ++k;
            }
        }
    }

    public String getProjectID() {
        return ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID;
    }

    public IConfiguration[] getSelectedConfigurations() {
        return this.projectConfigurationPage.getSelectedConfigurations();
    }
}

