/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model.type;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatingPointValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.Value;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;

public abstract class FloatingPointValue
extends Value
implements ICDIFloatingPointValue {
    public FloatingPointValue(Variable v) {
        super(v);
    }

    public double doubleValue() throws CDIException {
        double result = 0.0;
        String valueString = this.getValueString();
        if (this.isNaN(valueString)) {
            result = Double.NaN;
        } else if (this.isNegativeInfinity(valueString)) {
            result = Double.NEGATIVE_INFINITY;
        } else if (this.isPositiveInfinity(valueString)) {
            result = Double.POSITIVE_INFINITY;
        } else {
            try {
                result = Double.parseDouble(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public float floatValue() throws CDIException {
        float result = 0.0f;
        String valueString = this.getValueString();
        if (this.isNaN(valueString)) {
            result = Float.NaN;
        } else if (this.isNegativeInfinity(valueString)) {
            result = Float.NEGATIVE_INFINITY;
        } else if (this.isPositiveInfinity(valueString)) {
            result = Float.POSITIVE_INFINITY;
        } else {
            try {
                result = Float.parseFloat(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean isPositiveInfinity(String valueString) {
        return valueString != null ? valueString.indexOf("inf") != -1 : false;
    }

    private boolean isNegativeInfinity(String valueString) {
        return valueString != null ? valueString.indexOf("-inf") != -1 : false;
    }

    private boolean isNaN(String valueString) {
        return valueString != null ? valueString.indexOf("nan") != -1 : false;
    }
}

