/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build.gcc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.build.CConsoleParser;
import org.eclipse.cdt.core.build.CToolChain;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.Preferences;

public class GCCToolChain
extends CToolChain {
    public GCCToolChain(String id, Preferences settings) {
        super(id, settings);
    }

    public GCCToolChain(String name) {
        super(name);
    }

    @Override
    public String getFamily() {
        return "GCC";
    }

    @Override
    public IFile getResource(IFolder buildFolder, String[] commandLine) {
        String[] stringArray = commandLine;
        int n = commandLine.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            String arg = stringArray[n2];
            if (!arg.startsWith("-") && (file = buildFolder.getFile(arg)).exists() && CoreModel.isTranslationUnit(file)) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ExtendedScannerInfo getScannerInfo(IFolder buildFolder, List<String> cmd) throws CoreException {
        try {
            String[] commandLine = cmd.toArray(new String[cmd.size()]);
            int i = 0;
            while (i < commandLine.length - 1) {
                if (commandLine[i].equals("-o")) {
                    commandLine[i + 1] = "-";
                    break;
                }
                ++i;
            }
            Path tmpFile = null;
            int i2 = 1;
            block10: while (i2 < commandLine.length) {
                IFile file;
                if (!commandLine[i2].startsWith("-") && (file = buildFolder.getFile(commandLine[i2])).exists() && CoreModel.isTranslationUnit(file)) {
                    Path parentPath = new File(((IFolder)file.getParent()).getLocationURI()).toPath();
                    int n = 0;
                    while (true) {
                        tmpFile = parentPath.resolve(".sc" + n + "." + file.getFileExtension());
                        commandLine[i2] = tmpFile.toString();
                        try {
                            Files.createFile(tmpFile, new FileAttribute[0]);
                            break block10;
                        }
                        catch (FileAlreadyExistsException e) {
                            ++n;
                            continue;
                        }
                        break;
                    }
                }
                ++i2;
            }
            String[] fullCmd = new String[commandLine.length + 4];
            fullCmd[0] = commandLine[0];
            fullCmd[1] = "-E";
            fullCmd[2] = "-P";
            fullCmd[3] = "-v";
            fullCmd[4] = "-dD";
            System.arraycopy(commandLine, 1, fullCmd, 5, commandLine.length - 1);
            GCCToolChain.fixPaths(fullCmd);
            File buildDir = new File(buildFolder.getLocationURI());
            Files.createDirectories(buildDir.toPath(), new FileAttribute[0]);
            ProcessBuilder processBuilder = new ProcessBuilder(fullCmd).directory(buildDir).redirectErrorStream(true);
            this.setEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            HashMap<String, String> symbols = new HashMap<String, String>();
            ArrayList<String> includePath = new ArrayList<String>();
            Pattern definePattern = Pattern.compile("#define (.*)\\s(.*)");
            boolean inIncludePaths = false;
            Throwable throwable = null;
            Object var14_20 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    if (inIncludePaths) {
                        if (line.equals("End of search list.")) {
                            inIncludePaths = false;
                        } else {
                            includePath.add(line.trim());
                        }
                    } else if (line.startsWith("#define ")) {
                        Matcher matcher = definePattern.matcher(line);
                        if (matcher.matches()) {
                            symbols.put(matcher.group(1), matcher.group(2));
                        }
                    } else if (line.equals("#include <...> search starts here:")) {
                        inIncludePaths = true;
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new ExtendedScannerInfo(symbols, includePath.toArray(new String[includePath.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "scanner info", (Throwable)e));
        }
    }

    @Override
    public CConsoleParser[] getConsoleParsers() {
        return new CConsoleParser[]{new CConsoleParser("(.*?):(\\d+):(\\d+:)? (fatal )?error: (.*)"){

            @Override
            protected int getSeverity(Matcher matcher) {
                return 2;
            }

            @Override
            protected String getMessage(Matcher matcher) {
                return matcher.group(5);
            }

            @Override
            protected int getLineNumber(Matcher matcher) {
                return Integer.parseInt(matcher.group(2));
            }

            @Override
            protected String getFileName(Matcher matcher) {
                return matcher.group(1);
            }

            @Override
            protected int getLinkOffset(Matcher matcher) {
                return 0;
            }

            @Override
            protected int getLinkLength(Matcher matcher) {
                return matcher.group(1).length() + 1 + matcher.group(2).length() + 1 + matcher.group(3).length();
            }
        }};
    }
}

