/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

public class EditorSelectionDialog
extends Dialog {
    private IEditorDescriptor selectedEditor;
    private IEditorDescriptor hiddenSelectedEditor;
    private Button externalButton;
    private FilteredTree editorTable;
    private Button browseExternalEditorsButton;
    private Button internalButton;
    private Button okButton;
    protected static final String STORE_ID_INTERNAL_EXTERNAL = "EditorSelectionDialog.STORE_ID_INTERNAL_EXTERNAL";
    private static final String STORE_ID_DESCR = "EditorSelectionDialog.STORE_ID_DESCR";
    private String message = WorkbenchMessages.EditorSelection_chooseAnEditor;
    private IEditorDescriptor[] externalEditors;
    private IEditorDescriptor[] internalEditors;
    private IEditorDescriptor[] editorsToFilter;
    private DialogListener listener = new DialogListener();
    private ResourceManager resourceManager;
    private TreeViewer editorTableViewer;
    private String fileName;
    private Button rememberTypeButton;
    private Button rememberEditorButton;
    private static final String[] Executable_Filters = Util.isWindows() ? new String[]{"*.exe", "*.bat", "*.*"} : (Util.isMac() ? new String[]{"*.app", "*"} : new String[]{"*"});
    private static final int TABLE_WIDTH = 200;

    public EditorSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parentShell.getDisplay()));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveWidgetValues();
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        boolean result = super.close();
        this.resourceManager.dispose();
        this.resourceManager = null;
        return result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.EditorSelection_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.editor_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite contents = (Composite)super.createDialogArea(parent);
        ((GridLayout)contents.getLayout()).numColumns = 2;
        Label textLabel = new Label(contents, 64);
        textLabel.setText(this.message);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.widthHint = 200;
        textLabel.setLayoutData((Object)data);
        textLabel.setFont(font);
        Composite group = new Composite(contents, 32);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        group.setLayout((Layout)new RowLayout(256));
        group.setLayoutData((Object)data);
        this.internalButton = new Button(group, 16400);
        this.internalButton.setText(WorkbenchMessages.EditorSelection_internal);
        this.internalButton.addListener(13, (Listener)this.listener);
        this.internalButton.setFont(font);
        this.externalButton = new Button(group, 16400);
        this.externalButton.setText(WorkbenchMessages.EditorSelection_external);
        this.externalButton.addListener(13, (Listener)this.listener);
        this.externalButton.setFont(font);
        this.editorTable = new FilteredTree(contents, 2052, new PatternFilter(), true);
        this.editorTableViewer = this.editorTable.getViewer();
        Tree tree = this.editorTableViewer.getTree();
        tree.addListener(13, (Listener)this.listener);
        tree.addListener(14, (Listener)this.listener);
        tree.addListener(8, (Listener)this.listener);
        data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 2;
        this.editorTable.setLayoutData(data);
        this.editorTable.setFont(font);
        data.heightHint = tree.getItemHeight() * 12;
        this.editorTableViewer.setContentProvider((IContentProvider)new TreeArrayContentProvider());
        this.editorTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IEditorDescriptor d = (IEditorDescriptor)element;
                return TextProcessor.process((String)d.getLabel(), (String)".");
            }

            public Image getImage(Object element) {
                IEditorDescriptor d = (IEditorDescriptor)element;
                return (Image)EditorSelectionDialog.this.resourceManager.get((DeviceResourceDescriptor)d.getImageDescriptor());
            }
        });
        this.browseExternalEditorsButton = new Button(contents, 8);
        this.browseExternalEditorsButton.setText(WorkbenchMessages.EditorSelection_browse);
        this.browseExternalEditorsButton.addListener(13, (Listener)this.listener);
        data = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseExternalEditorsButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        data.horizontalSpan = 2;
        this.browseExternalEditorsButton.setLayoutData((Object)data);
        this.browseExternalEditorsButton.setFont(font);
        if (this.fileName != null) {
            this.rememberEditorButton = new Button(contents, 16416);
            this.rememberEditorButton.setText(NLS.bind((String)WorkbenchMessages.EditorSelection_rememberEditor, (Object)this.fileName));
            this.rememberEditorButton.addListener(13, (Listener)this.listener);
            data = new GridData();
            data.horizontalSpan = 2;
            this.rememberEditorButton.setLayoutData((Object)data);
            this.rememberEditorButton.setFont(font);
            String fileType = this.getFileType();
            if (!fileType.isEmpty()) {
                this.rememberTypeButton = new Button(contents, 16416);
                this.rememberTypeButton.setText(NLS.bind((String)WorkbenchMessages.EditorSelection_rememberType, (Object)fileType));
                this.rememberTypeButton.addListener(13, (Listener)this.listener);
                data = new GridData();
                data.horizontalSpan = 2;
                data.horizontalIndent = 15;
                this.rememberTypeButton.setLayoutData((Object)data);
                this.rememberTypeButton.setFont(font);
                this.rememberTypeButton.setEnabled(false);
            }
        }
        this.restoreWidgetValues();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (EditorSelectionDialog.this.editorTable.isDisposed()) {
                    return;
                }
                EditorSelectionDialog.this.fillEditorTable();
                EditorSelectionDialog.this.updateEnableState();
            }
        });
        return contents;
    }

    private String getFileType() {
        if (this.fileName == null) {
            return "";
        }
        int lastDot = this.fileName.lastIndexOf(46);
        if (lastDot == -1 || lastDot >= this.fileName.length() - 2) {
            return "";
        }
        return this.fileName.substring(lastDot + 1, this.fileName.length());
    }

    protected void fillEditorTable() {
        boolean isShowingInternal;
        IEditorDescriptor newSelection = this.selectedEditor;
        boolean showInternal = this.internalButton.getSelection();
        Object[] input = (Object[])this.editorTableViewer.getInput();
        if (input != null && showInternal != (isShowingInternal = Arrays.equals(input, this.getInternalEditors()))) {
            newSelection = this.hiddenSelectedEditor;
            if (!this.editorTableViewer.getSelection().isEmpty()) {
                this.hiddenSelectedEditor = (EditorDescriptor)this.editorTableViewer.getStructuredSelection().getFirstElement();
            }
        }
        this.editorTableViewer.setInput((Object)(showInternal ? this.getInternalEditors() : this.getExternalEditors()));
        if (newSelection != null) {
            this.editorTableViewer.setSelection((ISelection)new StructuredSelection((Object)newSelection), true);
        } else {
            this.editorTableViewer.getTree().showItem(this.editorTableViewer.getTree().getItem(0));
        }
        this.editorTable.setFocus();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("EditorSelectionDialog");
        if (section == null) {
            section = workbenchSettings.addNewSection("EditorSelectionDialog");
        }
        return section;
    }

    protected IEditorDescriptor[] getExternalEditors() {
        if (this.externalEditors == null) {
            IProgressService ps = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    EditorRegistry reg = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
                    EditorSelectionDialog.this.externalEditors = reg.getSortedEditorsFromOS();
                    EditorSelectionDialog.this.externalEditors = EditorSelectionDialog.this.filterEditors(EditorSelectionDialog.this.externalEditors);
                }
            };
            try {
                ps.runInUI(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), runnable, null);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Object status = cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, "org.eclipse.ui", "Error while retrieving native editors", cause);
                StatusManager.getManager().handle((IStatus)status);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.externalEditors;
    }

    protected IEditorDescriptor[] filterEditors(IEditorDescriptor[] editors) {
        if (editors == null || editors.length < 1) {
            return editors;
        }
        if (this.editorsToFilter == null || this.editorsToFilter.length < 1) {
            return editors;
        }
        ArrayList<IEditorDescriptor> filteredList = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            boolean add = true;
            int j = 0;
            while (j < this.editorsToFilter.length) {
                if (editors[i].getId().equals(this.editorsToFilter[j].getId())) {
                    add = false;
                }
                ++j;
            }
            if (add) {
                filteredList.add(editors[i]);
            }
            ++i;
        }
        return filteredList.toArray(new IEditorDescriptor[filteredList.size()]);
    }

    protected IEditorDescriptor[] getInternalEditors() {
        if (this.internalEditors == null) {
            EditorRegistry reg = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            this.internalEditors = reg.getSortedEditorsFromPlugins();
            this.internalEditors = this.filterEditors(this.internalEditors);
        }
        return this.internalEditors;
    }

    public IEditorDescriptor getSelectedEditor() {
        return this.selectedEditor;
    }

    protected void promptForExternalEditor() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10009000);
        dialog.setFilterExtensions(Executable_Filters);
        String result = dialog.open();
        if (result != null) {
            EditorDescriptor editor = EditorDescriptor.createForProgram(result);
            IEditorDescriptor[] newEditors = new IEditorDescriptor[this.externalEditors.length + 1];
            System.arraycopy(this.externalEditors, 0, newEditors, 0, this.externalEditors.length);
            newEditors[newEditors.length - 1] = editor;
            this.externalEditors = newEditors;
            this.editorTableViewer.setInput((Object)this.externalEditors);
            this.editorTableViewer.setSelection((ISelection)new StructuredSelection((Object)editor), true);
            this.editorTable.setFocus();
            this.selectedEditor = editor;
        }
    }

    protected void handleDoubleClickEvent() {
        this.buttonPressed(0);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        boolean wasExternal = settings.getBoolean(STORE_ID_INTERNAL_EXTERNAL);
        this.internalButton.setSelection(!wasExternal);
        this.externalButton.setSelection(wasExternal);
        String id = settings.get(STORE_ID_DESCR);
        if (id != null) {
            IEditorDescriptor[] editors = wasExternal ? this.getExternalEditors() : this.getInternalEditors();
            IEditorDescriptor[] iEditorDescriptorArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorDescriptor desc = iEditorDescriptorArray[n2];
                if (id.equals(desc.getId())) {
                    this.selectedEditor = desc;
                }
                ++n2;
            }
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_ID_INTERNAL_EXTERNAL, !this.internalButton.getSelection());
        settings.put(STORE_ID_DESCR, this.selectedEditor.getId());
        String editorId = this.selectedEditor.getId();
        settings.put(STORE_ID_DESCR, editorId);
        if (this.rememberEditorButton == null || !this.rememberEditorButton.getSelection()) {
            return;
        }
        EditorRegistry reg = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
        if (this.rememberTypeButton == null || !this.rememberTypeButton.getSelection()) {
            this.updateFileMappings(reg, true);
            reg.setDefaultEditor(this.fileName, this.selectedEditor);
        } else {
            this.updateFileMappings(reg, false);
            reg.setDefaultEditor("*." + this.getFileType(), this.selectedEditor);
        }
        ArrayList<IFileEditorMapping> newMappings = new ArrayList<IFileEditorMapping>();
        newMappings.addAll(Arrays.asList(reg.getFileEditorMappings()));
        reg.setFileEditorMappings(newMappings.toArray(new FileEditorMapping[newMappings.size()]));
        reg.saveAssociations();
    }

    private void updateFileMappings(EditorRegistry reg, boolean useFileName) {
        IFileEditorMapping mapping;
        IFileEditorMapping[] mappings = reg.getFileEditorMappings();
        boolean hasMapping = false;
        String fileType = this.getFileType();
        IFileEditorMapping[] iFileEditorMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            mapping = iFileEditorMappingArray[n2];
            if (useFileName) {
                if (this.fileName.equals(mapping.getLabel())) {
                    hasMapping = true;
                    break;
                }
            } else if (fileType.equals(mapping.getExtension())) {
                hasMapping = true;
                break;
            }
            ++n2;
        }
        if (hasMapping) {
            return;
        }
        mapping = useFileName ? new FileEditorMapping(this.fileName, null) : new FileEditorMapping(null, fileType);
        ArrayList<IFileEditorMapping> newMappings = new ArrayList<IFileEditorMapping>();
        newMappings.addAll(Arrays.asList(mappings));
        newMappings.add(mapping);
        FileEditorMapping[] array = newMappings.toArray(new FileEditorMapping[newMappings.size()]);
        reg.setFileEditorMappings(array);
    }

    public void setMessage(String aMessage) {
        this.message = aMessage;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setEditorsToFilter(IEditorDescriptor[] editors) {
        this.editorsToFilter = editors;
    }

    protected void updateEnableState() {
        boolean enableExternal = this.externalButton.getSelection();
        this.browseExternalEditorsButton.setEnabled(enableExternal);
        if (this.rememberEditorButton != null && this.rememberTypeButton != null) {
            this.rememberTypeButton.setEnabled(this.rememberEditorButton.getSelection());
        }
        this.updateOkButton();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(false);
    }

    protected void updateOkButton() {
        if (this.okButton == null) {
            return;
        }
        if (this.editorTableViewer.getSelection().isEmpty()) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(this.selectedEditor != null);
    }

    protected boolean isResizable() {
        return true;
    }

    private class DialogListener
    implements Listener {
        private DialogListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 8) {
                EditorSelectionDialog.this.handleDoubleClickEvent();
                return;
            }
            if (event.widget == EditorSelectionDialog.this.externalButton) {
                EditorSelectionDialog.this.fillEditorTable();
            } else if (event.widget == EditorSelectionDialog.this.browseExternalEditorsButton) {
                EditorSelectionDialog.this.promptForExternalEditor();
            } else if (event.widget == EditorSelectionDialog.this.editorTableViewer.getTree()) {
                if (!EditorSelectionDialog.this.editorTableViewer.getSelection().isEmpty()) {
                    EditorSelectionDialog.this.selectedEditor = (EditorDescriptor)EditorSelectionDialog.this.editorTableViewer.getStructuredSelection().getFirstElement();
                } else {
                    EditorSelectionDialog.this.selectedEditor = null;
                    EditorSelectionDialog.this.okButton.setEnabled(false);
                }
            }
            EditorSelectionDialog.this.updateEnableState();
        }
    }

    private static class TreeArrayContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];

        private TreeArrayContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null || !inputElement.getClass().isArray()) {
                return EMPTY;
            }
            Object[] orig = (Object[])inputElement;
            Object[] arr = new Object[orig.length];
            System.arraycopy(orig, 0, arr, 0, arr.length);
            return arr;
        }

        public Object[] getChildren(Object parentElement) {
            return EMPTY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

