/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.client;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.ptp.proxy.event.IProxyEvent;

public class ProxyEventQueue {
    private ConcurrentLinkedQueue<IProxyEvent> eventQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<IProxyEvent> priorityEventQueue = new ConcurrentLinkedQueue();

    public synchronized void addPriorityProxyEvent(IProxyEvent e) {
        this.priorityEventQueue.add(e);
        this.notify();
    }

    public synchronized void addProxyEvent(IProxyEvent e) {
        this.eventQueue.add(e);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProxyEvent getProxyEvent() {
        ProxyEventQueue proxyEventQueue = this;
        synchronized (proxyEventQueue) {
            if (this.priorityEventQueue.peek() == null && this.eventQueue.peek() == null) {
                this.waitForEvent();
            }
        }
        IProxyEvent event = this.priorityEventQueue.poll();
        if (event != null) {
            return event;
        }
        event = this.eventQueue.poll();
        if (event != null) {
            return event;
        }
        return null;
    }

    public int size() {
        return this.priorityEventQueue.size() + this.eventQueue.size();
    }

    private void waitForEvent() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }
}

