/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.core.jobs.IJobListener;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.messages.Messages;

public class RuntimeProcess
implements IProcess,
IJobListener {
    private IPLaunch fLaunch = null;
    private Map<String, String> fAttributes;
    private int fExitValue = -1;
    private boolean fTerminated = false;

    public RuntimeProcess(IPLaunch launch, Map<String, String> attributes) {
        this.fLaunch = launch;
        JobManager.getInstance().addListener(launch.getJobControl().getControlId(), (IJobListener)this);
        this.initializeAttributes(attributes);
        try {
            this.fTerminated = launch.getJobControl().getJobStatus(launch.getJobId(), null).getState().equals("COMPLETED");
        }
        catch (CoreException coreException) {
            this.fTerminated = true;
        }
        launch.addProcess((IProcess)this);
    }

    public synchronized boolean canTerminate() {
        return !this.fTerminated;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        return null;
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return this.fAttributes.get(key);
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, Messages.RuntimeProcess_Exit_value_not_available, null));
    }

    public String getLabel() {
        return "Runtime process " + this.fLaunch.getJobId();
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IStreamsProxy getStreamsProxy() {
        try {
            return this.fLaunch.getJobControl().getJobStatus(this.fLaunch.getJobId(), null).getStreamsProxy();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void jobAdded(IJobStatus status) {
    }

    public void jobChanged(IJobStatus status) {
        if (!this.isTerminated() && this.fLaunch.getJobId().equals(status.getJobId()) && status.getState().equals("COMPLETED")) {
            this.terminated();
        }
    }

    public synchronized boolean isTerminated() {
        return this.fTerminated;
    }

    public void setAttribute(String key, String value) {
        String origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, String>(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            try {
                this.fLaunch.getJobControl().control(this.fLaunch.getJobId(), "TERMINATE", null);
            }
            catch (CoreException e) {
                throw new DebugException(e.getStatus());
            }
        }
    }

    private void initializeAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.setAttribute(key, attributes.get(key));
            }
        }
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminated() {
        RuntimeProcess runtimeProcess = this;
        synchronized (runtimeProcess) {
            this.fTerminated = true;
        }
        this.fExitValue = 0;
        this.fireTerminateEvent();
        JobManager.getInstance().removeListener((IJobListener)this);
    }
}

