/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.commit.CommitJob;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.CommitDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CommitUI {
    private IndexDiff indexDiff;
    private Set<String> notIndexed;
    private Set<String> indexChanges;
    private Set<String> notTracked;
    private Set<String> files;
    private boolean amending;
    private Shell shell;
    private Repository repo;
    private IResource[] selectedResources;
    private boolean preselectAll;

    public CommitUI(Shell shell, Repository repo, IResource[] selectedResources, boolean preselectAll) {
        this.shell = shell;
        this.repo = repo;
        this.selectedResources = new IResource[selectedResources.length];
        System.arraycopy(selectedResources, 0, this.selectedResources, 0, selectedResources.length);
        this.preselectAll = preselectAll;
    }

    public boolean commit() {
        CommitOperation commitOperation;
        if (!UIUtils.saveAllEditors(this.repo)) {
            return false;
        }
        BasicConfigurationDialog.show(this.repo);
        this.resetState();
        final IProject[] projects = this.getProjectsOfRepositories();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CommitUI.this.buildIndexHeadDiffList(projects, monitor);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(UIText.CommitAction_errorComputingDiffs, e.getCause(), true);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        CommitHelper commitHelper = new CommitHelper(this.repo);
        if (!commitHelper.canCommit()) {
            MessageDialog.openError((Shell)this.shell, (String)UIText.CommitAction_cannotCommit, (String)commitHelper.getCannotCommitMessage());
            return false;
        }
        boolean amendAllowed = commitHelper.amendAllowed();
        if (this.files.isEmpty()) {
            if (amendAllowed && commitHelper.getPreviousCommit() != null) {
                boolean result = MessageDialog.openQuestion((Shell)this.shell, (String)UIText.CommitAction_noFilesToCommit, (String)UIText.CommitAction_amendCommit);
                if (!result) {
                    return false;
                }
                this.amending = true;
            } else {
                MessageDialog.openWarning((Shell)this.shell, (String)UIText.CommitAction_noFilesToCommit, (String)UIText.CommitAction_amendNotPossible);
                return false;
            }
        }
        CommitDialog commitDialog = new CommitDialog(this.shell);
        commitDialog.setAmending(this.amending);
        commitDialog.setAmendAllowed(amendAllowed);
        commitDialog.setFiles(this.repo, this.files, this.indexDiff);
        commitDialog.setPreselectedFiles(this.getSelectedFiles());
        commitDialog.setPreselectAll(this.preselectAll);
        commitDialog.setAuthor(commitHelper.getAuthor());
        commitDialog.setCommitter(commitHelper.getCommitter());
        commitDialog.setAllowToChangeSelection(!commitHelper.isMergedResolved && !commitHelper.isCherryPickResolved);
        commitDialog.setCommitMessage(commitHelper.getCommitMessage());
        if (commitDialog.open() != 0) {
            return false;
        }
        try {
            commitOperation = new CommitOperation(this.repo, commitDialog.getSelectedFiles(), this.notTracked, commitDialog.getAuthor(), commitDialog.getCommitter(), commitDialog.getCommitMessage());
        }
        catch (CoreException e1) {
            Activator.handleError(UIText.CommitUI_commitFailed, e1, true);
            return false;
        }
        if (commitDialog.isAmending()) {
            commitOperation.setAmending(true);
        }
        commitOperation.setComputeChangeId(commitDialog.getCreateChangeId());
        commitOperation.setCommitAll(commitHelper.isMergedResolved);
        if (commitHelper.isMergedResolved) {
            commitOperation.setRepository(this.repo);
        }
        CommitJob commitJob = new CommitJob(this.repo, commitOperation).setPushUpstream(commitDialog.isPushRequested());
        commitJob.schedule();
        return true;
    }

    private IProject[] getProjectsOfRepositories() {
        IProject[] projects;
        HashSet<IProject> ret = new HashSet<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IProject)project);
            if (mapping != null && mapping.getRepository() == this.repo) {
                ret.add(project);
            }
            ++n2;
        }
        return ret.toArray(new IProject[ret.size()]);
    }

    private void resetState() {
        this.files = new LinkedHashSet<String>();
        this.notIndexed = new LinkedHashSet<String>();
        this.indexChanges = new LinkedHashSet<String>();
        this.notTracked = new LinkedHashSet<String>();
        this.amending = false;
        this.indexDiff = null;
    }

    private Set<String> getSelectedFiles() {
        LinkedHashSet<String> preselectionCandidates = new LinkedHashSet<String>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        block0: for (String fileName : this.files) {
            int n;
            URI uri = new File(this.repo.getWorkTree(), fileName).toURI();
            IFile[] workspaceFiles = root.findFilesForLocationURI(uri);
            if (workspaceFiles.length > 0) {
                IFile file = workspaceFiles[0];
                IResource[] iResourceArray = this.selectedResources;
                int n2 = this.selectedResources.length;
                n = 0;
                while (n < n2) {
                    IResource resource = iResourceArray[n];
                    if (resource.contains((ISchedulingRule)file)) {
                        preselectionCandidates.add(fileName);
                        continue block0;
                    }
                    ++n;
                }
                continue;
            }
            IResource[] iResourceArray = this.selectedResources;
            n = this.selectedResources.length;
            int n3 = 0;
            while (n3 < n) {
                IResource resource = iResourceArray[n3];
                IPath location = resource.getLocation();
                if (location != null && location.toFile().equals(new File(uri))) {
                    preselectionCandidates.add(fileName);
                }
                ++n3;
            }
        }
        return preselectionCandidates;
    }

    private void buildIndexHeadDiffList(IProject[] selectedProjects, IProgressMonitor monitor) throws IOException, OperationCanceledException {
        monitor.beginTask(UIText.CommitActionHandler_calculatingChanges, 1000);
        EclipseGitProgressTransformer jgitMonitor = new EclipseGitProgressTransformer(monitor);
        CountingVisitor counter = new CountingVisitor();
        IProject[] iProjectArray = selectedProjects;
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                p.accept((IResourceVisitor)counter);
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        WorkingTreeIterator it = IteratorService.createInitialIterator((Repository)this.repo);
        if (it == null) {
            throw new OperationCanceledException();
        }
        this.indexDiff = new IndexDiff(this.repo, "HEAD", it);
        this.indexDiff.diff((ProgressMonitor)jgitMonitor, counter.count, 0, NLS.bind((String)UIText.CommitActionHandler_repository, (Object)this.repo.getDirectory().getPath()));
        this.includeList(this.indexDiff.getAdded(), this.indexChanges);
        this.includeList(this.indexDiff.getChanged(), this.indexChanges);
        this.includeList(this.indexDiff.getRemoved(), this.indexChanges);
        this.includeList(this.indexDiff.getMissing(), this.notIndexed);
        this.includeList(this.indexDiff.getModified(), this.notIndexed);
        this.includeList(this.indexDiff.getUntracked(), this.notTracked);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.done();
    }

    private void includeList(Set<String> added, Set<String> category) {
        for (String filename : added) {
            if (!this.files.contains(filename)) {
                this.files.add(filename);
            }
            category.add(filename);
        }
    }

    static class CountingVisitor
    implements IResourceVisitor {
        int count;

        CountingVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            ++this.count;
            return true;
        }
    }
}

