/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.factories;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.GitHistoryPageSource;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitModelWorkbenchAdapter;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitObjectMapping;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.IShowInSource;

public class GitAdapterFactory
implements IAdapterFactory {
    private Object historyPageSource = new GitHistoryPageSource();
    private GitModelWorkbenchAdapter gitModelWorkbenchAdapter;
    private static final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IHistoryView historyView;
        IHistoryPage historyPage;
        if (adapterType.isAssignableFrom(IHistoryPageSource.class)) {
            return this.historyPageSource;
        }
        if (IWorkbenchAdapter.class == adapterType) {
            if (adaptableObject instanceof RepositoryNode) {
                return GitAdapterFactory.getRepsitoryNodeWorkbenchAdapter((RepositoryNode)adaptableObject);
            }
            if (this.gitModelWorkbenchAdapter == null) {
                this.gitModelWorkbenchAdapter = new GitModelWorkbenchAdapter();
            }
            return this.gitModelWorkbenchAdapter;
        }
        if (adaptableObject instanceof IHistoryView && IShowInSource.class == adapterType && (historyPage = (historyView = (IHistoryView)adaptableObject).getHistoryPage()) instanceof GitHistoryPage) {
            return historyPage;
        }
        if (adaptableObject instanceof GitModelObject && adapterType == ResourceMapping.class) {
            return GitObjectMapping.create((GitModelObject)((Object)adaptableObject));
        }
        if (adaptableObject instanceof GitModelObject && adapterType == IResource.class) {
            IFile res;
            GitModelObject obj = (GitModelObject)((Object)adaptableObject);
            if (obj instanceof GitModelBlob) {
                res = ResourceUtil.getFileForLocation((IPath)obj.getLocation(), (boolean)false);
                if (res == null) {
                    res = root.getFile(obj.getLocation());
                }
                return res;
            }
            if (obj instanceof GitModelTree) {
                res = root.getContainerForLocation(obj.getLocation());
                if (res == null) {
                    res = root.getFolder(obj.getLocation());
                }
                return res;
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IHistoryPageSource.class, ISynchronizationCompareAdapter.class, ResourceMapping.class, IResource.class, IWorkbenchAdapter.class, IShowInSource.class};
    }

    private static IWorkbenchAdapter getRepsitoryNodeWorkbenchAdapter(final RepositoryNode node) {
        return new WorkbenchAdapter(){

            public String getLabel(Object object) {
                RepositoriesViewLabelProvider labelProvider = new RepositoriesViewLabelProvider();
                return labelProvider.getText(node);
            }
        };
    }
}

