/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DateFormatPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final PersonIdent SAMPLE = new PersonIdent("", "", new Date(System.currentTimeMillis() - 86400000L), DateFormatPreferencePage.getDifferentTimeZone());
    private static final Map<GitDateFormatter.Format, FormatInfo> DATA = DateFormatPreferencePage.initializeData();
    private ComboFieldEditor formatChooser;
    private StringFieldEditor dateFormat;
    private Label dateFormatPreview;
    private Label formatExplanation;
    private String lastCustomValue;

    public DateFormatPreferencePage() {
        super(1);
        DateFormatPreferencePage.initializeData();
        this.setTitle(UIText.DateFormatPreferencePage_title);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void createFieldEditors() {
        String[][] values = new String[DATA.size()][2];
        int i = 0;
        for (Map.Entry<GitDateFormatter.Format, FormatInfo> entry : DATA.entrySet()) {
            values[i][0] = entry.getValue().name;
            values[i][1] = entry.getKey() == null ? "CUSTOM" : entry.getKey().name();
            ++i;
        }
        final Composite pane = this.getFieldEditorParent();
        this.formatChooser = new ComboFieldEditor("date_format_choice", UIText.DateFormatPreferencePage_formatChooser_label, values, pane);
        this.addField((FieldEditor)this.formatChooser);
        this.dateFormat = new StringFieldEditor("date_format", UIText.DateFormatPreferencePage_formatInput_label, StringFieldEditor.UNLIMITED, 0, pane){

            protected boolean doCheckState() {
                if (!this.getTextControl(pane).isEnabled()) {
                    return true;
                }
                try {
                    DateFormatPreferencePage.this.updatePreview(new SimpleDateFormat(this.getStringValue().trim()));
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    DateFormatPreferencePage.this.dateFormatPreview.setText("");
                    return false;
                }
            }

            protected void doLoad() {
            }

            protected void doStore() {
                if (this.getTextControl(pane).isEnabled() && this.doCheckState()) {
                    super.doStore();
                }
            }

            public void setStringValue(String value) {
                super.setStringValue(value);
                this.refreshValidState();
            }
        };
        this.dateFormat.setEmptyStringAllowed(false);
        this.dateFormat.setErrorMessage(UIText.DateFormatPreferencePage_invalidDateFormat_message);
        this.addField((FieldEditor)this.dateFormat);
        Label dpLabel = SWTUtils.createLabel(pane, UIText.DateFormatPreferencePage_datePreview_label);
        dpLabel.setLayoutData((Object)SWTUtils.createGridData(-1, -1, false, false));
        this.dateFormatPreview = SWTUtils.createLabel(pane, null, 1);
        Label dummyLabel = SWTUtils.createLabel(pane, "");
        dummyLabel.setLayoutData((Object)SWTUtils.createGridData(-1, -1, false, false));
        this.formatExplanation = new Label(pane, 16448);
        GridData layout = SWTUtils.createGridData(-1, -1, false, true);
        this.formatExplanation.setLayoutData((Object)layout);
        this.lastCustomValue = this.getPreferenceStore().getString("date_format");
        String initialValue = this.getPreferenceStore().getString("date_format_choice");
        GitDateFormatter.Format initialFormat = this.fromString(initialValue);
        FormatInfo info = DATA.get(initialFormat);
        this.dateFormat.setEnabled(initialFormat == null, pane);
        this.dateFormat.setStringValue(initialFormat == null ? this.lastCustomValue : info.format);
        this.formatExplanation.setText(info.explanation);
    }

    protected void initialize() {
        super.initialize();
        this.formatChooser.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_value".equals(event.getProperty())) {
                    GitDateFormatter.Format format = DateFormatPreferencePage.this.fromString((String)event.getOldValue());
                    if (format == null) {
                        DateFormatPreferencePage.this.lastCustomValue = DateFormatPreferencePage.this.dateFormat.getStringValue();
                    }
                    DateFormatPreferencePage.this.updateFields((String)event.getNewValue());
                }
            }
        });
    }

    private void updateFields(String newSelection) {
        GitDateFormatter.Format format = this.fromString(newSelection);
        FormatInfo info = DATA.get(format);
        this.formatExplanation.setText(info.explanation);
        if (format == null) {
            this.dateFormat.getTextControl(this.getFieldEditorParent()).setEnabled(true);
            this.dateFormat.setStringValue(this.lastCustomValue);
        } else {
            this.dateFormat.getTextControl(this.getFieldEditorParent()).setEnabled(false);
            this.dateFormat.setStringValue(info.format);
            this.updatePreview(format);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.lastCustomValue = this.getPreferenceStore().getDefaultString("date_format");
        this.updateFields(this.getPreferenceStore().getDefaultString("date_format_choice"));
    }

    private GitDateFormatter.Format fromString(String value) {
        try {
            return GitDateFormatter.Format.valueOf((String)value);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return null;
        }
    }

    private void updatePreview(SimpleDateFormat format) {
        format.setTimeZone(SAMPLE.getTimeZone());
        this.dateFormatPreview.setText(format.format(SAMPLE.getWhen()));
    }

    private void updatePreview(GitDateFormatter.Format format) {
        this.dateFormatPreview.setText(new GitDateFormatter(format).formatDate(SAMPLE));
    }

    private static Map<GitDateFormatter.Format, FormatInfo> initializeData() {
        LinkedHashMap<GitDateFormatter.Format, FormatInfo> d = new LinkedHashMap<GitDateFormatter.Format, FormatInfo>();
        d.put(GitDateFormatter.Format.DEFAULT, new FormatInfo(UIText.DateFormatPreferencePage_choiceGitDefault_label, "EEE MMM dd HH:mm:ss yyyy Z", UIText.DateFormatPreferencePage_helpGitDefault_label));
        d.put(GitDateFormatter.Format.LOCAL, new FormatInfo(UIText.DateFormatPreferencePage_choiceGitLocal_label, "EEE MMM dd HH:mm:ss yyyy", UIText.DateFormatPreferencePage_helpGitLocal_label));
        d.put(GitDateFormatter.Format.RELATIVE, new FormatInfo(UIText.DateFormatPreferencePage_choiceGitRelative_label, UIText.DateFormatPreferencePage_gitRelative_format_text, UIText.DateFormatPreferencePage_helpGitRelative_label));
        d.put(GitDateFormatter.Format.ISO, new FormatInfo(UIText.DateFormatPreferencePage_choiceGitIso_label, "yyyy-MM-dd HH:mm:ss Z", UIText.DateFormatPreferencePage_helpGitIso_label));
        d.put(GitDateFormatter.Format.RFC, new FormatInfo(UIText.DateFormatPreferencePage_choiceGitRfc_label, "EEE, dd MMM yyyy HH:mm:ss Z", UIText.DateFormatPreferencePage_helpGitRfc_label));
        d.put(GitDateFormatter.Format.SHORT, new FormatInfo(UIText.DateFormatPreferencePage_choiceGitShort_label, "yyyy-MM-dd", UIText.DateFormatPreferencePage_helpGitShort_label));
        DateFormat systemFormat = DateFormat.getDateTimeInstance(2, 2);
        String localeLocalFormat = systemFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)systemFormat).toPattern() : UIText.DateFormatPreferencePage_gitLocaleLocal_format_text;
        String localeFormat = systemFormat instanceof SimpleDateFormat ? String.valueOf(localeLocalFormat) + " Z" : UIText.DateFormatPreferencePage_gitLocale_format_text;
        d.put(GitDateFormatter.Format.LOCALE, new FormatInfo(UIText.DateFormatPreferencePage_choiceGitLocale_label, localeFormat, UIText.DateFormatPreferencePage_helpGitLocale_label));
        d.put(GitDateFormatter.Format.LOCALELOCAL, new FormatInfo(UIText.DateFormatPreferencePage_choiceGitLocaleLocal_label, localeLocalFormat, UIText.DateFormatPreferencePage_helpGitLocaleLocal_label));
        d.put(null, new FormatInfo(UIText.DateFormatPreferencePage_choiceCustom_label, "", UIText.DateFormatPreferencePage_helpCustom_label));
        return d;
    }

    private static TimeZone getDifferentTimeZone() {
        TimeZone localTimeZone = TimeZone.getDefault();
        int offset = (localTimeZone.getRawOffset() / 3600 / 1000 - 6) * 3600 * 1000;
        return TimeZone.getTimeZone(TimeZone.getAvailableIDs(offset)[0]);
    }

    private static final class FormatInfo {
        private final String name;
        private final String format;
        private final String explanation;

        public FormatInfo(String name, String dateFormat, String explanation) {
            this.name = name;
            this.format = dateFormat;
            this.explanation = explanation;
        }
    }
}

