/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.decorators.IProblemDecoratable;

public class StagingFolderEntry
implements IAdaptable,
IProblemDecoratable {
    private final IPath repoLocation;
    private final IPath repoRelativePath;
    private final IPath nodePath;
    private final IContainer container;
    private StagingFolderEntry parent;
    private Object[] children;

    public StagingFolderEntry(IPath repoLocation, IPath repoRelativePath, IPath nodePath) {
        this.repoLocation = repoLocation;
        this.repoRelativePath = repoRelativePath;
        this.nodePath = nodePath;
        this.container = ResourceUtil.getContainerForLocation((IPath)this.getLocation(), (boolean)false);
    }

    public IContainer getContainer() {
        return this.container;
    }

    @Override
    public int getProblemSeverity() {
        if (this.container == null) {
            return -1;
        }
        try {
            return this.container.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1);
        }
        catch (CoreException coreException) {
            return -1;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class || adapter == IContainer.class) {
            return this.getContainer();
        }
        if (adapter == IPath.class) {
            return this.getLocation();
        }
        return null;
    }

    public IPath getPath() {
        return this.repoRelativePath;
    }

    public IPath getLocation() {
        return this.repoLocation.append(this.repoRelativePath);
    }

    public IPath getNodePath() {
        return this.nodePath;
    }

    public StagingFolderEntry getParent() {
        return this.parent;
    }

    public void setParent(StagingFolderEntry parent) {
        this.parent = parent;
    }

    public Object[] getChildren() {
        return this.children;
    }

    public void setChildren(Object[] children) {
        this.children = children;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StagingFolderEntry) {
            return ((StagingFolderEntry)obj).getLocation().equals((Object)this.getLocation());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }
}

