/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public abstract class CConsoleParser {
    private final String pattern;
    private final int flags;
    private final String lineQualifier;
    private final Pattern errorPattern;
    public static final String LINK_OFFSET = "cdt.link.offset";
    public static final String LINK_LENGTH = "cdt.link.length";

    protected CConsoleParser(String pattern, int flags, String lineQualifier) {
        this.pattern = pattern;
        this.flags = flags;
        this.lineQualifier = lineQualifier;
        this.errorPattern = Pattern.compile(pattern);
    }

    protected CConsoleParser(String pattern) {
        this(pattern, 0, null);
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getCompilerFlags() {
        return this.flags;
    }

    public String getLineQualifier() {
        return this.lineQualifier;
    }

    protected abstract String getFileName(Matcher var1);

    protected abstract int getLineNumber(Matcher var1);

    protected abstract String getMessage(Matcher var1);

    protected abstract int getSeverity(Matcher var1);

    protected abstract int getLinkOffset(Matcher var1);

    protected abstract int getLinkLength(Matcher var1);

    public IMarker generateMarker(IFolder buildDirectory, String text) {
        String fileName;
        IFile file;
        Matcher matcher = this.errorPattern.matcher(text);
        if (matcher.matches() && (file = buildDirectory.getFile(fileName = this.getFileName(matcher))).exists()) {
            try {
                IMarker marker = file.createMarker("org.eclipse.cdt.core.problem");
                marker.setAttribute("message", (Object)this.getMessage(matcher));
                marker.setAttribute("severity", this.getSeverity(matcher));
                marker.setAttribute("lineNumber", this.getLineNumber(matcher));
                marker.setAttribute("charStart", -1);
                marker.setAttribute("charEnd", -1);
                marker.setAttribute(LINK_OFFSET, this.getLinkOffset(matcher));
                marker.setAttribute(LINK_LENGTH, this.getLinkLength(matcher));
                return marker;
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                return null;
            }
        }
        return null;
    }
}

