/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build.gcc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.build.CToolChain;
import org.eclipse.cdt.core.build.IToolChainFactory;
import org.eclipse.cdt.core.build.gcc.GCCToolChain;
import org.osgi.service.prefs.Preferences;

public class GCCToolChainFactory
implements IToolChainFactory {
    private static Pattern gccPattern = Pattern.compile("(.*-)?(gcc|g\\+\\+|clang|clang\\+\\+)(-[0-9].*)?");
    private static Pattern versionPattern = Pattern.compile(".*(gcc|LLVM) version .*");
    private static Pattern targetPattern = Pattern.compile("Target: (.*)");

    @Override
    public void discover() {
        String path = null;
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("PATH")) continue;
            path = entry.getValue();
            break;
        }
        if (path != null) {
            HashMap<String, ArrayList<String>> installs = new HashMap<String, ArrayList<String>>();
            String[] stringArray = path.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dirStr = stringArray[n2];
                File dir = new File(dirStr);
                String[] stringArray2 = dir.list();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String file = stringArray2[n4];
                    Matcher matcher = gccPattern.matcher(file);
                    if (matcher.matches()) {
                        String prefix = matcher.group(1);
                        String suffix = matcher.group(3);
                        String command = String.valueOf(dirStr) + File.separatorChar + file;
                        String version = this.getVersion(command);
                        if (version != null) {
                            ArrayList<String> commands = (ArrayList<String>)installs.get(version);
                            if (commands == null) {
                                commands = new ArrayList<String>();
                                installs.put(version, commands);
                            }
                            commands.add(command);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            for (Map.Entry entry : installs.entrySet()) {
                System.out.println((String)entry.getKey());
                for (String command : (List)entry.getValue()) {
                    System.out.println("\t" + command);
                }
            }
        }
    }

    private String getVersion(String command) {
        try {
            Process proc = new ProcessBuilder(command, "-v").redirectErrorStream(true).start();
            String version = null;
            String target = null;
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    Matcher versionMatcher = versionPattern.matcher(line);
                    if (versionMatcher.matches()) {
                        version = line.trim();
                    } else {
                        Matcher targetMatcher = targetPattern.matcher(line);
                        if (targetMatcher.matches()) {
                            target = targetMatcher.group(1);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (version != null) {
                if (target != null) {
                    return String.valueOf(version) + " " + target;
                }
                return version;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public CToolChain createToolChain(String id, Preferences settings) {
        return new GCCToolChain(id, settings);
    }
}

