/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.core.resources.IResource;

public class ToolChainScannerInfo {
    private Map<String, String> definedSymbols;
    private String[] includePaths;
    private String[] macroFiles;
    private String[] includeFiles;
    private String[] localIncludePath;
    private Set<String> resourcePaths;
    private transient IScannerInfo scannerInfo;

    public ToolChainScannerInfo(ExtendedScannerInfo scannerInfo) {
        this.scannerInfo = scannerInfo;
        this.definedSymbols = scannerInfo.getDefinedSymbols();
        this.includePaths = scannerInfo.getIncludePaths();
        this.macroFiles = scannerInfo.getMacroFiles();
        this.includeFiles = scannerInfo.getIncludeFiles();
        this.localIncludePath = scannerInfo.getLocalIncludePath();
    }

    public IScannerInfo getScannerInfo() {
        if (this.scannerInfo == null) {
            this.scannerInfo = new ExtendedScannerInfo(this.definedSymbols, this.includePaths, this.macroFiles, this.includeFiles, this.localIncludePath);
        }
        return this.scannerInfo;
    }

    public Collection<String> getResourcePaths() {
        return this.resourcePaths != null ? this.resourcePaths : Collections.emptySet();
    }

    public void addResource(IResource resource) {
        if (this.resourcePaths == null) {
            this.resourcePaths = new HashSet<String>();
        }
        this.resourcePaths.add(resource.getFullPath().toString());
    }
}

