/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPBaseClause
implements ICPPBase,
ICPPInternalBase {
    private final ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier base;
    private IType baseClass;
    private boolean inheritedConstructorsSource;

    public CPPBaseClause(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier base) {
        this.base = base;
    }

    @Override
    public IBinding getBaseClass() {
        IType type = this.getBaseClassType();
        if ((type = SemanticUtil.getNestedType(type, 1)) instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        return null;
    }

    @Override
    public IType getBaseClassType() {
        if (this.baseClass == null) {
            ICPPASTNameSpecifier nameSpec = this.base.getNameSpecifier();
            IBinding b = nameSpec.resolveBinding();
            if (b instanceof IProblemBinding) {
                this.baseClass = new CPPClassType.CPPClassTypeProblem(nameSpec, ((IProblemBinding)b).getID());
            } else if (!(b instanceof IType)) {
                this.baseClass = new CPPClassType.CPPClassTypeProblem(nameSpec, 16);
            } else {
                this.baseClass = (IType)((Object)b);
                IType check = SemanticUtil.getNestedType(this.baseClass, 1);
                if (!(check instanceof ICPPClassType) && !(check instanceof ICPPUnknownType)) {
                    this.baseClass = new CPPClassType.CPPClassTypeProblem(nameSpec, 16);
                }
            }
        }
        return this.baseClass;
    }

    @Override
    public int getVisibility() {
        int vis = this.base.getVisibility();
        if (vis == 0) {
            ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)this.base.getParent();
            vis = compSpec.getKey() == 3 ? 3 : 1;
        }
        return vis;
    }

    @Override
    public boolean isVirtual() {
        return this.base.isVirtual();
    }

    @Override
    public boolean isInheritedConstructorsSource() {
        return this.inheritedConstructorsSource;
    }

    @Override
    @Deprecated
    public IName getBaseClassSpecifierName() {
        return this.base.getName();
    }

    @Override
    public IName getClassDefinitionName() {
        IASTNode parent = this.base.getParent();
        if (parent instanceof ICPPASTCompositeTypeSpecifier) {
            return ((ICPPASTCompositeTypeSpecifier)parent).getName();
        }
        return null;
    }

    @Override
    public ICPPBase clone() {
        ICPPBase t = null;
        try {
            t = (ICPPBase)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    @Override
    public void setBaseClass(IBinding cls) {
        if (cls instanceof IType) {
            this.baseClass = (IType)((Object)cls);
        }
    }

    @Override
    public void setBaseClass(IType cls) {
        this.baseClass = cls;
    }

    public void setInheritedConstructorsSource(boolean value) {
        this.inheritedConstructorsSource = value;
    }
}

