/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public class IndexCPPSignatureUtil {
    public static String getSignature(IBinding binding) throws CoreException, DOMException {
        ICPPBinding inst;
        StringBuilder buffer = new StringBuilder();
        if (binding instanceof ICPPDeferredClassInstance) {
            buffer.append(IndexCPPSignatureUtil.getSignature(((ICPPDeferredClassInstance)binding).getTemplateDefinition()));
        }
        if (binding instanceof ICPPTemplateInstance) {
            inst = (ICPPTemplateInstance)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(inst.getTemplateArguments(), true));
        } else if (binding instanceof ICPPUnknownMemberClassInstance) {
            inst = (ICPPUnknownMemberClassInstance)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(inst.getArguments(), true));
        } else if (binding instanceof ICPPClassTemplatePartialSpecialization) {
            ICPPClassTemplatePartialSpecialization partial = (ICPPClassTemplatePartialSpecialization)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(partial.getTemplateArguments(), false));
        }
        if (binding instanceof ICPPFunction) {
            ICPPFunction function = (ICPPFunction)binding;
            IFunctionType ftype = function.getType();
            buffer.append(IndexCPPSignatureUtil.getFunctionParameterString(ftype));
            if (binding instanceof ICPPTemplateDefinition) {
                ICPPTemplateDefinition tdef = (ICPPTemplateDefinition)binding;
                IndexCPPSignatureUtil.appendTemplateParameters(tdef.getTemplateParameters(), buffer);
                ASTTypeUtil.appendType(ftype.getReturnType(), true, buffer);
            }
        }
        if (binding instanceof ICPPMethod && !(binding instanceof ICPPConstructor)) {
            ICPPFunctionType ft = ((ICPPMethod)binding).getType();
            if (ft.isConst()) {
                buffer.append('c');
            }
            if (ft.isVolatile()) {
                buffer.append('v');
            }
            if (ft.hasRefQualifier()) {
                buffer.append('&');
                if (ft.isRValueReference()) {
                    buffer.append('&');
                }
            }
        }
        return buffer.toString();
    }

    private static void appendTemplateParameters(ICPPTemplateParameter[] tpars, StringBuilder buffer) {
        buffer.append('<');
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tpars;
        int n = tpars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            IndexCPPSignatureUtil.appendTemplateParameter(tpar, buffer);
            buffer.append(',');
            ++n2;
        }
        buffer.append('>');
    }

    private static void appendTemplateParameter(ICPPTemplateParameter tpar, StringBuilder buffer) {
        if (tpar instanceof ICPPTemplateNonTypeParameter) {
            ASTTypeUtil.appendType(((ICPPTemplateNonTypeParameter)tpar).getType(), true, buffer);
        } else if (tpar instanceof ICPPTemplateTypeParameter) {
            buffer.append('#');
        } else if (tpar instanceof ICPPTemplateTemplateParameter) {
            buffer.append('#');
            IndexCPPSignatureUtil.appendTemplateParameters(((ICPPTemplateTemplateParameter)tpar).getTemplateParameters(), buffer);
        }
        if (tpar.isParameterPack()) {
            buffer.append("...");
        }
    }

    public static String getTemplateArgString(ICPPTemplateArgument[] args, boolean qualifyTemplateParameters) throws CoreException, DOMException {
        return ASTTypeUtil.getArgumentListString(args, true);
    }

    private static String getFunctionParameterString(IFunctionType functionType) throws DOMException {
        IType[] types = functionType.getParameterTypes();
        if (types.length == 1 && SemanticUtil.isVoidType(types[0])) {
            types = new IType[]{};
        }
        StringBuilder result = new StringBuilder();
        result.append('(');
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                result.append(',');
            }
            ASTTypeUtil.appendType(types[i], true, result);
            ++i;
        }
        if (functionType instanceof ICPPFunctionType && ((ICPPFunctionType)functionType).takesVarArgs()) {
            if (types.length != 0) {
                result.append(',');
            }
            result.append("...");
        }
        result.append(')');
        return result.toString();
    }

    public static Integer getSignatureHash(IBinding binding) throws CoreException, DOMException {
        String sig = IndexCPPSignatureUtil.getSignature(binding);
        return sig.length() == 0 ? null : new Integer(sig.hashCode());
    }

    public static int compareSignatures(IBinding a, IBinding b) {
        try {
            int siga = IndexCPPSignatureUtil.getSignature(a).hashCode();
            int sigb = IndexCPPSignatureUtil.getSignature(b).hashCode();
            return siga < sigb ? -1 : (siga > sigb ? 1 : 0);
        }
        catch (DOMException | CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }
}

