/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IncludeEntry
extends APathEntry
implements IIncludeEntry {
    IPath includePath;
    boolean isSystemInclude;

    public IncludeEntry(IPath resourcePath, IPath basePath, IPath baseRef, IPath includePath, boolean isSystemInclude, IPath[] exclusionPatterns, boolean isExported) {
        super(16, basePath, baseRef, resourcePath, exclusionPatterns, isExported);
        this.includePath = includePath == null ? Path.EMPTY : PathUtil.getCanonicalPathWindows(includePath);
        this.isSystemInclude = isSystemInclude;
    }

    @Override
    public IPath getIncludePath() {
        return this.includePath;
    }

    @Override
    public boolean isSystemInclude() {
        return this.isSystemInclude;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.includePath == null ? 0 : this.includePath.hashCode());
        result = 31 * result + (this.isSystemInclude ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IIncludeEntry) {
            IIncludeEntry otherEntry = (IIncludeEntry)obj;
            if (!super.equals(otherEntry)) {
                return false;
            }
            if (this.path == null ? otherEntry.getPath() != null : !this.path.toString().equals(otherEntry.getPath().toString())) {
                return false;
            }
            if (this.includePath == null ? otherEntry.getIncludePath() != null : !this.includePath.toString().equals(otherEntry.getIncludePath().toString())) {
                return false;
            }
            return this.isSystemInclude == otherEntry.isSystemInclude();
        }
        return super.equals(obj);
    }

    @Override
    public IPath getFullIncludePath() {
        IPath inc = this.getIncludePath();
        if (!this.basePath.isEmpty()) {
            IPath location;
            IResource res;
            IPath loc = this.basePath;
            if (!loc.isAbsolute() && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(loc.append(inc))) != null && (location = res.getLocation()) != null) {
                return location;
            }
            return loc.append(inc);
        }
        if (!inc.isAbsolute()) {
            IPath location;
            IPath resPath = this.getPath();
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(resPath.append(inc));
            if (res != null && (location = res.getLocation()) != null) {
                return location;
            }
        }
        return inc;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.isSystemInclude) {
            sb.append(" isSystemInclude:").append(this.isSystemInclude);
        }
        if (this.includePath != null && !this.includePath.isEmpty()) {
            sb.append(" includePath:").append(this.includePath);
        }
        return sb.toString();
    }
}

