/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.build;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.cdt.core.build.CConsoleParser;
import org.eclipse.cdt.core.build.IConsoleService;
import org.eclipse.cdt.internal.ui.build.CPatternMatchListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class CConsoleService
implements IConsoleService,
IResourceChangeListener {
    private MessageConsole console;
    private MessageConsoleStream out;
    private MessageConsoleStream err;
    private IFolder buildDirectory;
    List<CPatternMatchListener> listeners = new ArrayList<CPatternMatchListener>();

    private void initConsole() {
        this.console = new MessageConsole("C/C++", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        this.out = this.console.newMessageStream();
        this.err = this.console.newMessageStream();
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                CConsoleService.this.out.setColor(display.getSystemColor(2));
                CConsoleService.this.err.setColor(display.getSystemColor(3));
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 8);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 8: {
                if (event.getBuildKind() == 9) break;
                this.console.clearConsole();
            }
        }
    }

    public void monitor(final Process process, CConsoleParser[] consoleParsers, IFolder buildDirectory) throws IOException {
        if (this.console == null) {
            this.initConsole();
        }
        this.buildDirectory = buildDirectory;
        for (CPatternMatchListener listener : this.listeners) {
            this.console.removePatternMatchListener((IPatternMatchListener)listener);
        }
        this.listeners.clear();
        if (consoleParsers != null) {
            CConsoleParser[] cConsoleParserArray = consoleParsers;
            int n = consoleParsers.length;
            int n2 = 0;
            while (n2 < n) {
                CConsoleParser parser = cConsoleParserArray[n2];
                CPatternMatchListener listener = new CPatternMatchListener(this, parser);
                this.listeners.add(listener);
                this.console.addPatternMatchListener((IPatternMatchListener)listener);
                ++n2;
            }
        }
        this.console.activate();
        final CountDownLatch latch = new CountDownLatch(2);
        new Thread("C/C++ Build Console Output"){

            @Override
            public void run() {
                try {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (BufferedReader processOut = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                            String line = processOut.readLine();
                            while (line != null) {
                                CConsoleService.this.out.write(line);
                                CConsoleService.this.out.write(10);
                                line = processOut.readLine();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        latch.countDown();
                    }
                }
                finally {
                    latch.countDown();
                }
            }
        }.start();
        new Thread("C/C++ Build Console Error"){

            @Override
            public void run() {
                try {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (BufferedReader processErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                            String line = processErr.readLine();
                            while (line != null) {
                                CConsoleService.this.err.write(line);
                                CConsoleService.this.out.write(10);
                                line = processErr.readLine();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        latch.countDown();
                    }
                }
                finally {
                    latch.countDown();
                }
            }
        }.start();
        try {
            latch.await();
            process.waitFor();
        }
        catch (InterruptedException e) {
            CUIPlugin.log(e);
        }
    }

    public void writeOutput(String msg) throws IOException {
        if (this.out == null) {
            this.initConsole();
        }
        this.out.write(msg);
    }

    public void writeError(String msg) throws IOException {
        if (this.err == null) {
            this.initConsole();
        }
        this.err.write(msg);
    }

    public IFolder getBuildDirectory() {
        return this.buildDirectory;
    }
}

