/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.tools.launch.core.factory.CdtSpawnerProcessFactory;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;

public class ValgrindCommand {
    protected static final String WHICH_CMD = "which";
    protected static final String VALGRIND_CMD = "valgrind";
    protected Process process;
    protected String[] args;

    public String getValgrindCommand() {
        return VALGRIND_CMD;
    }

    public String whichVersion(IProject project) throws IOException {
        StringBuffer out = new StringBuffer();
        String version = "";
        Process p = RuntimeProcessFactory.getFactory().exec(new String[]{VALGRIND_CMD, "--version"}, project);
        try {
            this.readIntoBuffer(out, p);
            version = out.toString().trim();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return version;
    }

    public void execute(String[] commandArray, Object env, File wd, boolean usePty, IProject project) throws IOException {
        this.args = commandArray;
        try {
            this.process = this.startProcess(commandArray, env, wd, usePty, project);
        }
        catch (IOException e) {
            if (this.process != null) {
                this.process.destroy();
            }
            throw e;
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public String getCommandLine() {
        StringBuffer ret = new StringBuffer();
        String[] stringArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            ret.append(arg).append(" ");
            ++n2;
        }
        return ret.toString().trim();
    }

    private Process startProcess(String[] commandArray, Object env, File workDir, boolean usePty, IProject project) throws IOException {
        if (workDir == null) {
            return CdtSpawnerProcessFactory.getFactory().exec(commandArray, (String[])env, project);
        }
        if (PTY.isSupported() && usePty) {
            return CdtSpawnerProcessFactory.getFactory().exec(commandArray, (String[])env, workDir, new PTY(), project);
        }
        return CdtSpawnerProcessFactory.getFactory().exec(commandArray, (String[])env, workDir, project);
    }

    private void readIntoBuffer(StringBuffer out, Process p) throws IOException {
        if (p == null) {
            throw new IOException("Null Process object: unabled to read input into buffer");
        }
        try {
            int ch;
            InputStream input = p.getInputStream();
            InputStream err = p.getErrorStream();
            boolean success = p.waitFor() == 0;
            InputStream in = success ? input : err;
            while ((ch = in.read()) != -1) {
                out.append((char)ch);
            }
            if (!success) {
                throw new IOException(out.toString());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

