/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.serial;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.cdt.serial.BaudRate;
import org.eclipse.cdt.serial.ByteSize;
import org.eclipse.cdt.serial.Parity;
import org.eclipse.cdt.serial.StopBits;
import org.eclipse.cdt.serial.internal.Messages;

public class SerialPort {
    private final String portName;
    private boolean isOpen;
    private boolean isPaused;
    private Object pauseMutex = new Object();
    private BaudRate baudRate = BaudRate.B115200;
    private ByteSize byteSize = ByteSize.B8;
    private Parity parity = Parity.None;
    private StopBits stopBits = StopBits.S1;
    private long handle;
    private static final String PORT_OPEN = Messages.getString("SerialPort.PortIsOpen");
    private InputStream inputStream = new InputStream(){
        private byte[] rbuff = new byte[256];
        private int rpos = 0;
        private int rlen = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read() throws IOException {
            if (SerialPort.this.isOpen()) {
                if (this.rpos >= this.rlen) {
                    while (true) {
                        this.rlen = SerialPort.this.read1(SerialPort.this.handle, this.rbuff, 0, this.rbuff.length);
                        if (this.rlen < 0) {
                            if (SerialPort.this.isPaused) {
                                Object object = SerialPort.this.pauseMutex;
                                synchronized (object) {
                                    while (SerialPort.this.isPaused) {
                                        try {
                                            SerialPort.this.pauseMutex.wait();
                                        }
                                        catch (InterruptedException e) {
                                            return -1;
                                        }
                                    }
                                }
                            }
                            return -1;
                        }
                        if (this.rlen > 0) break;
                    }
                }
                return this.rbuff[this.rpos++];
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (!SerialPort.this.isOpen()) return -1;
            int n = this.rlen - this.rpos;
            if (n > 0) {
                if (len < n) {
                    n = len;
                }
                System.arraycopy(this.rbuff, this.rpos, b, off, n);
                this.rpos += n;
                return n;
            }
            n = SerialPort.this.read1(SerialPort.this.handle, b, off, len);
            if (n >= 0) return n;
            if (!SerialPort.this.isPaused) return n;
            Object object = SerialPort.this.pauseMutex;
            synchronized (object) {
                while (SerialPort.this.isPaused) {
                    try {
                        SerialPort.this.pauseMutex.wait();
                    }
                    catch (InterruptedException e) {
                        return -1;
                    }
                }
                return SerialPort.this.read1(SerialPort.this.handle, b, off, len);
            }
        }

        @Override
        public void close() throws IOException {
            SerialPort.this.close();
        }
    };
    private OutputStream outputStream = new OutputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            block9: {
                if (SerialPort.this.isOpen()) {
                    try {
                        SerialPort.this.write0(SerialPort.this.handle, b);
                        break block9;
                    }
                    catch (IOException e) {
                        if (!SerialPort.this.isPaused) break block9;
                        Object object = SerialPort.this.pauseMutex;
                        synchronized (object) {
                            while (SerialPort.this.isPaused) {
                                try {
                                    SerialPort.this.pauseMutex.wait();
                                }
                                catch (InterruptedException e1) {
                                    throw e;
                                }
                            }
                        }
                    }
                    SerialPort.this.write0(SerialPort.this.handle, b);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            block9: {
                if (SerialPort.this.isOpen()) {
                    try {
                        SerialPort.this.write1(SerialPort.this.handle, buff, off, len);
                        break block9;
                    }
                    catch (IOException e) {
                        if (!SerialPort.this.isPaused) break block9;
                        Object object = SerialPort.this.pauseMutex;
                        synchronized (object) {
                            while (SerialPort.this.isPaused) {
                                try {
                                    SerialPort.this.pauseMutex.wait();
                                }
                                catch (InterruptedException e1) {
                                    throw e;
                                }
                            }
                        }
                    }
                    SerialPort.this.write1(SerialPort.this.handle, buff, off, len);
                }
            }
        }

        @Override
        public void close() throws IOException {
            SerialPort.this.close();
        }
    };

    static {
        try {
            System.loadLibrary("serial");
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
    }

    public SerialPort(String portName) {
        this.portName = portName;
    }

    private native long open0(String var1, int var2, int var3, int var4, int var5) throws IOException;

    private native void close0(long var1) throws IOException;

    private native int read1(long var1, byte[] var3, int var4, int var5) throws IOException;

    private native void write0(long var1, int var3) throws IOException;

    private native void write1(long var1, byte[] var3, int var4, int var5) throws IOException;

    private static native String getPortName(int var0) throws IOException;

    private static String[] listDevs(final Pattern pattern) {
        File dev = new File("/dev");
        File[] files = dev.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return pattern.matcher(name).matches();
            }
        });
        if (files == null) {
            return new String[0];
        }
        String[] names = new String[files.length];
        int i = 0;
        while (i < files.length) {
            names[i] = files[i].getAbsolutePath();
            ++i;
        }
        return names;
    }

    public static String[] list() throws IOException {
        String osName = System.getProperty("os.name");
        if (osName.equals("Mac OS X")) {
            return SerialPort.listDevs(Pattern.compile("tty\\..*(usbserial|usbmodem).*"));
        }
        if (osName.equals("Linux")) {
            return SerialPort.listDevs(Pattern.compile("ttyUSB.*"));
        }
        if (osName.startsWith("Windows")) {
            ArrayList<String> ports = new ArrayList<String>();
            int i = 0;
            String name = SerialPort.getPortName(i++);
            while (name != null) {
                ports.add(name);
                name = SerialPort.getPortName(i++);
            }
            return ports.toArray(new String[ports.size()]);
        }
        return new String[0];
    }

    public String getPortName() {
        return this.portName;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void open() throws IOException {
        this.handle = this.open0(this.portName, this.baudRate.getRate(), this.byteSize.getSize(), this.parity.ordinal(), this.stopBits.ordinal());
        this.isOpen = true;
    }

    public synchronized void close() throws IOException {
        if (this.isOpen) {
            this.close0(this.handle);
            this.isOpen = false;
            this.handle = 0L;
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void pause() throws IOException {
        this.isPaused = true;
        this.close0(this.handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws IOException {
        Object object = this.pauseMutex;
        synchronized (object) {
            this.isPaused = false;
            this.open();
            this.pauseMutex.notifyAll();
        }
    }

    public void setBaudRate(BaudRate rate) throws IOException {
        if (this.isOpen) {
            throw new IOException(PORT_OPEN);
        }
        this.baudRate = rate;
    }

    public BaudRate getBaudRate() {
        return this.baudRate;
    }

    public void setByteSize(ByteSize size) throws IOException {
        if (this.isOpen) {
            throw new IOException(PORT_OPEN);
        }
        this.byteSize = size;
    }

    public ByteSize getByteSize() {
        return this.byteSize;
    }

    public void setParity(Parity parity) throws IOException {
        if (this.isOpen) {
            throw new IOException(PORT_OPEN);
        }
        this.parity = parity;
    }

    public Parity getParity() {
        return this.parity;
    }

    public void setStopBits(StopBits stopBits) throws IOException {
        if (this.isOpen) {
            throw new IOException(PORT_OPEN);
        }
        this.stopBits = stopBits;
    }

    public StopBits getStopBits() {
        return this.stopBits;
    }
}

