/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeDocumentProvider;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakefileContentOutlinePage;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakefileSourceConfiguration;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IMakefile;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MakefileEditor;
import org.eclipse.cdt.internal.autotools.ui.preferences.AutomakeEditorPreferencePage;
import org.eclipse.cdt.internal.autotools.ui.preferences.AutotoolsEditorPreferenceConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class AutomakeEditor
extends MakefileEditor {
    protected AutomakefileContentOutlinePage ampage;
    private AutomakefileSourceConfiguration sourceViewerConfiguration;
    private static AutomakeEditor fgInstance = new AutomakeEditor();
    private IEditorInput input;

    public static AutomakeEditor getDefault() {
        return fgInstance;
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        super.doSetInput(newInput);
        this.input = newInput;
        this.getOutlinePage().setInput(this.input);
    }

    @Override
    protected void initializeEditor() {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#MakefileEditorContext");
        this.setRulerContextMenuId("#MakefileRulerContext");
        this.setDocumentProvider(AutomakeEditorFactory.getDefault().getAutomakefileDocumentProvider());
        IPreferenceStore[] stores = new IPreferenceStore[]{AutotoolsPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(stores);
        this.setPreferenceStore((IPreferenceStore)chainedStore);
        this.sourceViewerConfiguration = new AutomakefileSourceConfiguration((IPreferenceStore)chainedStore, this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
        AutotoolsEditorPreferenceConstants.initializeDefaultValues(stores[0]);
        AutomakeEditorPreferencePage.initDefaults(stores[0]);
        this.configureInsertMode(SMART_INSERT, false);
        this.setInsertMode(INSERT);
    }

    public AutomakeDocumentProvider getAutomakefileDocumentProvider() {
        return (AutomakeDocumentProvider)AutomakeEditorFactory.getDefault().getAutomakefileDocumentProvider();
    }

    public AutomakefileContentOutlinePage getAutomakeOutlinePage() {
        if (this.ampage == null) {
            this.ampage = new AutomakefileContentOutlinePage(this);
            this.ampage.addSelectionChangedListener(this);
            this.ampage.setInput(this.getEditorInput());
        }
        return this.ampage;
    }

    @Override
    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getAutomakeOutlinePage();
        }
        return super.getAdapter(key);
    }

    public AutomakefileSourceConfiguration getAutomakeSourceViewerConfiguration() {
        return this.sourceViewerConfiguration;
    }

    public IMakefile getMakefile() {
        return this.getAutomakefileDocumentProvider().getWorkingCopy(this.getEditorInput());
    }

    public ISourceViewer getAutomakeSourceViewer() {
        return this.getSourceViewer();
    }
}

