/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.PartServiceImpl;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.MultiPartInitException;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.internal.AbstractWorkingSetManager;
import org.eclipse.ui.internal.ActionSetManager;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.DefaultSaveable;
import org.eclipse.ui.internal.E4PartWrapper;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.NavigationHistory;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveExtensionReader;
import org.eclipse.ui.internal.PerspectiveTagger;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.dialogs.cpd.CustomizePerspectiveDialog;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityView;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayout;
import org.eclipse.ui.internal.e4.compatibility.SelectionService;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.misc.ExternalEditor;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewDescriptor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WorkbenchPage
implements IWorkbenchPage {
    private static final String ATT_AGGREGATE_WORKING_SET_ID = "aggregateWorkingSetId";
    private static final int WINDOW_SCOPE = 13;
    ArrayList<MPart> activationList = new ArrayList();
    private MPerspectiveStack _perspectiveStack;
    private List<String> mruShowInPartIds = new ArrayList<String>();
    private List<ViewReference> viewReferences = new ArrayList<ViewReference>();
    private List<EditorReference> editorReferences = new ArrayList<EditorReference>();
    private List<IPerspectiveDescriptor> sortedPerspectives = new ArrayList<IPerspectiveDescriptor>();
    private ListenerList partListenerList = new ListenerList();
    private ListenerList partListener2List = new ListenerList();
    private IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(final PageChangedEvent event) {
            Object[] listeners;
            Object[] objectArray = listeners = WorkbenchPage.this.partListener2List.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                final Object listener = objectArray[n2];
                if (listener instanceof IPageChangedListener) {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            ((IPageChangedListener)listener).pageChanged(event);
                        }
                    });
                }
                ++n2;
            }
        }
    };
    private E4PartListener e4PartListener = new E4PartListener();
    protected WorkbenchWindow legacyWindow;
    private IAdaptable input;
    private IWorkingSet workingSet;
    private AggregateWorkingSet aggregateWorkingSet;
    private Composite composite;
    private ListenerList propertyChangeListeners = new ListenerList();
    private IActionBars actionBars;
    private ActionSetManager actionSets;
    private NavigationHistory navigationHistory = new NavigationHistory(this);
    private IWorkbenchPartReference partBeingActivated = null;
    private IPropertyChangeListener workingSetPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("workingSetRemove".equals(property)) {
                ArrayList<IWorkingSet> newList;
                if (event.getOldValue().equals(WorkbenchPage.this.workingSet)) {
                    WorkbenchPage.this.setWorkingSet(null);
                }
                if ((newList = new ArrayList<IWorkingSet>(Arrays.asList(WorkbenchPage.this.workingSets))).remove(event.getOldValue())) {
                    WorkbenchPage.this.setWorkingSets(newList.toArray(new IWorkingSet[newList.size()]));
                }
            }
        }
    };
    private ActionSwitcher actionSwitcher = new ActionSwitcher();
    private IExtensionTracker tracker;
    private int deferCount = 0;
    private IWorkingSet[] workingSets = new IWorkingSet[0];
    private String aggregateWorkingSetId;
    private long maxFileSize = 0L;
    private boolean checkDocumentSize;
    private EPartService partService;
    private SelectionService selectionService;
    private MApplication application;
    private MWindow window;
    private EModelService modelService;
    private IEventBroker broker;
    private EventHandler widgetHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MPart changedPart;
            Object impl;
            Object element = event.getProperty("ChangedElement");
            Object newValue = event.getProperty("NewValue");
            if (element instanceof MArea) {
                if (WorkbenchPage.this.modelService.findElements((MUIElement)WorkbenchPage.this.window, null, MArea.class, null).contains(element) && newValue instanceof Control) {
                    WorkbenchPage.this.installAreaDropSupport((Control)newValue);
                }
            } else if (element instanceof MPart && newValue == null && (impl = (changedPart = (MPart)element).getObject()) != null && !(impl instanceof CompatibilityPart)) {
                ViewReference vRef;
                EditorReference eRef = WorkbenchPage.this.getEditorReference(changedPart);
                if (eRef != null) {
                    WorkbenchPage.this.editorReferences.remove(eRef);
                }
                if ((vRef = WorkbenchPage.this.getViewReference(changedPart)) != null) {
                    WorkbenchPage.this.viewReferences.remove(vRef);
                }
            }
        }
    };
    private boolean dndSupportInstalled = false;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MStackElement element;
            Object changedElement = event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            List theStack = WorkbenchPage.this.modelService.findElements((MUIElement)WorkbenchPage.this.window, null, MPerspectiveStack.class, null);
            if (theStack.isEmpty()) {
                return;
            }
            if (!theStack.isEmpty() && changedElement != theStack.get(0)) {
                return;
            }
            MPerspective oldPersp = (MPerspective)event.getProperty("OldValue");
            MPerspective newPersp = (MPerspective)event.getProperty("NewValue");
            ArrayList<MPart> hiddenParts = new ArrayList<MPart>();
            ArrayList<MPart> visibleParts = new ArrayList<MPart>();
            List oldStacks = WorkbenchPage.this.getPartStacks(oldPersp);
            List newStacks = WorkbenchPage.this.getPartStacks(newPersp);
            for (MPartStack oldStack : oldStacks) {
                element = (MStackElement)oldStack.getSelectedElement();
                if (element instanceof MPlaceholder) {
                    hiddenParts.add((MPart)((MPlaceholder)element).getRef());
                    continue;
                }
                if (!(element instanceof MPart)) continue;
                hiddenParts.add((MPart)element);
            }
            for (MPartStack newStack : newStacks) {
                element = (MStackElement)newStack.getSelectedElement();
                if (element instanceof MPlaceholder) {
                    visibleParts.add((MPart)((MPlaceholder)element).getRef());
                    continue;
                }
                if (!(element instanceof MPart)) continue;
                visibleParts.add((MPart)element);
            }
            ArrayList<MPart> ignoredParts = new ArrayList<MPart>();
            for (MPart hiddenPart : hiddenParts) {
                if (!visibleParts.contains(hiddenPart)) continue;
                ignoredParts.add(hiddenPart);
            }
            hiddenParts.removeAll(ignoredParts);
            visibleParts.removeAll(ignoredParts);
            for (MPart hiddenPart : hiddenParts) {
                WorkbenchPage.this.firePartHidden(hiddenPart);
            }
            for (MPart visiblePart : visibleParts) {
                WorkbenchPage.this.firePartVisible(visiblePart);
            }
            WorkbenchPage.this.updateActionSets(WorkbenchPage.this.getPerspective(oldPersp), WorkbenchPage.this.getPerspective(newPersp));
            if (newPersp != null) {
                IPerspectiveDescriptor perspective = WorkbenchPage.this.getPerspectiveDesc(newPersp.getElementId());
                WorkbenchPage.this.legacyWindow.firePerspectiveActivated(WorkbenchPage.this, perspective);
                WorkbenchPage.this.sortedPerspectives.remove(perspective);
                WorkbenchPage.this.sortedPerspectives.add(perspective);
            }
            WorkbenchPage.this.legacyWindow.updateActionSets();
        }
    };
    private HashMap<MPerspective, Perspective> modelToPerspectiveMapping = new HashMap();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private WeakHashMap<MPart, Integer> partEvents = new WeakHashMap();
    private static final int FIRE_PART_VISIBLE = 1;
    private static final int FIRE_PART_BROUGHTTOTOP = 2;
    private EventHandler firingHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Integer events;
            Object element = event.getProperty("ChangedElement");
            Object value = event.getProperty("NewValue");
            if (value instanceof CompatibilityPart && element instanceof MPart && (events = (Integer)WorkbenchPage.this.partEvents.remove(element)) != null) {
                int e = events;
                if ((e & 1) == 1) {
                    WorkbenchPage.this.firePartVisible((MPart)element);
                }
                if ((e & 2) == 2) {
                    WorkbenchPage.this.firePartBroughtToTop((MPart)element);
                }
            }
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object changedObj = event.getProperty("ChangedElement");
            MUIElement changedElement = (MUIElement)changedObj;
            if (WorkbenchPage.this.modelService.getTopLevelWindowFor(changedElement) != WorkbenchPage.this.window) {
                return;
            }
            if (UIEvents.isADD((Event)event)) {
                for (Object o : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                    if (!(o instanceof MUIElement)) continue;
                    MUIElement element = (MUIElement)o;
                    List addedParts = WorkbenchPage.this.modelService.findElements(element, null, MPart.class, null);
                    for (MPart part : addedParts) {
                        IWorkbenchPartReference ref = (IWorkbenchPartReference)part.getTransientData().get(IWorkbenchPartReference.class.getName());
                        if (!(ref instanceof EditorReference) || WorkbenchPage.this.getEditorReference(part) != null) continue;
                        WorkbenchPage.this.addEditorReference((EditorReference)ref);
                    }
                }
            }
        }
    };
    private EventHandler referenceRemovalEventHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (Boolean.TRUE.equals(event.getProperty("NewValue"))) {
                return;
            }
            Object element = event.getProperty("ChangedElement");
            if (element instanceof MPlaceholder) {
                MUIElement ref = ((MPlaceholder)element).getRef();
                WorkbenchPage.this.unzoomSharedArea(ref);
                if (ref instanceof MPart) {
                    List placeholders = WorkbenchPage.this.modelService.findElements((MUIElement)WorkbenchPage.this.window, ref.getElementId(), MPlaceholder.class, null, 13);
                    for (MPlaceholder placeholder : placeholders) {
                        if (placeholder.getRef() != ref || !placeholder.isToBeRendered()) continue;
                        return;
                    }
                    ViewReference reference = WorkbenchPage.this.getViewReference((MPart)ref);
                    if (reference != null) {
                        reference.unsubscribe();
                    }
                }
            } else if (element instanceof MPart) {
                EditorReference reference;
                MPart part = (MPart)element;
                WorkbenchPage.this.unzoomSharedArea((MUIElement)part);
                if ("org.eclipse.e4.ui.compatibility.editor".equals(part.getElementId()) && (reference = WorkbenchPage.this.getEditorReference(part)) != null) {
                    reference.unsubscribe();
                }
            }
        }
    };

    private void deactivateLastEditor(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityEditor) {
            for (MPart previouslyActive : this.activationList) {
                Object object;
                if (previouslyActive == part || !((object = previouslyActive.getObject()) instanceof CompatibilityEditor)) continue;
                EditorSite site = (EditorSite)((CompatibilityEditor)object).getPart().getSite();
                String lastId = site.getId();
                String activeId = ((CompatibilityEditor)client).getPart().getSite().getId();
                if (lastId == null || lastId.equals(activeId)) break;
                site.deactivateActionBars(true);
                break;
            }
        }
    }

    private void updateActivations(MPart part) {
        IWorkbenchPart workbenchPart;
        if (this.activationList.size() > 1) {
            this.deactivateLastEditor(part);
        }
        this.activationList.remove(part);
        this.activationList.add(0, part);
        this.updateActivePartSources(part);
        this.updateActiveEditorSources(part);
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            workbenchPart = ((CompatibilityPart)client).getPart();
            PartSite site = (PartSite)workbenchPart.getSite();
            site.activateActionBars(true);
            IActionBars actionBars = site.getActionBars();
            if (actionBars instanceof EditorActionBars) {
                ((EditorActionBars)actionBars).partChanged(workbenchPart);
            }
        }
        ((WorkbenchWindow)this.getWorkbenchWindow()).getStatusLineManager().update(false);
        workbenchPart = this.getWorkbenchPart(part);
        this.actionSwitcher.updateActivePart(workbenchPart);
    }

    private void updateActivePartSources(MPart part) {
        IWorkbenchPart workbenchPart = this.getWorkbenchPart(part);
        if (workbenchPart == null) {
            this.window.getContext().set("activePart", null);
            this.window.getContext().set("activePartId", null);
            this.window.getContext().set("activeSite", null);
        } else {
            this.window.getContext().set("activePart", (Object)workbenchPart);
            this.window.getContext().set("activePartId", (Object)workbenchPart.getSite().getId());
            this.window.getContext().set("activeSite", (Object)workbenchPart.getSite());
        }
    }

    private void updateActionSets(Perspective oldPersp, Perspective newPersp) {
        IContextService service = (IContextService)this.legacyWindow.getService(IContextService.class);
        try {
            IActionSetDescriptor descriptor;
            service.deferUpdates(true);
            if (newPersp != null) {
                List<IActionSetDescriptor> newAlwaysOn = newPersp.getAlwaysOnActionSets();
                int i = 0;
                while (i < newAlwaysOn.size()) {
                    IActionSetDescriptor descriptor2 = newAlwaysOn.get(i);
                    this.actionSets.showAction(descriptor2);
                    ++i;
                }
                List<IActionSetDescriptor> newAlwaysOff = newPersp.getAlwaysOffActionSets();
                int i2 = 0;
                while (i2 < newAlwaysOff.size()) {
                    descriptor = newAlwaysOff.get(i2);
                    this.actionSets.maskAction(descriptor);
                    ++i2;
                }
            }
            if (oldPersp != null) {
                List<IActionSetDescriptor> oldAlwaysOn = oldPersp.getAlwaysOnActionSets();
                int i = 0;
                while (i < oldAlwaysOn.size()) {
                    IActionSetDescriptor descriptor3 = oldAlwaysOn.get(i);
                    this.actionSets.hideAction(descriptor3);
                    ++i;
                }
                List<IActionSetDescriptor> oldAlwaysOff = oldPersp.getAlwaysOffActionSets();
                int i3 = 0;
                while (i3 < oldAlwaysOff.size()) {
                    descriptor = oldAlwaysOff.get(i3);
                    this.actionSets.unmaskAction(descriptor);
                    ++i3;
                }
            }
        }
        finally {
            service.deferUpdates(false);
        }
    }

    private IWorkbenchPart getWorkbenchPart(MPart part) {
        if (part != null) {
            Object clientObject = part.getObject();
            if (clientObject instanceof CompatibilityPart) {
                return ((CompatibilityPart)clientObject).getPart();
            }
            if (clientObject != null) {
                if (part.getTransientData().get("e4Wrapper") instanceof E4PartWrapper) {
                    return (IWorkbenchPart)part.getTransientData().get("e4Wrapper");
                }
                ViewReference viewReference = this.getViewReference(part);
                if (viewReference != null) {
                    E4PartWrapper legacyPart = new E4PartWrapper(part);
                    try {
                        viewReference.initialize(legacyPart);
                    }
                    catch (PartInitException e) {
                        WorkbenchPlugin.log((Throwable)((Object)e));
                    }
                    part.getTransientData().put("e4Wrapper", legacyPart);
                    return legacyPart;
                }
            }
        }
        return null;
    }

    private void updateActiveEditorSources(MPart part) {
        IEditorPart editor = this.getEditor(part);
        this.window.getContext().set("activeEditorId", editor == null ? null : editor.getSite().getId());
        this.window.getContext().set("activeEditor", (Object)editor);
        this.window.getContext().set("activeEditorInput", (Object)(editor == null ? null : editor.getEditorInput()));
        if (editor != null) {
            this.navigationHistory.markEditor(editor);
        }
        this.actionSwitcher.updateTopEditor(editor);
    }

    public void updateShowInSources(MPart part) {
        IWorkbenchPart workbenchPart = this.getWorkbenchPart(part);
        ShowInContext context = this.getContext(workbenchPart);
        if (context != null) {
            this.window.getContext().set("showInInput", context.getInput());
            this.window.getContext().set("showInSelection", (Object)context.getSelection());
        }
    }

    private IShowInSource getShowInSource(IWorkbenchPart sourcePart) {
        return (IShowInSource)Adapters.adapt((Object)sourcePart, IShowInSource.class);
    }

    private ShowInContext getContext(IWorkbenchPart sourcePart) {
        IShowInSource source = this.getShowInSource(sourcePart);
        if (source != null) {
            ShowInContext context = source.getShowInContext();
            if (context != null) {
                return context;
            }
        } else if (sourcePart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)sourcePart).getEditorInput();
            ISelectionProvider sp = sourcePart.getSite().getSelectionProvider();
            ISelection sel = sp == null ? null : sp.getSelection();
            return new ShowInContext(input, sel);
        }
        return null;
    }

    private IEditorPart getEditor(MPart part) {
        Object clientObject;
        if (part != null && (clientObject = part.getObject()) instanceof CompatibilityEditor) {
            return ((CompatibilityEditor)clientObject).getEditor();
        }
        return this.getActiveEditor();
    }

    private void updateBroughtToTop(MPart part) {
        MElementContainer parent;
        this.updateActiveEditorSources(part);
        IWorkbenchPart workbenchPart = this.getWorkbenchPart(part);
        if (workbenchPart instanceof IEditorPart) {
            this.navigationHistory.markEditor((IEditorPart)workbenchPart);
        }
        if ((parent = part.getParent()) == null) {
            MPlaceholder placeholder = part.getCurSharedRef();
            if (placeholder == null) {
                return;
            }
            parent = placeholder.getParent();
        }
        if (parent instanceof MPartStack) {
            int newIndex = this.lastIndexOfContainer(parent);
            if (newIndex >= 0 && part == this.activationList.get(newIndex)) {
                return;
            }
            this.activationList.remove(part);
            if (newIndex >= 0 && newIndex < this.activationList.size() - 1) {
                this.activationList.add(newIndex, part);
            } else {
                this.activationList.add(part);
            }
        }
    }

    private int lastIndexOfContainer(MElementContainer<?> parent) {
        int i = 0;
        while (i < this.activationList.size()) {
            MPlaceholder placeholder;
            MPart mPart = this.activationList.get(i);
            MElementContainer container = mPart.getParent();
            if (container == parent) {
                return i;
            }
            if (container == null && (placeholder = mPart.getCurSharedRef()) != null && placeholder.getParent() == parent) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Inject
    @Optional
    private void handleMinimizedStacks(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        MPlaceholder ph;
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MToolControl)) {
            return;
        }
        MToolControl minimizedStack = (MToolControl)changedObj;
        if (!(minimizedStack.getObject() instanceof TrimStack)) {
            return;
        }
        TrimStack ts = (TrimStack)minimizedStack.getObject();
        if (!(ts.getMinimizedElement() instanceof MPartStack)) {
            return;
        }
        MPartStack stack = (MPartStack)ts.getMinimizedElement();
        MUIElement stackSel = stack.getSelectedElement();
        MPart thePart = null;
        if (stackSel instanceof MPart) {
            thePart = (MPart)stackSel;
        } else if (stackSel instanceof MPlaceholder && (ph = (MPlaceholder)stackSel).getRef() instanceof MPart) {
            thePart = (MPart)ph.getRef();
        }
        if (thePart == null) {
            return;
        }
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)"MinimizedAndShowing")) {
                this.firePartVisible(thePart);
            }
        } else if (UIEvents.isREMOVE((Event)event) && UIEvents.contains((Event)event, (String)"OldValue", (Object)"MinimizedAndShowing")) {
            this.firePartHidden(thePart);
        }
    }

    public WorkbenchPage(WorkbenchWindow w, IAdaptable input) throws WorkbenchException {
        this.init(w, null, input, false);
    }

    public MWindow getWindowModel() {
        return this.window;
    }

    @Override
    public void activate(IWorkbenchPart part) {
        if (part == null || !this.certifyPart(part) || this.legacyWindow.isClosing()) {
            return;
        }
        MPart mpart = this.findPart(part);
        if (mpart != null) {
            this.partService.activate(mpart);
            this.actionSwitcher.updateActivePart(part);
        }
    }

    @Override
    public void addPartListener(IPartListener l) {
        this.partListenerList.add((Object)l);
    }

    @Override
    public void addPartListener(IPartListener2 l) {
        this.partListener2List.add((Object)l);
    }

    @Override
    @Deprecated
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        this.selectionService.addSelectionListener(listener);
    }

    @Override
    public void addSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.addSelectionListener(partId, listener);
    }

    @Override
    public void addPostSelectionListener(ISelectionListener listener) {
        this.selectionService.addPostSelectionListener(listener);
    }

    @Override
    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.addPostSelectionListener(partId, listener);
    }

    @Override
    public void bringToTop(IWorkbenchPart part) {
        MPart mpart = this.findPart(part);
        if (mpart != null) {
            this.partService.bringToTop(mpart);
        }
    }

    public MPart findPart(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        for (IViewReference iViewReference : this.viewReferences) {
            if (part != iViewReference.getPart(false)) continue;
            return ((WorkbenchPartReference)((Object)iViewReference)).getModel();
        }
        for (IEditorReference iEditorReference : this.editorReferences) {
            if (part != iEditorReference.getPart(false)) continue;
            return ((WorkbenchPartReference)((Object)iEditorReference)).getModel();
        }
        return null;
    }

    public EditorReference createEditorReferenceForPart(MPart part, IEditorInput input, String editorId, IMemento memento) {
        IEditorRegistry registry = this.legacyWindow.getWorkbench().getEditorRegistry();
        EditorDescriptor descriptor = (EditorDescriptor)registry.findEditor(editorId);
        EditorReference ref = new EditorReference(this.window.getContext(), this, part, input, descriptor, memento);
        this.addEditorReference(ref);
        ref.subscribe();
        return ref;
    }

    private List<EditorReference> getOrderedEditorReferences() {
        ArrayList<EditorReference> editorRefs = new ArrayList<EditorReference>();
        List visibleEditors = this.modelService.findElements((MUIElement)this.window, "org.eclipse.e4.ui.compatibility.editor", MPart.class, null);
        for (MPart editor : visibleEditors) {
            EditorReference ref;
            if (!editor.isToBeRendered() || (ref = this.getEditorReference(editor)) == null || editorRefs.contains(ref)) continue;
            editorRefs.add(ref);
        }
        return editorRefs;
    }

    List<EditorReference> getSortedEditorReferences() {
        return this.getSortedEditorReferences(false);
    }

    private List<EditorReference> getSortedEditorReferences(boolean allPerspectives) {
        ArrayList<EditorReference> sortedReferences = new ArrayList<EditorReference>();
        block0: for (MPart part : this.activationList) {
            for (EditorReference ref : this.editorReferences) {
                if (ref.getModel() != part) continue;
                sortedReferences.add(ref);
                continue block0;
            }
        }
        for (EditorReference ref : this.editorReferences) {
            if (sortedReferences.contains(ref)) continue;
            sortedReferences.add(ref);
        }
        MPerspective currentPerspective = this.getCurrentPerspective();
        if (currentPerspective != null) {
            int scope = allPerspectives ? 13 : 11;
            List placeholders = this.modelService.findElements((MUIElement)this.window, "org.eclipse.e4.ui.compatibility.editor", MPart.class, null, scope);
            ArrayList<EditorReference> visibleReferences = new ArrayList<EditorReference>();
            for (EditorReference reference : sortedReferences) {
                for (MPart placeholder : placeholders) {
                    if (reference.getModel() != placeholder || !placeholder.isToBeRendered()) continue;
                    visibleReferences.add(reference);
                }
            }
            return visibleReferences;
        }
        return sortedReferences;
    }

    public List<EditorReference> getInternalEditorReferences() {
        return this.editorReferences;
    }

    public EditorReference getEditorReference(MPart part) {
        for (EditorReference ref : this.editorReferences) {
            if (ref.getModel() != part) continue;
            return ref;
        }
        return null;
    }

    public ViewReference getViewReference(MPart part) {
        for (ViewReference ref : this.viewReferences) {
            if (ref.getModel() != part) continue;
            return ref;
        }
        return null;
    }

    private boolean contains(ViewReference reference) {
        for (ViewReference viewReference : this.viewReferences) {
            if (!reference.getModel().getElementId().equals(viewReference.getModel().getElementId())) continue;
            return true;
        }
        return false;
    }

    public void addViewReference(ViewReference reference) {
        if (!this.contains(reference)) {
            this.viewReferences.add(reference);
        }
    }

    public void addEditorReference(EditorReference editorReference) {
        WorkbenchPage curPage = (WorkbenchPage)editorReference.getPage();
        if (curPage != this) {
            curPage.editorReferences.remove(editorReference);
            editorReference.setPage(this);
        }
        if (!this.editorReferences.contains(editorReference)) {
            this.editorReferences.add(editorReference);
        }
    }

    MPartDescriptor findDescriptor(String id) {
        return this.modelService.getPartDescriptor(id);
    }

    private MPart findPart(String viewId, int searchFlags) {
        List parts = this.modelService.findElements((MUIElement)this.getWindowModel(), viewId, MPart.class, null, searchFlags);
        if (parts.size() > 0) {
            return (MPart)parts.get(0);
        }
        return null;
    }

    EPartService.PartState convert(int mode) {
        switch (mode) {
            case 1: {
                return EPartService.PartState.ACTIVATE;
            }
            case 2: {
                return EPartService.PartState.VISIBLE;
            }
            case 3: {
                return EPartService.PartState.CREATE;
            }
        }
        throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalViewMode);
    }

    protected IViewPart busyShowView(String viewId, int mode) throws PartInitException {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalViewMode);
            }
        }
        MPart part = this.findPart(viewId, 29);
        if (part == null) {
            MPlaceholder ph = this.partService.createSharedPart(viewId, false);
            if (ph == null) {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotCreate, (Object)viewId));
            }
            part = (MPart)ph.getRef();
            part.setCurSharedRef(ph);
        }
        part = this.showPart(mode, part);
        ViewReference ref = this.getViewReference(part);
        return (IViewPart)ref.getPart(true);
    }

    private MPart showPart(int mode, MPart part) {
        switch (mode) {
            case 1: {
                this.partService.showPart(part, EPartService.PartState.ACTIVATE);
                if (!(part.getObject() instanceof CompatibilityView)) break;
                CompatibilityView compatibilityView = (CompatibilityView)part.getObject();
                this.actionSwitcher.updateActivePart(compatibilityView.getPart());
                break;
            }
            case 2: {
                MPart activePart = this.partService.getActivePart();
                if (activePart == null) {
                    this.partService.showPart(part, EPartService.PartState.ACTIVATE);
                    if (!(part.getObject() instanceof CompatibilityView)) break;
                    CompatibilityView compatibilityView = (CompatibilityView)part.getObject();
                    this.actionSwitcher.updateActivePart(compatibilityView.getPart());
                    break;
                }
                part = ((PartServiceImpl)this.partService).addPart(part);
                MPlaceholder activePlaceholder = activePart.getCurSharedRef();
                MElementContainer activePartParent = activePlaceholder == null ? activePart.getParent() : activePlaceholder.getParent();
                this.partService.showPart(part, EPartService.PartState.CREATE);
                if (part.getCurSharedRef() != null && part.getCurSharedRef().getParent() == activePartParent) break;
                this.partService.bringToTop(part);
                break;
            }
            case 3: {
                MElementContainer parentElement;
                this.partService.showPart(part, EPartService.PartState.CREATE);
                MPart sElement = part;
                if (part.getCurSharedRef() != null) {
                    sElement = part.getCurSharedRef();
                }
                if ((parentElement = sElement.getParent()) instanceof MPartStack) {
                    MPartStack partStack = (MPartStack)parentElement;
                    if (partStack.getSelectedElement() == sElement && !partStack.getTags().contains("Minimized")) {
                        this.firePartVisible(part);
                        break;
                    }
                    this.firePartHidden(part);
                    break;
                }
                this.firePartVisible(part);
            }
        }
        return part;
    }

    private boolean certifyPart(IWorkbenchPart part) {
        return part == null || part.getSite() instanceof PartSite;
    }

    @Override
    public boolean close() {
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                ret[0] = WorkbenchPage.this.close(true, true);
            }
        });
        return ret[0];
    }

    public boolean closeAllSavedEditors() {
        IEditorReference[] editors = this.getEditorReferences();
        IEditorReference[] savedEditors = new IEditorReference[editors.length];
        int j = 0;
        int i = 0;
        while (i < editors.length) {
            IEditorReference editor = editors[i];
            if (!editor.isDirty()) {
                savedEditors[j++] = editor;
            }
            ++i;
        }
        if (j == 0) {
            return true;
        }
        IEditorReference[] newSaved = new IEditorReference[j];
        System.arraycopy(savedEditors, 0, newSaved, 0, j);
        return this.closeEditors(newSaved, false);
    }

    @Override
    public boolean closeAllEditors(boolean save) {
        return this.closeEditors(this.getEditorReferences(), save);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean closeEditors(IEditorReference[] refArray, boolean save) {
        boolean bl;
        void var4_5;
        if (refArray.length == 0) {
            return true;
        }
        ArrayList<IEditorReference> editorRefs = new ArrayList<IEditorReference>();
        boolean bl2 = false;
        while (var4_5 < refArray.length) {
            WorkbenchPartReference ref;
            IEditorReference iEditorReference = refArray[var4_5];
            if (iEditorReference == this.partBeingActivated) {
                WorkbenchPlugin.log(new RuntimeException("WARNING: Blocked recursive attempt to close part " + this.partBeingActivated.getId() + " while still in the middle of activating it"));
                return false;
            }
            if (!(iEditorReference instanceof WorkbenchPartReference) || !(ref = (WorkbenchPartReference)((Object)iEditorReference)).isDisposed()) {
                editorRefs.add(iEditorReference);
            }
            ++var4_5;
        }
        for (IEditorReference iEditorReference : editorRefs) {
            IEditorPart oldPart = iEditorReference.getEditor(false);
            if (oldPart != null && this.navigationHistory.updateActive(oldPart)) break;
        }
        ArrayList<IWorkbenchPart> arrayList = new ArrayList<IWorkbenchPart>();
        for (IEditorReference iEditorReference : editorRefs) {
            IEditorPart refPart = iEditorReference.getEditor(false);
            if (refPart == null) continue;
            arrayList.add(refPart);
        }
        boolean bl3 = true;
        SaveablesList modelManager = null;
        Object postCloseInfo = null;
        if (arrayList.size() > 0) {
            modelManager = (SaveablesList)this.getWorkbenchWindow().getService(ISaveablesLifecycleListener.class);
            postCloseInfo = modelManager.preCloseParts(arrayList, save, this.getWorkbenchWindow());
            if (postCloseInfo == null) {
                return false;
            }
            bl = false;
        }
        for (IEditorReference iEditorReference : editorRefs) {
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), iEditorReference, "editorClose");
        }
        this.deferUpdates(true);
        try {
            if (modelManager != null) {
                modelManager.postClose(postCloseInfo);
            }
            Iterator iterator = editorRefs.iterator();
            while (iterator.hasNext()) {
                IEditorReference ref = (IEditorReference)iterator.next();
                if (ref.getPart(false) != null) continue;
                if (!this.hidePart(((EditorReference)ref).getModel(), false, bl, false, false)) {
                    return false;
                }
                iterator.remove();
            }
            MPart mPart = this.findPart(this.getActiveEditor());
            boolean closeActivePart = false;
            for (IEditorReference iEditorReference : editorRefs) {
                MPart model = ((EditorReference)iEditorReference).getModel();
                if (mPart == model) {
                    closeActivePart = true;
                    continue;
                }
                if (this.hidePart(model, false, bl, false, false)) continue;
                return false;
            }
            if (closeActivePart && !this.hidePart(mPart, false, bl, false)) {
                return false;
            }
        }
        finally {
            this.deferUpdates(false);
        }
        this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "editorClose");
        return true;
    }

    public boolean closeEditor(IEditorReference editor) {
        if (this.getInternalEditorReferences().contains(editor)) {
            MPart part = ((EditorReference)editor).getModel();
            this.hidePart(part, false, false, false, false);
            MElementContainer parent = part.getParent();
            if (parent != null) {
                parent.getChildren().remove(part);
            }
            return true;
        }
        return false;
    }

    private boolean hidePart(MPart part, boolean save, boolean confirm, boolean force) {
        return this.hidePart(part, save, confirm, force, true);
    }

    private boolean hidePart(MPart part, boolean save, boolean confirm, boolean force, boolean local) {
        ISaveablePart iSaveablePart;
        if (!this.partService.getParts().contains(part)) {
            if (local) {
                return false;
            }
            part.setToBeRendered(false);
            return true;
        }
        Object clientObject = part.getObject();
        if (!(clientObject instanceof CompatibilityPart)) {
            if (save) {
                if (this.partService.savePart(part, confirm)) {
                    this.partService.hidePart(part, force);
                    return true;
                }
                return false;
            }
            this.partService.hidePart(part, force);
            return true;
        }
        CompatibilityPart compatibilityPart = (CompatibilityPart)clientObject;
        IWorkbenchPart workbenchPart = compatibilityPart.getPart();
        if (save && (iSaveablePart = SaveableHelper.getSaveable(workbenchPart)) != null && iSaveablePart.isSaveOnCloseNeeded() && !this.saveSaveable(iSaveablePart, workbenchPart, confirm, true)) {
            return false;
        }
        for (IViewReference iViewReference : this.viewReferences) {
            if (workbenchPart != iViewReference.getPart(false)) continue;
            this.partService.hidePart(part, force);
            return true;
        }
        for (IEditorReference iEditorReference : this.editorReferences) {
            if (workbenchPart != iEditorReference.getPart(false)) continue;
            this.partService.hidePart(part, force);
            return true;
        }
        return false;
    }

    private void deferUpdates(boolean shouldDefer) {
        if (shouldDefer) {
            if (this.deferCount == 0) {
                this.startDeferring();
            }
            ++this.deferCount;
        } else {
            --this.deferCount;
            if (this.deferCount == 0) {
                this.handleDeferredEvents();
            }
        }
    }

    private void startDeferring() {
    }

    private void handleDeferredEvents() {
    }

    public boolean closeEditor(IEditorReference editorRef, boolean save) {
        return this.closeEditors(new IEditorReference[]{editorRef}, save);
    }

    @Override
    public boolean closeEditor(IEditorPart editor, boolean save) {
        IWorkbenchPartReference ref = this.getReference(editor);
        if (ref instanceof IEditorReference) {
            return this.closeEditors(new IEditorReference[]{(IEditorReference)ref}, save);
        }
        return false;
    }

    private void closePerspective(IPerspectiveDescriptor desc, String perspectiveId, boolean saveParts) {
        MPerspective persp = (MPerspective)this.modelService.find(perspectiveId, (MUIElement)this.window);
        if (persp != null) {
            IPerspectiveDescriptor lastActive;
            if (saveParts) {
                ArrayList<IWorkbenchPart> partsToSave = new ArrayList<IWorkbenchPart>();
                List parts = this.modelService.findElements((MUIElement)persp, null, MPart.class, null);
                if (!parts.isEmpty()) {
                    for (MPerspective perspective : this.getPerspectiveStack().getChildren()) {
                        if (perspective == persp) continue;
                        parts.removeAll(this.modelService.findElements((MUIElement)perspective, null, MPart.class, null));
                    }
                    if (!parts.isEmpty()) {
                        Iterator it = parts.iterator();
                        while (it.hasNext()) {
                            MPart part = (MPart)it.next();
                            if (part.isDirty()) {
                                IWorkbenchPart workbenchPart;
                                ISaveablePart saveablePart;
                                Object object = part.getObject();
                                if (!(object instanceof CompatibilityPart) || (saveablePart = SaveableHelper.getSaveable(workbenchPart = ((CompatibilityPart)object).getPart())) == null) continue;
                                if (!saveablePart.isSaveOnCloseNeeded()) {
                                    part.setDirty(false);
                                    it.remove();
                                    continue;
                                }
                                partsToSave.add(workbenchPart);
                                continue;
                            }
                            it.remove();
                        }
                        if (!partsToSave.isEmpty() && !WorkbenchPage.saveAll(partsToSave, true, true, false, this.legacyWindow, this.legacyWindow)) {
                            return;
                        }
                    }
                }
            }
            this.sortedPerspectives.remove(desc);
            if (this.getPerspectiveStack().getSelectedElement() == persp && !this.sortedPerspectives.isEmpty() && (lastActive = this.sortedPerspectives.get(this.sortedPerspectives.size() - 1)) != null) {
                this.setPerspective(lastActive);
            }
            this.modelService.removePerspectiveModel(persp, this.window);
            this.modelToPerspectiveMapping.remove(persp);
            this.legacyWindow.firePerspectiveClosed(this, desc);
        }
    }

    @Override
    public void closePerspective(IPerspectiveDescriptor desc, boolean saveParts, boolean closePage) {
        this.closePerspective(desc, desc.getId(), saveParts, closePage);
    }

    public void closePerspective(IPerspectiveDescriptor desc, String perspectiveId, boolean saveParts, boolean closePage) {
        MPerspective persp = (MPerspective)this.modelService.find(perspectiveId, (MUIElement)this.window);
        if (persp != null) {
            persp.getTags().add("PerspClosing");
            try {
                MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null).get(0);
                if (perspectiveStack.getChildren().size() == 1) {
                    this.closeAllPerspectives(saveParts, closePage);
                } else {
                    this.closePerspective(desc, perspectiveId, saveParts);
                }
            }
            finally {
                persp.getTags().remove("PerspClosing");
            }
        }
    }

    @Override
    public void closeAllPerspectives(boolean saveEditors, boolean closePage) {
        boolean okToProceed = this.closeAllEditors(true);
        if (okToProceed) {
            ArrayList kids = new ArrayList(this._perspectiveStack.getChildren());
            MPerspective curPersp = (MPerspective)this._perspectiveStack.getSelectedElement();
            for (MPerspective persp : kids) {
                if (persp == curPersp) continue;
                this.closePerspective(this.getPerspectiveDesc(persp.getElementId()), persp.getElementId(), false);
            }
            if (curPersp != null) {
                this.closePerspective(this.getPerspectiveDesc(curPersp.getElementId()), curPersp.getElementId(), false);
            }
            if (closePage) {
                this.close();
            }
        }
    }

    private boolean close(boolean save, boolean unsetPage) {
        if (save && !this.saveAllEditors(true, true, true)) {
            return false;
        }
        Collection partsToHide = this.partService.getParts();
        List partsOutsidePersp = this.modelService.findElements((MUIElement)this.window, null, MPart.class, null, 1);
        partsToHide.removeAll(partsOutsidePersp);
        for (MPart part : partsToHide) {
            this.hidePart(part, false, true, true);
        }
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null).get(0);
        MPerspective current = (MPerspective)perspectiveStack.getSelectedElement();
        Object[] objectArray = perspectiveStack.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object perspective = objectArray[n2];
            if (perspective != current) {
                this.modelService.removePerspectiveModel((MPerspective)perspective, this.window);
            }
            ++n2;
        }
        if (current != null) {
            this.modelService.removePerspectiveModel(current, this.window);
        }
        this.viewReferences.clear();
        this.editorReferences.clear();
        this.sortedPerspectives.clear();
        this.modelToPerspectiveMapping.clear();
        if (unsetPage) {
            this.legacyWindow.setActivePage(null);
            this.partService.removePartListener((org.eclipse.e4.ui.workbench.modeling.IPartListener)this.e4PartListener);
            this.broker.unsubscribe(this.selectionHandler);
            this.broker.unsubscribe(this.widgetHandler);
            this.broker.unsubscribe(this.referenceRemovalEventHandler);
            this.broker.unsubscribe(this.firingHandler);
            this.broker.unsubscribe(this.childrenHandler);
            this.partEvents.clear();
            this.partListenerList.clear();
            this.partListener2List.clear();
            this.propertyChangeListeners.clear();
            this.selectionService.dispose();
            ContextInjectionFactory.uninject((Object)this, (IEclipseContext)this.window.getContext());
        }
        return true;
    }

    public void unzoomAllPerspectives() {
    }

    public void dispose() {
    }

    @Override
    public INavigationHistory getNavigationHistory() {
        return this.navigationHistory;
    }

    public boolean editActionSets() {
        boolean ret;
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return false;
        }
        CustomizePerspectiveDialog dlg = this.legacyWindow.createCustomizePerspectiveDialog(persp, this.window.getContext());
        boolean bl = ret = dlg.open() == 0;
        if (ret) {
            this.legacyWindow.updateActionSets();
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "reset");
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "resetComplete");
        }
        return ret;
    }

    @Override
    public IViewPart findView(String id) {
        IViewReference ref = this.findViewReference(id);
        if (ref == null) {
            return null;
        }
        return ref.getView(true);
    }

    @Override
    public IViewReference findViewReference(String viewId) {
        IViewReference[] iViewReferenceArray = this.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference reference = iViewReferenceArray[n2];
            ViewReference ref = (ViewReference)reference;
            if (viewId.equals(ref.getModel().getElementId())) {
                return reference;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IViewReference findViewReference(String viewId, String secondaryId) {
        String compoundId = viewId;
        if (secondaryId != null && secondaryId.length() > 0) {
            compoundId = String.valueOf(compoundId) + ":" + secondaryId;
        }
        return this.findViewReference(compoundId);
    }

    public void createViewReferenceForPart(MPart part, String viewId) {
        int colonIndex = viewId.indexOf(58);
        String descId = colonIndex == -1 ? viewId : viewId.substring(0, colonIndex);
        IViewDescriptor desc = this.getWorkbenchWindow().getWorkbench().getViewRegistry().find(descId);
        ViewReference ref = new ViewReference(this.window.getContext(), this, part, (ViewDescriptor)desc);
        if (this.contains(ref)) {
            return;
        }
        IEclipseContext partContext = part.getContext();
        if (partContext == null) {
            ref.subscribe();
        } else {
            partContext.set(ViewReference.class.getName(), (Object)ref);
        }
        this.addViewReference(ref);
    }

    private void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        UIListenerLogging.logPagePropertyChanged(this, changeId, oldValue, newValue);
        Object[] listeners = this.propertyChangeListeners.getListeners();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public IActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this.legacyWindow);
        }
        return this.actionBars;
    }

    public IActionSetDescriptor[] getActionSets() {
        Collection collection = this.actionSets.getVisibleItems();
        return collection.toArray(new IActionSetDescriptor[collection.size()]);
    }

    @Override
    public IEditorPart getActiveEditor() {
        MPerspective perspective;
        IEditorPart editor;
        IWorkbenchPart activePart = this.getActivePart();
        if (activePart instanceof IEditorPart) {
            return (IEditorPart)activePart;
        }
        if (!this.activationList.isEmpty() && (editor = this.findActiveEditor()) != null) {
            return editor;
        }
        MUIElement area = this.findSharedArea();
        if (area instanceof MPlaceholder) {
            area = ((MPlaceholder)area).getRef();
        }
        if (area != null && area.isVisible() && area.isToBeRendered()) {
            List editors = this.modelService.findElements(area, "org.eclipse.e4.ui.compatibility.editor", MPart.class, null);
            for (MPart model : editors) {
                CompatibilityEditor editor2;
                Object object = model.getObject();
                if (!(object instanceof CompatibilityEditor) || (editor2 = (CompatibilityEditor)object).isBeingDisposed() || !this.isInArea(area, (MUIElement)model)) continue;
                return ((CompatibilityEditor)object).getEditor();
            }
        }
        if ((perspective = (MPerspective)this.getPerspectiveStack().getSelectedElement()) == null) {
            return null;
        }
        List parts = this.modelService.findElements((MUIElement)perspective, "org.eclipse.e4.ui.compatibility.editor", MPart.class, null);
        for (MPart part : parts) {
            CompatibilityEditor editor3;
            Object object = part.getObject();
            if (!(object instanceof CompatibilityEditor) || (editor3 = (CompatibilityEditor)object).isBeingDisposed() || !this.isValid((MUIElement)perspective, (MUIElement)part) && !this.isValid((MUIElement)this.window, (MUIElement)part)) continue;
            return ((CompatibilityEditor)object).getEditor();
        }
        return null;
    }

    private IEditorPart findActiveEditor() {
        CompatibilityEditor editor;
        Object object;
        ArrayList<MPart> candidates = new ArrayList<MPart>(this.activationList);
        MUIElement area = this.findSharedArea();
        if (area instanceof MPlaceholder) {
            area = ((MPlaceholder)area).getRef();
        }
        if (area != null && area.isVisible() && area.isToBeRendered()) {
            List editors = this.modelService.findElements(area, "org.eclipse.e4.ui.compatibility.editor", MPart.class, null);
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                MPart model = (MPart)it.next();
                if (!editors.contains(model)) continue;
                object = model.getObject();
                if (object instanceof CompatibilityEditor && !(editor = (CompatibilityEditor)object).isBeingDisposed() && this.isInArea(area, (MUIElement)model)) {
                    return ((CompatibilityEditor)object).getEditor();
                }
                it.remove();
            }
        }
        MPerspective perspective = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        for (MPart model : this.activationList) {
            object = model.getObject();
            if (!(object instanceof CompatibilityEditor) || (editor = (CompatibilityEditor)object).isBeingDisposed() || !this.isValid((MUIElement)perspective, (MUIElement)model) && !this.isValid((MUIElement)this.window, (MUIElement)model)) continue;
            return ((CompatibilityEditor)object).getEditor();
        }
        return null;
    }

    private boolean isInArea(MUIElement area, MUIElement element) {
        if (!element.isToBeRendered() || !element.isVisible()) {
            return false;
        }
        if (element == area) {
            return true;
        }
        MElementContainer parent = element.getParent();
        if (parent == null || parent instanceof MPerspective || parent instanceof MWindow) {
            return false;
        }
        if (parent instanceof MGenericStack) {
            return parent.getSelectedElement() == element ? this.isValid(area, (MUIElement)parent) : false;
        }
        return this.isValid(area, (MUIElement)parent);
    }

    private boolean isValid(MUIElement ancestor, MUIElement element) {
        if (!element.isToBeRendered() || !element.isVisible()) {
            return false;
        }
        if (element == ancestor) {
            return true;
        }
        MElementContainer parent = element.getParent();
        if (parent == null) {
            if (element instanceof MWindow) {
                parent = (MElementContainer)((EObject)element).eContainer();
            }
            if (parent == null) {
                return false;
            }
        }
        if (parent instanceof MGenericStack) {
            return parent.getSelectedElement() == element ? this.isValid(ancestor, (MUIElement)parent) : false;
        }
        return this.isValid(ancestor, (MUIElement)parent);
    }

    @Override
    public IWorkbenchPart getActivePart() {
        MPart part = this.partService.getActivePart();
        return this.getWorkbenchPart(part);
    }

    @Override
    public IWorkbenchPartReference getActivePartReference() {
        IWorkbenchPart part = this.getActivePart();
        return part == null ? null : this.getReference(part);
    }

    public Composite getClientComposite() {
        return this.composite;
    }

    @Override
    public IEditorPart[] getDirtyEditors() {
        ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
        for (IEditorReference iEditorReference : this.editorReferences) {
            IEditorPart editor = iEditorReference.getEditor(false);
            if (editor == null || !editor.isDirty()) continue;
            dirtyEditors.add(editor);
        }
        return dirtyEditors.toArray(new IEditorPart[dirtyEditors.size()]);
    }

    @Override
    public IEditorPart findEditor(IEditorInput input) {
        IEditorReference[] references = this.findEditors(input, null, 1);
        return references.length == 0 ? null : references[0].getEditor(true);
    }

    @Override
    public IEditorReference[] findEditors(IEditorInput input, String editorId, int matchFlags) {
        List<EditorReference> filteredReferences = this.getSortedEditorReferences();
        switch (matchFlags) {
            case 1: {
                ArrayList<IEditorReference> editorRefs = new ArrayList<IEditorReference>();
                for (EditorReference editorReference : filteredReferences) {
                    this.checkEditor(input, editorRefs, editorReference);
                }
                return editorRefs.toArray(new IEditorReference[editorRefs.size()]);
            }
            case 2: {
                ArrayList<IEditorReference> editorRefs = new ArrayList<IEditorReference>();
                for (IEditorReference iEditorReference : filteredReferences) {
                    if (!editorId.equals(iEditorReference.getId())) continue;
                    editorRefs.add(iEditorReference);
                }
                return editorRefs.toArray(new IEditorReference[editorRefs.size()]);
            }
        }
        if ((matchFlags & 2) != 0 && (matchFlags & 1) != 0) {
            ArrayList<IEditorReference> editorRefs = new ArrayList<IEditorReference>();
            for (EditorReference editorReference : filteredReferences) {
                if (!editorReference.getId().equals(editorId)) continue;
                this.checkEditor(input, editorRefs, editorReference);
            }
            return editorRefs.toArray(new IEditorReference[editorRefs.size()]);
        }
        return new IEditorReference[0];
    }

    private void checkEditor(IEditorInput input, List<IEditorReference> editorRefs, EditorReference editorRef) {
        IEditorMatchingStrategy strategy;
        EditorDescriptor descriptor = editorRef.getDescriptor();
        if (descriptor != null && (strategy = descriptor.getEditorMatchingStrategy()) != null && strategy.matches(editorRef, input)) {
            editorRefs.add(editorRef);
            return;
        }
        IEditorPart editor = editorRef.getEditor(false);
        if (editor == null) {
            try {
                String name = input.getName();
                IPersistableElement persistable = input.getPersistable();
                if (name == null || persistable == null) {
                    return;
                }
                String id = persistable.getFactoryId();
                if (id != null && id.equals(editorRef.getFactoryId()) && name.equals(editorRef.getName()) && input.equals(editorRef.getEditorInput())) {
                    editorRefs.add(editorRef);
                }
            }
            catch (PartInitException e) {
                WorkbenchPlugin.log((Throwable)((Object)e));
            }
        } else if (editor.getEditorInput().equals(input)) {
            editorRefs.add(editorRef);
        }
    }

    @Override
    public IEditorPart[] getEditors() {
        IEditorReference[] editorReferences = this.getEditorReferences();
        int length = editorReferences.length;
        IEditorPart[] editors = new IEditorPart[length];
        int i = 0;
        while (i < length) {
            editors[i] = editorReferences[i].getEditor(true);
            ++i;
        }
        return editors;
    }

    @Override
    public IEditorReference[] getEditorReferences() {
        List<EditorReference> references = this.getOrderedEditorReferences();
        return references.toArray(new IEditorReference[references.size()]);
    }

    public IEditorReference[] getSortedEditors() {
        IWorkbenchPartReference[] parts = this.getSortedParts(true, false, false);
        IEditorReference[] editors = new IEditorReference[parts.length];
        System.arraycopy(parts, 0, editors, 0, parts.length);
        return editors;
    }

    public IWorkbenchPartReference[] getSortedParts() {
        return this.getSortedParts(true, true, false);
    }

    private IWorkbenchPartReference[] getSortedParts(boolean editors, boolean views, boolean allPerspectives) {
        if (!editors && !views) {
            return new IWorkbenchPartReference[0];
        }
        ArrayList<EditorReference> sortedReferences = new ArrayList<EditorReference>();
        IViewReference[] viewReferences = this.getViewReferences(allPerspectives);
        List<EditorReference> editorReferences = this.getSortedEditorReferences(allPerspectives);
        block0: for (MPart part : this.activationList) {
            if (views) {
                IViewReference[] iViewReferenceArray = viewReferences;
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPartReference ref = iViewReferenceArray[n2];
                    if (((ViewReference)ref).getModel() == part) {
                        sortedReferences.add((EditorReference)ref);
                        continue block0;
                    }
                    ++n2;
                }
            }
            if (!editors) continue;
            for (IWorkbenchPartReference ref : editorReferences) {
                if (ref.getModel() != part) continue;
                sortedReferences.add((EditorReference)ref);
                continue block0;
            }
        }
        if (views) {
            IViewReference[] iViewReferenceArray = viewReferences;
            int n = viewReferences.length;
            int n3 = 0;
            while (n3 < n) {
                IWorkbenchPartReference ref = iViewReferenceArray[n3];
                if (!sortedReferences.contains(ref)) {
                    sortedReferences.add((EditorReference)ref);
                }
                ++n3;
            }
        }
        if (editors) {
            for (IWorkbenchPartReference ref : editorReferences) {
                if (sortedReferences.contains(ref)) continue;
                sortedReferences.add((EditorReference)ref);
            }
        }
        return sortedReferences.toArray(new IWorkbenchPartReference[sortedReferences.size()]);
    }

    @Override
    public IAdaptable getInput() {
        return this.input;
    }

    @Override
    public String getLabel() {
        String label = WorkbenchMessages.WorkbenchPage_UnknownLabel;
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Adapters.adapt((Object)this.input, IWorkbenchAdapter.class);
        if (adapter != null) {
            label = adapter.getLabel(this.input);
        }
        return label;
    }

    @Override
    public IPerspectiveDescriptor getPerspective() {
        MPerspectiveStack ps = this.getPerspectiveStack();
        MPerspective curPersp = (MPerspective)ps.getSelectedElement();
        if (curPersp == null) {
            return null;
        }
        return this.getPerspectiveDesc(curPersp.getElementId());
    }

    public IPerspectiveDescriptor getPerspectiveDesc(String id) {
        IPerspectiveRegistry perspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        if (perspectiveRegistry == null) {
            return null;
        }
        IPerspectiveDescriptor desc = perspectiveRegistry.findPerspectiveWithId(id);
        return desc;
    }

    @Override
    public ISelection getSelection() {
        return this.selectionService.getSelection();
    }

    @Override
    public ISelection getSelection(String partId) {
        return this.selectionService.getSelection(partId);
    }

    public ArrayList<?> getShowInPartIds() {
        MPerspective perspective = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        return new ArrayList<String>(ModeledPageLayout.getIds(perspective, "persp.showIn:"));
    }

    public void performedShowIn(String partId) {
        this.mruShowInPartIds.remove(partId);
        this.mruShowInPartIds.add(0, partId);
    }

    public void sortShowInPartIds(ArrayList<?> partIds) {
        Collections.sort(partIds, new Comparator<Object>(){

            @Override
            public int compare(Object ob1, Object ob2) {
                int index1 = WorkbenchPage.this.mruShowInPartIds.indexOf(ob1);
                int index2 = WorkbenchPage.this.mruShowInPartIds.indexOf(ob2);
                if (index1 != -1 && index2 == -1) {
                    return -1;
                }
                if (index1 == -1 && index2 != -1) {
                    return 1;
                }
                return index1 - index2;
            }
        });
    }

    @Override
    public IViewReference[] getViewReferences() {
        return this.getViewReferences(false);
    }

    private IViewReference[] getViewReferences(boolean allPerspectives) {
        MPerspective perspective = this.getCurrentPerspective();
        if (perspective != null) {
            int scope = allPerspectives ? 13 : 11;
            HashSet parts = new HashSet();
            List placeholders = this.modelService.findElements((MUIElement)this.window, null, MPlaceholder.class, null, scope);
            parts.addAll(placeholders);
            parts.addAll(this.modelService.findElements((MUIElement)this.window, null, MPart.class, null, scope));
            ArrayList<ViewReference> visibleReferences = new ArrayList<ViewReference>();
            for (ViewReference reference : this.viewReferences) {
                MPart model = reference.getModel();
                if (!parts.contains(model) || !model.isToBeRendered() || model.getCurSharedRef() != null && !model.getCurSharedRef().isToBeRendered()) continue;
                visibleReferences.add(reference);
            }
            return visibleReferences.toArray(new IViewReference[visibleReferences.size()]);
        }
        return new IViewReference[0];
    }

    @Override
    public IViewPart[] getViews() {
        IViewReference[] viewReferences = this.getViewReferences();
        int length = viewReferences.length;
        IViewPart[] views = new IViewPart[length];
        int i = 0;
        while (i < length) {
            views[i] = viewReferences[i].getView(true);
            ++i;
        }
        return views;
    }

    @Override
    public IWorkbenchWindow getWorkbenchWindow() {
        return this.legacyWindow;
    }

    @Override
    @Deprecated
    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    @Override
    public void hideActionSet(String actionSetID) {
        MPerspective mpersp = this.getCurrentPerspective();
        if (mpersp == null) {
            return;
        }
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
            IActionSetDescriptor desc = reg.findActionSet(actionSetID);
            if (desc != null) {
                persp.removeActionSet(desc);
            }
            this.legacyWindow.updateActionSets();
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "actionSetHide");
        }
        String tag = "persp.actionSet:" + actionSetID;
        this.addHiddenItems(tag);
    }

    @Override
    public void hideView(IViewReference view) {
        if (view != null) {
            IViewReference[] iViewReferenceArray = this.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference reference = iViewReferenceArray[n2];
                if (reference == view) {
                    this.hidePart(((ViewReference)view).getModel(), true, true, false);
                    break;
                }
                ++n2;
            }
        }
    }

    @Override
    public void hideView(IViewPart view) {
        MPart part;
        if (view != null && (part = this.findPart(view)) != null) {
            this.hidePart(part, true, true, false);
        }
    }

    private void init(WorkbenchWindow w, String layoutID, IAdaptable input, boolean openExtras) {
        this.legacyWindow = w;
        this.input = input;
        this.actionSets = new ActionSetManager(w);
        this.initActionSetListener();
        this.initMaxFileSize();
    }

    private void initMaxFileSize() {
        IPreferenceStore preferenceStore = PrefUtil.getInternalPreferenceStore();
        this.maxFileSize = preferenceStore.getLong("LARGE_DOC_SIZE_FOR_EDITORS");
        this.checkDocumentSize = this.maxFileSize != 0L;
    }

    @PostConstruct
    public void setup(MApplication application, EModelService modelService, IEventBroker broker, MWindow window, EPartService partService) {
        IPerspectiveDescriptor desc;
        this.application = application;
        this.modelService = modelService;
        this.broker = broker;
        this.window = window;
        this.partService = partService;
        this.selectionService = (SelectionService)ContextInjectionFactory.make(SelectionService.class, (IEclipseContext)window.getContext());
        partService.addPartListener((org.eclipse.e4.ui.workbench.modeling.IPartListener)this.e4PartListener);
        List editors = modelService.findElements((MUIElement)window, "org.eclipse.e4.ui.compatibility.editor", MPart.class, null, 13);
        for (MPart editor : editors) {
            this.createEditorReferenceForPart(editor, null, editor.getElementId(), null);
        }
        List placeholders = modelService.findElements((MUIElement)window, null, MPlaceholder.class, null, 5);
        for (MPlaceholder placeholder : placeholders) {
            Object part;
            String uri;
            MUIElement ref;
            if (!placeholder.isToBeRendered() || !((ref = placeholder.getRef()) instanceof MPart) || !(uri = (part = (MPart)ref).getContributionURI()).equals("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView")) continue;
            this.createViewReferenceForPart((MPart)part, part.getElementId());
        }
        broker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.selectionHandler);
        broker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.widgetHandler);
        broker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.referenceRemovalEventHandler);
        broker.subscribe("org/eclipse/e4/ui/model/application/Contribution/object/*", this.firingHandler);
        broker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childrenHandler);
        MPerspectiveStack perspectiveStack = this.getPerspectiveStack();
        if (perspectiveStack != null) {
            this.extendPerspectives(perspectiveStack);
        }
        IPerspectiveRegistry registry = this.getWorkbenchWindow().getWorkbench().getPerspectiveRegistry();
        for (MPerspective perspective : perspectiveStack.getChildren()) {
            IPerspectiveDescriptor desc2 = registry.findPerspectiveWithId(perspective.getElementId());
            if (desc2 == null) continue;
            this.sortedPerspectives.add(desc2);
        }
        MPerspective selectedPerspective = (MPerspective)perspectiveStack.getSelectedElement();
        if (selectedPerspective != null && (desc = registry.findPerspectiveWithId(selectedPerspective.getElementId())) != null) {
            this.sortedPerspectives.remove(desc);
            this.sortedPerspectives.add(desc);
        }
        this.restoreWorkingSets();
        this.restoreShowInMruPartIdsList();
    }

    public void restoreWorkingSets() {
        String workingSetMemString;
        String workingSetName = (String)this.getWindowModel().getPersistedState().get("workingSet");
        if (workingSetName != null) {
            AbstractWorkingSetManager workingSetManager = (AbstractWorkingSetManager)this.getWorkbenchWindow().getWorkbench().getWorkingSetManager();
            this.setWorkingSet(workingSetManager.getWorkingSet(workingSetName));
        }
        if ((workingSetMemString = (String)this.getWindowModel().getPersistedState().get("workingSets")) != null) {
            try {
                XMLMemento workingSetMem = XMLMemento.createReadRoot(new StringReader(workingSetMemString));
                IMemento[] workingSetChildren = workingSetMem.getChildren("workingSet");
                ArrayList<IWorkingSet> workingSetList = new ArrayList<IWorkingSet>(workingSetChildren.length);
                int i = 0;
                while (i < workingSetChildren.length) {
                    IWorkingSet set = this.getWorkbenchWindow().getWorkbench().getWorkingSetManager().getWorkingSet(workingSetChildren[i].getID());
                    if (set != null) {
                        workingSetList.add(set);
                    }
                    ++i;
                }
                this.workingSets = workingSetList.toArray(new IWorkingSet[workingSetList.size()]);
            }
            catch (WorkbenchException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui", 4, WorkbenchMessages.WorkbenchPage_problemRestoringTitle, (Throwable)((Object)e)));
            }
        }
        this.aggregateWorkingSetId = (String)this.getWindowModel().getPersistedState().get(ATT_AGGREGATE_WORKING_SET_ID);
    }

    private void restoreShowInMruPartIdsList() {
        String mruList = (String)this.getWindowModel().getPersistedState().get("show_in_time");
        if (mruList != null) {
            try {
                IMemento[] mementoChildren;
                XMLMemento memento = XMLMemento.createReadRoot(new StringReader(mruList));
                IMemento[] iMementoArray = mementoChildren = memento.getChildren();
                int n = mementoChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    this.mruShowInPartIds.add(child.getID());
                    ++n2;
                }
            }
            catch (WorkbenchException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui", 4, WorkbenchMessages.WorkbenchPage_problemRestoringTitle, (Throwable)((Object)e)));
            }
        }
    }

    @PreDestroy
    public void saveWorkingSets() {
        if (this.workingSet != null) {
            this.getWindowModel().getPersistedState().put("workingSet", this.workingSet.getName());
        } else {
            this.getWindowModel().getPersistedState().remove("workingSet");
        }
        ArrayList<String> workingSetNames = new ArrayList<String>(this.workingSets.length);
        IWorkingSet[] iWorkingSetArray = this.workingSets;
        int n = this.workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            workingSetNames.add(workingSet.getName());
            ++n2;
        }
        this.saveMemento("workingSets", "workingSet", workingSetNames);
        this.getWindowModel().getPersistedState().put(ATT_AGGREGATE_WORKING_SET_ID, this.aggregateWorkingSetId);
    }

    @PreDestroy
    public void saveShowInMruPartIdsList() {
        this.saveMemento("show_in_time", "id", this.mruShowInPartIds);
    }

    private void saveMemento(String rootType, String childType, Collection<String> ids) {
        XMLMemento memento = XMLMemento.createWriteRoot(rootType);
        for (String id : ids) {
            memento.createChild(childType, id);
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save(writer);
            this.getWindowModel().getPersistedState().put(rootType, writer.getBuffer().toString());
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui", 4, WorkbenchMessages.SavingProblem, (Throwable)e));
        }
    }

    private void extendPerspectives(MPerspectiveStack perspectiveStack) {
        for (MPerspective perspective : perspectiveStack.getChildren()) {
            String id = perspective.getElementId();
            IPerspectiveDescriptor desc = this.getWorkbenchWindow().getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id);
            if (desc == null) continue;
            MPerspective temporary = (MPerspective)this.modelService.createModelElement(MPerspective.class);
            ModeledPageLayout modelLayout = new ModeledPageLayout(this.window, this.modelService, this.partService, temporary, desc, this, true);
            PerspectiveExtensionReader reader = new PerspectiveExtensionReader();
            reader.setIncludeOnlyTags(new String[]{"actionSet"});
            reader.extendLayout(null, id, modelLayout);
            this.addActionSet(perspective, temporary);
        }
    }

    ArrayList<String> getPerspectiveExtensionActionSets(String id) {
        IPerspectiveDescriptor desc = this.getWorkbenchWindow().getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id);
        if (desc != null) {
            MPerspective temporary = (MPerspective)this.modelService.createModelElement(MPerspective.class);
            ModeledPageLayout modelLayout = new ModeledPageLayout(this.window, this.modelService, this.partService, temporary, desc, this, true);
            PerspectiveExtensionReader reader = new PerspectiveExtensionReader();
            reader.setIncludeOnlyTags(new String[]{"actionSet"});
            reader.extendLayout(null, id, modelLayout);
            return new ArrayList<String>(ModeledPageLayout.getIds(temporary, "persp.actionSet:"));
        }
        return null;
    }

    private void addActionSet(MPerspective perspective, MPerspective temporary) {
        List tags = perspective.getTags();
        List extendedTags = temporary.getTags();
        for (String extendedTag : extendedTags) {
            if (tags.contains(extendedTag)) continue;
            tags.add(extendedTag);
        }
    }

    private void installAreaDropSupport(Control control) {
        if (!this.dndSupportInstalled) {
            WorkbenchWindowConfigurer configurer = this.legacyWindow.getWindowConfigurer();
            DropTargetListener dropTargetListener = configurer.getDropTargetListener();
            if (dropTargetListener != null) {
                DropTarget dropTarget = new DropTarget(control, 21);
                dropTarget.setTransfer(configurer.getTransfers());
                dropTarget.addDropListener(dropTargetListener);
            }
            this.dndSupportInstalled = true;
        }
    }

    private List<MPartStack> getPartStacks(MPerspective perspective) {
        if (perspective == null) {
            return Collections.emptyList();
        }
        return this.modelService.findElements((MUIElement)perspective, null, MPartStack.class, null);
    }

    @Override
    public boolean isPartVisible(IWorkbenchPart part) {
        MPart mpart = this.findPart(part);
        return mpart == null ? false : this.partService.isPartVisible(mpart);
    }

    public MUIElement findSharedArea() {
        MPerspective perspective = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        return perspective == null ? null : this.modelService.find("org.eclipse.ui.editorss", (MUIElement)perspective);
    }

    @Override
    public boolean isEditorAreaVisible() {
        MUIElement find = this.findSharedArea();
        return find == null ? false : find.isVisible() && find.isToBeRendered();
    }

    @Override
    public boolean isPageZoomed() {
        ArrayList<String> maxTag = new ArrayList<String>();
        maxTag.add("Maximized");
        List maxElements = this.modelService.findElements((MUIElement)this.window, null, null, maxTag);
        return maxElements.size() > 0;
    }

    @Override
    public void reuseEditor(IReusableEditor editor, IEditorInput input) {
        editor.setInput(input);
        this.navigationHistory.markEditor(editor);
    }

    @Override
    public IEditorPart openEditor(IEditorInput input, String editorID) throws PartInitException {
        return this.openEditor(input, editorID, true, 1);
    }

    @Override
    public IEditorPart openEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        return this.openEditor(input, editorID, activate, 1);
    }

    @Override
    public IEditorPart openEditor(IEditorInput input, String editorID, boolean activate, int matchFlags) throws PartInitException {
        return this.openEditor(input, editorID, activate, matchFlags, null, true);
    }

    public IEditorPart openEditor(final IEditorInput input, final String editorID, final boolean activate, final int matchFlags, final IMemento editorState, final boolean notify) throws PartInitException {
        if (input == null || editorID == null) {
            throw new IllegalArgumentException();
        }
        final IEditorPart[] result = new IEditorPart[1];
        final PartInitException[] ex = new PartInitException[1];
        BusyIndicator.showWhile((Display)this.legacyWindow.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = WorkbenchPage.this.busyOpenEditor(input, editorID, activate, matchFlags, editorState, notify);
                }
                catch (PartInitException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        return result[0];
    }

    private IEditorPart busyOpenEditor(IEditorInput input, String editorId, boolean activate, int matchFlags, IMemento editorState, boolean notify) throws PartInitException {
        if (input == null || editorId == null) {
            throw new IllegalArgumentException();
        }
        if ("org.eclipse.ui.systemExternalEditor".equals(editorId)) {
            IPathEditorInput fileInput = this.getPathEditorInput(input);
            if (fileInput == null) {
                throw new PartInitException(WorkbenchMessages.EditorManager_systemEditorError);
            }
            String fullPath = fileInput.getPath().toOSString();
            Program.launch((String)fullPath);
            return null;
        }
        IEditorDescriptor desc = this.getWorkbenchWindow().getWorkbench().getEditorRegistry().findEditor(editorId);
        if (desc != null && !desc.isOpenExternal() && this.isLargeDocument(input) && (desc = WorkbenchPage.getAlternateEditor()) == null) {
            return null;
        }
        if (desc == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_unknownEditorIDMessage, (Object)editorId));
        }
        this.setEditorAreaVisible(true);
        IEditorReference[] editorReferences = this.findEditors(input, editorId, matchFlags);
        if (editorReferences.length != 0) {
            IEditorPart editor = editorReferences[0].getEditor(true);
            if (editor instanceof IShowEditorInput) {
                ((IShowEditorInput)((Object)editor)).showEditorInput(input);
            }
            this.partService.showPart(((EditorReference)editorReferences[0]).getModel(), EPartService.PartState.VISIBLE);
            if (activate) {
                this.activate(editor);
            }
            this.recordEditor(input, desc);
            return editor;
        }
        if (desc.isInternal()) {
            EditorReference reusableEditorRef = (EditorReference)((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).findReusableEditor(this);
            if (reusableEditorRef != null) {
                IEditorPart reusableEditor = reusableEditorRef.getEditor(false);
                if (editorId.equals(reusableEditorRef.getId()) && reusableEditor instanceof IReusableEditor) {
                    this.recordEditor(input, desc);
                    this.reuseEditor((IReusableEditor)reusableEditor, input);
                    MPart editor = reusableEditorRef.getModel();
                    this.partService.showPart(editor, EPartService.PartState.VISIBLE);
                    if (activate) {
                        this.partService.activate(editor);
                    } else {
                        this.updateActiveEditorSources(editor);
                    }
                    return reusableEditor;
                }
                this.closeEditor(reusableEditorRef, false);
            }
        } else if (desc.isOpenExternal()) {
            this.openExternalEditor((EditorDescriptor)desc, input);
            return null;
        }
        MPart editor = this.partService.createPart("org.eclipse.e4.ui.compatibility.editor");
        editor.getTags().add(editorId);
        EditorReference ref = this.createEditorReferenceForPart(editor, input, editorId, editorState);
        this.partService.showPart(editor, EPartService.PartState.VISIBLE);
        CompatibilityEditor compatibilityEditor = (CompatibilityEditor)editor.getObject();
        if (compatibilityEditor == null) {
            return null;
        }
        if (activate) {
            this.partService.activate(editor);
        } else {
            this.updateActiveEditorSources(editor);
        }
        if (notify) {
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), ref, "editorOpen");
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "editorOpen");
        }
        this.recordEditor(input, desc);
        return compatibilityEditor.getEditor();
    }

    private void recordEditor(IEditorInput input, IEditorDescriptor descriptor) {
        EditorHistory history = ((Workbench)this.legacyWindow.getWorkbench()).getEditorHistory();
        history.add(input, descriptor);
    }

    private static IEditorDescriptor getAlternateEditor() {
        Shell shell = ProgressManagerUtil.getDefaultParent();
        EditorSelectionDialog dialog = new EditorSelectionDialog(shell){

            @Override
            protected IDialogSettings getDialogSettings() {
                DialogSettings result = new DialogSettings("EditorSelectionDialog");
                result.put("EditorSelectionDialog.STORE_ID_INTERNAL_EXTERNAL", true);
                return result;
            }
        };
        dialog.setMessage(WorkbenchMessages.EditorManager_largeDocumentWarning);
        if (dialog.open() == 0) {
            return dialog.getSelectedEditor();
        }
        return null;
    }

    boolean isLargeDocument(IEditorInput editorInput) {
        if (!this.checkDocumentSize) {
            return false;
        }
        if (!(editorInput instanceof IPathEditorInput)) {
            return false;
        }
        try {
            IPath path = ((IPathEditorInput)editorInput).getPath();
            File file = new File(path.toOSString());
            return file.length() > this.maxFileSize;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isEditorPinned(IEditorPart editor) {
        WorkbenchPartReference ref = (WorkbenchPartReference)this.getReference(editor);
        return ref != null && ref.isPinned();
    }

    @Override
    public void removePartListener(IPartListener l) {
        this.partListenerList.remove((Object)l);
    }

    @Override
    public void removePartListener(IPartListener2 l) {
        this.partListener2List.remove((Object)l);
    }

    @Override
    @Deprecated
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        this.selectionService.removeSelectionListener(listener);
    }

    @Override
    public void removeSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.removeSelectionListener(partId, listener);
    }

    @Override
    public void removePostSelectionListener(ISelectionListener listener) {
        this.selectionService.removePostSelectionListener(listener);
    }

    @Override
    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.removePostSelectionListener(partId, listener);
    }

    @Override
    public void resetPerspective() {
        MPerspectiveStack perspStack = this.getPerspectiveStack();
        MPerspective persp = (MPerspective)perspStack.getSelectedElement();
        if (persp == null) {
            return;
        }
        IPerspectiveDescriptor desc = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(persp.getElementId());
        if (desc == null) {
            return;
        }
        this.legacyWindow.firePerspectiveChanged(this, desc, "reset");
        List perspectiveParts = this.modelService.findElements((MUIElement)persp, null, MPart.class, null);
        MUIElement area = this.findSharedArea();
        if (area != null) {
            perspectiveParts.removeAll(this.modelService.findElements(area, "org.eclipse.e4.ui.compatibility.editor", MPart.class, null));
        }
        ArrayList<MPart> dirtyParts = new ArrayList<MPart>();
        ArrayList<IWorkbenchPart> partsToSave = new ArrayList<IWorkbenchPart>();
        for (MPart currentPart : perspectiveParts) {
            Object object;
            if (!currentPart.isDirty() || (object = currentPart.getObject()) == null) continue;
            if (object instanceof CompatibilityPart) {
                IWorkbenchPart workbenchPart = ((CompatibilityPart)object).getPart();
                ISaveablePart saveable = SaveableHelper.getSaveable(workbenchPart);
                if (saveable == null || !saveable.isSaveOnCloseNeeded()) continue;
                partsToSave.add(workbenchPart);
            }
            dirtyParts.add(currentPart);
        }
        SaveablesList saveablesList = null;
        Object postCloseInfo = null;
        if (partsToSave.size() > 0 && (postCloseInfo = (saveablesList = (SaveablesList)this.getWorkbenchWindow().getService(ISaveablesLifecycleListener.class)).preCloseParts(partsToSave, true, this.getWorkbenchWindow())) == null) {
            this.legacyWindow.firePerspectiveChanged(this, desc, "resetComplete");
            return;
        }
        this.modelService.resetPerspectiveModel(persp, this.window);
        if (saveablesList != null) {
            saveablesList.postClose(postCloseInfo);
        }
        boolean revert = false;
        if (desc instanceof PerspectiveDescriptor) {
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)desc;
            revert = perspectiveDescriptor.isPredefined() && !perspectiveDescriptor.hasCustomDefinition();
        }
        MPerspective dummyPerspective = null;
        if (!revert) {
            dummyPerspective = (MPerspective)this.modelService.cloneSnippet((MSnippetContainer)this.application, desc.getId(), this.window);
        }
        if (dummyPerspective == null) {
            dummyPerspective = (MPerspective)this.modelService.createModelElement(MPerspective.class);
            dummyPerspective.setElementId(persp.getElementId());
            IPerspectiveFactory factory = ((PerspectiveDescriptor)desc).createFactory();
            ModeledPageLayout modelLayout = new ModeledPageLayout(this.window, this.modelService, this.partService, dummyPerspective, desc, this, true);
            factory.createInitialLayout(modelLayout);
            PerspectiveTagger.tagPerspective(dummyPerspective, this.modelService);
            PerspectiveExtensionReader reader = new PerspectiveExtensionReader();
            reader.extendLayout(this.getExtensionTracker(), desc.getId(), modelLayout);
        }
        String hiddenItems = (String)dummyPerspective.getPersistedState().get("persp.hiddenItems");
        persp.getPersistedState().put("persp.hiddenItems", hiddenItems);
        this.legacyWindow.getMenuManager().updateAll(true);
        this.modelService.hideLocalPlaceholders(this.window, dummyPerspective);
        int dCount = dummyPerspective.getChildren().size();
        while (dummyPerspective.getChildren().size() > 0) {
            MPartSashContainerElement dChild = (MPartSashContainerElement)dummyPerspective.getChildren().remove(0);
            persp.getChildren().add(dChild);
        }
        while (persp.getChildren().size() > dCount) {
            MUIElement child = (MUIElement)persp.getChildren().get(0);
            child.setToBeRendered(false);
            persp.getChildren().remove(0);
        }
        ArrayList existingDetachedWindows = new ArrayList();
        existingDetachedWindows.addAll(persp.getWindows());
        while (dummyPerspective.getWindows().size() > 0) {
            MWindow detachedWindow = (MWindow)dummyPerspective.getWindows().remove(0);
            persp.getWindows().add(detachedWindow);
        }
        for (MWindow detachedWindow : existingDetachedWindows) {
            detachedWindow.setToBeRendered(false);
            persp.getWindows().remove(detachedWindow);
        }
        Perspective oldPersp = this.getPerspective(persp);
        Perspective dummyPersp = this.getPerspective(dummyPerspective);
        this.updateActionSets(oldPersp, dummyPersp);
        oldPersp.getAlwaysOnActionSets().clear();
        oldPersp.getAlwaysOnActionSets().addAll(dummyPersp.getAlwaysOnActionSets());
        oldPersp.getAlwaysOffActionSets().clear();
        oldPersp.getAlwaysOffActionSets().addAll(dummyPersp.getAlwaysOffActionSets());
        this.modelToPerspectiveMapping.remove(dummyPerspective);
        this.legacyWindow.updateActionSets();
        List tags = persp.getTags();
        tags.clear();
        tags.addAll(dummyPerspective.getTags());
        List trimElements = this.modelService.findElements((MUIElement)this.window, null, MTrimElement.class, null);
        for (MTrimElement mTrimElement : trimElements) {
            mTrimElement.getTags().remove("HIDDEN_EXPLICITLY");
        }
        this.partService.requestActivation();
        this.legacyWindow.firePerspectiveChanged(this, desc, "resetComplete");
        UIEvents.publishEvent((String)"org/eclipse/e4/ui/LifeCycle/perspReset", (MUIElement)persp);
    }

    private void initActionSetListener() {
    }

    @Override
    public boolean saveAllEditors(boolean confirm) {
        return this.saveAllEditors(confirm, false, false);
    }

    public ISaveablePart[] getDirtyParts() {
        ArrayList<ISaveablePart> result = new ArrayList<ISaveablePart>(3);
        IWorkbenchPartReference[] allParts = this.getSortedParts(true, true, true);
        int i = 0;
        while (i < allParts.length) {
            IWorkbenchPartReference reference = allParts[i];
            IWorkbenchPart part = reference.getPart(false);
            ISaveablePart saveable = SaveableHelper.getSaveable(part);
            if (saveable != null && saveable.isDirty()) {
                result.add(saveable);
            }
            ++i;
        }
        return result.toArray(new ISaveablePart[result.size()]);
    }

    public IWorkbenchPart[] getDirtyWorkbenchParts() {
        ArrayList<IWorkbenchPart> result = new ArrayList<IWorkbenchPart>(3);
        IWorkbenchPartReference[] allParts = this.getSortedParts(true, true, true);
        int i = 0;
        while (i < allParts.length) {
            IWorkbenchPartReference reference = allParts[i];
            IWorkbenchPart part = reference.getPart(false);
            ISaveablePart saveable = SaveableHelper.getSaveable(part);
            if (saveable != null && saveable.isDirty()) {
                result.add(part);
            }
            ++i;
        }
        return result.toArray(new IWorkbenchPart[result.size()]);
    }

    public boolean saveAllEditors(boolean confirm, boolean closing, boolean addNonPartSources) {
        IWorkbenchPart[] parts = this.getDirtyWorkbenchParts();
        if (parts.length == 0) {
            return true;
        }
        ArrayList<IWorkbenchPart> dirtyParts = new ArrayList<IWorkbenchPart>(parts.length);
        int i = 0;
        while (i < parts.length) {
            dirtyParts.add(parts[i]);
            ++i;
        }
        return WorkbenchPage.saveAll(dirtyParts, confirm, closing, addNonPartSources, this.legacyWindow, this.legacyWindow);
    }

    public static boolean saveAll(List<IWorkbenchPart> dirtyParts, boolean confirm, boolean closing, boolean addNonPartSources, IRunnableContext runnableContext, IWorkbenchWindow workbenchWindow) {
        dirtyParts = new ArrayList<IWorkbenchPart>(dirtyParts);
        if (closing) {
            WorkbenchPage.removeSaveOnCloseNotNeededParts(dirtyParts);
        }
        SaveablesList saveablesList = (SaveablesList)PlatformUI.getWorkbench().getService(ISaveablesLifecycleListener.class);
        if (confirm) {
            return WorkbenchPage.processSaveable2(dirtyParts) ? false : saveablesList.preCloseParts(dirtyParts, true, true, workbenchWindow, workbenchWindow) != null;
        }
        List<Saveable> modelsToSave = WorkbenchPage.convertToSaveables(dirtyParts, closing, addNonPartSources);
        return modelsToSave.isEmpty() ? true : !saveablesList.saveModels(modelsToSave, workbenchWindow, runnableContext, closing);
    }

    private static void removeSaveOnCloseNotNeededParts(List<IWorkbenchPart> parts) {
        Iterator<IWorkbenchPart> it = parts.iterator();
        while (it.hasNext()) {
            IWorkbenchPart part = it.next();
            ISaveablePart saveable = SaveableHelper.getSaveable(part);
            if (saveable != null && saveable.isSaveOnCloseNeeded()) continue;
            it.remove();
        }
    }

    private static boolean processSaveable2(List<IWorkbenchPart> dirtyParts) {
        boolean saveable2Processed = false;
        ListIterator<IWorkbenchPart> listIterator = dirtyParts.listIterator();
        WorkbenchPage currentPage = null;
        Object currentPageOriginalPerspective = null;
        while (listIterator.hasNext()) {
            IWorkbenchPart part = listIterator.next();
            ISaveablePart2 saveable2 = SaveableHelper.getSaveable2(part);
            if (saveable2 == null) continue;
            WorkbenchPage page = (WorkbenchPage)part.getSite().getPage();
            if (!Util.equals(currentPage, page)) {
                if (currentPage != null && currentPageOriginalPerspective != null && !currentPageOriginalPerspective.equals(currentPage.getActivePerspective())) {
                    currentPage.setPerspective(((Perspective)currentPageOriginalPerspective).getDesc());
                }
                currentPage = page;
                currentPageOriginalPerspective = page.getActivePerspective();
            }
            page.bringToTop(part);
            int choice = SaveableHelper.savePart(saveable2, page.getWorkbenchWindow(), true);
            if (choice == 2) {
                return true;
            }
            if (choice == 3) continue;
            saveable2Processed = true;
            listIterator.remove();
        }
        if (currentPage != null && currentPageOriginalPerspective != null && !currentPageOriginalPerspective.equals(currentPage.getActivePerspective())) {
            currentPage.setPerspective(((Perspective)currentPageOriginalPerspective).getDesc());
        }
        if (saveable2Processed) {
            WorkbenchPage.removeNonDirtyParts(dirtyParts);
        }
        return false;
    }

    private static void removeNonDirtyParts(List<IWorkbenchPart> parts) {
        ListIterator<IWorkbenchPart> listIterator = parts.listIterator();
        while (listIterator.hasNext()) {
            ISaveablePart part = SaveableHelper.getSaveable(listIterator.next());
            if (part != null && part.isDirty()) continue;
            listIterator.remove();
        }
    }

    private static List<Saveable> convertToSaveables(List<IWorkbenchPart> parts, boolean closing, boolean addNonPartSources) {
        ArrayList<Saveable> result = new ArrayList<Saveable>();
        HashSet<Saveable> seen = new HashSet<Saveable>();
        for (IWorkbenchPart part : parts) {
            Saveable[] saveables = WorkbenchPage.getSaveables(part);
            int j = 0;
            while (j < saveables.length) {
                Saveable saveable = saveables[j];
                if (saveable.isDirty() && !seen.contains(saveable)) {
                    seen.add(saveable);
                    if (!closing || WorkbenchPage.closingLastPartShowingModel(saveable, parts, part.getSite().getPage())) {
                        result.add(saveable);
                    }
                }
                ++j;
            }
        }
        if (addNonPartSources) {
            SaveablesList saveablesList = (SaveablesList)PlatformUI.getWorkbench().getService(ISaveablesLifecycleListener.class);
            ISaveablesSource[] nonPartSources = saveablesList.getNonPartSources();
            int i = 0;
            while (i < nonPartSources.length) {
                Saveable[] saveables = nonPartSources[i].getSaveables();
                int j = 0;
                while (j < saveables.length) {
                    Saveable saveable = saveables[j];
                    if (saveable.isDirty() && !seen.contains(saveable)) {
                        seen.add(saveable);
                        result.add(saveable);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    private static Saveable[] getSaveables(IWorkbenchPart part) {
        if (part instanceof ISaveablesSource) {
            ISaveablesSource source = (ISaveablesSource)((Object)part);
            return source.getSaveables();
        }
        return new Saveable[]{new DefaultSaveable(part)};
    }

    private static boolean closingLastPartShowingModel(Saveable model, List<IWorkbenchPart> closingParts, IWorkbenchPage page) {
        HashSet<IWorkbenchPart> closingPartsWithSameModel = new HashSet<IWorkbenchPart>();
        for (IWorkbenchPart part : closingParts) {
            Saveable[] models = WorkbenchPage.getSaveables(part);
            if (!Arrays.asList(models).contains(model)) continue;
            closingPartsWithSameModel.add(part);
        }
        IWorkbenchPartReference[] pagePartRefs = ((WorkbenchPage)page).getSortedParts();
        HashSet<IWorkbenchPart> pagePartsWithSameModels = new HashSet<IWorkbenchPart>();
        int i = 0;
        while (i < pagePartRefs.length) {
            Saveable[] models;
            IWorkbenchPartReference partRef = pagePartRefs[i];
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null && Arrays.asList(models = WorkbenchPage.getSaveables(part)).contains(model)) {
                pagePartsWithSameModels.add(part);
            }
            ++i;
        }
        for (IWorkbenchPart part : closingPartsWithSameModel) {
            pagePartsWithSameModels.remove(part);
        }
        return pagePartsWithSameModels.isEmpty();
    }

    public boolean saveSaveable(ISaveablePart saveable, IWorkbenchPart part, boolean confirm, boolean closing) {
        if (closing && !saveable.isSaveOnCloseNeeded()) {
            return true;
        }
        return SaveableHelper.savePart(saveable, part, this.legacyWindow, confirm);
    }

    @Override
    public boolean saveEditor(IEditorPart editor, boolean confirm) {
        return this.saveSaveable(editor, editor, confirm, false);
    }

    @Override
    public void savePerspective() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void savePerspectiveAs(IPerspectiveDescriptor perspective) {
        MPerspective visiblePerspective = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        String originalPerspectiveId = visiblePerspective.getElementId();
        IPerspectiveDescriptor originalPerspective = this.getWorkbenchWindow().getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(originalPerspectiveId);
        this.sortedPerspectives.remove(originalPerspective);
        this.sortedPerspectives.add(perspective);
        visiblePerspective.setLabel(perspective.getLabel());
        visiblePerspective.setTooltip(perspective.getLabel());
        visiblePerspective.setElementId(perspective.getId());
        this.modelService.cloneElement((MUIElement)visiblePerspective, (MSnippetContainer)this.application);
        if (perspective instanceof PerspectiveDescriptor) {
            ((PerspectiveDescriptor)perspective).setHasCustomDefinition(true);
        }
        UIEvents.publishEvent((String)"org/eclipse/e4/ui/LifeCycle/perpSaved", (MUIElement)visiblePerspective);
    }

    @Override
    public void setEditorAreaVisible(boolean showEditorArea) {
        MUIElement find = this.findSharedArea();
        if (find != null) {
            if (showEditorArea) {
                find.setToBeRendered(true);
            }
            if (showEditorArea) {
                find.getTags().remove("Minimized");
            }
            find.setVisible(showEditorArea);
        }
    }

    private Perspective getPerspective(MPerspective mperspective) {
        if (mperspective == null) {
            return null;
        }
        if (!this.modelToPerspectiveMapping.containsKey(mperspective)) {
            boolean fixedPerspective = false;
            PerspectiveDescriptor perspectiveDesc = (PerspectiveDescriptor)this.getPerspectiveDesc(mperspective.getElementId());
            if (perspectiveDesc == null) {
                fixedPerspective = true;
                perspectiveDesc = this.fixOrphanPerspective(mperspective);
            }
            Perspective p = new Perspective(perspectiveDesc, mperspective, this);
            this.modelToPerspectiveMapping.put(mperspective, p);
            p.initActionSets();
            if (fixedPerspective) {
                UIEvents.publishEvent((String)"org/eclipse/e4/ui/LifeCycle/perpSaved", (MUIElement)mperspective);
            }
        }
        return this.modelToPerspectiveMapping.get(mperspective);
    }

    private PerspectiveDescriptor fixOrphanPerspective(MPerspective mperspective) {
        PerspectiveRegistry reg = (PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry();
        String perspId = mperspective.getElementId();
        String label = mperspective.getLabel();
        String msg = "Perspective with name '" + label + "' and id '" + perspId + "' has been made into a local copy";
        IStatus status = StatusUtil.newStatus(2, msg, null);
        StatusManager.getManager().handle(status, 1);
        String newDescId = NLS.bind((String)WorkbenchMessages.Perspective_localCopyLabel, (Object)label);
        while (reg.findPerspectiveWithId(newDescId) != null) {
            newDescId = NLS.bind((String)WorkbenchMessages.Perspective_localCopyLabel, (Object)newDescId);
        }
        PerspectiveDescriptor pd = new PerspectiveDescriptor(perspId, label, null);
        PerspectiveDescriptor newDesc = reg.createPerspective(newDescId, pd);
        if (mperspective.getIconURI() != null) {
            try {
                ImageDescriptor img = ImageDescriptor.createFromURL((URL)new URI(mperspective.getIconURI()).toURL());
                newDesc.setImageDescriptor(img);
            }
            catch (MalformedURLException | URISyntaxException e) {
                WorkbenchPlugin.log(MessageFormat.format("Error on applying configured perspective icon: {0}", mperspective.getIconURI(), e));
            }
        }
        mperspective.setElementId(newDesc.getId());
        mperspective.setLabel(newDesc.getLabel());
        this.sortedPerspectives.add(newDesc);
        this.modelService.cloneElement((MUIElement)mperspective, (MSnippetContainer)this.application);
        newDesc.setHasCustomDefinition(true);
        return newDesc;
    }

    @Override
    public void setPerspective(IPerspectiveDescriptor perspective) {
        if (perspective == null) {
            return;
        }
        IPerspectiveDescriptor lastPerspective = this.getPerspective();
        if (lastPerspective != null && lastPerspective.getId().equals(perspective.getId())) {
            return;
        }
        MPerspectiveStack perspectives = this.getPerspectiveStack();
        for (MPerspective mperspective : perspectives.getChildren()) {
            if (!mperspective.getElementId().equals(perspective.getId())) continue;
            if (lastPerspective != null) {
                this.legacyWindow.firePerspectiveDeactivated(this, lastPerspective);
            }
            perspectives.setSelectedElement((MUIElement)mperspective);
            mperspective.getContext().activate();
            return;
        }
        MPerspective modelPerspective = (MPerspective)this.modelService.cloneSnippet((MSnippetContainer)this.application, perspective.getId(), this.window);
        if (modelPerspective == null) {
            modelPerspective = (MPerspective)this.modelService.createModelElement(MPerspective.class);
            modelPerspective.setElementId(perspective.getId());
            IPerspectiveFactory factory = ((PerspectiveDescriptor)perspective).createFactory();
            ModeledPageLayout modelLayout = new ModeledPageLayout(this.window, this.modelService, this.partService, modelPerspective, perspective, this, true);
            factory.createInitialLayout(modelLayout);
            PerspectiveTagger.tagPerspective(modelPerspective, this.modelService);
            PerspectiveExtensionReader reader = new PerspectiveExtensionReader();
            reader.extendLayout(this.getExtensionTracker(), perspective.getId(), modelLayout);
        }
        modelPerspective.setLabel(perspective.getLabel());
        ImageDescriptor imageDescriptor = perspective.getImageDescriptor();
        if (imageDescriptor != null) {
            String imageURL = MenuHelper.getImageUrl(imageDescriptor);
            modelPerspective.setIconURI(imageURL);
        }
        if (lastPerspective != null) {
            this.legacyWindow.firePerspectiveDeactivated(this, lastPerspective);
        }
        this.modelService.hideLocalPlaceholders(this.window, modelPerspective);
        perspectives.getChildren().add(modelPerspective);
        perspectives.setSelectedElement((MUIElement)modelPerspective);
        modelPerspective.getContext().activate();
        modelPerspective.getContext().set(ISelectionService.class, (Object)this.selectionService);
        this.legacyWindow.firePerspectiveOpened(this, perspective);
        UIEvents.publishEvent((String)"org/eclipse/e4/ui/LifeCycle/perspOpened", (MUIElement)modelPerspective);
    }

    void perspectiveActionSetChanged(Perspective perspective, IActionSetDescriptor descriptor, int changeType) {
        if (perspective == this.getActivePerspective()) {
            this.actionSets.change(descriptor, changeType);
        }
    }

    private MPerspectiveStack getPerspectiveStack() {
        if (this._perspectiveStack != null) {
            return this._perspectiveStack;
        }
        List theStack = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null);
        if (theStack.size() > 0) {
            this._perspectiveStack = (MPerspectiveStack)theStack.get(0);
            return this._perspectiveStack;
        }
        for (MWindowElement child : this.window.getChildren()) {
            if (!(child instanceof MPerspectiveStack)) continue;
            this._perspectiveStack = (MPerspectiveStack)child;
            return this._perspectiveStack;
        }
        MPartSashContainer stickySash = (MPartSashContainer)this.modelService.createModelElement(MPartSashContainer.class);
        stickySash.setHorizontal(true);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.modelService.createModelElement(MPerspectiveStack.class);
        perspectiveStack.setElementId("org.eclipse.ui.ide.perspectivestack");
        perspectiveStack.setContainerData("7500");
        MPartStack stickyFolder = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        stickyFolder.setContainerData("2500");
        stickyFolder.setElementId("stickyFolderRight");
        stickyFolder.setToBeRendered(false);
        IStickyViewDescriptor[] stickyViews = this.getWorkbenchWindow().getWorkbench().getViewRegistry().getStickyViews();
        int i = 0;
        while (i < stickyViews.length) {
            if (stickyViews[i].getLocation() == 2) {
                MStackElement viewModel = ModeledPageLayout.createViewModel(this.application, stickyViews[i].getId(), false, this, this.partService, true);
                stickyFolder.getChildren().add(viewModel);
            }
            ++i;
        }
        stickySash.getChildren().add(perspectiveStack);
        stickySash.getChildren().add(stickyFolder);
        stickySash.setSelectedElement((MUIElement)perspectiveStack);
        this.window.getChildren().add(stickySash);
        this.window.setSelectedElement((MUIElement)stickySash);
        this._perspectiveStack = perspectiveStack;
        return perspectiveStack;
    }

    @Deprecated
    public void setWorkingSet(IWorkingSet newWorkingSet) {
        IWorkingSet oldWorkingSet = this.workingSet;
        this.workingSet = newWorkingSet;
        if (oldWorkingSet != newWorkingSet) {
            this.firePropertyChange("workingSetReplace", oldWorkingSet, newWorkingSet);
        }
        if (newWorkingSet != null) {
            WorkbenchPlugin.getDefault().getWorkingSetManager().addPropertyChangeListener(this.workingSetPropertyChangeListener);
        } else {
            WorkbenchPlugin.getDefault().getWorkingSetManager().removePropertyChangeListener(this.workingSetPropertyChangeListener);
        }
    }

    @Override
    public void showActionSet(String actionSetID) {
        ActionSetRegistry reg;
        IActionSetDescriptor desc;
        Perspective persp = this.getActivePerspective();
        if (persp != null && (desc = (reg = WorkbenchPlugin.getDefault().getActionSetRegistry()).findActionSet(actionSetID)) != null) {
            List<IActionSetDescriptor> offActionSets = persp.getAlwaysOffActionSets();
            for (IActionSetDescriptor off : offActionSets) {
                if (!off.getId().equals(desc.getId())) continue;
                return;
            }
            persp.addActionSet(desc);
            this.legacyWindow.updateActionSets();
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "actionSetShow");
        }
    }

    @Override
    public IViewPart showView(String viewID) throws PartInitException {
        return this.showView(viewID, null, 1);
    }

    @Override
    public IViewPart showView(String viewID, String secondaryID, final int mode) throws PartInitException {
        if (secondaryID != null && (secondaryID.length() == 0 || secondaryID.indexOf(":") != -1)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalSecondaryId);
        }
        if (!this.certifyMode(mode)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalViewMode);
        }
        final String compoundId = secondaryID != null ? String.valueOf(viewID) + ':' + secondaryID : viewID;
        final Object[] result = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = WorkbenchPage.this.busyShowView(compoundId, mode);
                }
                catch (PartInitException e) {
                    result[0] = e;
                }
            }
        });
        if (result[0] instanceof IViewPart) {
            return (IViewPart)result[0];
        }
        if (result[0] instanceof PartInitException) {
            throw (PartInitException)((Object)result[0]);
        }
        throw new PartInitException(WorkbenchMessages.WorkbenchPage_AbnormalWorkbenchCondition);
    }

    private boolean certifyMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public MUIElement getActiveElement(IWorkbenchPartReference ref) {
        MPlaceholder element = null;
        MPerspective curPersp = this.modelService.getActivePerspective(this.window);
        if (curPersp == null) {
            return null;
        }
        MPlaceholder eaPH = (MPlaceholder)this.modelService.find("org.eclipse.ui.editorss", (MUIElement)curPersp);
        MPart model = ((WorkbenchPartReference)ref).getModel();
        MPlaceholder placeholder = model.getCurSharedRef();
        switch (this.modelService.getElementLocation((MUIElement)(placeholder == null ? model : placeholder))) {
            case 1: 
            case 2: {
                MElementContainer parent;
                MElementContainer mElementContainer = parent = placeholder == null ? model.getParent() : placeholder.getParent();
                if (!(parent instanceof MPartStack)) break;
                element = parent;
                break;
            }
            case 8: {
                element = eaPH;
            }
        }
        return element;
    }

    @Override
    public void setPartState(IWorkbenchPartReference ref, int iState) {
        MUIElement element = this.getActiveElement(ref);
        String state = null;
        if (iState == 0) {
            state = "Minimized";
        } else if (iState == 1) {
            state = "Maximized";
        }
        this.setPartState(element, state);
    }

    @Override
    public int getPartState(IWorkbenchPartReference ref) {
        int state = 2;
        MUIElement element = this.getActiveElement(ref);
        if (element != null) {
            if (element.getTags().contains("Minimized")) {
                state = 0;
            } else if (element.getTags().contains("Maximized")) {
                state = 1;
            }
        }
        return state;
    }

    private void setPartState(MUIElement element, String state) {
        if (element != null) {
            element.getTags().remove("MinimizedByZoom");
            if ("Minimized".equals(state)) {
                element.getTags().remove("Maximized");
                element.getTags().add("Minimized");
            } else if ("Maximized".equals(state)) {
                element.getTags().remove("Minimized");
                element.getTags().add("Maximized");
            } else {
                element.getTags().remove("Minimized");
                element.getTags().remove("Maximized");
            }
        }
    }

    public void updateActionBars() {
        this.legacyWindow.updateActionBars();
    }

    @Override
    public void zoomOut() {
    }

    @Override
    public void toggleZoom(IWorkbenchPartReference ref) {
        MUIElement element = this.getActiveElement(ref);
        if (element != null) {
            String state = null;
            if (!element.getTags().contains("Maximized")) {
                state = "Maximized";
            }
            this.setPartState(element, state);
        }
    }

    @Override
    public IPerspectiveDescriptor[] getOpenPerspectives() {
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null).get(0);
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        ArrayList<IPerspectiveDescriptor> tmp = new ArrayList<IPerspectiveDescriptor>(perspectiveStack.getChildren().size());
        for (MPerspective persp : perspectiveStack.getChildren()) {
            String perspectiveId = persp.getElementId();
            IPerspectiveDescriptor desc = registry.findPerspectiveWithId(perspectiveId);
            if (desc == null) continue;
            tmp.add(desc);
        }
        IPerspectiveDescriptor[] descs = new IPerspectiveDescriptor[tmp.size()];
        tmp.toArray(descs);
        return descs;
    }

    @Override
    public IPerspectiveDescriptor[] getSortedPerspectives() {
        return this.sortedPerspectives.toArray(new IPerspectiveDescriptor[this.sortedPerspectives.size()]);
    }

    @Override
    public IWorkbenchPartReference getReference(IWorkbenchPart part) {
        IWorkbenchPartSite site;
        if (part != null && (site = part.getSite()) instanceof PartSite) {
            return ((PartSite)site).getPartReference();
        }
        return null;
    }

    public MPerspective getCurrentPerspective() {
        MPerspectiveStack stack = this.getPerspectiveStack();
        return stack == null ? null : (MPerspective)stack.getSelectedElement();
    }

    Perspective getActivePerspective() {
        return this.getPerspective(this.getCurrentPerspective());
    }

    @Override
    public IViewPart[] getViewStack(IViewPart part) {
        MPart mpart = this.partService.findPart(part.getSite().getId());
        if (mpart != null) {
            MPlaceholder placeholder;
            MElementContainer parent = mpart.getParent();
            if (parent == null && (placeholder = mpart.getCurSharedRef()) != null) {
                parent = placeholder.getParent();
            }
            if (parent instanceof MPartStack) {
                MStackElement selectedElement = (MStackElement)((MPartStack)parent).getSelectedElement();
                final MUIElement topPart = selectedElement instanceof MPlaceholder ? ((MPlaceholder)selectedElement).getRef() : null;
                ArrayList<CompatibilityView> stack = new ArrayList<CompatibilityView>();
                for (Object child : parent.getChildren()) {
                    Object siblingObject;
                    MPart siblingPart = child instanceof MPart ? (MPart)child : (MPart)((MPlaceholder)child).getRef();
                    Object object = siblingObject = siblingPart != null ? siblingPart.getObject() : null;
                    if (!(siblingObject instanceof CompatibilityView)) continue;
                    stack.add((CompatibilityView)siblingObject);
                }
                Collections.sort(stack, new Comparator<CompatibilityView>(){

                    @Override
                    public int compare(CompatibilityView o1, CompatibilityView o2) {
                        MPart model1 = o1.getModel();
                        MPart model2 = o2.getModel();
                        if (model1 == topPart) {
                            return Integer.MIN_VALUE;
                        }
                        if (model2 == topPart) {
                            return Integer.MAX_VALUE;
                        }
                        int pos1 = WorkbenchPage.this.activationList.indexOf(model1);
                        int pos2 = WorkbenchPage.this.activationList.indexOf(model2);
                        if (pos1 == -1) {
                            pos1 = Integer.MAX_VALUE;
                        }
                        if (pos2 == -1) {
                            pos2 = Integer.MAX_VALUE;
                        }
                        return pos1 - pos2;
                    }
                });
                IViewPart[] result = new IViewPart[stack.size()];
                int i = 0;
                while (i < result.length) {
                    result[i] = ((CompatibilityView)stack.get(i)).getView();
                    ++i;
                }
                return result;
            }
            return new IViewPart[]{part};
        }
        return null;
    }

    @Override
    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getWorkbenchWindow().getWorkbench().getDisplay());
        }
        return this.tracker;
    }

    private String[] getArrayForTag(String tagPrefix) {
        List<String> id = this.getCollectionForTag(tagPrefix);
        if (id == null) {
            return EMPTY_STRING_ARRAY;
        }
        return id.toArray(new String[id.size()]);
    }

    private List<String> getCollectionForTag(String tagPrefix) {
        MPerspective perspective = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        if (perspective == null) {
            return Collections.emptyList();
        }
        return ModeledPageLayout.getIds(perspective, tagPrefix);
    }

    @Override
    public String[] getNewWizardShortcuts() {
        return this.getArrayForTag("persp.newWizSC:");
    }

    @Override
    public String[] getPerspectiveShortcuts() {
        return this.getArrayForTag("persp.perspSC:");
    }

    @Override
    public String[] getShowViewShortcuts() {
        return this.getArrayForTag("persp.viewSC:");
    }

    public boolean isPartVisible(IWorkbenchPartReference reference) {
        IWorkbenchPart part = reference.getPart(false);
        if (part == null) {
            return false;
        }
        return this.isPartVisible(part);
    }

    @Override
    public IWorkingSet[] getWorkingSets() {
        return this.workingSets;
    }

    @Override
    public void setWorkingSets(IWorkingSet[] newWorkingSets) {
        if (newWorkingSets != null) {
            WorkbenchPlugin.getDefault().getWorkingSetManager().addPropertyChangeListener(this.workingSetPropertyChangeListener);
        } else {
            WorkbenchPlugin.getDefault().getWorkingSetManager().removePropertyChangeListener(this.workingSetPropertyChangeListener);
        }
        if (newWorkingSets == null) {
            newWorkingSets = new IWorkingSet[]{};
        }
        Object[] oldWorkingSets = this.workingSets;
        if (newWorkingSets.length > 1) {
            HashSet<IWorkingSet> setOfSets = new HashSet<IWorkingSet>();
            int i = 0;
            while (i < newWorkingSets.length) {
                if (newWorkingSets[i] == null) {
                    throw new IllegalArgumentException();
                }
                setOfSets.add(newWorkingSets[i]);
                ++i;
            }
            newWorkingSets = setOfSets.toArray(new IWorkingSet[setOfSets.size()]);
        }
        this.workingSets = newWorkingSets;
        if (!Arrays.equals(oldWorkingSets, newWorkingSets)) {
            this.firePropertyChange("workingSetsReplace", oldWorkingSets, newWorkingSets);
            if (this.aggregateWorkingSet != null) {
                this.aggregateWorkingSet.setComponents(this.workingSets);
            }
        }
    }

    @Override
    public IWorkingSet getAggregateWorkingSet() {
        if (this.aggregateWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            if (this.aggregateWorkingSetId == null) {
                this.aggregateWorkingSet = this.findAggregateWorkingSet(workingSetManager);
                this.aggregateWorkingSetId = this.aggregateWorkingSet == null ? this.getDefaultAggregateWorkingSetId() : this.aggregateWorkingSet.getName();
            } else {
                this.aggregateWorkingSet = (AggregateWorkingSet)workingSetManager.getWorkingSet(this.aggregateWorkingSetId);
            }
            if (this.aggregateWorkingSet == null) {
                this.aggregateWorkingSet = (AggregateWorkingSet)workingSetManager.createAggregateWorkingSet(this.aggregateWorkingSetId, WorkbenchMessages.WorkbenchPage_workingSet_default_label, this.getWorkingSets());
                workingSetManager.addWorkingSet(this.aggregateWorkingSet);
            }
        }
        return this.aggregateWorkingSet;
    }

    private String getDefaultAggregateWorkingSetId() {
        return "Aggregate for window " + System.currentTimeMillis();
    }

    private AggregateWorkingSet findAggregateWorkingSet(IWorkingSetManager workingSetManager) {
        IWorkingSet[] iWorkingSetArray = workingSetManager.getAllWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (workingSet instanceof AggregateWorkingSet) {
                return (AggregateWorkingSet)workingSet;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void showEditor(IEditorReference ref) {
        E4Util.unsupported("showEditor");
    }

    @Override
    public void hideEditor(IEditorReference ref) {
        E4Util.unsupported("hideEditor");
    }

    private String getEditorImageURI(EditorReference reference) {
        IConfigurationElement element;
        String iconURI = null;
        EditorDescriptor descriptor = reference.getDescriptor();
        if (descriptor != null && (element = descriptor.getConfigurationElement()) != null) {
            iconURI = MenuHelper.getIconURI(element, "icon");
        }
        return iconURI;
    }

    @Override
    public IMemento[] getEditorState(IEditorReference[] editorRefs, boolean includeInputState) {
        IMemento[] m = new IMemento[editorRefs.length];
        int i = 0;
        while (i < editorRefs.length) {
            m[i] = ((EditorReference)editorRefs[i]).getEditorState();
            if (!includeInputState && m[i] != null) {
                m[i] = m[i].getChild("editorState");
            }
            ++i;
        }
        return m;
    }

    @Override
    public IEditorReference[] openEditors(IEditorInput[] inputs, String[] editorIDs, int matchFlags) throws MultiPartInitException {
        return this.openEditors(inputs, editorIDs, null, matchFlags, 0);
    }

    @Override
    public IEditorReference[] openEditors(IEditorInput[] inputs, String[] editorIDs, IMemento[] mementos, int matchFlags, int activationIndex) throws MultiPartInitException {
        if (inputs == null) {
            Assert.isTrue((mementos != null ? 1 : 0) != 0);
            inputs = new IEditorInput[mementos.length];
        }
        if (editorIDs == null) {
            Assert.isTrue((mementos != null ? 1 : 0) != 0);
            editorIDs = new String[mementos.length];
        }
        Assert.isTrue((inputs.length == editorIDs.length ? 1 : 0) != 0);
        Assert.isTrue((inputs.length > 0 ? 1 : 0) != 0);
        Assert.isTrue((mementos == null || mementos.length == inputs.length ? 1 : 0) != 0);
        PartInitException[] exceptions = new PartInitException[inputs.length];
        IWorkbenchPartReference[] references = new IEditorReference[inputs.length];
        boolean hasFailures = false;
        IEditorRegistry reg = this.getWorkbenchWindow().getWorkbench().getEditorRegistry();
        MPart editorToActivate = null;
        int i = 0;
        while (i < inputs.length) {
            block32: {
                IMemento curMemento;
                String curEditorID = editorIDs == null ? null : editorIDs[i];
                IEditorInput curInput = inputs == null ? null : inputs[i];
                IMemento iMemento = curMemento = mementos == null ? null : mementos[i];
                if (curEditorID == null && curMemento != null) {
                    curEditorID = curMemento.getString("id");
                }
                if (curInput == null && curMemento != null) {
                    try {
                        curInput = EditorReference.createInput(curMemento);
                    }
                    catch (PartInitException e) {
                        curInput = null;
                        exceptions[i] = e;
                        hasFailures = true;
                        break block32;
                    }
                }
                if (curMemento != null && !curMemento.getID().equals("editor")) {
                    XMLMemento outerMem = XMLMemento.createWriteRoot("editor");
                    outerMem.putString("id", curEditorID);
                    outerMem.copyChild(curMemento);
                    XMLMemento inputMem = (XMLMemento)outerMem.createChild("input");
                    inputMem.putString("factoryID", curInput.getPersistable().getFactoryId());
                    inputMem.putString("path", curInput.getName());
                }
                if (reg.findEditor(curEditorID) == null) {
                    references[i] = null;
                    exceptions[i] = new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_unknownEditorIDMessage, (Object)curEditorID));
                    hasFailures = true;
                } else if (curInput == null) {
                    references[i] = null;
                    exceptions[i] = new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_no_persisted_state, (Object)curEditorID));
                    hasFailures = true;
                } else {
                    StringWriter writer;
                    IEditorReference[] existingEditors = this.findEditors(curInput, curEditorID, matchFlags);
                    if (existingEditors.length == 0) {
                        MPart editor = this.partService.createPart("org.eclipse.e4.ui.compatibility.editor");
                        references[i] = this.createEditorReferenceForPart(editor, curInput, curEditorID, null);
                        if (i == activationIndex) {
                            editorToActivate = editor;
                        }
                        if (curMemento instanceof XMLMemento) {
                            XMLMemento memento = (XMLMemento)curMemento;
                            writer = new StringWriter();
                            try {
                                memento.save(writer);
                                editor.getPersistedState().put(WorkbenchPartReference.MEMENTO_KEY, writer.toString());
                            }
                            catch (IOException e) {
                                WorkbenchPlugin.log(e);
                            }
                        }
                        editor.setLabel(references[i].getTitle());
                        editor.setTooltip(references[i].getTitleToolTip());
                        editor.setIconURI(this.getEditorImageURI((EditorReference)references[i]));
                        ((PartServiceImpl)this.partService).addPart(editor);
                    } else {
                        CompatibilityEditor ce;
                        EditorReference ee = (EditorReference)existingEditors[0];
                        if (i == activationIndex) {
                            editorToActivate = ee.getModel();
                        }
                        if (ee.getModel().getWidget() == null) {
                            if (curMemento instanceof XMLMemento) {
                                XMLMemento momento = (XMLMemento)curMemento;
                                writer = new StringWriter();
                                try {
                                    momento.save(writer);
                                    ee.getModel().getPersistedState().put(WorkbenchPartReference.MEMENTO_KEY, writer.toString());
                                }
                                catch (IOException e) {
                                    WorkbenchPlugin.log(e);
                                }
                            }
                        } else if (curMemento != null && ee.getModel().getObject() instanceof CompatibilityEditor && (ce = (CompatibilityEditor)ee.getModel().getObject()).getEditor() instanceof IPersistableEditor) {
                            IMemento[] kids;
                            IPersistableEditor pe = (IPersistableEditor)((Object)ce.getEditor());
                            IMemento editorMem = curMemento.getChild("editorState");
                            if (editorMem == null && (kids = curMemento.getChildren()).length == 2) {
                                editorMem = kids[1];
                            }
                            if (editorMem != null) {
                                pe.restoreState(editorMem);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (editorToActivate != null) {
            this.partService.activate(editorToActivate);
        }
        boolean hasSuccesses = false;
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iWorkbenchPartReferenceArray[n2];
            if (reference != null) {
                hasSuccesses = true;
                this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), reference, "editorOpen");
            }
            ++n2;
        }
        if (hasSuccesses) {
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "editorOpen");
        }
        if (hasFailures) {
            throw new MultiPartInitException(references, exceptions);
        }
        return references;
    }

    void updatePerspectiveActionSets() {
        this.updateActionSets(null, this.getActivePerspective());
    }

    void fireInitialPartVisibilityEvents() {
        MPerspective selectedElement = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        if (selectedElement != null) {
            List parts = this.modelService.findElements((MUIElement)selectedElement, null, MPart.class, null);
            ArrayList<MPart> visibleParts = new ArrayList<MPart>(parts.size());
            for (MPart part : parts) {
                if (!this.isVisible(selectedElement, (MUIElement)part)) continue;
                visibleParts.add(part);
            }
            for (MPart part : visibleParts) {
                this.firePartVisible(part);
            }
        }
    }

    private boolean isVisible(MPerspective perspective, MUIElement element) {
        if (element == perspective) {
            return true;
        }
        if (element.isVisible() && element.isToBeRendered()) {
            MElementContainer parent = element.getParent();
            if (parent instanceof MPartStack) {
                if (parent.getSelectedElement() == element) {
                    return this.isVisible(perspective, (MUIElement)parent);
                }
            } else {
                if (parent == null) {
                    MPlaceholder placeholder = element.getCurSharedRef();
                    return placeholder == null ? false : this.isVisible(perspective, (MUIElement)placeholder);
                }
                return this.isVisible(perspective, (MUIElement)parent);
            }
        }
        return false;
    }

    private void firePartActivated(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            Object listener;
            final IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            final IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            if (partReference == null) {
                WorkbenchPlugin.log("Reference is null in firePartActivated");
                return;
            }
            Object[] objectArray = this.partListenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((IPartListener)listener).partActivated(workbenchPart);
                    }
                });
                ++n2;
            }
            objectArray = this.partListener2List.getListeners();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((IPartListener2)listener).partActivated(partReference);
                    }
                });
                ++n2;
            }
        }
    }

    private void firePartDeactivated(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            Object listener;
            final IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            final IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            Object[] objectArray = this.partListenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((IPartListener)listener).partDeactivated(workbenchPart);
                    }
                });
                ++n2;
            }
            objectArray = this.partListener2List.getListeners();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((IPartListener2)listener).partDeactivated(partReference);
                    }
                });
                ++n2;
            }
        }
    }

    public void firePartOpened(CompatibilityPart compatibilityPart) {
        Object listener;
        final IWorkbenchPart part = compatibilityPart.getPart();
        final WorkbenchPartReference partReference = compatibilityPart.getReference();
        SaveablesList saveablesList = (SaveablesList)this.getWorkbenchWindow().getService(ISaveablesLifecycleListener.class);
        saveablesList.postOpen(part);
        Object[] objectArray = this.partListenerList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partOpened(part);
                }
            });
            ++n2;
        }
        objectArray = this.partListener2List.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener2)listener).partOpened(partReference);
                }
            });
            ++n2;
        }
        if (part instanceof IPageChangeProvider) {
            ((IPageChangeProvider)part).addPageChangedListener(this.pageChangedListener);
        }
        if (compatibilityPart instanceof CompatibilityView) {
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), partReference, "viewShow");
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "viewShow");
        }
    }

    public void firePartClosed(CompatibilityPart compatibilityPart) {
        Object listener;
        final IWorkbenchPart part = compatibilityPart.getPart();
        final WorkbenchPartReference partReference = compatibilityPart.getReference();
        MPart model = partReference.getModel();
        SaveablesList modelManager = (SaveablesList)this.getWorkbenchWindow().getService(ISaveablesLifecycleListener.class);
        Object postCloseInfo = modelManager.preCloseParts(Collections.singletonList(part), false, this.getWorkbenchWindow());
        if (postCloseInfo != null) {
            modelManager.postClose(postCloseInfo);
        }
        Object[] objectArray = this.partListenerList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partClosed(part);
                }
            });
            ++n2;
        }
        objectArray = this.partListener2List.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener2)listener).partClosed(partReference);
                }
            });
            ++n2;
        }
        if (part instanceof IViewPart) {
            this.viewReferences.remove(partReference);
        } else {
            this.editorReferences.remove(partReference);
        }
        int i = 0;
        while (i < this.activationList.size()) {
            if (model == this.activationList.get(i)) {
                this.activationList.remove(i);
                break;
            }
            ++i;
        }
        MPart activePart = this.partService.getActivePart();
        if (activePart == null) {
            this.updateActivePartSources(null);
            this.updateActiveEditorSources(null);
        } else if (part instanceof IEditorPart) {
            IEditorPart activeEditor = this.getActiveEditor();
            if (activeEditor == null) {
                this.updateActiveEditorSources(activePart);
            } else {
                this.updateActiveEditorSources(this.findPart(activeEditor));
            }
        }
        if (part instanceof IPageChangeProvider) {
            ((IPageChangeProvider)part).removePageChangedListener(this.pageChangedListener);
        }
        if (compatibilityPart instanceof CompatibilityView) {
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), partReference, "viewHide");
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "viewHide");
        }
    }

    private void firePartBroughtToTop(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            Object listener;
            final IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            final IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            Object[] objectArray = this.partListenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((IPartListener)listener).partBroughtToTop(workbenchPart);
                    }
                });
                ++n2;
            }
            objectArray = this.partListener2List.getListeners();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((IPartListener2)listener).partBroughtToTop(partReference);
                    }
                });
                ++n2;
            }
        } else {
            Integer val = this.partEvents.get(part);
            if (val == null) {
                this.partEvents.put(part, 2);
            } else {
                this.partEvents.put(part, val | 2);
            }
        }
    }

    private void firePartVisible(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            final IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            Object[] objectArray = this.partListener2List.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Object listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((IPartListener2)listener).partVisible(partReference);
                    }
                });
                ++n2;
            }
        } else {
            Integer val = this.partEvents.get(part);
            if (val == null) {
                this.partEvents.put(part, 1);
            } else {
                this.partEvents.put(part, val | 1);
            }
        }
    }

    public void firePartHidden(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            final IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            Object[] objectArray = this.partListener2List.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Object listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((IPartListener2)listener).partHidden(partReference);
                    }
                });
                ++n2;
            }
        }
    }

    public void firePartInputChanged(final IWorkbenchPartReference partReference) {
        Object[] objectArray = this.partListener2List.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener2)listener).partInputChanged(partReference);
                }
            });
            ++n2;
        }
    }

    @Override
    public int getEditorReuseThreshold() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        return store.getInt("REUSE_OPEN_EDITORS");
    }

    @Override
    public void setEditorReuseThreshold(int openEditors) {
    }

    public IEditorPart openEditorFromDescriptor(IEditorInput fileEditorInput, IEditorDescriptor editorDescriptor, boolean activate, IMemento editorState) throws PartInitException {
        if (editorDescriptor.isOpenExternal()) {
            this.openExternalEditor((EditorDescriptor)editorDescriptor, fileEditorInput);
            return null;
        }
        return this.openEditor(fileEditorInput, editorDescriptor.getId(), activate, 1, editorState, true);
    }

    private IEditorReference openExternalEditor(final EditorDescriptor desc, IEditorInput input) throws PartInitException {
        final CoreException[] ex = new CoreException[1];
        final IPathEditorInput pathInput = this.getPathEditorInput(input);
        if (pathInput == null || pathInput.getPath() == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_errorOpeningExternalEditor, (Object)desc.getFileName(), (Object)desc.getId()));
        }
        BusyIndicator.showWhile((Display)this.legacyWindow.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (desc.getLauncher() != null) {
                        Object launcher = WorkbenchPlugin.createExtension(desc.getConfigurationElement(), "launcher");
                        ((IEditorLauncher)launcher).open(pathInput.getPath());
                    } else {
                        ExternalEditor oEditor = new ExternalEditor(pathInput.getPath(), desc);
                        oEditor.open();
                    }
                }
                catch (CoreException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_errorOpeningExternalEditor, (Object)desc.getFileName(), (Object)desc.getId()), ex[0]);
        }
        this.recordEditor(input, desc);
        return null;
    }

    private IPathEditorInput getPathEditorInput(IEditorInput input) {
        if (input instanceof IPathEditorInput) {
            return (IPathEditorInput)input;
        }
        return (IPathEditorInput)Adapters.adapt((Object)input, IPathEditorInput.class);
    }

    private void unzoomSharedArea() {
        MPerspective curPersp = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        if (curPersp == null) {
            return;
        }
        MPlaceholder eaPH = (MPlaceholder)this.modelService.find("org.eclipse.ui.editorss", (MUIElement)curPersp);
        for (MPart part : this.modelService.findElements((MUIElement)eaPH, null, MPart.class, null)) {
            MPlaceholder placeholder;
            if (!part.isToBeRendered() || (placeholder = part.getCurSharedRef()) != null && !placeholder.isToBeRendered()) continue;
            return;
        }
        this.setPartState((MUIElement)eaPH, null);
    }

    private void unzoomSharedArea(MUIElement element) {
        if (this.modelService.getElementLocation(element) == 8) {
            this.unzoomSharedArea();
        }
    }

    public String getHiddenItems() {
        MPerspective perspective = this.getCurrentPerspective();
        if (perspective == null) {
            return "";
        }
        String result = (String)perspective.getPersistedState().get("persp.hiddenItems");
        if (result == null) {
            return "";
        }
        return result;
    }

    public void addHiddenItems(MPerspective perspective, String id) {
        String persistedID;
        String hiddenIDs = (String)perspective.getPersistedState().get("persp.hiddenItems");
        if (hiddenIDs == null) {
            hiddenIDs = "";
        }
        if (!hiddenIDs.contains(persistedID = String.valueOf(id) + ",")) {
            hiddenIDs = String.valueOf(hiddenIDs) + persistedID;
            perspective.getPersistedState().put("persp.hiddenItems", hiddenIDs);
        }
    }

    public void addHiddenItems(String id) {
        MPerspective perspective = this.getCurrentPerspective();
        if (perspective == null) {
            return;
        }
        this.addHiddenItems(perspective, id);
    }

    public void removeHiddenItems(MPerspective perspective, String id) {
        String persistedID = String.valueOf(id) + ",";
        String hiddenIDs = (String)perspective.getPersistedState().get("persp.hiddenItems");
        if (hiddenIDs == null) {
            return;
        }
        String newValue = hiddenIDs.replaceFirst(persistedID, "");
        if (hiddenIDs.length() != newValue.length()) {
            if (newValue.length() == 0) {
                perspective.getPersistedState().remove("persp.hiddenItems");
            } else {
                perspective.getPersistedState().put("persp.hiddenItems", newValue);
            }
        }
    }

    public void removeHiddenItems(String id) {
        MPerspective perspective = this.getCurrentPerspective();
        if (perspective == null) {
            return;
        }
        this.removeHiddenItems(perspective, id);
    }

    public void setNewShortcuts(List<String> wizards, String tagPrefix) {
        MPerspective persp = this.getCurrentPerspective();
        if (persp == null) {
            return;
        }
        List tags = persp.getTags();
        ArrayList<String> existingNewWizards = new ArrayList<String>();
        for (String string : tags) {
            if (!string.contains(tagPrefix)) continue;
            existingNewWizards.add(string);
        }
        ArrayList<String> newWizards = new ArrayList<String>(wizards.size());
        for (String wizardName : wizards) {
            newWizards.add(String.valueOf(tagPrefix) + wizardName);
        }
        persp.getTags().removeAll(existingNewWizards);
        persp.getTags().addAll(newWizards);
    }

    public void resetToolBarLayout() {
        ICoolBarManager2 mgr = (ICoolBarManager2)this.legacyWindow.getCoolBarManager2();
        mgr.resetItemOrder();
    }

    public void firePartDeactivatedIfActive(MPart part) {
        if (this.partService.getActivePart() == part) {
            this.firePartDeactivated(part);
        }
    }

    private class ActionSwitcher {
        private IWorkbenchPart activePart;
        private IEditorPart topEditor;
        private List<IActionSetDescriptor> oldActionSets = new ArrayList<IActionSetDescriptor>();

        private ActionSwitcher() {
        }

        public void updateActivePart(IWorkbenchPart newPart) {
            if (this.activePart == newPart) {
                return;
            }
            boolean isNewPartAnEditor = newPart instanceof IEditorPart;
            if (isNewPartAnEditor) {
                String oldId = null;
                if (this.topEditor != null) {
                    oldId = this.topEditor.getSite().getId();
                }
                String newId = newPart.getSite().getId();
                if (this.activePart == this.topEditor && newId.equals(oldId)) {
                    this.activePart = newPart;
                    this.topEditor = (IEditorPart)newPart;
                    return;
                }
                if (oldId != null && !oldId.equals(newId)) {
                    this.deactivateContributions(this.topEditor, true);
                }
                if (this.activePart != null && this.activePart != this.topEditor) {
                    this.deactivateContributions(this.activePart, true);
                }
                if (!newId.equals(oldId) || this.activePart != this.topEditor) {
                    this.activateContributions(newPart, true);
                }
            } else if (newPart == null) {
                if (this.activePart != null) {
                    this.deactivateContributions(this.activePart, true);
                }
            } else {
                if (this.activePart != null) {
                    this.deactivateContributions(this.activePart, this.activePart instanceof IViewPart);
                }
                this.activateContributions(newPart, true);
            }
            List<IActionSetDescriptor> newActionSets = null;
            newActionSets = isNewPartAnEditor || this.activePart == this.topEditor && newPart == null ? this.calculateActionSets(newPart, null) : this.calculateActionSets(newPart, this.topEditor);
            if (!this.updateActionSets(newActionSets)) {
                WorkbenchPage.this.updateActionBars();
            }
            if (isNewPartAnEditor) {
                this.topEditor = (IEditorPart)newPart;
            } else if (this.activePart == this.topEditor && newPart == null) {
                this.topEditor = null;
            }
            this.activePart = newPart;
        }

        public void updateTopEditor(IEditorPart newEditor) {
            List<IActionSetDescriptor> newActionSets;
            if (this.topEditor == newEditor) {
                return;
            }
            if (this.activePart == this.topEditor) {
                this.updateActivePart(newEditor);
                return;
            }
            String oldId = null;
            if (this.topEditor != null) {
                oldId = this.topEditor.getSite().getId();
            }
            String newId = null;
            if (newEditor != null) {
                newId = newEditor.getSite().getId();
            }
            if (oldId == null ? newId == null : oldId.equals(newId)) {
                this.topEditor = newEditor;
                return;
            }
            if (this.topEditor != null) {
                this.deactivateContributions(this.topEditor, true);
            }
            if (newEditor != null) {
                this.activateContributions(newEditor, false);
            }
            if (!this.updateActionSets(newActionSets = this.calculateActionSets(this.activePart, newEditor))) {
                WorkbenchPage.this.updateActionBars();
            }
            this.topEditor = newEditor;
        }

        private void activateContributions(IWorkbenchPart part, boolean enable) {
            PartSite site = (PartSite)part.getSite();
            site.activateActionBars(enable);
        }

        private void deactivateContributions(IWorkbenchPart part, boolean remove) {
            PartSite site = (PartSite)part.getSite();
            site.deactivateActionBars(remove);
        }

        private List<IActionSetDescriptor> calculateActionSets(IWorkbenchPart part, IEditorPart editor) {
            int i;
            ArrayList<IActionSetDescriptor> newActionSets = new ArrayList<IActionSetDescriptor>();
            if (part != null) {
                IActionSetDescriptor[] partActionSets = WorkbenchPlugin.getDefault().getActionSetRegistry().getActionSetsFor(part.getSite().getId());
                i = 0;
                while (i < partActionSets.length) {
                    newActionSets.add(partActionSets[i]);
                    ++i;
                }
            }
            if (editor != null && editor != part) {
                IActionSetDescriptor[] editorActionSets = WorkbenchPlugin.getDefault().getActionSetRegistry().getActionSetsFor(editor.getSite().getId());
                i = 0;
                while (i < editorActionSets.length) {
                    newActionSets.add(editorActionSets[i]);
                    ++i;
                }
            }
            return newActionSets;
        }

        private boolean updateActionSets(List<IActionSetDescriptor> newActionSets) {
            if (this.oldActionSets.equals(newActionSets)) {
                return false;
            }
            IContextService service = (IContextService)WorkbenchPage.this.legacyWindow.getService(IContextService.class);
            try {
                service.deferUpdates(true);
                int i = 0;
                while (i < newActionSets.size()) {
                    WorkbenchPage.this.actionSets.showAction(newActionSets.get(i));
                    ++i;
                }
                i = 0;
                while (i < this.oldActionSets.size()) {
                    WorkbenchPage.this.actionSets.hideAction(this.oldActionSets.get(i));
                    ++i;
                }
                this.oldActionSets = newActionSets;
            }
            finally {
                service.deferUpdates(false);
            }
            Perspective persp = WorkbenchPage.this.getActivePerspective();
            if (persp == null) {
                return false;
            }
            WorkbenchPage.this.legacyWindow.updateActionSets();
            WorkbenchPage.this.legacyWindow.firePerspectiveChanged(WorkbenchPage.this, WorkbenchPage.this.getPerspective(), "actionSetShow");
            return true;
        }
    }

    class E4PartListener
    implements org.eclipse.e4.ui.workbench.modeling.IPartListener {
        E4PartListener() {
        }

        public void partActivated(MPart part) {
            IWorkbenchPart workbenchPart = WorkbenchPage.this.getWorkbenchPart(part);
            WorkbenchPage.this.selectionService.updateSelection(workbenchPart);
            WorkbenchPage.this.updateActivations(part);
            WorkbenchPage.this.firePartActivated(part);
            WorkbenchPage.this.selectionService.notifyListeners(workbenchPart);
        }

        public void partBroughtToTop(MPart part) {
            WorkbenchPage.this.updateBroughtToTop(part);
            WorkbenchPage.this.firePartBroughtToTop(part);
        }

        public void partDeactivated(MPart part) {
            WorkbenchWindow wwindow;
            WorkbenchPage.this.firePartDeactivated(part);
            Object client = part.getObject();
            if (client instanceof CompatibilityPart) {
                CompatibilityPart compatibilityPart = (CompatibilityPart)client;
                IWorkbenchPartSite site = compatibilityPart.getPart().getSite();
                ((PartSite)site).deactivateActionBars(site instanceof ViewSite);
            }
            if (!(wwindow = (WorkbenchWindow)WorkbenchPage.this.getWorkbenchWindow()).isClosing()) {
                wwindow.getStatusLineManager().update(false);
            }
        }

        public void partHidden(MPart part) {
            WorkbenchPage.this.firePartHidden(part);
        }

        public void partVisible(MPart part) {
            WorkbenchPage.this.firePartVisible(part);
        }
    }
}

